/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.workflow.util;

import com.aimluck.commons.utils.ALDeleteFileUtil;
import com.aimluck.eip.cayenne.om.portlet.EipTWorkflowCategory;
import com.aimluck.eip.cayenne.om.portlet.EipTWorkflowFile;
import com.aimluck.eip.cayenne.om.portlet.EipTWorkflowRequest;
import com.aimluck.eip.cayenne.om.portlet.EipTWorkflowRequestMap;
import com.aimluck.eip.cayenne.om.portlet.EipTWorkflowRoute;
import com.aimluck.eip.cayenne.om.security.TurbineUser;
import com.aimluck.eip.common.ALActivity;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALEipUser;
import com.aimluck.eip.common.ALFileNotRemovedException;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.fileupload.beans.FileuploadBean;
import com.aimluck.eip.fileupload.beans.FileuploadLiteBean;
import com.aimluck.eip.fileupload.util.FileuploadUtils;
import com.aimluck.eip.mail.ALAdminMailContext;
import com.aimluck.eip.mail.ALAdminMailMessage;
import com.aimluck.eip.mail.ALMailService;
import com.aimluck.eip.mail.util.ALEipUserAddr;
import com.aimluck.eip.mail.util.ALMailUtils;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.ResultList;
import com.aimluck.eip.orm.query.SelectQuery;
import com.aimluck.eip.services.accessctl.ALAccessControlFactoryService;
import com.aimluck.eip.services.accessctl.ALAccessControlHandler;
import com.aimluck.eip.services.orgutils.ALOrgUtilsService;
import com.aimluck.eip.services.social.ALActivityService;
import com.aimluck.eip.services.social.model.ALActivityPutRequest;
import com.aimluck.eip.services.storage.ALStorageService;
import com.aimluck.eip.user.beans.UserLiteBean;
import com.aimluck.eip.util.ALEipUtils;
import com.aimluck.eip.util.ALLocalizationUtils;
import com.aimluck.eip.workflow.WorkflowCategoryResultData;
import com.aimluck.eip.workflow.WorkflowDecisionRecordData;
import com.aimluck.eip.workflow.WorkflowDetailResultData;
import com.aimluck.eip.workflow.WorkflowOldRequestResultData;
import com.aimluck.eip.workflow.WorkflowRouteResultData;
import com.aimluck.eip.workflow.beans.WorkflowMailBean;
import java.io.StringWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TimeZone;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.imageio.ImageIO;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.jetspeed.services.customlocalization.CustomLocalizationService;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.resources.JetspeedResources;
import org.apache.jetspeed.util.ServiceUtil;
import org.apache.turbine.services.InstantiationException;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.util.RunData;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.context.Context;

public class WorkflowUtils {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)WorkflowUtils.class.getName());
    public static final String DB_STATUS_REQUEST = "R";
    public static final String DB_STATUS_CONFIRM = "C";
    public static final String DB_STATUS_WAIT = "W";
    public static final String DB_STATUS_ACCEPT = "A";
    public static final String DB_STATUS_DENIAL = "D";
    public static final String DB_STATUS_THROUGH = "T";
    public static final String DB_PROGRESS_ACCEPT = "A";
    public static final String DB_PROGRESS_WAIT = "W";
    public static final String DB_PROGRESS_DENAIL = "D";
    public static final String DB_PROGRESS_REAPPLY = "R";
    public static final String PREFIX_DBFILE = "DBF";
    public static final String FILE_ENCODING = JetspeedResources.getString((String)"content.defaultencoding", (String)"UTF-8");
    private static final String FOLDER_FILEDIR_WORKFLOW = JetspeedResources.getString((String)"aipo.filedir", (String)"");
    protected static final String CATEGORY_KEY = JetspeedResources.getString((String)"aipo.workflow.categorykey", (String)"");
    public static final String WORKFLOW_PORTLET_NAME = "Workflow";
    public static final String WORKFLOW_CATEGORY_PORTLET_NAME = "WorkflowCategory";
    public static final String TARGET_KEYWORD = "keyword";
    private static final String RESET_FLAG = "reset_params";

    public static EipTWorkflowRequest getEipTWorkflowRequest(RunData rundata, Context context, boolean mode_update) throws ALPageNotFoundException {
        int uid = ALEipUtils.getUserId((RunData)rundata);
        String requestid = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"entityid");
        try {
            List requests;
            if (requestid == null || Integer.valueOf(requestid) == null) {
                logger.debug((Object)"[WorkflowUtils] Empty ID...");
                throw new ALPageNotFoundException();
            }
            SelectQuery query = Database.query(EipTWorkflowRequest.class);
            Expression exp1 = ExpressionFactory.matchDbExp((String)"REQUEST_ID", (Object)requestid);
            query.setQualifier(exp1);
            if (mode_update) {
                Expression exp3 = ExpressionFactory.matchExp((String)"eipTWorkflowRequestMap.status", (Object)DB_STATUS_CONFIRM);
                query.andQualifier(exp3);
                Expression exp4 = ExpressionFactory.matchExp((String)"progress", (Object)"W");
                query.andQualifier(exp4);
            }
            if ((requests = query.fetchList()) == null || requests.size() == 0) {
                logger.debug((Object)"[WorkflowUtils] Not found ID...");
                throw new ALPageNotFoundException();
            }
            Set<Integer> relatedUserIds = WorkflowUtils.getRelatedUserIdList((EipTWorkflowRequest)requests.get(0));
            if (!relatedUserIds.contains(uid)) {
                logger.debug((Object)"[WorkFlow] Invalid user access...");
                throw new ALPageNotFoundException();
            }
            return (EipTWorkflowRequest)requests.get(0);
        }
        catch (ALPageNotFoundException pageNotFound) {
            throw pageNotFound;
        }
        catch (Exception ex) {
            logger.error((Object)"workflow", (Throwable)ex);
            return null;
        }
    }

    public static List<EipTWorkflowRequest> getEipTWorkflowRequest(EipTWorkflowRoute route) throws ALPageNotFoundException {
        try {
            SelectQuery query = Database.query(EipTWorkflowRequest.class);
            Expression exp = ExpressionFactory.matchExp((String)"eipTWorkflowRoute", (Object)route);
            query.setQualifier(exp);
            return query.fetchList();
        }
        catch (Exception ex) {
            logger.error((Object)"workflow", (Throwable)ex);
            return null;
        }
    }

    public static List<EipTWorkflowCategory> getEipTworkflowCategory(EipTWorkflowRoute route) throws ALPageNotFoundException {
        try {
            SelectQuery query = Database.query(EipTWorkflowCategory.class);
            Expression exp = ExpressionFactory.matchExp((String)"eipTWorkflowRoute", (Object)route);
            query.setQualifier(exp);
            return query.fetchList();
        }
        catch (Exception ex) {
            logger.error((Object)"workflow", (Throwable)ex);
            return null;
        }
    }

    public static EipTWorkflowRequest getEipTWorkflowRequestAll(RunData rundata, Context context) {
        String requestid = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"entityid");
        try {
            if (requestid == null || Integer.valueOf(requestid) == null) {
                logger.debug((Object)"[WorkflowUtils] Empty ID...");
                return null;
            }
            SelectQuery query = Database.query(EipTWorkflowRequest.class);
            Expression exp1 = ExpressionFactory.matchDbExp((String)"REQUEST_ID", (Object)requestid);
            query.setQualifier(exp1);
            List requests = query.fetchList();
            if (requests == null || requests.size() == 0) {
                logger.debug((Object)"[WorkflowUtils] Not found ID...");
                return null;
            }
            return (EipTWorkflowRequest)requests.get(0);
        }
        catch (Exception ex) {
            logger.error((Object)"workflow", (Throwable)ex);
            return null;
        }
    }

    public static EipTWorkflowRequest getEipTWorkflowRequestForOwner(RunData rundata, Context context) {
        String requestid = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"entityid");
        try {
            if (requestid == null || Integer.valueOf(requestid) == null) {
                logger.debug((Object)"[WorkflowUtils] Empty ID...");
                return null;
            }
            SelectQuery query = Database.query(EipTWorkflowRequest.class);
            Expression exp1 = ExpressionFactory.matchDbExp((String)"REQUEST_ID", (Object)requestid);
            query.setQualifier(exp1);
            Expression exp2 = ExpressionFactory.matchExp((String)"userId", (Object)ALEipUtils.getUserId((RunData)rundata));
            query.andQualifier(exp2);
            List requests = query.fetchList();
            if (requests == null || requests.size() == 0) {
                logger.debug((Object)"[WorkflowUtils] Not found ID...");
                return null;
            }
            return (EipTWorkflowRequest)requests.get(0);
        }
        catch (Exception ex) {
            logger.error((Object)"workflow", (Throwable)ex);
            return null;
        }
    }

    public static EipTWorkflowFile getEipTWorkflowFile(RunData rundata) throws ALPageNotFoundException, ALDBErrorException {
        try {
            int attachmentIndex = rundata.getParameters().getInt("attachmentIndex", -1);
            if (attachmentIndex < 0) {
                logger.debug((Object)"[WorkflowUtils] Empty ID...");
                throw new ALPageNotFoundException();
            }
            SelectQuery query = Database.query(EipTWorkflowFile.class);
            Expression exp = ExpressionFactory.matchDbExp((String)"FILE_ID", (Object)attachmentIndex);
            query.andQualifier(exp);
            List files = query.fetchList();
            if (files == null || files.size() == 0) {
                logger.debug((Object)"[WorkflowUtils] Not found ID...");
                throw new ALPageNotFoundException();
            }
            return (EipTWorkflowFile)files.get(0);
        }
        catch (Exception ex) {
            logger.error((Object)"[WorkflowUtils]", (Throwable)ex);
            throw new ALDBErrorException();
        }
    }

    public static void deleteFiles(int timelineId, String orgId, int uid, List<String> fpaths) throws ALFileNotRemovedException {
        ALDeleteFileUtil.deleteFiles((int)timelineId, (String)"eipTWorkflowRequest", (String)WorkflowUtils.getSaveDirPath(orgId, uid), fpaths, EipTWorkflowFile.class);
    }

    public static List<EipTWorkflowRequestMap> getEipTWorkflowRequestMap(EipTWorkflowRequest request) {
        try {
            SelectQuery query = Database.query(EipTWorkflowRequestMap.class);
            Expression exp = ExpressionFactory.matchDbExp((String)"eipTWorkflowRequest.REQUEST_ID", (Object)request.getRequestId());
            query.setQualifier(exp);
            query.orderAscending("orderIndex");
            List maps = query.fetchList();
            if (maps == null || maps.size() == 0) {
                logger.debug((Object)"[WorkflowSelectData] Not found ID...");
                return null;
            }
            return maps;
        }
        catch (Exception ex) {
            logger.error((Object)"workflow", (Throwable)ex);
            return null;
        }
    }

    public static EipTWorkflowCategory getEipTWorkflowCategory(RunData rundata, Context context) {
        String categoryid = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"entityid");
        try {
            if (categoryid == null || Integer.valueOf(categoryid) == null) {
                logger.debug((Object)"[WorkflowUtils] Empty ID...");
                return null;
            }
            SelectQuery query = Database.query(EipTWorkflowCategory.class);
            Expression exp1 = ExpressionFactory.matchDbExp((String)"CATEGORY_ID", (Object)categoryid);
            query.setQualifier(exp1);
            List categories = query.fetchList();
            if (categories == null || categories.size() == 0) {
                logger.debug((Object)"[WorkflowUtils] Not found ID...");
                return null;
            }
            return (EipTWorkflowCategory)categories.get(0);
        }
        catch (Exception ex) {
            logger.error((Object)"workflow", (Throwable)ex);
            return null;
        }
    }

    public static EipTWorkflowCategory getEipTWorkflowCategory(Long category_id) {
        try {
            EipTWorkflowCategory category = (EipTWorkflowCategory)Database.get(EipTWorkflowCategory.class, (Object)category_id);
            return category;
        }
        catch (Exception ex) {
            logger.error((Object)"workflow", (Throwable)ex);
            return null;
        }
    }

    public static List<WorkflowCategoryResultData> loadCategoryList(RunData rundata, Context context) {
        try {
            ArrayList<WorkflowCategoryResultData> categoryList = new ArrayList<WorkflowCategoryResultData>();
            SelectQuery query1 = Database.query(EipTWorkflowCategory.class);
            Expression exp1 = ExpressionFactory.matchDbExp((String)"CATEGORY_ID", (Object)1);
            query1.setQualifier(exp1);
            List aList1 = query1.fetchList();
            for (EipTWorkflowCategory record : aList1) {
                WorkflowCategoryResultData rd = new WorkflowCategoryResultData();
                rd.initField();
                rd.setCategoryId(record.getCategoryId().longValue());
                rd.setCategoryName(record.getCategoryName());
                rd.setOrderTemplate(record.getTemplate());
                categoryList.add(rd);
            }
            SelectQuery query = Database.query(EipTWorkflowCategory.class);
            Expression exp2 = ExpressionFactory.noMatchDbExp((String)"CATEGORY_ID", (Object)1);
            query.setQualifier(exp2);
            query.orderAscending("categoryName");
            List aList = query.fetchList();
            for (EipTWorkflowCategory record : aList) {
                WorkflowCategoryResultData rd = new WorkflowCategoryResultData();
                rd.initField();
                rd.setCategoryId(record.getCategoryId().longValue());
                rd.setCategoryName(record.getCategoryName());
                rd.setOrderTemplate(record.getTemplate());
                categoryList.add(rd);
            }
            return categoryList;
        }
        catch (Exception ex) {
            logger.error((Object)"workflow", (Throwable)ex);
            return null;
        }
    }

    public static EipTWorkflowRoute getEipTWorkflowRoute(RunData rundata, Context context) {
        String routeid = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"entityid");
        try {
            if (routeid == null || Integer.valueOf(routeid) == null) {
                logger.debug((Object)"[WorkflowUtils] Empty ID...");
                return null;
            }
            SelectQuery query = Database.query(EipTWorkflowRoute.class);
            Expression exp1 = ExpressionFactory.matchDbExp((String)"ROUTE_ID", (Object)routeid);
            query.setQualifier(exp1);
            List routes = query.fetchList();
            if (routes == null || routes.size() == 0) {
                logger.debug((Object)"[WorkflowUtils] Not found ID...");
                return null;
            }
            return (EipTWorkflowRoute)routes.get(0);
        }
        catch (Exception ex) {
            logger.error((Object)"workflow", (Throwable)ex);
            return null;
        }
    }

    public static EipTWorkflowRoute getEipTWorkflowRoute(Long route_id) {
        try {
            EipTWorkflowRoute route = (EipTWorkflowRoute)Database.get(EipTWorkflowRoute.class, (Object)route_id);
            return route;
        }
        catch (Exception ex) {
            logger.error((Object)"workflow", (Throwable)ex);
            return null;
        }
    }

    public static List<WorkflowRouteResultData> loadRouteList(RunData rundata, Context context) {
        try {
            ArrayList<WorkflowRouteResultData> routeList = new ArrayList<WorkflowRouteResultData>();
            SelectQuery query = Database.query(EipTWorkflowRoute.class);
            query.orderAscending("routeName");
            List aList = query.fetchList();
            for (EipTWorkflowRoute record : aList) {
                WorkflowRouteResultData rd = new WorkflowRouteResultData();
                rd.initField();
                rd.setRouteId(record.getRouteId().longValue());
                rd.setRouteName(record.getRouteName());
                rd.setRoute(record.getRoute());
                routeList.add(rd);
            }
            return routeList;
        }
        catch (Exception ex) {
            logger.error((Object)"workflow", (Throwable)ex);
            return null;
        }
    }

    public static Object getResultDataDetail(Object obj, ALEipUser login_user) {
        try {
            List list;
            List<EipTWorkflowRequest> oldReuqests;
            EipTWorkflowRequest record = (EipTWorkflowRequest)obj;
            WorkflowDetailResultData rd = new WorkflowDetailResultData();
            rd.initField();
            rd.setUserId(record.getUserId().longValue());
            rd.setRequestName(record.getRequestName());
            rd.setRequestId(record.getRequestId().longValue());
            rd.setCategoryId(record.getEipTWorkflowCategory().getCategoryId().longValue());
            rd.setCategoryName(record.getEipTWorkflowCategory().getCategoryName());
            rd.setPriorityString(WorkflowUtils.getPriorityString(record.getPriority().intValue()));
            rd.setNote(record.getNote());
            rd.setPrice(record.getPrice());
            rd.setProgress(record.getProgress());
            rd.setCanRemandApplicant(true);
            if (record.getEipTWorkflowRoute() != null) {
                rd.setRouteName(record.getEipTWorkflowRoute().getRouteName());
            }
            ArrayList<WorkflowDecisionRecordData> drList = new ArrayList<WorkflowDecisionRecordData>();
            ArrayList<WorkflowDecisionRecordData> remandList = new ArrayList<WorkflowDecisionRecordData>();
            ALEipUser user = null;
            EipTWorkflowRequestMap map = null;
            WorkflowDecisionRecordData drd = null;
            List<EipTWorkflowRequestMap> maps = WorkflowUtils.getEipTWorkflowRequestMap(record);
            int size = maps.size();
            boolean is_past = true;
            for (int i = 0; i < size; ++i) {
                map = maps.get(i);
                drd = new WorkflowDecisionRecordData();
                drd.initField();
                if (login_user.getUserId().getValue() == map.getUserId().longValue()) {
                    is_past = false;
                }
                user = ALEipUtils.getALEipUser((int)map.getUserId());
                drd.setUserId(map.getUserId().intValue());
                drd.setUserAliasName(user.getAliasName().getValue());
                drd.setStatus(map.getStatus());
                drd.setStatusString(WorkflowUtils.getStatusString(map.getStatus()));
                drd.setOrder(map.getOrderIndex());
                drd.setNote(map.getNote());
                drd.setUpdateDate(WorkflowUtils.translateDate(map.getUpdateDate(), ALLocalizationUtils.getl10n((String)"WORKFLOW_YEAR_MONTH_DAY_HOUR_MINIT")));
                drList.add(drd);
                if (is_past && !WorkflowUtils.isDisabledOrDeleted(map.getUserId().toString())) {
                    remandList.add(drd);
                    continue;
                }
                if (i != 0) continue;
                rd.setCanRemandApplicant(false);
            }
            rd.setDecisionRecords(drList);
            rd.setRemandingRecords(remandList);
            if (record.getParentId() != 0 && (oldReuqests = WorkflowUtils.getOldRequests(record)) != null && oldReuqests.size() > 0) {
                ArrayList<WorkflowOldRequestResultData> oldList = new ArrayList<WorkflowOldRequestResultData>();
                int osize = oldReuqests.size();
                for (int i = 0; i < osize; ++i) {
                    EipTWorkflowRequest request = oldReuqests.get(i);
                    WorkflowOldRequestResultData orrd = new WorkflowOldRequestResultData();
                    orrd.initField();
                    orrd.setRequestId(request.getRequestId().intValue());
                    orrd.setRequestName(request.getRequestName());
                    orrd.setCategoryName(request.getEipTWorkflowCategory().getCategoryName());
                    orrd.setUpdateDate(WorkflowUtils.translateDate(request.getUpdateDate(), ALLocalizationUtils.getl10n((String)"WORKFLOW_YEAR_MONTH_DAY_HOUR_MINIT")));
                    oldList.add(orrd);
                }
                rd.setOldRequestLinks(oldList);
            }
            if ((list = WorkflowUtils.getSelectQueryForFiles(record.getRequestId()).fetchList()) != null && list.size() > 0) {
                ArrayList<FileuploadBean> attachmentFileList = new ArrayList<FileuploadBean>();
                FileuploadBean filebean = null;
                for (EipTWorkflowFile file : list) {
                    String realname = file.getFileName();
                    DataHandler hData = new DataHandler((DataSource)new FileDataSource(realname));
                    filebean = new FileuploadBean();
                    filebean.setFileId(file.getFileId().intValue());
                    filebean.setFileName(realname);
                    if (hData != null) {
                        filebean.setContentType(hData.getContentType());
                    }
                    filebean.setIsImage(FileuploadUtils.isImage((String)realname));
                    attachmentFileList.add(filebean);
                }
                rd.setAttachmentFiles(attachmentFileList);
            }
            rd.setCreateDate(WorkflowUtils.translateDate(record.getCreateDate(), ALLocalizationUtils.getl10n((String)"WORKFLOW_YEAR_MONTH_DAY_HOUR_MINIT")));
            rd.setUpdateDate(WorkflowUtils.translateDate(record.getUpdateDate(), ALLocalizationUtils.getl10n((String)"WORKFLOW_YEAR_MONTH_DAY_HOUR_MINIT")));
            return rd;
        }
        catch (Exception ex) {
            logger.error((Object)"workflow", (Throwable)ex);
            return null;
        }
    }

    private static List<EipTWorkflowRequest> getOldRequests(EipTWorkflowRequest request) {
        try {
            SelectQuery query = Database.query(EipTWorkflowRequest.class);
            Expression exp11 = ExpressionFactory.matchDbExp((String)"REQUEST_ID", (Object)request.getParentId());
            Expression exp12 = ExpressionFactory.matchExp((String)"parentId", (Object)request.getParentId());
            query.setQualifier(exp11.orExp(exp12));
            Expression exp2 = ExpressionFactory.noMatchDbExp((String)"REQUEST_ID", (Object)request.getRequestId());
            query.andQualifier(exp2);
            query.orderAscending("updateDate");
            List requests = query.fetchList();
            if (requests == null || requests.size() == 0) {
                logger.debug((Object)"[WorkflowSelectData] Not found ID...");
                return null;
            }
            return requests;
        }
        catch (Exception ex) {
            logger.error((Object)"workflow", (Throwable)ex);
            return null;
        }
    }

    public static String getPriorityImage(int i) {
        String[] temp = new String[]{"priority_high.gif", "priority_middle_high.gif", "priority_middle.gif", "priority_middle_low.gif", "priority_low.gif"};
        String image = null;
        try {
            image = temp[i - 1];
        }
        catch (Exception exception) {
            // empty catch block
        }
        return image;
    }

    public static String getPriorityString(int i) {
        String[] temp = new String[]{ALLocalizationUtils.getl10n((String)"WORKFLOW_HIGH"), ALLocalizationUtils.getl10n((String)"WORKFLOW_FEW_HIGH"), ALLocalizationUtils.getl10n((String)"WORKFLOW_USUALLY"), ALLocalizationUtils.getl10n((String)"WORKFLOW_FEW_LOW"), ALLocalizationUtils.getl10n((String)"WORKFLOW_LOW")};
        String string = null;
        try {
            string = temp[i - 1];
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }

    public static String getStateImage(int i) {
        String[] temp = new String[]{"state_000.gif", "state_010.gif", "state_020.gif", "state_030.gif", "state_040.gif", "state_050.gif", "state_060.gif", "state_070.gif", "state_080.gif", "state_090.gif", "state_100.gif"};
        String image = null;
        try {
            image = temp[i / 10];
        }
        catch (Exception exception) {
            // empty catch block
        }
        return image;
    }

    public static String getStateString(int i) {
        if (i == 0) {
            return ALLocalizationUtils.getl10n((String)"TODO_NOT_START");
        }
        if (i == 100) {
            return ALLocalizationUtils.getl10n((String)"TODO_FINISHING");
        }
        return new StringBuffer().append(i).append("%").toString();
    }

    public static String getStatusString(String status) {
        String res = "";
        if ("R".equals(status)) {
            res = ALLocalizationUtils.getl10n((String)"WORKFLOW_APPLICATION");
        } else if (DB_STATUS_CONFIRM.equals(status)) {
            res = ALLocalizationUtils.getl10n((String)"WORKFLOW_CHECKING");
        } else if ("W".equals(status)) {
            res = ALLocalizationUtils.getl10n((String)"WORKFLOW_CHECKING_BEFORE");
        } else if ("A".equals(status)) {
            res = ALLocalizationUtils.getl10n((String)"WORKFLOW_APPROVAL");
        } else if ("D".equals(status)) {
            res = ALLocalizationUtils.getl10n((String)"WORKFLOW_DENIAL");
        } else if (DB_STATUS_THROUGH.equals(status)) {
            res = ALLocalizationUtils.getl10n((String)"WORKFLOW_APPROVAL_AUTO");
        }
        return res;
    }

    public static String translateDate(Date date, String dateFormat) {
        if (date == null) {
            return "Unknown";
        }
        if (dateFormat == null) {
            dateFormat = "yyyy/MM/dd HH:mm";
        }
        SimpleDateFormat sdf = new SimpleDateFormat(dateFormat);
        sdf.setTimeZone(TimeZone.getDefault());
        return sdf.format(date);
    }

    public static String translateMoneyStr(String money) {
        if (money == null || money.length() == 0) {
            return money;
        }
        StringBuffer sb = new StringBuffer();
        int len = money.length();
        int count = len / 3;
        int del = len % 3;
        sb.append(money.substring(0, del));
        if (count > 0) {
            if (len > 3 && del != 0) {
                sb.append(",");
            }
            for (int i = 0; i < count; ++i) {
                sb.append(money.substring(del + 3 * i, del + 3 * i + 3));
                if (i == count - 1) continue;
                sb.append(",");
            }
        }
        return sb.toString();
    }

    public static boolean sendMail(RunData rundata, EipTWorkflowRequest request, List<ALEipUser> destUsers, List<String> msgList) throws Exception {
        String orgId = Database.getDomainName();
        String subject = "[" + ALOrgUtilsService.getAlias() + "]" + ALLocalizationUtils.getl10n((String)"WORKFLOW_WORKFLOW");
        try {
            ArrayList<ALEipUser> memberList = new ArrayList<ALEipUser>();
            memberList.addAll(destUsers);
            List destMemberList = ALMailUtils.getALEipUserAddrs(memberList, (int)ALEipUtils.getUserId((RunData)rundata), (boolean)false);
            ArrayList<ALAdminMailMessage> messageList = new ArrayList<ALAdminMailMessage>();
            for (ALEipUserAddr destMember : destMemberList) {
                ALAdminMailMessage message = new ALAdminMailMessage(destMember);
                message.setPcSubject(subject);
                message.setCellularSubject(subject);
                message.setPcBody(WorkflowUtils.createMsgForPc(rundata, request, ""));
                message.setCellularBody(WorkflowUtils.createMsgForCellPhone(rundata, request));
                messageList.add(message);
            }
            ALMailService.sendAdminMailAsync((ALAdminMailContext)new ALAdminMailContext(orgId, ALEipUtils.getUserId((RunData)rundata), messageList, ALMailUtils.getSendDestType((int)23)));
        }
        catch (Exception ex) {
            logger.error((Object)"workflow", (Throwable)ex);
            return false;
        }
        return true;
    }

    public static boolean sendMailForUpdate(RunData rundata, List<EipTWorkflowRequestMap> sendMailMaps, EipTWorkflowRequest request, String comment, Type flowStatus) {
        String orgId = Database.getDomainName();
        ArrayList<ALEipUserAddr> userAddressList = new ArrayList<ALEipUserAddr>();
        WorkflowMailBean mailBean = new WorkflowMailBean();
        mailBean.setOrgId(Database.getDomainName());
        mailBean.setSubject("[" + ALOrgUtilsService.getAlias() + "]" + ALLocalizationUtils.getl10n((String)"WORKFLOW_WORKFLOW"));
        mailBean.setLoginUserId(ALEipUtils.getUserId((RunData)rundata));
        mailBean.setAipoAlias(ALOrgUtilsService.getAlias());
        mailBean.setGlobalUrl(ALMailUtils.getGlobalurl());
        mailBean.setLocalUrl(ALMailUtils.getLocalurl());
        String msgForPcPrefix = WorkflowUtils.createMsgForPcAtUpdatePrefix(request, comment, flowStatus, mailBean);
        String msgForCellPrefix = WorkflowUtils.createMsgForCellAtUpdatePrefix(request, comment, flowStatus, mailBean);
        if ("".equals(msgForPcPrefix) || "".equals(msgForCellPrefix)) {
            return false;
        }
        switch (flowStatus) {
            case REQUEST: {
                for (EipTWorkflowRequestMap requestMap : sendMailMaps) {
                    userAddressList.add(ALMailUtils.getALEipUserAddrByUserId((int)requestMap.getUserId()));
                }
                break;
            }
            case DENAIL: {
                for (EipTWorkflowRequestMap requestMap : sendMailMaps) {
                    userAddressList.add(ALMailUtils.getALEipUserAddrByUserId((int)requestMap.getUserId()));
                }
                break;
            }
            case ACCEPT: {
                userAddressList.add(ALMailUtils.getALEipUserAddrByUserId((int)request.getUserId()));
                break;
            }
        }
        try {
            ArrayList<ALAdminMailMessage> messageList = new ArrayList<ALAdminMailMessage>();
            for (ALEipUserAddr userAddr : userAddressList) {
                ALAdminMailMessage message = new ALAdminMailMessage(userAddr);
                message.setPcSubject(mailBean.getSubject());
                message.setCellularSubject(mailBean.getSubject());
                message.setPcBody(WorkflowUtils.createMsgForPc(rundata, request, comment));
                message.setCellularBody(WorkflowUtils.createMsgForPc(rundata, request, comment));
                messageList.add(message);
            }
            ALMailService.sendAdminMailAsync((ALAdminMailContext)new ALAdminMailContext(orgId, ALEipUtils.getUserId((RunData)rundata), messageList, ALMailUtils.getSendDestType((int)23)));
        }
        catch (Exception e) {
            logger.error((Object)"[WorkflowUtils]", (Throwable)e);
            return false;
        }
        return true;
    }

    @Deprecated
    public static boolean sendMailForUpdateCore(List<EipTWorkflowRequestMap> sendMailMaps, EipTWorkflowRequest request, Type flowStatus, WorkflowMailBean mailBean) {
        ArrayList msgList = new ArrayList();
        ArrayList<ALEipUserAddr> userAddressList = new ArrayList<ALEipUserAddr>();
        String msgForPcPrefix = WorkflowUtils.createMsgForPcAtUpdatePrefix(request, "", flowStatus, mailBean);
        String msgForCellPrefix = WorkflowUtils.createMsgForCellAtUpdatePrefix(request, "", flowStatus, mailBean);
        if ("".equals(msgForPcPrefix) || "".equals(msgForCellPrefix)) {
            return false;
        }
        for (EipTWorkflowRequestMap requestMap : sendMailMaps) {
            userAddressList.add(ALMailUtils.getALEipUserAddrByUserId((int)requestMap.getUserId()));
        }
        try {
            for (ALEipUserAddr userAddr : userAddressList) {
                String msgForPc = msgForPcPrefix;
                String msgForCell = msgForCellPrefix;
                ALMailUtils.sendMailDelegateOne((String)mailBean.getOrgId(), (int)mailBean.getLoginUserId(), (ALEipUserAddr)userAddr, (String)mailBean.getSubject(), (String)mailBean.getSubject(), (String)msgForPc, (String)msgForCell, (int)ALMailUtils.getSendDestType((int)23), msgList);
            }
        }
        catch (Exception e) {
            logger.error((Object)"[WorkflowUtils]", (Throwable)e);
            return false;
        }
        return true;
    }

    public static String createMsgForPcAtUpdatePrefix(EipTWorkflowRequest request, String comment, Type flowStatus, WorkflowMailBean mailBean) {
        ALEipUser user;
        try {
            user = ALEipUtils.getALEipUser((int)request.getUserId());
        }
        catch (ALDBErrorException e) {
            logger.error((Object)"[WorkflowUtils]", (Throwable)e);
            user = new ALEipUser();
        }
        try {
            StringBuilder body = new StringBuilder("");
            body.append(user.getAliasName().toString());
            body.append(WorkflowUtils.getMessageHead(flowStatus, ALMailUtils.CR));
            body.append(WorkflowUtils.getMessageContent(request, comment, ALMailUtils.CR, false, mailBean));
            return body.toString();
        }
        catch (Exception e) {
            logger.error((Object)"[WorkflowUtils]", (Throwable)e);
            return "";
        }
    }

    public static String createMsgForCellAtUpdatePrefix(EipTWorkflowRequest request, String comment, Type flowStatus, WorkflowMailBean mailBean) {
        ALEipUser user;
        try {
            user = ALEipUtils.getALEipUser((int)request.getUserId());
        }
        catch (ALDBErrorException e) {
            logger.error((Object)"[WorkflowUtils]", (Throwable)e);
            user = new ALEipUser();
        }
        try {
            StringBuilder body = new StringBuilder("");
            body.append(user.getAliasName().toString());
            body.append(WorkflowUtils.getMessageHead(flowStatus, ALMailUtils.CR));
            body.append(WorkflowUtils.getMessageContent(request, comment, ALMailUtils.CR, true, mailBean));
            return body.toString();
        }
        catch (Exception e) {
            logger.error((Object)"[WorkflowUtils]", (Throwable)e);
            return "";
        }
    }

    public static String getMessageHead(Type flowStatus, String CR) throws Exception {
        StringBuilder body = new StringBuilder("");
        switch (flowStatus) {
            case REQUEST: {
                body.append(ALLocalizationUtils.getl10n((String)"WORKFLOW_RECEIVE_REQUEST_MSG")).append(CR).append(CR);
                body.append("[").append(ALLocalizationUtils.getl10n((String)"WORKFLOW_FLOW_STATUS")).append("]").append(CR);
                body.append(ALLocalizationUtils.getl10n((String)"WORKFLOW_WAITING_DECISION")).append(CR);
                break;
            }
            case DENAIL: {
                body.append(ALLocalizationUtils.getl10n((String)"WORKFLOW_RECEIVE_DENIAL_MSG")).append(CR).append(CR);
                body.append("[").append(ALLocalizationUtils.getl10n((String)"WORKFLOW_FLOW_STATUS")).append("]").append(CR);
                body.append(ALLocalizationUtils.getl10n((String)"WORKFLOW_NEED_TO_CHECK_PASSBACK")).append(CR);
                break;
            }
            case ACCEPT: {
                body.append(ALLocalizationUtils.getl10n((String)"WORKFLOW_RECEIVE_ACCEPT_MSG")).append(CR).append(CR);
                body.append("[").append(ALLocalizationUtils.getl10n((String)"WORKFLOW_FLOW_STATUS")).append("]").append(CR);
                body.append(ALLocalizationUtils.getl10n((String)"WORKFLOW_CONFIRMED")).append(CR);
                break;
            }
        }
        return body.toString();
    }

    public static String getMessageContent(EipTWorkflowRequest request, String comment, String CR, boolean isCell, WorkflowMailBean mailBean) {
        StringBuilder body = new StringBuilder("");
        body.append("[").append(ALLocalizationUtils.getl10n((String)"WORKFLOW_REQUEST_NAME")).append("]").append(CR);
        body.append(request.getEipTWorkflowCategory().getCategoryName()).append(CR);
        if (request.getRequestName() != null && !"".equals(request.getRequestName())) {
            body.append(request.getRequestName()).append(CR);
        }
        body.append("[").append(ALLocalizationUtils.getl10n((String)"WORKFLOW_CREATEDATE")).append("]").append(CR).append(WorkflowUtils.translateDate(request.getCreateDate(), ALLocalizationUtils.getl10n((String)"WORKFLOW_YEAR_MONTH_DAY_HOUR_MINIT"))).append(CR);
        body.append("[").append(ALLocalizationUtils.getl10n((String)"WORKFLOW_PRIORITY_VALUE")).append("]").append(CR).append(WorkflowUtils.getPriorityString(request.getPriority().intValue())).append(CR);
        if (!isCell) {
            body.append("[").append(ALLocalizationUtils.getl10n((String)"WORKFLOW_ACCESS_TO")).append("]").append(CR).append(request.getNote());
            if (comment != null && !"".equals(comment)) {
                body.append(CR).append("[").append(ALLocalizationUtils.getl10n((String)"WORKFLOW_COMMENT")).append("]").append(CR).append(comment);
            }
        }
        return body.toString();
    }

    public static String createMsgForPc(RunData rundata, EipTWorkflowRequest request, String comment) {
        VelocityContext context = new VelocityContext();
        boolean enableAsp = JetspeedResources.getBoolean((String)"aipo.asp", (boolean)false);
        String CR = ALMailUtils.CR;
        WorkflowMailBean mailBean = new WorkflowMailBean();
        mailBean.setOrgId(Database.getDomainName());
        mailBean.setSubject("[" + ALOrgUtilsService.getAlias() + "]" + ALLocalizationUtils.getl10n((String)"WORKFLOW_WORKFLOW"));
        mailBean.setLoginUserId(ALEipUtils.getUserId((RunData)rundata));
        mailBean.setAipoAlias(ALOrgUtilsService.getAlias());
        mailBean.setGlobalUrl(ALMailUtils.getGlobalurl());
        mailBean.setLocalUrl(ALMailUtils.getLocalurl());
        TurbineUser tuser = null;
        ALEipUser auser = null;
        try {
            tuser = request.getTurbineUser();
            auser = ALEipUtils.getALEipUser((TurbineUser)tuser);
        }
        catch (ALDBErrorException e) {
            logger.error((Object)"[WorkflowUtils]", (Throwable)e);
            return "";
        }
        StringBuffer user_email = new StringBuffer("");
        user_email.append(auser.getAliasName().toString());
        if (!tuser.getEmail().equals("")) {
            user_email.append("(").append(tuser.getEmail()).append(")");
        }
        context.put("user_email", (Object)user_email);
        StringBuffer message = new StringBuffer("");
        if ("D".equals(request.getProgress())) {
            message.append(ALLocalizationUtils.getl10n((String)"WORKFLOW_RECEIVE_DENIAL_MSG"));
        } else if ("A".equals(request.getProgress())) {
            message.append(ALLocalizationUtils.getl10n((String)"WORKFLOW_RECEIVE_ACCEPT_MSG"));
        } else {
            message.append(ALLocalizationUtils.getl10n((String)"WORKFLOW_RECEIVE_REQUEST_MSG"));
        }
        context.put("message", (Object)message);
        StringBuffer progress = new StringBuffer("");
        if ("D".equals(request.getProgress())) {
            progress.append(ALLocalizationUtils.getl10n((String)"WORKFLOW_NEED_TO_CHECK_PASSBACK"));
        } else if ("A".equals(request.getProgress())) {
            progress.append(ALLocalizationUtils.getl10n((String)"WORKFLOW_CONFIRMED"));
        } else {
            progress.append(ALLocalizationUtils.getl10n((String)"WORKFLOW_WAITING_DECISION"));
        }
        context.put("progress", (Object)progress);
        context.put("content", (Object)WorkflowUtils.getMessageContent(request, comment, CR, false, mailBean));
        context.put("serviceAlias", (Object)ALOrgUtilsService.getAlias());
        context.put("enableAsp", (Object)enableAsp);
        context.put("globalurl", (Object)ALMailUtils.getGlobalurl());
        context.put("localurl", (Object)ALMailUtils.getLocalurl());
        CustomLocalizationService locService = (CustomLocalizationService)ServiceUtil.getServiceByName((String)"LocalizationService");
        String lang = locService.getLocale(rundata).getLanguage();
        StringWriter writer = new StringWriter();
        try {
            Template template;
            if (lang != null && lang.equals("ja")) {
                template = Velocity.getTemplate((String)("portlets/mail/" + lang + "/workflow-notification-mail.vm"), (String)"utf-8");
                template.merge((Context)context, (Writer)writer);
            } else {
                template = Velocity.getTemplate((String)"portlets/mail/workflow-notification-mail.vm", (String)"utf-8");
                template.merge((Context)context, (Writer)writer);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        writer.flush();
        String ret = writer.getBuffer().toString();
        return ret;
    }

    public static String createMsgForCellPhone(RunData rundata, EipTWorkflowRequest request) {
        VelocityContext context = new VelocityContext();
        boolean enableAsp = JetspeedResources.getBoolean((String)"aipo.asp", (boolean)false);
        String CR = ALMailUtils.CR;
        WorkflowMailBean mailBean = new WorkflowMailBean();
        mailBean.setOrgId(Database.getDomainName());
        mailBean.setSubject("[" + ALOrgUtilsService.getAlias() + "]" + ALLocalizationUtils.getl10n((String)"WORKFLOW_WORKFLOW"));
        mailBean.setLoginUserId(ALEipUtils.getUserId((RunData)rundata));
        mailBean.setAipoAlias(ALOrgUtilsService.getAlias());
        mailBean.setGlobalUrl(ALMailUtils.getGlobalurl());
        mailBean.setLocalUrl(ALMailUtils.getLocalurl());
        TurbineUser tuser = null;
        ALEipUser auser = null;
        try {
            tuser = request.getTurbineUser();
            auser = ALEipUtils.getALEipUser((TurbineUser)tuser);
        }
        catch (ALDBErrorException e) {
            logger.error((Object)"[WorkflowUtils]", (Throwable)e);
            return "";
        }
        StringBuffer user_email = new StringBuffer("");
        user_email.append(auser.getAliasName().toString());
        if (!tuser.getEmail().equals("")) {
            user_email.append("(").append(tuser.getEmail()).append(")");
        }
        context.put("user_email", (Object)user_email);
        StringBuffer message = new StringBuffer("");
        if ("D".equals(request.getProgress())) {
            message.append(ALLocalizationUtils.getl10n((String)"WORKFLOW_RECEIVE_DENIAL_MSG"));
        } else if ("A".equals(request.getProgress())) {
            message.append(ALLocalizationUtils.getl10n((String)"WORKFLOW_RECEIVE_ACCEPT_MSG"));
        } else {
            message.append(ALLocalizationUtils.getl10n((String)"WORKFLOW_RECEIVE_REQUEST_MSG"));
        }
        context.put("message", (Object)message);
        StringBuffer progress = new StringBuffer("");
        if ("D".equals(request.getProgress())) {
            progress.append(ALLocalizationUtils.getl10n((String)"WORKFLOW_NEED_TO_CHECK_PASSBACK"));
        } else if ("A".equals(request.getProgress())) {
            progress.append(ALLocalizationUtils.getl10n((String)"WORKFLOW_CONFIRMED"));
        } else {
            progress.append(ALLocalizationUtils.getl10n((String)"WORKFLOW_WAITING_DECISION"));
        }
        context.put("progress", (Object)progress);
        context.put("content", (Object)WorkflowUtils.getMessageContent(request, "", CR, false, mailBean));
        context.put("serviceAlias", (Object)ALOrgUtilsService.getAlias());
        context.put("enableAsp", (Object)enableAsp);
        context.put("globalurl", (Object)ALMailUtils.getGlobalurl());
        context.put("localurl", (Object)ALMailUtils.getLocalurl());
        CustomLocalizationService locService = (CustomLocalizationService)ServiceUtil.getServiceByName((String)"LocalizationService");
        String lang = locService.getLocale(rundata).getLanguage();
        StringWriter writer = new StringWriter();
        try {
            Template template;
            if (lang != null && lang.equals("ja")) {
                template = Velocity.getTemplate((String)("portlets/mail/" + lang + "/workflow-notification-mail.vm"), (String)"utf-8");
                template.merge((Context)context, (Writer)writer);
            } else {
                template = Velocity.getTemplate((String)"portlets/mail/workflow-notification-mail.vm", (String)"utf-8");
                template.merge((Context)context, (Writer)writer);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        writer.flush();
        String ret = writer.getBuffer().toString();
        return ret;
    }

    public static boolean insertFileDataDelegate(RunData rundata, Context context, EipTWorkflowRequest request, EipTWorkflowRequest oldrequest, List<FileuploadLiteBean> fileuploadList, String folderName, List<String> msgList) {
        int uid = ALEipUtils.getUserId((RunData)rundata);
        String orgId = Database.getDomainName();
        String[] fileids = rundata.getParameters().getStrings("attachments");
        if (fileids == null) {
            return true;
        }
        int fileIDsize = fileids[0].equals("") ? 0 : fileids.length;
        SelectQuery dbquery = Database.query(EipTWorkflowFile.class);
        dbquery.andQualifier(ExpressionFactory.matchDbExp((String)"eipTWorkflowRequest", (Object)request.getRequestId()));
        for (int i = 0; i < fileIDsize; ++i) {
            dbquery.orQualifier(ExpressionFactory.matchDbExp((String)"FILE_ID", (Object)fileids[i]));
        }
        List files = dbquery.fetchList();
        if (files.size() == fileIDsize && (fileuploadList == null || fileuploadList.size() <= 0)) {
            return true;
        }
        SelectQuery query = Database.query(EipTWorkflowFile.class);
        query.andQualifier(ExpressionFactory.matchDbExp((String)"eipTWorkflowRequest", (Object)request.getRequestId()));
        for (int i = 0; i < fileIDsize; ++i) {
            Expression exp = ExpressionFactory.matchDbExp((String)"FILE_ID", (Object)Integer.parseInt(fileids[i]));
            query.andQualifier(exp.notExp());
        }
        List delFiles = query.fetchList();
        if (delFiles.size() > 0) {
            int delsize = delFiles.size();
            for (int i = 0; i < delsize; ++i) {
                ALStorageService.deleteFile((String)(WorkflowUtils.getSaveDirPath(orgId, uid) + ((EipTWorkflowFile)delFiles.get(i)).getFilePath()));
            }
            Database.deleteAll((List)delFiles);
        }
        if (fileuploadList == null || fileuploadList.size() <= 0) {
            return true;
        }
        try {
            FileuploadLiteBean filebean = null;
            int size = fileuploadList.size();
            for (int i = 0; i < size; ++i) {
                filebean = fileuploadList.get(i);
                String[] acceptExts = ImageIO.getWriterFormatNames();
                byte[] fileThumbnail = null;
                FileuploadUtils.ShrinkImageSet bytesShrinkFilebean = FileuploadUtils.getBytesShrinkFilebean((String)orgId, (String)folderName, (int)uid, (FileuploadLiteBean)filebean, (String[])acceptExts, (int)86, (int)86, msgList, (boolean)false);
                if (bytesShrinkFilebean != null) {
                    fileThumbnail = bytesShrinkFilebean.getShrinkImage();
                }
                String filename = i + "_" + String.valueOf(System.nanoTime());
                EipTWorkflowFile file = (EipTWorkflowFile)Database.create(EipTWorkflowFile.class);
                file.setOwnerId(Integer.valueOf(uid));
                file.setEipTWorkflowRequest(request);
                file.setFileName(filebean.getFileName());
                file.setFilePath(WorkflowUtils.getRelativePath(filename));
                if (fileThumbnail != null) {
                    file.setFileThumbnail(fileThumbnail);
                }
                file.setCreateDate(Calendar.getInstance().getTime());
                file.setUpdateDate(Calendar.getInstance().getTime());
                ALStorageService.copyTmpFile((int)uid, (String)folderName, (String)String.valueOf(filebean.getFileId()), (String)FOLDER_FILEDIR_WORKFLOW, (String)(CATEGORY_KEY + ALStorageService.separator() + uid), (String)filename);
            }
            ALStorageService.deleteTmpFolder((int)uid, (String)folderName);
        }
        catch (Exception e) {
            logger.error((Object)"workflow", (Throwable)e);
            return false;
        }
        return true;
    }

    public static String getSaveDirPath(String orgId, int uid) {
        return ALStorageService.getDocumentPath((String)FOLDER_FILEDIR_WORKFLOW, (String)(CATEGORY_KEY + ALStorageService.separator() + uid));
    }

    public static String getRelativePath(String fileName) {
        return new StringBuffer().append("/").append(fileName).toString();
    }

    public static List<UserLiteBean> getAuthorityUsers(RunData rundata, String groupname, boolean includeLoginuser) {
        try {
            ALAccessControlFactoryService aclservice = (ALAccessControlFactoryService)((TurbineServices)TurbineServices.getInstance()).getService("ALAccessControlFactoryService");
            ALAccessControlHandler aclhandler = aclservice.getAccessControlHandler();
            List ulist = aclhandler.getAuthorityUsersFromGroup(rundata, "workflow_request_self", groupname, includeLoginuser);
            ArrayList<UserLiteBean> list = new ArrayList<UserLiteBean>();
            for (TurbineUser tuser : ulist) {
                UserLiteBean user = new UserLiteBean();
                user.initField();
                user.setUserId(tuser.getUserId().intValue());
                user.setName(tuser.getLoginName());
                user.setAliasName(tuser.getFirstName(), tuser.getLastName());
                list.add(user);
            }
            return list;
        }
        catch (InstantiationException e) {
            return null;
        }
    }

    private static SelectQuery<EipTWorkflowFile> getSelectQueryForFiles(int requestid) {
        SelectQuery query = Database.query(EipTWorkflowFile.class);
        Expression exp = ExpressionFactory.matchDbExp((String)"REQUEST_ID", (Object)requestid);
        query.setQualifier(exp);
        query.orderAscending("updateDate");
        query.orderAscending("filePath");
        return query;
    }

    public static String getName(String userId) {
        if (userId == null || userId.equals("")) {
            return null;
        }
        String firstName = null;
        String lastName = null;
        StringBuffer buffer = new StringBuffer();
        try {
            SelectQuery query = Database.query(TurbineUser.class);
            Expression exp = ExpressionFactory.matchDbExp((String)"USER_ID", (Object)Integer.valueOf(userId));
            query.setQualifier(exp);
            List destUserList = query.fetchList();
            if (destUserList == null || destUserList.size() <= 0) {
                return null;
            }
            firstName = ((TurbineUser)destUserList.get(0)).getFirstName();
            lastName = ((TurbineUser)destUserList.get(0)).getLastName();
        }
        catch (Exception ex) {
            logger.error((Object)"workflow", (Throwable)ex);
            return null;
        }
        return buffer.append(lastName).append(" ").append(firstName).toString();
    }

    public static String getUserName(String userId) {
        if (userId == null || userId.equals("")) {
            return null;
        }
        String userName = null;
        try {
            SelectQuery query = Database.query(TurbineUser.class);
            Expression exp = ExpressionFactory.matchDbExp((String)"USER_ID", (Object)Integer.valueOf(userId));
            query.setQualifier(exp);
            List destUserList = query.fetchList();
            if (destUserList == null || destUserList.size() <= 0) {
                return null;
            }
            userName = ((TurbineUser)destUserList.get(0)).getLoginName();
        }
        catch (Exception ex) {
            logger.error((Object)"workflow", (Throwable)ex);
            return null;
        }
        return userName;
    }

    public static Integer getRouteIdFromCategoryId(Integer categoryId) {
        if (categoryId == null || categoryId <= 0) {
            return null;
        }
        Integer routeId = null;
        try {
            SelectQuery query = Database.query(EipTWorkflowCategory.class);
            Expression exp = ExpressionFactory.matchDbExp((String)"CATEGORY_ID", (Object)categoryId);
            query.setQualifier(exp);
            List list = query.fetchList();
            if (list == null || list.size() <= 0) {
                return null;
            }
            routeId = ((EipTWorkflowCategory)list.get(0)).getEipTWorkflowRoute().getRouteId();
        }
        catch (Exception ex) {
            return null;
        }
        return routeId;
    }

    public static TurbineUser getTurbineUser(String userId) {
        if (userId == null || userId.equals("")) {
            return null;
        }
        try {
            SelectQuery query = Database.query(TurbineUser.class);
            Expression exp = ExpressionFactory.matchDbExp((String)"USER_ID", (Object)Integer.valueOf(userId));
            query.setQualifier(exp);
            List destUserList = query.fetchList();
            if (destUserList == null || destUserList.size() <= 0) {
                return null;
            }
            return (TurbineUser)destUserList.get(0);
        }
        catch (Exception ex) {
            logger.error((Object)"workflow", (Throwable)ex);
            return null;
        }
    }

    public static boolean isDisabledOrDeleted(String userId) {
        if (null == userId || "".equals(userId)) {
            return true;
        }
        int _userId = Integer.parseInt(userId);
        return WorkflowUtils.isDisabledOrDeleted(_userId);
    }

    public static boolean isDisabledOrDeleted(int userId) {
        try {
            TurbineUser user = ALEipUtils.getTurbineUser((int)userId);
            if (user == null) {
                return true;
            }
            String disabled = user.getDisabled();
            return DB_STATUS_THROUGH.equals(disabled) || "N".equals(disabled);
        }
        catch (ALDBErrorException e) {
            logger.error((Object)"workflow", (Throwable)e);
            return true;
        }
    }

    public static void createWorkflowRequestActivity(EipTWorkflowRequest request, String loginName, List<String> recipients, Type type) {
        if (recipients != null && recipients.size() > 0) {
            ALActivity RecentActivity = ALActivity.getRecentActivity((String)WORKFLOW_PORTLET_NAME, (int)request.getRequestId(), (float)1.0f);
            boolean isDeletePrev = RecentActivity != null && RecentActivity.isReplace(loginName);
            EipTWorkflowCategory category = request.getEipTWorkflowCategory();
            String name = request.getRequestName();
            StringBuilder b = new StringBuilder(ALLocalizationUtils.getl10n((String)"WORKFLOW_APPLICATION_ETC"));
            if (category != null) {
                b.append(category.getCategoryName());
                if (name != null && name.length() > 0) {
                    b.append("\uff1a");
                }
            }
            b.append(request.getRequestName()).append("\u300d");
            switch (type) {
                case REQUEST: {
                    b.append(ALLocalizationUtils.getl10n((String)"WORKFLOW_REQUEST_MSG"));
                    break;
                }
                case DENAIL: {
                    b.append(ALLocalizationUtils.getl10n((String)"WORKFLOW_DENIAL_MSG"));
                    break;
                }
                case ACCEPT: {
                    b.append(ALLocalizationUtils.getl10n((String)"WORKFLOW_ACCEPT_MSG"));
                    recipients.clear();
                    recipients.add(WorkflowUtils.getUserName(request.getUserId().toString()));
                    break;
                }
            }
            String portletParams = "?template=WorkflowDetailScreen" + "&entityid=" + request.getRequestId();
            ALActivityService.create((ALActivityPutRequest)new ALActivityPutRequest().withAppId(WORKFLOW_PORTLET_NAME).withLoginName(loginName).withUserId((request.getUserId() == null ? request.getTurbineUser().getUpdatedUserId() : request.getUserId()).intValue()).withPortletParams(portletParams).withRecipients(recipients).withTitle(b.toString()).withPriority(1.0f).withExternalId(String.valueOf(request.getRequestId())));
            if (isDeletePrev) {
                RecentActivity.delete();
            }
        }
    }

    public static Set<Integer> getRelatedUserIdList(EipTWorkflowRequest request) {
        HashSet<Integer> ids = new HashSet<Integer>();
        SelectQuery query = Database.query(EipTWorkflowRequestMap.class);
        Expression exp11 = ExpressionFactory.matchDbExp((String)"eipTWorkflowRequest.REQUEST_ID", (Object)request.getParentId());
        Expression exp12 = ExpressionFactory.matchExp((String)"eipTWorkflowRequest.parentId", (Object)request.getParentId());
        Expression exp13 = ExpressionFactory.matchExp((String)"eipTWorkflowRequest.parentId", (Object)request.getRequestId());
        query.setQualifier(exp11.orExp(exp12).orExp(exp13));
        ResultList mapList = query.getResultList();
        for (EipTWorkflowRequestMap map : mapList) {
            ids.add(map.getUserId());
        }
        return ids;
    }

    public static String getTargetKeyword(RunData rundata, Context context) {
        String target_keyword = null;
        String keywordParam = rundata.getParameters().getString(TARGET_KEYWORD);
        target_keyword = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)TARGET_KEYWORD);
        if (keywordParam == null && target_keyword == null) {
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)TARGET_KEYWORD, (String)"");
            target_keyword = "";
        } else if (keywordParam != null) {
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)TARGET_KEYWORD, (String)keywordParam.trim());
            target_keyword = keywordParam;
        }
        return target_keyword;
    }

    public static boolean hasResetFlag(RunData rundata, Context context) {
        String resetflag = rundata.getParameters().getString(RESET_FLAG);
        return resetflag != null;
    }

    public static void resetFilter(RunData rundata, Context context, String className) {
        ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)TARGET_KEYWORD, (String)"");
    }

    public static enum Type {
        REQUEST,
        DENAIL,
        ACCEPT;

    }
}

