/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.junit;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestListener;
import junit.framework.TestResult;
import junit.framework.TestSuite;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.optional.junit.FormatterElement;
import org.apache.tools.ant.taskdefs.optional.junit.JUnitResultFormatter;
import org.apache.tools.ant.taskdefs.optional.junit.JUnitTest;
import org.apache.tools.ant.util.StringUtils;

public class JUnitTestRunner
implements TestListener {
    public static final int SUCCESS = 0;
    public static final int FAILURES = 1;
    public static final int ERRORS = 2;
    private Vector formatters = new Vector();
    private TestResult res;
    private static boolean filtertrace = true;
    private boolean showOutput = false;
    private static final String[] DEFAULT_TRACE_FILTERS = new String[]{"junit.framework.TestCase", "junit.framework.TestResult", "junit.framework.TestSuite", "junit.framework.Assert.", "junit.swingui.TestRunner", "junit.awtui.TestRunner", "junit.textui.TestRunner", "java.lang.reflect.Method.invoke(", "org.apache.tools.ant."};
    private boolean haltOnError = false;
    private boolean haltOnFailure = false;
    private Test suite = null;
    private Exception exception;
    private int retCode = 0;
    private JUnitTest junitTest;
    private PrintStream systemError;
    private PrintStream systemOut;
    private boolean forked = false;
    private static Vector fromCmdLine = new Vector();

    public JUnitTestRunner(JUnitTest test, boolean haltOnError, boolean filtertrace, boolean haltOnFailure) {
        this(test, haltOnError, filtertrace, haltOnFailure, false);
    }

    public JUnitTestRunner(JUnitTest test, boolean haltOnError, boolean filtertrace, boolean haltOnFailure, boolean showOutput) {
        this(test, haltOnError, filtertrace, haltOnFailure, showOutput, null);
    }

    public JUnitTestRunner(JUnitTest test, boolean haltOnError, boolean filtertrace, boolean haltOnFailure, ClassLoader loader) {
        this(test, haltOnError, filtertrace, haltOnFailure, false, loader);
    }

    public JUnitTestRunner(JUnitTest test, boolean haltOnError, boolean filtertrace, boolean haltOnFailure, boolean showOutput, ClassLoader loader) {
        JUnitTestRunner.filtertrace = filtertrace;
        this.junitTest = test;
        this.haltOnError = haltOnError;
        this.haltOnFailure = haltOnFailure;
        this.showOutput = showOutput;
        try {
            Class<?> testClass = null;
            if (loader == null) {
                testClass = Class.forName(test.getName());
            } else {
                testClass = loader.loadClass(test.getName());
                AntClassLoader.initializeClass(testClass);
            }
            Method suiteMethod = null;
            try {
                suiteMethod = testClass.getMethod("suite", new Class[0]);
            }
            catch (Exception e) {
                // empty catch block
            }
            this.suite = suiteMethod != null ? (Test)suiteMethod.invoke(null, (Object[])new Class[0]) : new TestSuite(testClass);
        }
        catch (Exception e) {
            this.retCode = 2;
            this.exception = e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.res = new TestResult();
        this.res.addListener((TestListener)this);
        for (int i = 0; i < this.formatters.size(); ++i) {
            this.res.addListener((TestListener)this.formatters.elementAt(i));
        }
        long start = System.currentTimeMillis();
        this.fireStartTestSuite();
        if (this.exception != null) {
            for (int i = 0; i < this.formatters.size(); ++i) {
                ((TestListener)this.formatters.elementAt(i)).addError(null, (Throwable)this.exception);
            }
            this.junitTest.setCounts(1L, 0L, 1L);
            this.junitTest.setRunTime(0L);
        } else {
            PrintStream savedErr;
            ByteArrayOutputStream outStrm;
            ByteArrayOutputStream errStrm;
            block15: {
                errStrm = new ByteArrayOutputStream();
                this.systemError = new PrintStream(errStrm);
                outStrm = new ByteArrayOutputStream();
                this.systemOut = new PrintStream(outStrm);
                PrintStream savedOut = null;
                savedErr = null;
                if (this.forked) {
                    savedOut = System.out;
                    savedErr = System.err;
                    if (!this.showOutput) {
                        System.setOut(this.systemOut);
                        System.setErr(this.systemError);
                    } else {
                        System.setOut(new PrintStream(new TeeOutputStream(new OutputStream[]{savedOut, this.systemOut})));
                        System.setErr(new PrintStream(new TeeOutputStream(new OutputStream[]{savedErr, this.systemError})));
                    }
                }
                try {
                    this.suite.run(this.res);
                    Object var8_8 = null;
                    if (savedOut == null) break block15;
                }
                catch (Throwable throwable) {
                    Object var8_9 = null;
                    if (savedOut != null) {
                        System.setOut(savedOut);
                    }
                    if (savedErr != null) {
                        System.setErr(savedErr);
                    }
                    this.systemError.close();
                    this.systemError = null;
                    this.systemOut.close();
                    this.systemOut = null;
                    this.sendOutAndErr(new String(outStrm.toByteArray()), new String(errStrm.toByteArray()));
                    this.junitTest.setCounts(this.res.runCount(), this.res.failureCount(), this.res.errorCount());
                    this.junitTest.setRunTime(System.currentTimeMillis() - start);
                    throw throwable;
                }
                System.setOut(savedOut);
            }
            if (savedErr != null) {
                System.setErr(savedErr);
            }
            this.systemError.close();
            this.systemError = null;
            this.systemOut.close();
            this.systemOut = null;
            this.sendOutAndErr(new String(outStrm.toByteArray()), new String(errStrm.toByteArray()));
            this.junitTest.setCounts(this.res.runCount(), this.res.failureCount(), this.res.errorCount());
            this.junitTest.setRunTime(System.currentTimeMillis() - start);
            {
            }
        }
        this.fireEndTestSuite();
        if (this.retCode != 0 || this.res.errorCount() != 0) {
            this.retCode = 2;
        } else if (this.res.failureCount() != 0) {
            this.retCode = 1;
        }
    }

    public int getRetCode() {
        return this.retCode;
    }

    public void startTest(Test t) {
    }

    public void endTest(Test test) {
    }

    public void addFailure(Test test, Throwable t) {
        if (this.haltOnFailure) {
            this.res.stop();
        }
    }

    public void addFailure(Test test, AssertionFailedError t) {
        this.addFailure(test, (Throwable)t);
    }

    public void addError(Test test, Throwable t) {
        if (this.haltOnError) {
            this.res.stop();
        }
    }

    protected void handleOutput(String line) {
        if (this.systemOut != null) {
            this.systemOut.println(line);
        }
    }

    protected void handleErrorOutput(String line) {
        if (this.systemError != null) {
            this.systemError.println(line);
        }
    }

    protected void handleFlush(String line) {
        if (this.systemOut != null) {
            this.systemOut.print(line);
        }
    }

    protected void handleErrorFlush(String line) {
        if (this.systemError != null) {
            this.systemError.print(line);
        }
    }

    private void sendOutAndErr(String out, String err) {
        for (int i = 0; i < this.formatters.size(); ++i) {
            JUnitResultFormatter formatter = (JUnitResultFormatter)this.formatters.elementAt(i);
            formatter.setSystemOutput(out);
            formatter.setSystemError(err);
        }
    }

    private void fireStartTestSuite() {
        for (int i = 0; i < this.formatters.size(); ++i) {
            ((JUnitResultFormatter)this.formatters.elementAt(i)).startTestSuite(this.junitTest);
        }
    }

    private void fireEndTestSuite() {
        for (int i = 0; i < this.formatters.size(); ++i) {
            ((JUnitResultFormatter)this.formatters.elementAt(i)).endTestSuite(this.junitTest);
        }
    }

    public void addFormatter(JUnitResultFormatter f) {
        this.formatters.addElement(f);
    }

    public static void main(String[] args) throws IOException {
        boolean exitAtEnd = true;
        boolean haltError = false;
        boolean haltFail = false;
        boolean stackfilter = true;
        Properties props = new Properties();
        boolean showOut = false;
        if (args.length == 0) {
            System.err.println("required argument TestClassName missing");
            System.exit(2);
        }
        for (int i = 1; i < args.length; ++i) {
            if (args[i].startsWith("haltOnError=")) {
                haltError = Project.toBoolean((String)args[i].substring(12));
                continue;
            }
            if (args[i].startsWith("haltOnFailure=")) {
                haltFail = Project.toBoolean((String)args[i].substring(14));
                continue;
            }
            if (args[i].startsWith("filtertrace=")) {
                stackfilter = Project.toBoolean((String)args[i].substring(12));
                continue;
            }
            if (args[i].startsWith("formatter=")) {
                try {
                    JUnitTestRunner.createAndStoreFormatter(args[i].substring(10));
                }
                catch (BuildException be) {
                    System.err.println(be.getMessage());
                    System.exit(2);
                }
                continue;
            }
            if (args[i].startsWith("propsfile=")) {
                FileInputStream in = new FileInputStream(args[i].substring(10));
                props.load(in);
                in.close();
                continue;
            }
            if (!args[i].startsWith("showoutput=")) continue;
            showOut = Project.toBoolean((String)args[i].substring(11));
        }
        JUnitTest t = new JUnitTest(args[0]);
        Properties p = System.getProperties();
        Enumeration enumeration = ((Hashtable)p).keys();
        while (enumeration.hasMoreElements()) {
            Object key = enumeration.nextElement();
            ((Hashtable)props).put(key, ((Hashtable)p).get(key));
        }
        t.setProperties(props);
        JUnitTestRunner runner = new JUnitTestRunner(t, haltError, stackfilter, haltFail, showOut);
        runner.forked = true;
        JUnitTestRunner.transferFormatters(runner);
        runner.run();
        System.exit(runner.getRetCode());
    }

    private static void transferFormatters(JUnitTestRunner runner) {
        for (int i = 0; i < fromCmdLine.size(); ++i) {
            runner.addFormatter((JUnitResultFormatter)fromCmdLine.elementAt(i));
        }
    }

    private static void createAndStoreFormatter(String line) throws BuildException {
        FormatterElement fe = new FormatterElement();
        int pos = line.indexOf(44);
        if (pos == -1) {
            fe.setClassname(line);
        } else {
            fe.setClassname(line.substring(0, pos));
            fe.setOutfile(new File(line.substring(pos + 1)));
        }
        fromCmdLine.addElement(fe.createFormatter());
    }

    public static String getFilteredTrace(Throwable t) {
        String trace = StringUtils.getStackTrace((Throwable)t);
        return JUnitTestRunner.filterStack(trace);
    }

    public static String filterStack(String stack) {
        if (!filtertrace) {
            return stack;
        }
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        StringReader sr = new StringReader(stack);
        BufferedReader br = new BufferedReader(sr);
        try {
            String line;
            while ((line = br.readLine()) != null) {
                if (JUnitTestRunner.filterLine(line)) continue;
                pw.println(line);
            }
        }
        catch (Exception IOException2) {
            return stack;
        }
        return sw.toString();
    }

    private static boolean filterLine(String line) {
        for (int i = 0; i < DEFAULT_TRACE_FILTERS.length; ++i) {
            if (line.indexOf(DEFAULT_TRACE_FILTERS[i]) <= 0) continue;
            return true;
        }
        return false;
    }

    private class TeeOutputStream
    extends OutputStream {
        private OutputStream[] outs;

        private TeeOutputStream(OutputStream[] outs) {
            this.outs = outs;
        }

        public void write(int b) throws IOException {
            for (int i = 0; i < this.outs.length; ++i) {
                this.outs[i].write(b);
            }
        }
    }
}

