/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.ClassLoweringPass;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.backend.jvm.JvmLoweredDeclarationOrigin;
import org.jetbrains.kotlin.backend.jvm.lower.GenerateMultifileFacadesKt;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.declarations.IrAttributeContainer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationBase;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.expressions.IrClassReference;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrPropertyReference;
import org.jetbrains.kotlin.ir.expressions.impl.IrClassReferenceImpl;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\bH\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\t\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/UpdateConstantFacadePropertyReferences;", "Lorg/jetbrains/kotlin/backend/common/ClassLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "shouldGeneratePartHierarchy", "", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;Z)V", "getReplacementFacadeClassOrNull", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "irClass", "lower", "", "backend.jvm"})
final class UpdateConstantFacadePropertyReferences
implements ClassLoweringPass {
    private final JvmBackendContext context;
    private final boolean shouldGeneratePartHierarchy;

    @Override
    public void lower(@NotNull IrClass irClass2) {
        Intrinsics.checkNotNullParameter((Object)irClass2, (String)"irClass");
        IrClass irClass3 = this.getReplacementFacadeClassOrNull(irClass2);
        if (irClass3 == null) {
            return;
        }
        IrClass facadeClass = irClass3;
        IrElementTransformerVoidKt.transformChildrenVoid(irClass2, new IrElementTransformerVoid(facadeClass){
            final /* synthetic */ IrClass $facadeClass;

            @NotNull
            public IrStatement visitClass(@NotNull IrClass declaration2) {
                Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
                return declaration2;
            }

            @NotNull
            public IrExpression visitClassReference(@NotNull IrClassReference expression2) {
                Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                return new IrClassReferenceImpl(expression2.getStartOffset(), expression2.getEndOffset(), IrUtilsKt.getDefaultType(this.$facadeClass), (IrClassifierSymbol)this.$facadeClass.getSymbol(), IrUtilsKt.getDefaultType(this.$facadeClass));
            }
            {
                this.$facadeClass = $captured_local_variable$0;
            }
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final IrClass getReplacementFacadeClassOrNull(IrClass irClass2) {
        IrElement irElement;
        if (Intrinsics.areEqual((Object)irClass2.getOrigin(), (Object)JvmLoweredDeclarationOrigin.GENERATED_PROPERTY_REFERENCE.INSTANCE) ^ true && Intrinsics.areEqual((Object)irClass2.getOrigin(), (Object)JvmLoweredDeclarationOrigin.FUNCTION_REFERENCE_IMPL.INSTANCE) ^ true) {
            return null;
        }
        IrAttributeContainer callableReference = irClass2.getAttributeOwnerId();
        if (callableReference instanceof IrPropertyReference) {
            Object object = ((IrPropertyReference)callableReference).getGetter();
            irElement = object != null && (object = (IrSimpleFunction)object.getOwner()) != null && (object = ((IrSimpleFunction)object).getCorrespondingPropertySymbol()) != null ? (IrProperty)object.getOwner() : null;
        } else {
            if (!(callableReference instanceof IrFunctionReference)) return null;
            irElement = ((IrFunctionSymbol)((IrFunctionReference)callableReference).getSymbol()).getOwner();
        }
        if (irElement == null) return null;
        IrElement declaration2 = irElement;
        IrDeclarationParent irDeclarationParent = ((IrDeclarationBase)declaration2).getParent();
        if (!(irDeclarationParent instanceof IrClass)) {
            irDeclarationParent = null;
        }
        IrClass irClass3 = (IrClass)irDeclarationParent;
        if (irClass3 == null) return null;
        IrClass parent2 = irClass3;
        Map<IrClass, IrClass> map2 = this.context.getMultifileFacadeClassForPart$backend_jvm();
        IrAttributeContainer irAttributeContainer = parent2.getAttributeOwnerId();
        boolean bl = false;
        IrClass facadeClass = map2.get(irAttributeContainer);
        if (!this.shouldGeneratePartHierarchy) {
            if (!(declaration2 instanceof IrProperty)) return null;
            IrField irField = ((IrProperty)declaration2).getBackingField();
            if (irField == null) return null;
            if (!GenerateMultifileFacadesKt.access$shouldMoveToFacade(irField)) return null;
        }
        IrClass irClass4 = facadeClass;
        return irClass4;
    }

    public UpdateConstantFacadePropertyReferences(@NotNull JvmBackendContext context2, boolean shouldGeneratePartHierarchy) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        this.context = context2;
        this.shouldGeneratePartHierarchy = shouldGeneratePartHierarchy;
    }

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter((Object)irFile, (String)"irFile");
        ClassLoweringPass.DefaultImpls.lower(this, irFile);
    }
}

