/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.openapi.progress.util;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.progress.ProgressIndicator;
import org.jetbrains.kotlin.com.intellij.openapi.progress.TaskInfo;
import org.jetbrains.kotlin.com.intellij.openapi.progress.util.AbstractProgressIndicatorBase;
import org.jetbrains.kotlin.com.intellij.openapi.wm.ex.ProgressIndicatorEx;
import org.jetbrains.kotlin.com.intellij.util.ArrayUtil;
import org.jetbrains.kotlin.com.intellij.util.containers.WeakList;

public class AbstractProgressIndicatorExBase
extends AbstractProgressIndicatorBase
implements ProgressIndicatorEx {
    private final boolean myReusable;
    private volatile ProgressIndicatorEx @Nullable [] myStateDelegates;
    private volatile WeakList<TaskInfo> myFinished;
    private volatile boolean myWasStarted;
    private TaskInfo myOwnerTask;

    public AbstractProgressIndicatorExBase(boolean reusable) {
        this.myReusable = reusable;
    }

    public AbstractProgressIndicatorExBase() {
        this(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        Object object = this.getLock();
        synchronized (object) {
            super.start();
            this.delegateRunningChange(ProgressIndicator::start);
            this.myWasStarted = true;
        }
    }

    @Override
    public void stop() {
        super.stop();
        this.delegateRunningChange(ProgressIndicator::stop);
    }

    @Override
    public void cancel() {
        super.cancel();
        this.delegateRunningChange(ProgressIndicator::cancel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void finish(@NotNull TaskInfo task) {
        WeakList<TaskInfo> finished;
        if (task == null) {
            AbstractProgressIndicatorExBase.$$$reportNull$$$0(0);
        }
        if ((finished = this.myFinished) == null) {
            Object object = this.getLock();
            synchronized (object) {
                finished = this.myFinished;
                if (finished == null) {
                    this.myFinished = finished = new WeakList();
                }
            }
        }
        if (!finished.addIfAbsent(task)) {
            return;
        }
        this.delegateRunningChange(each -> each.finish(task));
    }

    public boolean isFinished(@NotNull TaskInfo task) {
        WeakList<TaskInfo> list2;
        if (task == null) {
            AbstractProgressIndicatorExBase.$$$reportNull$$$0(1);
        }
        return (list2 = this.myFinished) != null && list2.contains(task);
    }

    protected void setOwnerTask(TaskInfo owner) {
        this.myOwnerTask = owner;
    }

    @Override
    public void processFinish() {
        if (this.myOwnerTask != null) {
            this.finish(this.myOwnerTask);
            this.myOwnerTask = null;
        }
    }

    @Override
    public final void checkCanceled() {
        super.checkCanceled();
        this.delegate(ProgressIndicator::checkCanceled);
    }

    @Override
    public void setText(String text2) {
        super.setText(text2);
        this.delegateProgressChange(each -> each.setText(text2));
    }

    @Override
    public void setText2(String text2) {
        super.setText2(text2);
        this.delegateProgressChange(each -> each.setText2(text2));
    }

    @Override
    public void setFraction(double fraction) {
        super.setFraction(fraction);
        this.delegateProgressChange(each -> each.setFraction(fraction));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pushState() {
        Object object = this.getLock();
        synchronized (object) {
            super.pushState();
            this.delegateProgressChange(ProgressIndicator::pushState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void popState() {
        Object object = this.getLock();
        synchronized (object) {
            super.popState();
            this.delegateProgressChange(ProgressIndicator::popState);
        }
    }

    @Override
    protected boolean isReuseable() {
        return this.myReusable;
    }

    @Override
    public void setIndeterminate(boolean indeterminate) {
        super.setIndeterminate(indeterminate);
        this.delegateProgressChange(each -> each.setIndeterminate(indeterminate));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void addStateDelegate(@NotNull ProgressIndicatorEx delegate) {
        if (delegate == null) {
            AbstractProgressIndicatorExBase.$$$reportNull$$$0(2);
        }
        Object object = this.getLock();
        synchronized (object) {
            delegate.initStateFrom(this);
            ProgressIndicatorEx[] stateDelegates = this.myStateDelegates;
            if (stateDelegates == null) {
                this.myStateDelegates = stateDelegates = new ProgressIndicatorEx[1];
                stateDelegates[0] = delegate;
            } else {
                if (ArrayUtil.contains(delegate, stateDelegates)) {
                    throw new IllegalArgumentException("Already registered: " + delegate);
                }
                this.myStateDelegates = ArrayUtil.append(stateDelegates, delegate, ProgressIndicatorEx.class);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeStateDelegate(@NotNull ProgressIndicatorEx delegate) {
        if (delegate == null) {
            AbstractProgressIndicatorExBase.$$$reportNull$$$0(3);
        }
        Object object = this.getLock();
        synchronized (object) {
            ProgressIndicatorEx[] delegates = this.myStateDelegates;
            if (delegates == null) {
                return;
            }
            this.myStateDelegates = ArrayUtil.remove(delegates, delegate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void removeAllStateDelegates() {
        Object object = this.getLock();
        synchronized (object) {
            this.myStateDelegates = null;
        }
    }

    protected void delegateProgressChange(@NotNull IndicatorAction action) {
        if (action == null) {
            AbstractProgressIndicatorExBase.$$$reportNull$$$0(4);
        }
        this.delegate(action);
        this.onProgressChange();
    }

    protected void delegateRunningChange(@NotNull IndicatorAction action) {
        if (action == null) {
            AbstractProgressIndicatorExBase.$$$reportNull$$$0(5);
        }
        this.delegate(action);
        this.onRunningChange();
    }

    private void delegate(@NotNull IndicatorAction action) {
        ProgressIndicatorEx[] list2;
        if (action == null) {
            AbstractProgressIndicatorExBase.$$$reportNull$$$0(6);
        }
        if ((list2 = this.myStateDelegates) != null) {
            for (ProgressIndicatorEx each : list2) {
                action.execute(each);
            }
        }
    }

    protected void onProgressChange() {
    }

    protected void onRunningChange() {
    }

    public boolean wasStarted() {
        return this.myWasStarted;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delegate";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/kotlin/com/intellij/openapi/progress/util/AbstractProgressIndicatorExBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "finish";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isFinished";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "addStateDelegate";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "removeStateDelegate";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "delegateProgressChange";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "delegateRunningChange";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "delegate";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    @FunctionalInterface
    protected static interface IndicatorAction {
        public void execute(@NotNull ProgressIndicatorEx var1);
    }
}

