/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.toolchain.internal.swift.metadata;

import com.google.common.collect.ImmutableList;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.util.List;
import org.gradle.api.UncheckedIOException;
import org.gradle.nativeplatform.toolchain.internal.metadata.AbstractMetadataProvider;
import org.gradle.nativeplatform.toolchain.internal.metadata.CompilerType;
import org.gradle.nativeplatform.toolchain.internal.swift.metadata.SwiftcMetadata;
import org.gradle.process.internal.ExecActionFactory;
import org.gradle.util.VersionNumber;

public class SwiftcMetadataProvider
extends AbstractMetadataProvider<SwiftcMetadata> {
    private static final CompilerType SWIFTC_COMPILER_TYPE = new CompilerType(){

        @Override
        public String getIdentifier() {
            return "swiftc";
        }

        @Override
        public String getDescription() {
            return "SwiftC";
        }
    };

    public SwiftcMetadataProvider(ExecActionFactory execActionFactory) {
        super(execActionFactory);
    }

    @Override
    protected List<String> compilerArgs() {
        return ImmutableList.of((Object)"--version");
    }

    @Override
    public CompilerType getCompilerType() {
        return SWIFTC_COMPILER_TYPE;
    }

    @Override
    protected SwiftcMetadata parseCompilerOutput(String stdout, String stderr, File swiftc, List<File> path) {
        BufferedReader reader = new BufferedReader(new StringReader(stdout));
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                if (!line.contains("Swift version")) continue;
                String[] tokens = line.split(" ");
                int i = 2;
                if ("Apple".equals(tokens[0])) {
                    ++i;
                }
                VersionNumber version = VersionNumber.parse((String)tokens[i]);
                return new DefaultSwiftcMetadata(line, version);
            }
            throw new AbstractMetadataProvider.BrokenResultException(String.format("Could not determine %s metadata: %s produced unexpected output.", this.getCompilerType().getDescription(), swiftc.getName()));
        }
        catch (IOException e) {
            throw new UncheckedIOException((Throwable)e);
        }
    }

    private static class DefaultSwiftcMetadata
    implements SwiftcMetadata {
        private final String versionString;
        private final VersionNumber version;

        DefaultSwiftcMetadata(String versionString, VersionNumber version) {
            this.versionString = versionString;
            this.version = version;
        }

        @Override
        public String getVendor() {
            return this.versionString;
        }

        @Override
        public VersionNumber getVersion() {
            return this.version;
        }
    }
}

