/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution.steps;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedMap;
import java.util.Optional;
import org.gradle.caching.internal.origin.OriginMetadata;
import org.gradle.internal.Try;
import org.gradle.internal.execution.AfterPreviousExecutionContext;
import org.gradle.internal.execution.CachingResult;
import org.gradle.internal.execution.ExecutionOutcome;
import org.gradle.internal.execution.Result;
import org.gradle.internal.execution.Step;
import org.gradle.internal.execution.UnitOfWork;
import org.gradle.internal.execution.caching.CachingState;
import org.gradle.internal.execution.history.AfterPreviousExecutionState;
import org.gradle.internal.snapshot.FileSystemSnapshot;

public class SkipEmptyWorkStep<C extends AfterPreviousExecutionContext>
implements Step<C, CachingResult> {
    private final Step<? super C, ? extends CachingResult> delegate;

    public SkipEmptyWorkStep(Step<? super C, ? extends CachingResult> delegate) {
        this.delegate = delegate;
    }

    @Override
    public CachingResult execute(UnitOfWork work, C context) {
        ImmutableSortedMap outputFilesAfterPreviousExecution = context.getAfterPreviousExecutionState().map(AfterPreviousExecutionState::getOutputFilesProducedByWork).orElse(ImmutableSortedMap.of());
        UnitOfWork.Identity identity = context.getIdentity();
        return work.skipIfInputsEmpty((ImmutableSortedMap<String, FileSystemSnapshot>)outputFilesAfterPreviousExecution).map(skippedOutcome -> {
            context.getHistory().ifPresent(history -> history.remove(identity.getUniqueId()));
            return new CachingResult((ExecutionOutcome)((Object)skippedOutcome), work, (AfterPreviousExecutionContext)context){
                final /* synthetic */ ExecutionOutcome val$skippedOutcome;
                final /* synthetic */ UnitOfWork val$work;
                final /* synthetic */ AfterPreviousExecutionContext val$context;
                {
                    this.val$skippedOutcome = executionOutcome;
                    this.val$work = unitOfWork;
                    this.val$context = afterPreviousExecutionContext;
                }

                @Override
                public Try<Result.ExecutionResult> getExecutionResult() {
                    return Try.successful((Object)new Result.ExecutionResult(){

                        @Override
                        public ExecutionOutcome getOutcome() {
                            return val$skippedOutcome;
                        }

                        @Override
                        public Object getOutput() {
                            return val$work.loadRestoredOutput(val$context.getWorkspace());
                        }
                    });
                }

                @Override
                public CachingState getCachingState() {
                    return CachingState.NOT_DETERMINED;
                }

                @Override
                public ImmutableList<String> getExecutionReasons() {
                    return ImmutableList.of();
                }

                @Override
                public ImmutableSortedMap<String, FileSystemSnapshot> getOutputFilesProduceByWork() {
                    return ImmutableSortedMap.of();
                }

                @Override
                public Optional<OriginMetadata> getReusedOutputOriginMetadata() {
                    return Optional.empty();
                }
            };
        }).orElseGet(() -> this.delegate.execute(work, (AfterPreviousExecutionContext)context));
    }
}

