/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins;

import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.Incubating;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.JavaVersion;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.internal.ConventionMapping;
import org.gradle.api.internal.IConventionAware;
import org.gradle.api.internal.artifacts.configurations.ConfigurationInternal;
import org.gradle.api.internal.plugins.DslObject;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.plugins.BasePlugin;
import org.gradle.api.plugins.JavaBasePluginRules;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.plugins.JvmEcosystemPlugin;
import org.gradle.api.plugins.ReportingBasePlugin;
import org.gradle.api.plugins.internal.DefaultJavaPluginConvention;
import org.gradle.api.plugins.internal.DefaultJavaPluginExtension;
import org.gradle.api.plugins.internal.JvmPluginsHelper;
import org.gradle.api.plugins.jvm.internal.JvmEcosystemUtilities;
import org.gradle.api.plugins.jvm.internal.JvmPluginServices;
import org.gradle.api.provider.Provider;
import org.gradle.api.reporting.DirectoryReport;
import org.gradle.api.reporting.ReportingExtension;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.compile.AbstractCompile;
import org.gradle.api.tasks.compile.CompileOptions;
import org.gradle.api.tasks.compile.GroovyCompile;
import org.gradle.api.tasks.compile.JavaCompile;
import org.gradle.api.tasks.javadoc.Javadoc;
import org.gradle.api.tasks.testing.JUnitXmlReport;
import org.gradle.api.tasks.testing.Test;
import org.gradle.internal.deprecation.DeprecatableConfiguration;
import org.gradle.jvm.toolchain.JavaCompiler;
import org.gradle.jvm.toolchain.JavaInstallationRegistry;
import org.gradle.jvm.toolchain.JavaLauncher;
import org.gradle.jvm.toolchain.JavaToolchainService;
import org.gradle.jvm.toolchain.JavaToolchainSpec;
import org.gradle.jvm.toolchain.internal.DefaultJavaToolchainService;
import org.gradle.jvm.toolchain.internal.DefaultToolchainSpec;
import org.gradle.jvm.toolchain.internal.JavaToolchainQueryService;
import org.gradle.language.jvm.tasks.ProcessResources;

public class JavaBasePlugin
implements Plugin<Project> {
    public static final String CHECK_TASK_NAME = "check";
    public static final String VERIFICATION_GROUP = "verification";
    public static final String BUILD_TASK_NAME = "build";
    public static final String BUILD_DEPENDENTS_TASK_NAME = "buildDependents";
    public static final String BUILD_NEEDED_TASK_NAME = "buildNeeded";
    public static final String DOCUMENTATION_GROUP = "documentation";
    @Incubating
    public static final String COMPILE_CLASSPATH_PACKAGING_SYSTEM_PROPERTY = "org.gradle.java.compile-classpath-packaging";
    public static final Set<String> UNPUBLISHABLE_VARIANT_ARTIFACTS = ImmutableSet.of((Object)"java-classes-directory", (Object)"java-resources-directory", (Object)"directory");
    private final JavaInstallationRegistry javaInstallationRegistry;
    private final boolean javaClasspathPackaging;
    private final JvmPluginServices jvmPluginServices;

    @Inject
    public JavaBasePlugin(JavaInstallationRegistry javaInstallationRegistry, JvmEcosystemUtilities jvmPluginServices) {
        this.javaInstallationRegistry = javaInstallationRegistry;
        this.javaClasspathPackaging = Boolean.getBoolean(COMPILE_CLASSPATH_PACKAGING_SYSTEM_PROPERTY);
        this.jvmPluginServices = (JvmPluginServices)jvmPluginServices;
    }

    public void apply(Project project) {
        ProjectInternal projectInternal = (ProjectInternal)project;
        project.getPluginManager().apply(BasePlugin.class);
        project.getPluginManager().apply(JvmEcosystemPlugin.class);
        project.getPluginManager().apply(ReportingBasePlugin.class);
        JavaPluginConvention javaConvention = this.addExtensions(projectInternal);
        this.configureSourceSetDefaults(javaConvention);
        this.configureCompileDefaults(project, javaConvention);
        this.configureJavaDoc(project, javaConvention);
        this.configureTest(project, javaConvention);
        this.configureBuildNeeded(project);
        this.configureBuildDependents(project);
        this.bridgeToSoftwareModelIfNecessary(projectInternal);
    }

    private JavaPluginConvention addExtensions(ProjectInternal project) {
        DefaultToolchainSpec toolchainSpec = (DefaultToolchainSpec)project.getObjects().newInstance(DefaultToolchainSpec.class, new Object[0]);
        SourceSetContainer sourceSets = (SourceSetContainer)project.getExtensions().getByName("sourceSets");
        DefaultJavaPluginConvention javaConvention = new DefaultJavaPluginConvention(project, sourceSets, toolchainSpec);
        project.getConvention().getPlugins().put("java", javaConvention);
        project.getExtensions().create(JavaPluginExtension.class, "java", DefaultJavaPluginExtension.class, new Object[]{javaConvention, project, this.jvmPluginServices, toolchainSpec});
        project.getExtensions().add(JavaInstallationRegistry.class, "javaInstalls", (Object)this.javaInstallationRegistry);
        project.getExtensions().create(JavaToolchainService.class, "javaToolchains", DefaultJavaToolchainService.class, new Object[]{this.getJavaToolchainQueryService()});
        return javaConvention;
    }

    private void bridgeToSoftwareModelIfNecessary(ProjectInternal project) {
        project.addRuleBasedPluginListener(targetProject -> targetProject.getPluginManager().apply(JavaBasePluginRules.class));
    }

    private void configureSourceSetDefaults(JavaPluginConvention pluginConvention) {
        ProjectInternal project = pluginConvention.getProject();
        pluginConvention.getSourceSets().all(arg_0 -> this.lambda$configureSourceSetDefaults$1((Project)project, arg_0));
    }

    private void configureLibraryElements(TaskProvider<JavaCompile> compileTaskProvider, SourceSet sourceSet, ConfigurationContainer configurations, ObjectFactory objectFactory) {
        Action<ConfigurationInternal> configureLibraryElements = JvmPluginsHelper.configureLibraryElementsAttributeForCompileClasspath(this.javaClasspathPackaging, sourceSet, compileTaskProvider, objectFactory);
        ((ConfigurationInternal)configurations.getByName(sourceSet.getCompileClasspathConfigurationName())).beforeLocking(configureLibraryElements);
    }

    private void configureTargetPlatform(TaskProvider<JavaCompile> compileTask, SourceSet sourceSet, ConfigurationContainer configurations) {
        this.jvmPluginServices.useDefaultTargetPlatformInference(configurations.getByName(sourceSet.getCompileClasspathConfigurationName()), compileTask);
        this.jvmPluginServices.useDefaultTargetPlatformInference(configurations.getByName(sourceSet.getRuntimeClasspathConfigurationName()), compileTask);
    }

    private TaskProvider<JavaCompile> createCompileJavaTask(SourceSet sourceSet, SourceDirectorySet sourceDirectorySet, Project target) {
        return target.getTasks().register(sourceSet.getCompileJavaTaskName(), JavaCompile.class, compileTask -> {
            compileTask.setDescription("Compiles " + sourceDirectorySet + ".");
            compileTask.setSource((FileTree)sourceDirectorySet);
            ConventionMapping conventionMapping = compileTask.getConventionMapping();
            conventionMapping.map("classpath", sourceSet::getCompileClasspath);
            JvmPluginsHelper.configureAnnotationProcessorPath(sourceSet, sourceDirectorySet, compileTask.getOptions(), target);
            String generatedHeadersDir = "generated/sources/headers/" + sourceDirectorySet.getName() + "/" + sourceSet.getName();
            compileTask.getOptions().getHeaderOutputDirectory().convention(target.getLayout().getBuildDirectory().dir(generatedHeadersDir));
            JavaPluginExtension javaPluginExtension = (JavaPluginExtension)target.getExtensions().getByType(JavaPluginExtension.class);
            compileTask.getModularity().getInferModulePath().convention((Provider)javaPluginExtension.getModularity().getInferModulePath());
            compileTask.getJavaCompiler().convention(this.getToolchainTool(target, JavaToolchainService::compilerFor));
        });
    }

    private void createProcessResourcesTask(SourceSet sourceSet, SourceDirectorySet resourceSet, Project target) {
        target.getTasks().register(sourceSet.getProcessResourcesTaskName(), ProcessResources.class, resourcesTask -> {
            resourcesTask.setDescription("Processes " + resourceSet + ".");
            new DslObject((Object)resourcesTask.getRootSpec()).getConventionMapping().map("destinationDir", () -> sourceSet.getOutput().getResourcesDir());
            resourcesTask.from(new Object[]{resourceSet});
        });
    }

    private void createClassesTask(SourceSet sourceSet, Project target) {
        sourceSet.compiledBy(target.getTasks().register(sourceSet.getClassesTaskName(), classesTask -> {
            classesTask.setGroup(BUILD_TASK_NAME);
            classesTask.setDescription("Assembles " + sourceSet.getOutput() + ".");
            classesTask.dependsOn(new Object[]{sourceSet.getOutput().getDirs()});
            classesTask.dependsOn(new Object[]{sourceSet.getCompileJavaTaskName()});
            classesTask.dependsOn(new Object[]{sourceSet.getProcessResourcesTaskName()});
        }));
    }

    private void definePathsForSourceSet(SourceSet sourceSet, ConventionMapping outputConventionMapping, Project project) {
        outputConventionMapping.map("resourcesDir", () -> {
            String classesDirName = "resources/" + sourceSet.getName();
            return new File(project.getBuildDir(), classesDirName);
        });
        sourceSet.getJava().srcDir((Object)("src/" + sourceSet.getName() + "/java"));
        sourceSet.getResources().srcDir((Object)("src/" + sourceSet.getName() + "/resources"));
    }

    private void defineConfigurationsForSourceSet(SourceSet sourceSet, ConfigurationContainer configurations) {
        String compileConfigurationName = sourceSet.getCompileConfigurationName();
        String implementationConfigurationName = sourceSet.getImplementationConfigurationName();
        String runtimeConfigurationName = sourceSet.getRuntimeConfigurationName();
        String runtimeOnlyConfigurationName = sourceSet.getRuntimeOnlyConfigurationName();
        String compileOnlyConfigurationName = sourceSet.getCompileOnlyConfigurationName();
        String compileClasspathConfigurationName = sourceSet.getCompileClasspathConfigurationName();
        String annotationProcessorConfigurationName = sourceSet.getAnnotationProcessorConfigurationName();
        String runtimeClasspathConfigurationName = sourceSet.getRuntimeClasspathConfigurationName();
        String apiElementsConfigurationName = sourceSet.getApiElementsConfigurationName();
        String runtimeElementsConfigurationName = sourceSet.getRuntimeElementsConfigurationName();
        String sourceSetName = sourceSet.toString();
        DeprecatableConfiguration compileConfiguration = (DeprecatableConfiguration)configurations.maybeCreate(compileConfigurationName);
        compileConfiguration.setVisible(false);
        compileConfiguration.setDescription("Dependencies for " + sourceSetName + " (deprecated, use '" + implementationConfigurationName + "' instead).");
        Configuration implementationConfiguration = (Configuration)configurations.maybeCreate(implementationConfigurationName);
        implementationConfiguration.setVisible(false);
        implementationConfiguration.setDescription("Implementation only dependencies for " + sourceSetName + ".");
        implementationConfiguration.setCanBeConsumed(false);
        implementationConfiguration.setCanBeResolved(false);
        implementationConfiguration.extendsFrom(new Configuration[]{compileConfiguration});
        DeprecatableConfiguration runtimeConfiguration = (DeprecatableConfiguration)configurations.maybeCreate(runtimeConfigurationName);
        runtimeConfiguration.setVisible(false);
        runtimeConfiguration.extendsFrom(new Configuration[]{compileConfiguration});
        runtimeConfiguration.setDescription("Runtime dependencies for " + sourceSetName + " (deprecated, use '" + runtimeOnlyConfigurationName + "' instead).");
        DeprecatableConfiguration compileOnlyConfiguration = (DeprecatableConfiguration)configurations.maybeCreate(compileOnlyConfigurationName);
        compileOnlyConfiguration.setVisible(false);
        compileOnlyConfiguration.setDescription("Compile only dependencies for " + sourceSetName + ".");
        ConfigurationInternal compileClasspathConfiguration = (ConfigurationInternal)configurations.maybeCreate(compileClasspathConfigurationName);
        compileClasspathConfiguration.setVisible(false);
        compileClasspathConfiguration.extendsFrom(new Configuration[]{compileOnlyConfiguration, implementationConfiguration});
        compileClasspathConfiguration.setDescription("Compile classpath for " + sourceSetName + ".");
        compileClasspathConfiguration.setCanBeConsumed(false);
        this.jvmPluginServices.configureAsCompileClasspath(compileClasspathConfiguration);
        ConfigurationInternal annotationProcessorConfiguration = (ConfigurationInternal)configurations.maybeCreate(annotationProcessorConfigurationName);
        annotationProcessorConfiguration.setVisible(false);
        annotationProcessorConfiguration.setDescription("Annotation processors and their dependencies for " + sourceSetName + ".");
        annotationProcessorConfiguration.setCanBeConsumed(false);
        annotationProcessorConfiguration.setCanBeResolved(true);
        this.jvmPluginServices.configureAsRuntimeClasspath(annotationProcessorConfiguration);
        Configuration runtimeOnlyConfiguration = (Configuration)configurations.maybeCreate(runtimeOnlyConfigurationName);
        runtimeOnlyConfiguration.setVisible(false);
        runtimeOnlyConfiguration.setCanBeConsumed(false);
        runtimeOnlyConfiguration.setCanBeResolved(false);
        runtimeOnlyConfiguration.setDescription("Runtime only dependencies for " + sourceSetName + ".");
        ConfigurationInternal runtimeClasspathConfiguration = (ConfigurationInternal)configurations.maybeCreate(runtimeClasspathConfigurationName);
        runtimeClasspathConfiguration.setVisible(false);
        runtimeClasspathConfiguration.setCanBeConsumed(false);
        runtimeClasspathConfiguration.setCanBeResolved(true);
        runtimeClasspathConfiguration.setDescription("Runtime classpath of " + sourceSetName + ".");
        runtimeClasspathConfiguration.extendsFrom(new Configuration[]{runtimeOnlyConfiguration, runtimeConfiguration, implementationConfiguration});
        this.jvmPluginServices.configureAsRuntimeClasspath(runtimeClasspathConfiguration);
        sourceSet.setCompileClasspath((FileCollection)compileClasspathConfiguration);
        sourceSet.setRuntimeClasspath(sourceSet.getOutput().plus((FileCollection)runtimeClasspathConfiguration));
        sourceSet.setAnnotationProcessorPath((FileCollection)annotationProcessorConfiguration);
        compileConfiguration.deprecateForDeclaration(new String[]{implementationConfigurationName});
        compileConfiguration.deprecateForConsumption(new String[]{apiElementsConfigurationName});
        compileConfiguration.deprecateForResolution(new String[]{compileClasspathConfigurationName});
        compileOnlyConfiguration.deprecateForConsumption(new String[]{apiElementsConfigurationName});
        compileOnlyConfiguration.deprecateForResolution(new String[]{compileClasspathConfigurationName});
        runtimeConfiguration.deprecateForDeclaration(new String[]{runtimeOnlyConfigurationName});
        runtimeConfiguration.deprecateForConsumption(new String[]{runtimeElementsConfigurationName});
        runtimeConfiguration.deprecateForResolution(new String[]{runtimeClasspathConfigurationName});
        compileClasspathConfiguration.deprecateForDeclaration(new String[]{implementationConfigurationName, compileOnlyConfigurationName});
        runtimeClasspathConfiguration.deprecateForDeclaration(new String[]{implementationConfigurationName, compileOnlyConfigurationName, runtimeOnlyConfigurationName});
    }

    private void configureCompileDefaults(Project project, JavaPluginConvention javaConvention) {
        JavaPluginExtension javaExtension = (JavaPluginExtension)project.getExtensions().getByType(JavaPluginExtension.class);
        DefaultJavaPluginConvention defaultJavaPluginConvention = (DefaultJavaPluginConvention)javaConvention;
        project.getTasks().withType(AbstractCompile.class).configureEach(compile -> {
            ConventionMapping conventionMapping = compile.getConventionMapping();
            conventionMapping.map("sourceCompatibility", this.determineCompatibility((AbstractCompile)compile, javaExtension, defaultJavaPluginConvention::getSourceCompatibility, defaultJavaPluginConvention::getRawSourceCompatibility));
            conventionMapping.map("targetCompatibility", this.determineCompatibility((AbstractCompile)compile, javaExtension, defaultJavaPluginConvention::getTargetCompatibility, defaultJavaPluginConvention::getRawTargetCompatibility));
        });
    }

    private Callable<String> determineCompatibility(AbstractCompile compile, JavaPluginExtension javaExtension, Supplier<JavaVersion> javaVersionSupplier, Supplier<JavaVersion> rawJavaVersionSupplier) {
        return () -> {
            GroovyCompile groovyCompile;
            if (compile instanceof JavaCompile) {
                JavaCompile javaCompile = (JavaCompile)compile;
                if (javaCompile.getOptions().getRelease().isPresent()) {
                    return JavaVersion.toVersion((Object)javaCompile.getOptions().getRelease().get()).toString();
                }
                if (javaCompile.getJavaCompiler().isPresent()) {
                    this.checkToolchainAndCompatibilityUsage(javaExtension, rawJavaVersionSupplier);
                    return ((JavaCompiler)javaCompile.getJavaCompiler().get()).getMetadata().getLanguageVersion().toString();
                }
            }
            if (compile instanceof GroovyCompile && (groovyCompile = (GroovyCompile)compile).getJavaLauncher().isPresent()) {
                this.checkToolchainAndCompatibilityUsage(javaExtension, rawJavaVersionSupplier);
                return ((JavaLauncher)groovyCompile.getJavaLauncher().get()).getMetadata().getLanguageVersion().toString();
            }
            return ((JavaVersion)javaVersionSupplier.get()).toString();
        };
    }

    private void checkToolchainAndCompatibilityUsage(JavaPluginExtension javaExtension, Supplier<JavaVersion> rawJavaVersionSupplier) {
        if (((DefaultToolchainSpec)javaExtension.getToolchain()).isConfigured() && rawJavaVersionSupplier.get() != null) {
            throw new InvalidUserDataException("The new Java toolchain feature cannot be used at the project level in combination with source and/or target compatibility");
        }
    }

    private void configureJavaDoc(Project project, JavaPluginConvention convention) {
        project.getTasks().withType(Javadoc.class).configureEach(javadoc -> {
            javadoc.getConventionMapping().map("destinationDir", () -> new File(convention.getDocsDir(), "javadoc"));
            javadoc.getConventionMapping().map("title", () -> ((ReportingExtension)project.getExtensions().getByType(ReportingExtension.class)).getApiDocTitle());
            javadoc.getJavadocTool().convention(this.getToolchainTool(project, JavaToolchainService::javadocToolFor));
        });
    }

    private void configureBuildNeeded(Project project) {
        project.getTasks().register(BUILD_NEEDED_TASK_NAME, buildTask -> {
            buildTask.setDescription("Assembles and tests this project and all projects it depends on.");
            buildTask.setGroup(BUILD_TASK_NAME);
            buildTask.dependsOn(new Object[]{BUILD_TASK_NAME});
        });
    }

    private void configureBuildDependents(Project project) {
        project.getTasks().register(BUILD_DEPENDENTS_TASK_NAME, buildTask -> {
            buildTask.setDescription("Assembles and tests this project and all projects that depend on it.");
            buildTask.setGroup(BUILD_TASK_NAME);
            buildTask.dependsOn(new Object[]{BUILD_TASK_NAME});
        });
    }

    private void configureTest(Project project, JavaPluginConvention convention) {
        project.getTasks().withType(Test.class).configureEach(test -> this.configureTestDefaults((Test)test, project, convention));
    }

    private void configureTestDefaults(Test test, Project project, JavaPluginConvention convention) {
        DirectoryReport htmlReport = test.getReports().getHtml();
        JUnitXmlReport xmlReport = test.getReports().getJunitXml();
        xmlReport.getOutputLocation().convention(project.getLayout().getProjectDirectory().dir(project.provider(() -> new File(convention.getTestResultsDir(), test.getName()).getAbsolutePath())));
        htmlReport.getOutputLocation().convention(project.getLayout().getProjectDirectory().dir(project.provider(() -> new File(convention.getTestReportDir(), test.getName()).getAbsolutePath())));
        test.getBinaryResultsDirectory().convention(project.getLayout().getProjectDirectory().dir(project.provider(() -> new File(convention.getTestResultsDir(), test.getName() + "/binary").getAbsolutePath())));
        test.workingDir((Object)project.getProjectDir());
        test.getJavaLauncher().convention(this.getToolchainTool(project, JavaToolchainService::launcherFor));
    }

    private <T> Provider<T> getToolchainTool(Project project, BiFunction<JavaToolchainService, JavaToolchainSpec, Provider<T>> toolMapper) {
        JavaPluginExtension extension = (JavaPluginExtension)project.getExtensions().getByType(JavaPluginExtension.class);
        JavaToolchainService service = (JavaToolchainService)project.getExtensions().getByType(JavaToolchainService.class);
        return toolMapper.apply(service, extension.getToolchain());
    }

    @Inject
    protected JavaToolchainQueryService getJavaToolchainQueryService() {
        throw new UnsupportedOperationException();
    }

    private /* synthetic */ void lambda$configureSourceSetDefaults$1(Project project, SourceSet sourceSet) {
        ConventionMapping outputConventionMapping = ((IConventionAware)sourceSet.getOutput()).getConventionMapping();
        ConfigurationContainer configurations = project.getConfigurations();
        this.defineConfigurationsForSourceSet(sourceSet, configurations);
        this.definePathsForSourceSet(sourceSet, outputConventionMapping, project);
        this.createProcessResourcesTask(sourceSet, sourceSet.getResources(), project);
        TaskProvider<JavaCompile> compileTask = this.createCompileJavaTask(sourceSet, sourceSet.getJava(), project);
        this.createClassesTask(sourceSet, project);
        this.configureLibraryElements(compileTask, sourceSet, configurations, project.getObjects());
        this.configureTargetPlatform(compileTask, sourceSet, configurations);
        JvmPluginsHelper.configureOutputDirectoryForSourceSet(sourceSet, sourceSet.getJava(), project, compileTask, (Provider<CompileOptions>)compileTask.map(JavaCompile::getOptions));
    }
}

