/*
 * Decompiled with CFR 0.152.
 */
package tokyocabinet;

import java.io.File;
import java.io.PrintStream;
import java.util.Random;
import tokyocabinet.FDB;
import tokyocabinet.Util;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
class FDBTest {
    private static final PrintStream STDOUT = System.out;
    private static final PrintStream STDERR = System.err;
    private static final Random RND = new Random();
    static /* synthetic */ Class class$tokyocabinet$FDBTest;

    public static void main(String[] stringArray) {
        int n = 0;
        if (stringArray.length < 1) {
            FDBTest.usage();
        }
        if (stringArray[0].equals("write")) {
            n = FDBTest.runwrite(stringArray);
        } else if (stringArray[0].equals("read")) {
            n = FDBTest.runread(stringArray);
        } else if (stringArray[0].equals("remove")) {
            n = FDBTest.runremove(stringArray);
        } else if (stringArray[0].equals("misc")) {
            n = FDBTest.runmisc(stringArray);
        } else {
            FDBTest.usage();
        }
        System.gc();
        System.exit(n);
    }

    private static final void usage() {
        STDERR.println("test cases of the fixed-length database API");
        STDERR.println("");
        STDERR.println("synopsis:");
        StringBuffer stringBuffer = new StringBuffer("  java ");
        Class clazz = class$tokyocabinet$FDBTest;
        if (clazz == null) {
            clazz = class$tokyocabinet$FDBTest = FDBTest.class("[Ltokyocabinet.FDBTest;", false);
        }
        STDERR.println(stringBuffer.append(clazz.getName()).append(" arguments...").toString());
        STDERR.println("");
        STDERR.println("arguments:");
        STDERR.println("  tchtest.rb write [-nl|-nb] path rnum [width [limsiz]]");
        STDERR.println("  tchtest.rb read [-nl|-nb] path");
        STDERR.println("  tchtest.rb remove [-nl|-nb] path");
        STDERR.println("  tchtest.rb misc [-nl|-nb] path rnum");
        STDERR.println("");
        System.exit(1);
    }

    private static final void eprint(FDB fDB, String string) {
        String string2 = fDB.path();
        StringBuffer stringBuffer = new StringBuffer();
        Class clazz = class$tokyocabinet$FDBTest;
        if (clazz == null) {
            clazz = class$tokyocabinet$FDBTest = FDBTest.class("[Ltokyocabinet.FDBTest;", false);
        }
        STDERR.println(stringBuffer.append(clazz.getName()).append(": ").append(string2).append(": ").append(string).append(": ").append(fDB.errmsg()).toString());
    }

    private static final int runwrite(String[] stringArray) {
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        int n = 0;
        int n2 = 1;
        while (n2 < stringArray.length) {
            String string5 = stringArray[n2];
            if (string == null && string5.startsWith("-")) {
                if (string5.equals("-nl")) {
                    n |= 0x10;
                } else if (string5.equals("-nb")) {
                    n |= 0x20;
                } else {
                    FDBTest.usage();
                }
            } else if (string == null) {
                string = string5;
            } else if (string2 == null) {
                string2 = string5;
            } else if (string3 == null) {
                string3 = string5;
            } else if (string4 == null) {
                string4 = string5;
            } else {
                FDBTest.usage();
            }
            ++n2;
        }
        if (string == null || string2 == null) {
            FDBTest.usage();
        }
        if ((n2 = Util.atoi(string2)) < 1) {
            FDBTest.usage();
        }
        int n3 = string3 != null ? Util.atoi(string3) : -1;
        long l = string4 != null ? Util.atol(string4) : (long)-1;
        int n4 = FDBTest.procwrite(string, n2, n3, l, n);
        return n4;
    }

    private static final int runread(String[] stringArray) {
        String string = null;
        int n = 0;
        int n2 = 1;
        while (n2 < stringArray.length) {
            String string2 = stringArray[n2];
            if (string == null && string2.startsWith("-")) {
                if (string2.equals("-nl")) {
                    n |= 0x10;
                } else if (string2.equals("-nb")) {
                    n |= 0x20;
                } else {
                    FDBTest.usage();
                }
            } else if (string == null) {
                string = string2;
            } else {
                FDBTest.usage();
            }
            ++n2;
        }
        if (string == null) {
            FDBTest.usage();
        }
        n2 = FDBTest.procread(string, n);
        return n2;
    }

    private static final int runremove(String[] stringArray) {
        String string = null;
        int n = 0;
        int n2 = 1;
        while (n2 < stringArray.length) {
            String string2 = stringArray[n2];
            if (string == null && string2.startsWith("-")) {
                if (string2.equals("-nl")) {
                    n |= 0x10;
                } else if (string2.equals("-nb")) {
                    n |= 0x20;
                } else {
                    FDBTest.usage();
                }
            } else if (string == null) {
                string = string2;
            } else {
                FDBTest.usage();
            }
            ++n2;
        }
        if (string == null) {
            FDBTest.usage();
        }
        n2 = FDBTest.procremove(string, n);
        return n2;
    }

    private static final int runmisc(String[] stringArray) {
        String string = null;
        String string2 = null;
        int n = 0;
        int n2 = 1;
        while (n2 < stringArray.length) {
            String string3 = stringArray[n2];
            if (string == null && string3.startsWith("-")) {
                if (string3.equals("-nl")) {
                    n |= 0x10;
                } else if (string3.equals("-nb")) {
                    n |= 0x20;
                } else {
                    FDBTest.usage();
                }
            } else if (string == null) {
                string = string3;
            } else if (string2 == null) {
                string2 = string3;
            } else {
                FDBTest.usage();
            }
            ++n2;
        }
        if (string == null || string2 == null) {
            FDBTest.usage();
        }
        if ((n2 = Util.atoi(string2)) < 1) {
            FDBTest.usage();
        }
        int n3 = FDBTest.procmisc(string, n2, n);
        return n3;
    }

    private static final int procwrite(String string, int n, int n2, long l, int n3) {
        STDOUT.println("<Writing Test>");
        STDOUT.println("  path=" + string + "  rnum=" + n + "  width=" + n2 + "  limsiz=" + l + "  omode=" + n3);
        STDOUT.println("");
        int n4 = 0;
        double d = Util.time();
        FDB fDB = new FDB();
        if (!fDB.tune(n2, l)) {
            FDBTest.eprint(fDB, "tune");
            n4 = 1;
        }
        if (!fDB.open(string, 0xE | n3)) {
            FDBTest.eprint(fDB, "open");
            n4 = 1;
        }
        int n5 = 1;
        while (n5 <= n) {
            String string2 = Util.itoa(n5, 8, '0');
            if (!fDB.put(string2, string2)) {
                FDBTest.eprint(fDB, "put");
                n4 = 1;
                break;
            }
            if (n > 250 && n5 % (n / 250) == 0) {
                STDOUT.print('.');
                if (n5 == n || n5 % (n / 10) == 0) {
                    STDOUT.println(" (" + string2 + ')');
                }
            }
            ++n5;
        }
        STDOUT.println("record number: " + fDB.rnum());
        STDOUT.println("size: " + fDB.fsiz());
        if (!fDB.close()) {
            FDBTest.eprint(fDB, "close");
            n4 = 1;
        }
        STDOUT.println("time: " + (Util.time() - d));
        STDOUT.println(n4 != 0 ? "error" : "ok");
        STDOUT.println("");
        return n4;
    }

    private static final int procread(String string, int n) {
        STDOUT.println("<Reading Test>");
        STDOUT.println("  path=" + string + "  omode=" + n);
        STDOUT.println("");
        int n2 = 0;
        double d = Util.time();
        FDB fDB = new FDB();
        if (!fDB.open(string, 1 | n)) {
            FDBTest.eprint(fDB, "open");
            n2 = 1;
        }
        int n3 = (int)fDB.rnum();
        int n4 = 1;
        while (n4 <= n3) {
            String string2 = Util.itoa(n4, 8, '0');
            if (fDB.get(string2) == null) {
                FDBTest.eprint(fDB, "get");
                n2 = 1;
                break;
            }
            if (n3 > 250 && n4 % (n3 / 250) == 0) {
                STDOUT.print('.');
                if (n4 == n3 || n4 % (n3 / 10) == 0) {
                    STDOUT.println(" (" + string2 + ')');
                }
            }
            ++n4;
        }
        STDOUT.println("record number: " + fDB.rnum());
        STDOUT.println("size: " + fDB.fsiz());
        if (!fDB.close()) {
            FDBTest.eprint(fDB, "close");
            n2 = 1;
        }
        STDOUT.println("time: " + (Util.time() - d));
        STDOUT.println(n2 != 0 ? "error" : "ok");
        STDOUT.println("");
        return n2;
    }

    private static final int procremove(String string, int n) {
        STDOUT.println("<Removing Test>");
        STDOUT.println("  path=" + string + "  omode=" + n);
        STDOUT.println("");
        int n2 = 0;
        double d = Util.time();
        FDB fDB = new FDB();
        if (!fDB.open(string, 2 | n)) {
            FDBTest.eprint(fDB, "open");
            n2 = 1;
        }
        int n3 = (int)fDB.rnum();
        int n4 = 1;
        while (n4 <= n3) {
            String string2 = Util.itoa(n4, 8, '0');
            if (!fDB.out(string2)) {
                FDBTest.eprint(fDB, "out");
                n2 = 1;
                break;
            }
            if (n3 > 250 && n4 % (n3 / 250) == 0) {
                STDOUT.print('.');
                if (n4 == n3 || n4 % (n3 / 10) == 0) {
                    STDOUT.println(" (" + string2 + ')');
                }
            }
            ++n4;
        }
        STDOUT.println("record number: " + fDB.rnum());
        STDOUT.println("size: " + fDB.fsiz());
        if (!fDB.close()) {
            FDBTest.eprint(fDB, "close");
            n2 = 1;
        }
        STDOUT.println("time: " + (Util.time() - d));
        STDOUT.println(n2 != 0 ? "error" : "ok");
        STDOUT.println("");
        return n2;
    }

    private static final int procmisc(String string, int n, int n2) {
        String string2;
        Object object;
        String string3;
        STDOUT.println("<Miscellaneous Test>");
        STDOUT.println("  path=" + string + "  rnum=" + n + "  omode=" + n2);
        STDOUT.println("");
        int n3 = 0;
        double d = Util.time();
        FDB fDB = new FDB();
        if (!fDB.tune(10, 1024 + 32 * n)) {
            FDBTest.eprint(fDB, "tune");
            n3 = 1;
        }
        if (!fDB.open(string, 0xE | n2)) {
            FDBTest.eprint(fDB, "open");
            n3 = 1;
        }
        STDOUT.println("writing:");
        int n4 = 1;
        while (n4 <= n) {
            string3 = Util.itoa(n4, 8, '0');
            if (!fDB.put(string3, string3)) {
                FDBTest.eprint(fDB, "put");
                n3 = 1;
                break;
            }
            if (n > 250 && n4 % (n / 250) == 0) {
                STDOUT.print('.');
                if (n4 == n || n4 % (n / 10) == 0) {
                    STDOUT.println(" (" + string3 + ')');
                }
            }
            ++n4;
        }
        STDOUT.println("reading:");
        n4 = 1;
        while (n4 <= n) {
            string3 = Util.itoa(n4, 8, '0');
            if (fDB.get(string3) == null) {
                FDBTest.eprint(fDB, "get");
                n3 = 1;
                break;
            }
            if (n > 250 && n4 % (n / 250) == 0) {
                STDOUT.print('.');
                if (n4 == n || n4 % (n / 10) == 0) {
                    STDOUT.println(" (" + string3 + ')');
                }
            }
            ++n4;
        }
        STDOUT.println("removing:");
        n4 = 1;
        while (n4 <= n) {
            string3 = Util.itoa(n4, 8, '0');
            if (RND.nextInt(2) == 0 && !fDB.out(string3)) {
                FDBTest.eprint(fDB, "get");
                n3 = 1;
                break;
            }
            if (n > 250 && n4 % (n / 250) == 0) {
                STDOUT.print('.');
                if (n4 == n || n4 % (n / 10) == 0) {
                    STDOUT.println(" (" + string3 + ')');
                }
            }
            ++n4;
        }
        STDOUT.println("checking iterator:");
        if (!fDB.iterinit()) {
            FDBTest.eprint(fDB, "iterinit");
            n3 = 1;
        }
        n4 = 0;
        while ((string3 = fDB.iternext2()) != null) {
            object = fDB.get(string3);
            if (object == null) {
                FDBTest.eprint(fDB, "get");
                n3 = 1;
            }
            if (n4 > 0 && n > 250 && n4 % (n / 250) == 0) {
                STDOUT.print('.');
                if (n4 == n || n4 % (n / 10) == 0) {
                    STDOUT.println(" (" + Util.itoa(n4, 8, '0') + ')');
                }
            }
            ++n4;
        }
        if (n > 250) {
            STDOUT.println(" (" + Util.itoa(n4, 8, '0') + ')');
        }
        if (fDB.ecode() != 22 || (long)n4 != fDB.rnum()) {
            FDBTest.eprint(fDB, "(validation)");
            n3 = 1;
        }
        object = fDB.range("[min,max]", 10);
        if (fDB.rnum() >= 10L && object.size() != 10) {
            FDBTest.eprint(fDB, "range");
            n3 = 1;
        }
        STDOUT.println("checking counting:");
        int n5 = 1;
        while (n5 <= n) {
            String string4 = "[" + (RND.nextInt(n) + 1) + ']';
            if (RND.nextInt(2) == 0) {
                if (fDB.addint(string4, 1) == Integer.MIN_VALUE && fDB.ecode() != 21) {
                    FDBTest.eprint(fDB, "addint");
                    n3 = 1;
                    break;
                }
            } else if (fDB.adddouble(string4, 1.0) == -2.147483648E9 && fDB.ecode() != 21) {
                FDBTest.eprint(fDB, "adddouble");
                n3 = 1;
                break;
            }
            if (n > 250 && n5 % (n / 250) == 0) {
                STDOUT.print('.');
                if (n5 == n || n5 % (n / 10) == 0) {
                    STDOUT.println(" (" + Util.itoa(n5, 8, '0') + ')');
                }
            }
            ++n5;
        }
        if (!fDB.sync()) {
            FDBTest.eprint(fDB, "sync");
            n3 = 1;
        }
        if (!fDB.optimize()) {
            FDBTest.eprint(fDB, "optimize");
            n3 = 1;
        }
        if (!fDB.copy(string2 = string + "-tmp")) {
            FDBTest.eprint(fDB, "copy");
            n3 = 1;
        }
        new File(string2).delete();
        if (!fDB.vanish()) {
            FDBTest.eprint(fDB, "vanish");
            n3 = 1;
        }
        STDOUT.println("checking transaction commit:");
        if (!fDB.tranbegin()) {
            FDBTest.eprint(fDB, "tranbegin");
            n3 = 1;
        }
        int n6 = 1;
        while (n6 <= n) {
            String string5 = "" + n6;
            if (RND.nextInt(2) == 0) {
                if (!fDB.putcat(string5, string5)) {
                    FDBTest.eprint(fDB, "putcat");
                    n3 = 1;
                    break;
                }
            } else if (!fDB.out(string5) && fDB.ecode() != 22) {
                FDBTest.eprint(fDB, "out");
                n3 = 1;
                break;
            }
            if (n > 250 && n6 % (n / 250) == 0) {
                STDOUT.print('.');
                if (n6 == n || n6 % (n / 10) == 0) {
                    STDOUT.println(" (" + Util.itoa(n6, 8, '0') + ')');
                }
            }
            ++n6;
        }
        if (!fDB.trancommit()) {
            FDBTest.eprint(fDB, "trancommit");
            n3 = 1;
        }
        STDOUT.println("checking transaction abort:");
        long l = fDB.rnum();
        long l2 = fDB.fsiz();
        if (!fDB.tranbegin()) {
            FDBTest.eprint(fDB, "tranbegin");
            n3 = 1;
        }
        int n7 = 1;
        while (n7 <= n) {
            String string6 = "" + n7;
            if (RND.nextInt(2) == 0) {
                if (!fDB.putcat(string6, string6)) {
                    FDBTest.eprint(fDB, "putcat");
                    n3 = 1;
                    break;
                }
            } else if (!fDB.out(string6) && fDB.ecode() != 22) {
                FDBTest.eprint(fDB, "out");
                n3 = 1;
                break;
            }
            if (n > 250 && n7 % (n / 250) == 0) {
                STDOUT.print('.');
                if (n7 == n || n7 % (n / 10) == 0) {
                    STDOUT.println(" (" + Util.itoa(n7, 8, '0') + ')');
                }
            }
            ++n7;
        }
        if (!fDB.tranabort()) {
            FDBTest.eprint(fDB, "trancommit");
            n3 = 1;
        }
        if (fDB.rnum() != l || fDB.fsiz() != l2) {
            FDBTest.eprint(fDB, "(validation)");
            n3 = 1;
        }
        STDOUT.println("checking common interface:");
        FDB fDB2 = fDB;
        int n8 = 1;
        while (n8 <= n) {
            String string7 = "[" + Util.itoa(RND.nextInt(n), 8, '0') + ']';
            int n9 = RND.nextInt(3);
            if (n9 == 0) {
                fDB2.put(string7, string7);
            } else if (n9 == 1) {
                fDB2.get(string7);
            } else {
                fDB2.out(string7);
            }
            if (n > 250 && n8 % (n / 250) == 0) {
                STDOUT.print('.');
                if (n8 == n || n8 % (n / 10) == 0) {
                    STDOUT.println(" (" + Util.itoa(n8, 8, '0') + ')');
                }
            }
            ++n8;
        }
        STDOUT.println("checking iterator:");
        n4 = 0;
        if (!fDB2.iterinit()) {
            FDBTest.eprint(fDB, "iterinit");
            n3 = 1;
        }
        while ((string3 = fDB2.iternext2()) != null) {
            String string8 = fDB2.get(string3);
            if (string8 == null) {
                FDBTest.eprint(fDB, "get");
                n3 = 1;
            }
            if (n4 > 0 && n > 250 && n4 % (n / 250) == 0) {
                STDOUT.print('.');
                if (n4 == n || n4 % (n / 10) == 0) {
                    STDOUT.println(" (" + Util.itoa(n4, 8, '0') + ')');
                }
            }
            ++n4;
        }
        if (n > 250) {
            STDOUT.println(" (" + Util.itoa(n4, 8, '0') + ')');
        }
        STDOUT.println("record number: " + fDB.rnum());
        STDOUT.println("size: " + fDB.fsiz());
        if (!fDB.close()) {
            FDBTest.eprint(fDB, "close");
            n3 = 1;
        }
        STDOUT.println("time: " + (Util.time() - d));
        STDOUT.println(n3 != 0 ? "error" : "ok");
        STDOUT.println("");
        return n3;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    private FDBTest() throws NoSuchMethodException {
        throw new NoSuchMethodException();
    }
}

