/*
 * Decompiled with CFR 0.152.
 */
package javax.imageio.metadata;

import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadataController;
import javax.imageio.metadata.IIOMetadataFormat;
import javax.imageio.metadata.IIOMetadataNode;
import org.w3c.dom.Node;

public abstract class IIOMetadata {
    protected IIOMetadataController controller;
    protected IIOMetadataController defaultController;
    protected String[] extraMetadataFormatClassNames;
    protected String[] extraMetadataFormatNames;
    protected String nativeMetadataFormatClassName;
    protected String nativeMetadataFormatName;
    protected boolean standardFormatSupported;

    public boolean activateController() {
        if (!this.hasController()) {
            return false;
        }
        return this.getDefaultController().activate(this);
    }

    public IIOMetadataController getController() {
        return this.controller;
    }

    public IIOMetadataController getDefaultController() {
        return this.defaultController;
    }

    public String[] getExtraMetadataFormatNames() {
        return (String[])this.extraMetadataFormatNames.clone();
    }

    public IIOMetadataFormat getMetadataFormat(String string) {
        Object object;
        if (string == null) {
            throw new IllegalArgumentException("formatName may not be null");
        }
        String string2 = null;
        if (this.isStandardMetadataFormatSupported() && string.equals(this.nativeMetadataFormatName)) {
            string2 = this.nativeMetadataFormatClassName;
        } else {
            object = this.getExtraMetadataFormatNames();
            int n = ((String[])object).length - 1;
            while (n >= 0) {
                if (object[n].equals(string)) {
                    string2 = object[n];
                    break;
                }
                --n;
            }
        }
        if (string2 == null) {
            throw new IllegalArgumentException("unknown format");
        }
        try {
            object = (IIOMetadataFormat)Class.forName(string2).newInstance();
        }
        catch (Exception exception) {
            IllegalStateException illegalStateException = new IllegalStateException();
            illegalStateException.initCause(exception);
            throw illegalStateException;
        }
        return object;
    }

    public String[] getMetadataFormatNames() {
        String[] stringArray = this.getExtraMetadataFormatNames();
        if (this.isStandardMetadataFormatSupported()) {
            String[] stringArray2 = new String[stringArray.length + 1];
            stringArray2[0] = this.getNativeMetadataFormatName();
            int n = 1;
            while (n < stringArray2.length) {
                stringArray2[n] = stringArray[n - 1];
                ++n;
            }
            stringArray = stringArray2;
        }
        return stringArray;
    }

    public String getNativeMetadataFormatName() {
        return this.nativeMetadataFormatName;
    }

    public boolean hasController() {
        boolean bl = false;
        if (this.getController() != null) {
            bl = true;
        }
        return bl;
    }

    public abstract boolean isReadOnly();

    public boolean isStandardMetadataFormatSupported() {
        return this.standardFormatSupported;
    }

    public abstract void reset();

    public void setController(IIOMetadataController iIOMetadataController) {
        this.controller = iIOMetadataController;
    }

    public abstract Node getAsTree(String var1);

    protected IIOMetadataNode getStandardChromaNode() {
        return null;
    }

    protected IIOMetadataNode getStandardCompressionNode() {
        return null;
    }

    protected IIOMetadataNode getStandardDataNode() {
        return null;
    }

    protected IIOMetadataNode getStandardDimensionNode() {
        return null;
    }

    protected IIOMetadataNode getStandardDocumentNode() {
        return null;
    }

    protected IIOMetadataNode getStandardTextNode() {
        return null;
    }

    protected IIOMetadataNode getStandardTileNode() {
        return null;
    }

    protected IIOMetadataNode getStandardTransparencyNode() {
        return null;
    }

    private final void appendChild(IIOMetadataNode iIOMetadataNode, IIOMetadataNode iIOMetadataNode2) {
        if (iIOMetadataNode2 != null) {
            iIOMetadataNode.appendChild(iIOMetadataNode2);
        }
    }

    protected final IIOMetadataNode getStandardTree() {
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode();
        this.appendChild(iIOMetadataNode, this.getStandardChromaNode());
        this.appendChild(iIOMetadataNode, this.getStandardCompressionNode());
        this.appendChild(iIOMetadataNode, this.getStandardDataNode());
        this.appendChild(iIOMetadataNode, this.getStandardDimensionNode());
        this.appendChild(iIOMetadataNode, this.getStandardDocumentNode());
        this.appendChild(iIOMetadataNode, this.getStandardTextNode());
        this.appendChild(iIOMetadataNode, this.getStandardTileNode());
        this.appendChild(iIOMetadataNode, this.getStandardTransparencyNode());
        return iIOMetadataNode;
    }

    public abstract void mergeTree(String var1, Node var2) throws IIOInvalidTreeException;

    public void setFromTree(String string, Node node2) throws IIOInvalidTreeException {
        this.reset();
        this.mergeTree(string, node2);
    }

    protected IIOMetadata() {
    }

    protected IIOMetadata(boolean bl, String string, String string2, String[] stringArray, String[] stringArray2) {
        if (stringArray != null && stringArray.length == 0) {
            throw new IllegalArgumentException("extraMetadataFormatNames may not be empty");
        }
        if (stringArray == null && stringArray2 != null || stringArray != null && stringArray2 == null || stringArray != null && stringArray2 != null && stringArray.length != stringArray2.length) {
            throw new IllegalArgumentException("extraMetadataFormatNames and extraMetadataFormatClassNames have different lengths");
        }
        this.standardFormatSupported = bl;
        this.nativeMetadataFormatName = string;
        this.nativeMetadataFormatClassName = string2;
        this.extraMetadataFormatNames = stringArray;
        this.extraMetadataFormatClassNames = stringArray2;
    }
}

