/*
 * Decompiled with CFR 0.152.
 */
package org.sablecc.sablecc;

import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Map;
import java.util.Vector;
import org.sablecc.sablecc.AcceptStates;
import org.sablecc.sablecc.ConstructNFA;
import org.sablecc.sablecc.DFA;
import org.sablecc.sablecc.MacroExpander;
import org.sablecc.sablecc.NFA;
import org.sablecc.sablecc.ResolveIds;
import org.sablecc.sablecc.Transitions;
import org.sablecc.sablecc.analysis.AnalysisAdapter;
import org.sablecc.sablecc.node.Node;
import org.sablecc.sablecc.node.Start1;

public class GenLexer
extends AnalysisAdapter {
    private MacroExpander macros;
    private ResolveIds ids;
    private File pkgDir;
    private String pkgName;
    private AcceptStates[] acceptStatesArray;
    private Transitions transitions;

    public GenLexer(ResolveIds resolveIds) {
        this.ids = resolveIds;
        try {
            this.macros = new MacroExpander(new InputStreamReader(this.getClass().getResourceAsStream("lexer.txt")));
        }
        catch (IOException iOException) {
            throw new RuntimeException("unable to open lexer.txt.");
        }
        this.pkgDir = new File(resolveIds.pkgDir, "lexer");
        String string = this.pkgName = resolveIds.pkgName.equals("") ? "lexer" : String.valueOf(resolveIds.pkgName) + ".lexer";
        if (!this.pkgDir.exists() && !this.pkgDir.mkdir()) {
            throw new RuntimeException("Unable to create " + this.pkgDir.getAbsolutePath());
        }
    }

    public void caseStart1(Start1 start1) {
        int n = Math.max(1, this.ids.stateList.size());
        this.acceptStatesArray = new AcceptStates[n];
        String[] stringArray = new String[n];
        if (this.ids.stateList.size() == 0) {
            stringArray[0] = "INITIAL";
        } else {
            Iterator iterator = this.ids.stateList.iterator();
            int n2 = 0;
            while (n2 < n) {
                stringArray[n2] = (String)iterator.next();
                ++n2;
            }
        }
        int n3 = 0;
        while (n3 < n) {
            System.out.println(" State: " + stringArray[n3]);
            System.out.println(" - Constructing NFA.");
            ConstructNFA constructNFA = new ConstructNFA(this.ids, stringArray[n3]);
            start1.apply(constructNFA);
            System.out.println();
            NFA nFA = (NFA)constructNFA.getOut(start1);
            constructNFA = null;
            System.out.println(" - Constructing DFA.");
            DFA dFA = new DFA(nFA);
            System.out.println();
            System.out.println(" - resolving ACCEPT states.");
            this.acceptStatesArray[n3] = new AcceptStates(dFA, this.ids, stringArray[n3]);
            start1.apply(this.acceptStatesArray[n3]);
            ++n3;
        }
        this.transitions = new Transitions();
        start1.apply(this.transitions);
        this.createLexerException();
        this.createLexer();
    }

    private void createLexer() {
        BufferedWriter bufferedWriter;
        try {
            bufferedWriter = new BufferedWriter(new FileWriter(new File(this.pkgDir, "Lexer.java")));
        }
        catch (IOException iOException) {
            throw new RuntimeException("Unable to create " + new File(this.pkgDir, "Lexer.java").getAbsolutePath());
        }
        try {
            Object object;
            Object object2;
            Object object3;
            Vector<Object> vector;
            Object object4;
            int n;
            Object object5;
            Object object6;
            String string = "INITIAL";
            if (this.ids.stateList.size() > 0) {
                string = (String)this.ids.stateList.getFirst();
            }
            this.macros.apply(bufferedWriter, "LexerHeader", new String[]{this.pkgName, this.ids.pkgName.equals("") ? "node" : String.valueOf(this.ids.pkgName) + ".node", string});
            ListIterator listIterator = this.ids.tokenList.listIterator();
            while (listIterator.hasNext()) {
                object6 = (String)listIterator.next();
                object5 = (Node)this.ids.tokens.get(object6);
                n = ((Boolean)this.ids.fixedTokens.get(object5)).booleanValue();
                if (n != 0) {
                    this.macros.apply(bufferedWriter, "LexerFixedToken", new String[]{String.valueOf(listIterator.previousIndex()), object6});
                } else {
                    this.macros.apply(bufferedWriter, "LexerVariableToken", new String[]{String.valueOf(listIterator.previousIndex()), object6});
                }
                object4 = (Map)this.transitions.tokenStates.get(object5);
                if (object4.size() > 0) {
                    this.macros.apply(bufferedWriter, "TokenSwitchHeader", null);
                    vector = object4.entrySet().iterator();
                    while (vector.hasNext()) {
                        Map.Entry entry = (Map.Entry)vector.next();
                        this.macros.apply(bufferedWriter, "TokenCase", new String[]{String.valueOf(this.ids.stateList.indexOf((String)entry.getKey())), (String)entry.getValue()});
                    }
                    this.macros.apply(bufferedWriter, "TokenSwitchTail", null);
                }
                this.macros.apply(bufferedWriter, "LexerTokenTail", null);
            }
            this.macros.apply(bufferedWriter, "LexerBody1");
            object6 = this.ids.tokenList.listIterator();
            while (object6.hasNext()) {
                object5 = (String)object6.next();
                Node node = (Node)this.ids.tokens.get(object5);
                boolean bl = (Boolean)this.ids.fixedTokens.get(node);
                if (bl) {
                    this.macros.apply(bufferedWriter, "LexerNewFixedToken", new String[]{String.valueOf(object6.previousIndex()), object5});
                    continue;
                }
                this.macros.apply(bufferedWriter, "LexerNewVariableToken", new String[]{String.valueOf(object6.previousIndex()), object5});
            }
            this.macros.apply(bufferedWriter, "LexerBody2");
            object5 = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(new File(this.pkgDir, "lexer.dat"))));
            ((DataOutputStream)object5).writeInt(this.acceptStatesArray.length);
            n = 0;
            while (n < this.acceptStatesArray.length) {
                object4 = this.acceptStatesArray[n].dfa;
                bufferedWriter.write("        { // " + this.acceptStatesArray[n].stateName + System.getProperty("line.separator"));
                vector = new Vector<Object>();
                int n2 = 0;
                while (n2 < ((DFA)object4).states.size()) {
                    object3 = new Vector();
                    object2 = (DFA.State)((DFA)object4).states.elementAt(n2);
                    bufferedWriter.write("            {");
                    int n3 = 0;
                    while (n3 < ((DFA.State)object2).transitions.size()) {
                        object = (DFA.Transition)((DFA.State)object2).transitions.elementAt(n3);
                        bufferedWriter.write("{" + ((DFA.Transition)object).interval().start + ", " + ((DFA.Transition)object).interval().end + ", " + ((DFA.Transition)object).destination + "}, ");
                        ((Vector)object3).addElement(new int[]{((DFA.Transition)object).interval().start, ((DFA.Transition)object).interval().end, ((DFA.Transition)object).destination});
                        ++n3;
                    }
                    bufferedWriter.write("}," + System.getProperty("line.separator"));
                    vector.addElement(object3);
                    ++n2;
                }
                bufferedWriter.write("        }" + System.getProperty("line.separator"));
                ((DataOutputStream)object5).writeInt(vector.size());
                object3 = vector.elements();
                while (object3.hasMoreElements()) {
                    object2 = (Vector)object3.nextElement();
                    ((DataOutputStream)object5).writeInt(((Vector)object2).size());
                    Enumeration enumeration = ((Vector)object2).elements();
                    while (enumeration.hasMoreElements()) {
                        object = (int[])enumeration.nextElement();
                        int n4 = 0;
                        while (n4 < 3) {
                            ((DataOutputStream)object5).writeInt((int)object[n4]);
                            ++n4;
                        }
                    }
                }
                ++n;
            }
            this.macros.apply(bufferedWriter, "LexerAcceptHeader");
            int n5 = this.acceptStatesArray.length;
            vector = new Vector();
            int n6 = 0;
            while (n6 < n5) {
                object3 = this.acceptStatesArray[n6].dfa;
                object2 = new Vector();
                bufferedWriter.write("        // " + this.acceptStatesArray[n6].stateName + System.getProperty("line.separator"));
                bufferedWriter.write("        {");
                int n7 = 0;
                while (n7 < ((DFA)object3).states.size()) {
                    object = (DFA.State)((DFA)object3).states.elementAt(n7);
                    bufferedWriter.write(String.valueOf(((DFA.State)object).accept) + ", ");
                    ((Vector)object2).addElement(new Integer(((DFA.State)object).accept));
                    ++n7;
                }
                bufferedWriter.write("}," + System.getProperty("line.separator"));
                vector.addElement(object2);
                ++n6;
            }
            ((DataOutputStream)object5).writeInt(vector.size());
            object3 = vector.elements();
            while (object3.hasMoreElements()) {
                object2 = (Vector)object3.nextElement();
                ((DataOutputStream)object5).writeInt(((Vector)object2).size());
                Enumeration enumeration = ((Vector)object2).elements();
                while (enumeration.hasMoreElements()) {
                    object = (Integer)enumeration.nextElement();
                    ((DataOutputStream)object5).writeInt((Integer)object);
                }
            }
            ((FilterOutputStream)object5).close();
            bufferedWriter.write(System.getProperty("line.separator"));
            this.macros.apply(bufferedWriter, "LexerAcceptTail");
            this.macros.apply(bufferedWriter, "LexerStateHeader");
            if (this.ids.stateList.size() > 0) {
                object2 = this.ids.stateList.listIterator();
                while (object2.hasNext()) {
                    String string2 = (String)object2.next();
                    this.macros.apply(bufferedWriter, "LexerStateBody", new String[]{string2, String.valueOf(object2.previousIndex())});
                }
            } else {
                this.macros.apply(bufferedWriter, "LexerStateBody", new String[]{"INITIAL", "0"});
            }
            this.macros.apply(bufferedWriter, "LexerStateTail");
            this.macros.apply(bufferedWriter, "LexerTail");
        }
        catch (IOException iOException) {
            throw new RuntimeException("An error occured while writing to " + new File(this.pkgDir, "Lexer.java").getAbsolutePath());
        }
        try {
            bufferedWriter.close();
        }
        catch (IOException iOException) {}
    }

    private void createLexerException() {
        BufferedWriter bufferedWriter;
        try {
            bufferedWriter = new BufferedWriter(new FileWriter(new File(this.pkgDir, "LexerException.java")));
        }
        catch (IOException iOException) {
            throw new RuntimeException("Unable to create " + new File(this.pkgDir, "LexerException.java").getAbsolutePath());
        }
        try {
            this.macros.apply(bufferedWriter, "LexerException", new String[]{this.pkgName});
        }
        catch (IOException iOException) {
            throw new RuntimeException("An error occured while writing to " + new File(this.pkgDir, "LexerException.java").getAbsolutePath());
        }
        try {
            bufferedWriter.close();
        }
        catch (IOException iOException) {}
    }
}

