#
#  finance.yahoo.com stock service
#  yahoo provides a nice 'csv' format, easy to parse
#  decimal values returned by yahoo

proc finance.yahoo.com {} {
    global ticker_symbols data
    set i 0
    set symbol_list ""
    while {[info exists ticker_symbols([incr i])]} {
	lappend symbol_list [string toupper $ticker_symbols($i)]
    }
    if {[llength $symbol_list] == 0} {
        return 0
    }
    foreach sym $symbol_list {
        set newdata($sym,last) ""
        set newdata($sym,sign) ""
        set newdata($sym,delta) ""
    }
    set symvar [cgi_cgi_set s $symbol_list]
    set timeout [expr {3 * 60000}]
    set id [http::geturl \
        http://finance.yahoo.com/d/quotes.csv?f=sl1d1t1c1ohgv&e=.csv&$symvar \
	-timeout $timeout]
    if {"[http::wait $id]" != "ok"} {
	return 0
    }
    set html [http::data $id]
    catch {unset $id}
    foreach line [split $html \n] {
	# further split on comma to separate quote values
	set datavals [split $line ,]
	if {[llength $datavals] != 9} continue
	foreach {sym last date time change bid ask open vol} $datavals {
	    break
	}
	# remove double quotes around symbols
	regsub -all \" $sym {} sym
	# make sure symbol and quote values are valid
	if {[string length $sym] == 0} continue
	if {[scan $last   %f v] != 1}  continue
	if {[scan $change %f v] != 1}  continue

	set newdata($sym,last) $last
        if {$change > 0} {
	    set newdata($sym,sign) +
	} elseif {$change < 0} {
	    set newdata($sym,sign) -
	} else {
	    set newdata($sym,sign) =
	}
	set newdata($sym,delta) $change
    }
    array set data [array get newdata]
    return 1
}


