#
#  www.quote.com stock service
#  quote.com provides a typical html table buried in the page, lots of
#  parsing to get the values
#  fractional values returned by quote.com, no daily change on mutual funds

proc www.quote.com {} {
    global ticker_symbols data
    set i 0
    set symbol_list ""
    while {[info exists ticker_symbols([incr i])]} {
	lappend symbol_list [string toupper $ticker_symbols($i)]
    }
    if {[llength $symbol_list] == 0} {
        return 0
    }
    foreach sym $symbol_list {
	set newdata($sym,last) ""
	set newdata($sym,sign) ""
	set newdata($sym,delta) ""
    }
    if {[llength $symbol_list] == 1} {
	# a single symbol returns a different format, add a bogus symbol
	lappend symbol_list BOGUSTICK
    }
    set symvar [cgi_cgi_set symbols $symbol_list]
    # change $ to uri code, for composite e.g., '$compx' = nasdaq composite idx
    regsub -all {\$} $symbol_list %24 symbol_list
    set timeout [expr {3 * 60000}]    
    set id [http::geturl \
        http://mach.quote.com/fq/fq_quote.asp?$symvar&symtype=st&mode= \
	-timeout $timeout]
    if {"[http::wait $id]" != "ok"} {
	return 0
    }
    set html [http::data $id]
    catch {unset $id}
    # find start of quote table, stock or fund, throw away beginning portion
    if {[regexp -indices {Change|52 Week High} $html indx]} {
	set html [string range $html [lindex $indx 1] end]
    }
    # clean up newlines and special characters
    regsub -all \n $html {} html
    regsub -all \r $html {} html
    regsub -all {&nbsp;} $html {} html
    # make each table row a newline so with can split on it
    regsub -all -nocase {</tr>} $html \n html
    foreach line [lrange [split $html \n] 1 end] {
	# make the table data tags a newline so we can further split it
	regsub -all -nocase {</td>} $line \n line
	# remove all other html tags
        regsub -all {<[^>]*>} $line { } line
	# remove any left over html tag stuff
	regsub -all {>} $line {} line
	# make multiple whitespace into a single space
	regsub -all "\[ \t\]\[ \t\]?" $line { } line
	# if we hit another TABLE line, we've got all info, break out
	#if {[regexp -nocase TABLE $line]} break
	# make fractional values neater by eliminating spaces around /
	regsub -all " / " $line / line
	set quoteline  [split $line \n]
	# stock and mutual funds come back in different tables :(
	if {[llength $quoteline] == 9} {
	    # stock line: pick out symbol, last, and quote
	    foreach {sym last change} $quoteline {
	        break
	    }
	} elseif {[llength $quoteline] == 8} {
	    # mutual fund line: pick out symbol, date nav, (no change amount)
	    foreach {sym date last} $quoteline {
	        break
	    }
	    # www.quote.com doesn't provide a daily change amount for funds :(
	    set change ""
	} else {
	    continue
	}
	set sym [string trim $sym]
	# make sure we don't get our bogus symbol, or any other bad symbols
	if {[string compare $sym BOGUSTICK] == 0} continue
	if {[string length $sym] == 0} continue
	if {[scan $last   %f v] != 1}    continue

	set newdata($sym,last) [string trim $last]
	# www.quote.com normal uses a graphic to indicate change, instead look
	# at the + or - in the percentage string
        if {[regexp -- - $change]} {
	    set newdata($sym,sign) -
	    set change "-[string trim $change]"
	} elseif {[string length $change]} {
	    set newdata($sym,sign) +
	    set change "+[string trim $change]"
	} else {
	    set newdata($sym,sign) =
	}
	# remove the percentage change e.g., "(+1.24%)"
	regsub {\([^)]*\)} $change {} change
	set newdata($sym,delta) [string trim $change]
    }
    array set data [array get newdata]
    return 1
}


