/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;

public abstract class Definer
extends Task {
    private String name;
    private String value;
    private Path classpath;
    private File file;
    private String resource;
    private boolean reverseLoader = false;
    private String loaderId = null;
    private String classpathId = null;
    private static final String REUSE_LOADER_REF = "ant.reuse.loader";

    public void setReverseLoader(boolean reverseLoader) {
        this.reverseLoader = reverseLoader;
        this.log("The reverseloader attribute is DEPRECATED. It will be removed", 1);
    }

    public void setClasspath(Path classpath) {
        if (this.classpath == null) {
            this.classpath = classpath;
        } else {
            this.classpath.append(classpath);
        }
    }

    public Path createClasspath() {
        if (this.classpath == null) {
            this.classpath = new Path(this.project);
        }
        return this.classpath.createPath();
    }

    public void setClasspathRef(Reference r) {
        this.classpathId = r.getRefId();
        this.createClasspath().setRefid(r);
    }

    public void setLoaderRef(Reference r) {
        this.loaderId = r.getRefId();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute() throws BuildException {
        AntClassLoader al = this.createLoader();
        if (this.file == null && this.resource == null) {
            if (this.name != null && this.value != null) {
                this.addDefinition(al, this.name, this.value);
                return;
            }
            String msg = "name or classname attributes of " + this.getTaskName() + " element " + "are undefined";
            throw new BuildException(msg);
        }
        InputStream is = null;
        try {
            try {
                if (this.name != null || this.value != null) {
                    String msg = "You must not specify name or value together with file or resource.";
                    throw new BuildException(msg, this.location);
                }
                if (this.file != null && this.resource != null) {
                    String msg = "You must not specify both, file and resource.";
                    throw new BuildException(msg, this.location);
                }
                Properties props = new Properties();
                if (this.file != null) {
                    this.log("Loading definitions from file " + this.file, 3);
                    is = new FileInputStream(this.file);
                    if (is == null) {
                        this.log("Could not load definitions from file " + this.file + ". It doesn't exist.", 1);
                    }
                }
                if (this.resource != null) {
                    this.log("Loading definitions from resource " + this.resource, 3);
                    is = al.getResourceAsStream(this.resource);
                    if (is == null) {
                        this.log("Could not load definitions from resource " + this.resource + ". It could not be found.", 1);
                    }
                }
                if (is != null) {
                    props.load(is);
                    Enumeration keys = ((Hashtable)props).keys();
                    while (keys.hasMoreElements()) {
                        String n = (String)keys.nextElement();
                        String v = props.getProperty(n);
                        this.addDefinition(al, n, v);
                    }
                }
                Object var8_11 = null;
                if (is == null) return;
            }
            catch (IOException ex) {
                throw new BuildException(ex, this.location);
            }
        }
        catch (Throwable throwable) {
            Object var8_12 = null;
            if (is == null) throw throwable;
            try {
                is.close();
                throw throwable;
            }
            catch (IOException e) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException e) {}
        is.close();
        return;
    }

    private void addDefinition(ClassLoader al, String name, String value) throws BuildException {
        try {
            Class<?> c = al.loadClass(value);
            AntClassLoader.initializeClass(c);
            this.addDefinition(name, c);
        }
        catch (ClassNotFoundException cnfe) {
            String msg = this.getTaskName() + " class " + value + " cannot be found";
            throw new BuildException(msg, cnfe, this.location);
        }
        catch (NoClassDefFoundError ncdfe) {
            String msg = this.getTaskName() + " class " + value + " cannot be found";
            throw new BuildException(msg, ncdfe, this.location);
        }
    }

    private AntClassLoader createLoader() {
        Object reusedLoader;
        if (this.project.getProperty(REUSE_LOADER_REF) != null && this.loaderId == null && this.classpathId != null) {
            this.loaderId = "ant.loader." + this.classpathId;
        }
        if (this.loaderId != null && (reusedLoader = this.project.getReference(this.loaderId)) != null && reusedLoader instanceof AntClassLoader) {
            return (AntClassLoader)reusedLoader;
        }
        AntClassLoader al = null;
        al = this.classpath != null ? new AntClassLoader(this.project, this.classpath, !this.reverseLoader) : new AntClassLoader(this.project, Path.systemClasspath, !this.reverseLoader);
        al.addSystemPackageRoot("org.apache.tools.ant");
        if (this.loaderId != null && this.project.getReference(this.loaderId) == null) {
            this.project.addReference(this.loaderId, al);
        }
        return al;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public void setResource(String res) {
        this.resource = res;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getClassname() {
        return this.value;
    }

    public void setClassname(String v) {
        this.value = v;
    }

    protected abstract void addDefinition(String var1, Class var2);
}

