/*
 * Decompiled with CFR 0.152.
 */
package org.igoweb.igoweb.client.swing;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.igoweb.igoweb.client.CConvo;
import org.igoweb.igoweb.client.Client;
import org.igoweb.igoweb.client.swing.GuiClientUtil;
import org.igoweb.igoweb.shared.User;
import org.igoweb.util.Defs;
import org.igoweb.util.Event;
import org.igoweb.util.EventListener;
import org.igoweb.util.swing.ATextField;
import org.igoweb.util.swing.DFrame;
import org.igoweb.util.swing.Errout;
import org.igoweb.util.swing.MsgOut;
import org.igoweb.util.swing.TBlock;

public class LeaveMessageWindow
extends DFrame
implements ActionListener,
EventListener {
    private final Client client;
    private final ATextField nameIn = new ATextField();
    private final JTextArea msgIn = new JTextArea();
    private final JButton okBut;

    public LeaveMessageWindow(Client client, Component parent) {
        super(Defs.getString(-903340527), parent);
        this.client = client;
        GuiClientUtil.addToWindowList(client, this);
        JComponent panel = this.getMainPanel();
        panel.add("xSpan=2,xGrow=f", new TBlock(Defs.getString(-903340526, 1000.0), 40));
        panel.add("x=0,xSpan=1", new JLabel(Defs.getString(-903340680)));
        panel.add("xGrow=t", this.nameIn);
        panel.add("x=0,xSpan=2,xGrow=f", new JLabel(Defs.getString(-903340693)));
        this.msgIn.setLineWrap(true);
        this.msgIn.setWrapStyleWord(true);
        panel.add("x=0,xSpan=2,xGrow=f,yGrow=t", new JScrollPane(this.msgIn, 20, 31));
        this.okBut = this.addButton(Defs.getString(1436228518), this);
        this.addButton(Defs.getString(1436228510), this);
        this.pack(parent);
        this.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (event.getSource() == this.okBut && this.msgIn.getText().length() > 0) {
            String dest = this.nameIn.getText().trim();
            if (!User.nameValid(dest)) {
                new Errout(Defs.getString(-903340799, dest), this);
                return;
            }
            if (this.client.getMe().canonName().equals(User.canonName(dest))) {
                new Errout(Defs.getString(-903340513), this);
                return;
            }
            String msg = this.msgIn.getText();
            if (msg.length() > 1000) {
                new Errout(Defs.getString(-903340525), this);
                return;
            }
            this.client.leaveMessage(dest, msg, this);
            this.msgIn.setEnabled(false);
            this.nameIn.setEnabled(false);
            this.okBut.setEnabled(false);
        } else {
            this.dispose();
        }
    }

    @Override
    public void handleEvent(Event event) {
        switch (event.type) {
            case 101: {
                this.dispose();
                break;
            }
            case 102: 
            case 117: {
                new Errout(Defs.getString(event.type == 102 ? -903340594 : -903340593, this.nameIn.getText().trim()), this);
                this.msgIn.setEnabled(true);
                this.nameIn.setEnabled(true);
                this.okBut.setEnabled(true);
                break;
            }
            case 103: {
                this.convertToTell(this.nameIn.getText().trim(), this.msgIn.getText());
                break;
            }
            case 94: {
                ((CConvo)event.arg).sendChat(this.msgIn.getText());
            }
        }
    }

    public void convertToTell(String who, String message) {
        String peer = this.nameIn.getText().trim();
        new MsgOut(Defs.getString(-903340709), Defs.getString(-903340543, this.nameIn.getText().trim()), 1, (Component)this);
        CConvo convo = this.client.getConvo(peer);
        if (convo == null) {
            this.client.createConvo(peer, this);
        } else {
            convo.sendChat(this.msgIn.getText());
        }
        this.dispose();
    }

    @Override
    public Dimension getDefaultPreferredSize() {
        Dimension prevPref = super.getDefaultPreferredSize();
        return new Dimension(prevPref.width, prevPref.height * 3 / 2);
    }
}

