/*
 * Decompiled with CFR 0.152.
 */
package org.campagnelab.goby.alignments.processors;

import edu.cornell.med.icb.identifier.IndexedIdentifier;
import it.unimi.dsi.fastutil.AbstractPriorityQueue;
import it.unimi.dsi.fastutil.objects.ObjectHeapPriorityQueue;
import java.io.IOException;
import java.util.Comparator;
import org.campagnelab.goby.alignments.Alignments;
import org.campagnelab.goby.alignments.processors.AlignmentProcessorInterface;
import org.campagnelab.goby.reads.RandomAccessSequenceInterface;

public class LocalSortProcessor
implements AlignmentProcessorInterface {
    AbstractPriorityQueue<Alignments.AlignmentEntry> entryHeap;
    AlignmentProcessorInterface delegate;
    private int windowLength = 30;
    private int processedCount = 0;
    private int modifiedCount = 0;
    final Comparator<? super Alignments.AlignmentEntry> comparator = new Comparator<Alignments.AlignmentEntry>(){

        @Override
        public int compare(Alignments.AlignmentEntry alignmentEntry, Alignments.AlignmentEntry alignmentEntry1) {
            int targetDiff = alignmentEntry.getTargetIndex() - alignmentEntry1.getTargetIndex();
            if (targetDiff != 0) {
                return targetDiff;
            }
            int value = alignmentEntry.getPosition() - alignmentEntry1.getPosition();
            return value;
        }
    };
    private int lastCurrentPosition;
    private int lastTargetIndex;
    int currentTargetIndex = Integer.MAX_VALUE;
    int currentPosition = 0;
    boolean finished = false;

    public LocalSortProcessor(AlignmentProcessorInterface delegate) {
        this.delegate = delegate;
        this.entryHeap = new ObjectHeapPriorityQueue(10000, this.comparator);
    }

    @Override
    public Alignments.AlignmentEntry nextRealignedEntry(int targetIndex, int position) throws IOException {
        Alignments.AlignmentEntry entry;
        if (this.finished && this.entryHeap.isEmpty()) {
            return null;
        }
        boolean mustLoadPool = false;
        if (!this.finished) {
            if (this.entryHeap.isEmpty()) {
                mustLoadPool = true;
            } else {
                Alignments.AlignmentEntry firstEntry = (Alignments.AlignmentEntry)this.entryHeap.first();
                boolean bl = mustLoadPool = this.entryHeap.isEmpty() || this.currentTargetIndex == firstEntry.getTargetIndex() && this.currentPosition - this.windowLength < firstEntry.getPosition();
            }
        }
        if (mustLoadPool) {
            int initialCurrentPosition = this.currentPosition;
            do {
                if ((entry = this.delegate.nextRealignedEntry(targetIndex, position)) != null) {
                    this.currentTargetIndex = Math.min(this.currentTargetIndex, entry.getTargetIndex());
                    if (this.currentTargetIndex != entry.getTargetIndex() && !this.entryHeap.isEmpty()) {
                        this.pushEntry(entry);
                        break;
                    }
                    this.pushEntry(entry);
                    continue;
                }
                this.finished = true;
            } while (entry != null && entry.getPosition() < initialCurrentPosition + this.windowLength);
        }
        if (this.entryHeap.isEmpty()) {
            this.finished = true;
            return null;
        }
        entry = (Alignments.AlignmentEntry)this.entryHeap.dequeue();
        ++this.processedCount;
        this.currentPosition = entry.getPosition();
        this.currentTargetIndex = entry.getTargetIndex();
        return entry;
    }

    private void pushEntry(Alignments.AlignmentEntry entry) {
        if (entry.getTargetIndex() == this.lastTargetIndex && entry.getPosition() < this.lastCurrentPosition) {
            ++this.modifiedCount;
        }
        this.entryHeap.enqueue((Object)entry);
        this.lastCurrentPosition = Math.max(this.lastCurrentPosition, entry.getPosition());
        this.lastTargetIndex = Math.max(this.lastTargetIndex, entry.getTargetIndex());
    }

    @Override
    public void setGenome(RandomAccessSequenceInterface genome, IndexedIdentifier targetIdentifiers) {
        this.delegate.setGenome(genome, targetIdentifiers);
    }

    @Override
    public int getModifiedCount() {
        return this.delegate.getModifiedCount();
    }

    @Override
    public int getProcessedCount() {
        return this.delegate.getProcessedCount();
    }
}

