/*
 * Decompiled with CFR 0.152.
 */
package org.campagnelab.goby.readers.sam;

import com.google.protobuf.ByteString;
import edu.cornell.med.icb.identifier.IndexedIdentifier;
import htsjdk.samtools.SAMRecord;
import it.unimi.dsi.fastutil.ints.Int2ByteMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.lang.MutableString;
import java.io.IOException;
import org.campagnelab.goby.alignments.AlignmentTooManyHitsWriter;
import org.campagnelab.goby.alignments.AlignmentWriter;
import org.campagnelab.goby.alignments.Alignments;
import org.campagnelab.goby.readers.sam.ChromosomeMapper;
import org.campagnelab.goby.readers.sam.ConversionConfig;
import org.campagnelab.goby.readers.sam.GobyQuickSeqvar;
import org.campagnelab.goby.readers.sam.GobySamRecord;
import org.campagnelab.goby.readers.sam.GobySamSegment;
import org.campagnelab.goby.readers.sam.SamRecordParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConvertSamBAMReadToGobyAlignment {
    private static final Logger LOG = LoggerFactory.getLogger(ConvertSamBAMReadToGobyAlignment.class);
    private boolean hasResult;
    private AlignmentTooManyHitsWriter tmhWriter;
    private int numAligns;
    private IndexedIdentifier targetIds;
    private AlignmentWriter writer;
    private IndexedIdentifier readGroups;
    private boolean hasPaired;
    private SAMRecord prevRecord;
    private Int2ByteMap queryIndex2NextFragmentIndex;
    private ObjectArrayList<Alignments.AlignmentEntry.Builder> builders;
    private SamRecordParser samRecordParser;
    private SAMRecord samRecord;
    private int numTotalHits;
    private boolean readPaired;
    private ConversionConfig config;
    private GobySamRecord gobySamRecord;
    private int queryIndex;
    private int multiplicity;
    private int mateFragmentIndex;
    private int firstFragmentIndex;
    MutableString convertBasesBuffer = new MutableString();
    private final MutableString bases = new MutableString();

    public void setConfig(ConversionConfig config) {
        this.config = config;
    }

    public GobySamRecord getGobySamRecord() {
        return this.gobySamRecord;
    }

    public int getQueryIndex() {
        return this.queryIndex;
    }

    public int getMultiplicity() {
        return this.multiplicity;
    }

    public int getMateFragmentIndex() {
        return this.mateFragmentIndex;
    }

    public int getFirstFragmentIndex() {
        return this.firstFragmentIndex;
    }

    public ConvertSamBAMReadToGobyAlignment(IndexedIdentifier targetIds, IndexedIdentifier readGroups, Int2ByteMap queryIndex2NextFragmentIndex, ObjectArrayList<Alignments.AlignmentEntry.Builder> builders, SamRecordParser samRecordParser) {
        this.config = new ConversionConfig();
        this.targetIds = targetIds;
        this.readGroups = readGroups;
        this.queryIndex2NextFragmentIndex = queryIndex2NextFragmentIndex;
        this.builders = builders;
        this.samRecordParser = samRecordParser;
    }

    public void setSamRecord(SAMRecord samRecord) {
        this.samRecord = samRecord;
    }

    public boolean hasResult() {
        return this.hasResult;
    }

    public int getNumAligns() {
        return this.numAligns;
    }

    public boolean isHasPaired() {
        return this.hasPaired;
    }

    public SAMRecord getPrevRecord() {
        return this.prevRecord;
    }

    private int getTargetIndex(IndexedIdentifier targetIds, String sequenceName, boolean thirdPartyInput) {
        int targetIndex = -1;
        targetIndex = targetIds.registerIdentifier(new MutableString(sequenceName));
        return targetIndex;
    }

    public ConvertSamBAMReadToGobyAlignment invoke() throws IOException {
        int mateFragmentIndex;
        int genomeTargetIndex;
        boolean readIsSpliced;
        Object xoString;
        int numTotalHits;
        boolean anotherPair;
        int compare;
        this.builders.clear();
        GobySamRecord gobySamRecord = this.samRecordParser.processRead(this.samRecord);
        if (gobySamRecord == null) {
            if (this.config.debug && LOG.isDebugEnabled()) {
                LOG.debug(String.format("NOT keeping unmapped read %s", this.samRecord.getReadName()));
            }
            this.hasResult = false;
            return this;
        }
        if (gobySamRecord.getTargetAlignedLength() + gobySamRecord.getNumInserts() != gobySamRecord.getQueryAlignedLength() + gobySamRecord.getNumDeletes()) {
            LOG.error(String.format("targetAlignedLength+inserts != queryAlignedLength+deletes for read %s", this.samRecord.getReadName()));
            this.hasResult = false;
            return this;
        }
        int targetIndex = this.getTargetIndex(this.targetIds, this.samRecord.getReferenceName(), this.config.thirdPartyInput);
        if (this.config.sortedInput && this.prevRecord != null && this.prevRecord.getReferenceIndex() == targetIndex && (compare = this.prevRecord.getAlignmentStart() - this.samRecord.getAlignmentStart()) > 0) {
            String message = String.format("record %s has position before previous record: %s", this.samRecord.toString(), this.prevRecord.toString());
            System.err.println("You cannot specify --sorted when the input file is not sorted. For instance: " + message);
            LOG.warn(message);
        }
        this.prevRecord = this.samRecord;
        int readMaxOccurence = 1;
        boolean readIsPaired = this.samRecord.getReadPairedFlag();
        boolean bl = anotherPair = readIsPaired && !this.samRecord.getMateUnmappedFlag();
        if (anotherPair) {
            this.hasPaired = true;
            ++readMaxOccurence;
        }
        this.numTotalHits = numTotalHits = (xoString = this.samRecord.getAttribute("X0")) == null ? 1 : (this.hasPaired ? 1 : (Integer)xoString);
        int numEntries = gobySamRecord.getNumSegments();
        boolean bl2 = readIsSpliced = numEntries > 1;
        readMaxOccurence = this.hasPaired ? (readIsPaired ? 2 : 1) : numTotalHits;
        int n = readIsSpliced ? 2 : 1;
        String readName = this.samRecord.getReadName();
        int queryIndex = this.getQueryIndex(readMaxOccurence *= n, readName);
        assert (queryIndex >= 0) : " Query index must never be negative.";
        int ambiguity = 1;
        Object ihString = this.samRecord.getAttribute("IH");
        if (ihString != null) {
            ambiguity = Integer.parseInt((String)ihString);
        }
        boolean multiplicity = true;
        this.config.largestQueryIndex = Math.max(queryIndex, this.config.largestQueryIndex);
        this.config.smallestQueryIndex = Math.min(queryIndex, this.config.smallestQueryIndex);
        int n2 = genomeTargetIndex = this.config.genome == null ? -1 : this.config.genome.getReferenceIndex(ChromosomeMapper.chromosomeNameMapping(this.config.genome, this.samRecord.getReferenceName()));
        if (this.config.genome != null && genomeTargetIndex == -1) {
            System.out.println("genomeTargetIndex==-1, name=" + this.samRecord.getReferenceName());
            System.out.println("mapping=" + ChromosomeMapper.chromosomeNameMapping(this.config.genome, this.samRecord.getReferenceName()));
            System.exit(10);
        }
        int segmentIndex = 0;
        for (GobySamSegment gobySamSegment : gobySamRecord.getSegments()) {
            int inferredInsertSize;
            byte[] sourceQualAsBytes;
            Alignments.AlignmentEntry.Builder currentEntry = Alignments.AlignmentEntry.newBuilder();
            currentEntry.setAmbiguity(ambiguity);
            if (this.config.preserveReadName) {
                currentEntry.setReadName(gobySamRecord.getReadName().toString());
            }
            currentEntry.setQueryIndex(queryIndex);
            currentEntry.setTargetIndex(targetIndex);
            currentEntry.setPosition(gobySamSegment.getPosition());
            currentEntry.setQueryPosition(gobySamSegment.getQueryPosition());
            currentEntry.setQueryLength(gobySamRecord.getQueryLength());
            currentEntry.setMatchingReverseStrand(gobySamRecord.isReverseStrand());
            currentEntry.setQueryAlignedLength(gobySamSegment.getQueryAlignedLength());
            currentEntry.setTargetAlignedLength(gobySamSegment.getTargetAlignedLength());
            currentEntry.setMappingQuality(this.samRecord.getMappingQuality());
            if (this.config.preserveSoftClips) {
                int leftTrim = gobySamSegment.getSoftClippedBasesLeft().length();
                if (leftTrim > 0) {
                    currentEntry.setSoftClippedBasesLeft(this.convertBases(genomeTargetIndex, gobySamSegment.getPosition() - leftTrim, this.samRecord.getReadBases(), 0, leftTrim));
                    currentEntry.setSoftClippedQualityLeft(gobySamSegment.getSoftClippedQualityLeft());
                }
                int queryAlignedLength = gobySamSegment.getQueryAlignedLength();
                int rightTrim = gobySamSegment.getSoftClippedBasesRight().length();
                int queryPosition = gobySamSegment.getQueryPosition();
                if (rightTrim > 0) {
                    int startIndex = queryPosition + queryAlignedLength;
                    int endIndex = startIndex + rightTrim;
                    currentEntry.setSoftClippedBasesRight(this.convertBases(genomeTargetIndex, gobySamSegment.getPosition() + gobySamSegment.getTargetAlignedLength(), this.samRecord.getReadBases(), startIndex, endIndex));
                    currentEntry.setSoftClippedQualityRight(gobySamSegment.getSoftClippedQualityRight());
                }
            }
            if (this.config.preserveAllMappedQuals && segmentIndex == 0 && (sourceQualAsBytes = gobySamRecord.getReadQualitiesAsBytes()) != null) {
                currentEntry.setReadQualityScores(ByteString.copyFrom((byte[])sourceQualAsBytes));
            }
            this.addSamAttributes(this.samRecord, currentEntry);
            currentEntry.setPairFlags(this.samRecord.getFlags());
            if (this.hasPaired && (inferredInsertSize = this.samRecord.getInferredInsertSize()) != 0) {
                currentEntry.setInsertSize(inferredInsertSize);
            }
            for (GobyQuickSeqvar variation : gobySamSegment.getSequenceVariations()) {
                ConvertSamBAMReadToGobyAlignment.appendNewSequenceVariation(currentEntry, variation, gobySamRecord.getQueryLength());
                if (!this.config.debug || !LOG.isDebugEnabled()) continue;
                LOG.debug(String.format("Added seqvar=%s for queryIndex=%d to alignment", variation.toString(), queryIndex));
            }
            String readGroup = this.samRecord.getStringAttribute("RG");
            if (readGroup != null && this.config.storeReadOrigin) {
                int readOriginIndex = this.readGroups.getInt((Object)new MutableString(readGroup).compact());
                if (readOriginIndex == -1) {
                    System.err.printf("Read group identifier %s is used in alignment record (read-name=%s), but was not found in the header. Ignoring this read group.%n", readGroup, this.samRecord.getReadName());
                } else {
                    currentEntry.setReadOriginIndex(readOriginIndex);
                }
            }
            this.builders.add((Object)currentEntry);
            ++segmentIndex;
        }
        int numFragments = this.builders.size();
        for (Alignments.AlignmentEntry.Builder builder : this.builders) {
            builder.setFragmentIndex(this.nextFragmentIndex(queryIndex, this.queryIndex2NextFragmentIndex));
        }
        if (numFragments > 1) {
            for (int j = 0; j < numFragments + 1; ++j) {
                this.linkSplicedEntries(j - 1 >= 0 ? (Alignments.AlignmentEntry.Builder)this.builders.get(j - 1) : null, j < numFragments ? (Alignments.AlignmentEntry.Builder)this.builders.get(j) : null);
            }
        }
        int firstFragmentIndex = ((Alignments.AlignmentEntry.Builder)this.builders.get(0)).getFragmentIndex();
        if (readIsPaired) {
            if (this.samRecord.getFirstOfPairFlag()) {
                int fragmentIndex = firstFragmentIndex;
                if (this.pairBefore(this.samRecord)) {
                    mateFragmentIndex = firstFragmentIndex - 1;
                } else {
                    mateFragmentIndex = this.nextFragmentIndex(queryIndex, this.queryIndex2NextFragmentIndex);
                    this.uncomsumeFragmentIndex(queryIndex, this.queryIndex2NextFragmentIndex);
                }
            } else {
                int fragmentIndex = firstFragmentIndex;
                mateFragmentIndex = this.pairBefore(this.samRecord) ? firstFragmentIndex - 1 : firstFragmentIndex + 1;
            }
        } else {
            int fragmentIndex = firstFragmentIndex;
            mateFragmentIndex = this.nextFragmentIndex(queryIndex, this.queryIndex2NextFragmentIndex);
            this.uncomsumeFragmentIndex(queryIndex, this.queryIndex2NextFragmentIndex);
        }
        this.firstFragmentIndex = firstFragmentIndex;
        this.mateFragmentIndex = mateFragmentIndex;
        this.hasResult = true;
        this.multiplicity = 1;
        this.queryIndex = queryIndex;
        this.gobySamRecord = gobySamRecord;
        return this;
    }

    public int getQueryIndex(int readMaxOccurence, String readName) {
        return this.config.readNamesAreQueryIndices ? Integer.parseInt(readName) : this.config.nameToQueryIndices.getQueryIndex(readName, readMaxOccurence);
    }

    private void addSamAttributes(SAMRecord samRecord, Alignments.AlignmentEntry.Builder currentEntry) {
        if (this.config.preserveAllTags) {
            String[] tokens = samRecord.getSAMString().split("\t");
            int size = tokens.length;
            for (int i = 11; i < size; ++i) {
                String token = tokens[i];
                if (token.startsWith("MD:Z") || token.startsWith("RG:Z")) continue;
                currentEntry.addBamAttributes(token.replaceAll("\n", ""));
            }
        }
    }

    private int nextFragmentIndex(int queryIndex, Int2ByteMap queryIndex2NextFragmentIndex) {
        byte fragmentIndex = queryIndex2NextFragmentIndex.get(queryIndex);
        queryIndex2NextFragmentIndex.put(queryIndex, (byte)(fragmentIndex + 1));
        return fragmentIndex;
    }

    private void linkSplicedEntries(Alignments.AlignmentEntry.Builder a, Alignments.AlignmentEntry.Builder b) {
        if (a == null || b == null) {
            return;
        }
        Alignments.RelatedAlignmentEntry.Builder forwardSpliceLink = Alignments.RelatedAlignmentEntry.newBuilder();
        forwardSpliceLink.setFragmentIndex(b.getFragmentIndex());
        forwardSpliceLink.setPosition(b.getPosition());
        forwardSpliceLink.setTargetIndex(b.getTargetIndex());
        a.setSplicedForwardAlignmentLink(forwardSpliceLink);
        Alignments.RelatedAlignmentEntry.Builder backwardSpliceLink = Alignments.RelatedAlignmentEntry.newBuilder();
        backwardSpliceLink.setFragmentIndex(a.getFragmentIndex());
        backwardSpliceLink.setPosition(a.getPosition());
        backwardSpliceLink.setTargetIndex(a.getTargetIndex());
        b.setSplicedBackwardAlignmentLink(backwardSpliceLink);
    }

    private boolean pairBefore(SAMRecord samRecord) {
        int pairOrder = samRecord.getMateReferenceName().compareTo(samRecord.getReferenceName());
        if (pairOrder > 0) {
            return false;
        }
        if (pairOrder == 0) {
            return samRecord.getMateAlignmentStart() < samRecord.getAlignmentStart();
        }
        return true;
    }

    private void uncomsumeFragmentIndex(int queryIndex, Int2ByteMap queryIndex2NextFragmentIndex) {
        byte fragmentIndex = queryIndex2NextFragmentIndex.get(queryIndex);
        queryIndex2NextFragmentIndex.put(queryIndex, (byte)(fragmentIndex - 1));
    }

    public ObjectArrayList<Alignments.AlignmentEntry.Builder> getBuilders() {
        return this.builders;
    }

    public int getNumTotalHits() {
        return this.numTotalHits;
    }

    public boolean isReadPaired() {
        return this.readPaired;
    }

    public String convertBases(int referenceIndex, int positionStartOfRead, byte[] readBases, int startIndex, int endIndex) {
        if (this.config.genome != null) {
            int i;
            int referenceLength;
            int actualPositionStartOfRead = positionStartOfRead;
            int numPrepend = 0;
            int numAppend = 0;
            int actualLength = endIndex - startIndex;
            if (actualPositionStartOfRead < 0) {
                numPrepend = -actualPositionStartOfRead;
                actualPositionStartOfRead = 0;
                actualLength -= numPrepend;
            }
            if (actualPositionStartOfRead + actualLength > (referenceLength = this.config.genome.getLength(referenceIndex))) {
                numAppend = actualPositionStartOfRead + actualLength - referenceLength;
                actualLength -= numAppend;
            }
            this.config.genome.getRange(referenceIndex, actualPositionStartOfRead, actualLength, this.bases);
            for (i = 0; i < numPrepend; ++i) {
                this.bases.insert(0, "N");
            }
            for (i = 0; i < numAppend; ++i) {
                this.bases.append("N");
            }
        }
        this.convertBasesBuffer.setLength(endIndex - startIndex);
        int j = 0;
        for (int i = startIndex; i < endIndex; ++i) {
            char readBase = (char)readBases[i];
            char refBase = this.config.genome != null ? (char)this.bases.charAt(i - startIndex) : (char)'!';
            this.convertBasesBuffer.setCharAt(j, refBase == readBase ? (char)'=' : (char)readBase);
            ++j;
        }
        return this.convertBasesBuffer.toString();
    }

    static void appendNewSequenceVariation(Alignments.AlignmentEntry.Builder currentEntry, GobyQuickSeqvar variation, int queryLength) {
        int readIndex = variation.getReadIndex();
        if (readIndex > queryLength) {
            if (readIndex > queryLength) {
                System.out.println("STOP6");
            }
            assert (readIndex <= queryLength) : String.format(" readIndex %d must be smaller than read length %d .", readIndex, queryLength);
            LOG.warn(String.format("Ignoring sequence variations for a read since readIndex %d must be smaller than read length %d. query index=%d reference index=%d%n", readIndex, queryLength, currentEntry.getQueryIndex(), currentEntry.getTargetIndex()));
            return;
        }
        Alignments.SequenceVariation.Builder sequenceVariation = Alignments.SequenceVariation.newBuilder();
        sequenceVariation.setFrom(variation.getFrom());
        sequenceVariation.setTo(variation.getTo());
        sequenceVariation.setPosition(variation.getPosition());
        sequenceVariation.setReadIndex(readIndex);
        byte[] toQuality = variation.getToQualitiesAsBytes();
        if (toQuality != null && toQuality.length > 0) {
            sequenceVariation.setToQuality(ByteString.copyFrom((byte[])toQuality));
        }
        currentEntry.addSequenceVariations(sequenceVariation);
    }
}

