#    Jools -- a graphical puzzle game in the Tetris tradition
#    
#    Copyright (C) 2002-2003 Paul Pelzl
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#

# scoreboard.py
# 
# displays the running tally of points, current level, etc.
#


from initialize import *

mainc  = (250,0,0)
backc  = (1,1,1)
boardc = (50,0,0)


class Scoreboard:
   def __init__(self):
      self.levelText = joolsFont.render("Level : ", 1,
         mainc, boardc)
      self.pointsText = joolsFont.render("Points : ", 1,
         mainc, boardc)
      self.numJoolsText = joolsFont.render("Jools Cleared : ", 1,
         mainc, boardc)
      self.movesText = joolsFont.render("Moves Available : ", 1,
         mainc, boardc)
      self.levelRect    = self.levelText.get_rect()
      self.pointsRect   = self.pointsText.get_rect()
      self.numJoolsRect = self.numJoolsText.get_rect()
      self.movesRect    = self.movesText.get_rect()

      self.maxWidth  = max(self.levelRect.width, self.pointsRect.width, 
         self.numJoolsRect.width, self.movesRect.width)
      self.maxHeight = max(self.levelRect.height, self.pointsRect.height, 
         self.numJoolsRect.height, self.movesRect.height)

      self.leftMargin = 10
      self.vspace = 20
      # following will center the scoreboard vertically
      self.topMargin  = (SCREENH-125 - 4*self.maxHeight - 3*self.vspace - 5)/2 + 125
      self.spacer     = self.leftMargin + self.maxWidth + 5 
      self.levelHeight    = self.topMargin
      self.pointsHeight   = self.levelHeight + self.maxHeight + self.vspace
      self.numJoolsHeight = self.pointsHeight + self.maxHeight + self.vspace
      self.movesHeight    = self.numJoolsHeight + self.maxHeight + self.vspace


      # this surface gets blitted over the numbers representing
      # points, levels, etc
      self.pointsBkgd = joolsFont.render("99999999999", 1, boardc, boardc)


   def drawBoard(self):
      pygame.draw.rect(screen, mainc, pygame.Rect(self.leftMargin,
         self.topMargin-5, self.maxWidth+self.pointsBkgd.get_rect().width+10,
         4*self.maxHeight + 3*self.vspace + 10), 0)
      pygame.draw.rect(screen, boardc, pygame.Rect(self.leftMargin+2,
         self.topMargin-5+2, self.maxWidth+self.pointsBkgd.get_rect().width+10-4,
         4*self.maxHeight + 3*self.vspace + 10-4), 0)

      screen.blit(self.levelText, (self.spacer - self.levelRect.width,
         self.levelHeight))
      screen.blit(self.pointsText, (self.spacer - self.pointsRect.width,
         self.pointsHeight))
      screen.blit(self.numJoolsText, (self.spacer - self.numJoolsRect.width,
         self.numJoolsHeight))
      screen.blit(self.movesText, (self.spacer - self.movesRect.width,
         self.movesHeight))

      

   def setLevel(self, level):
      screen.blit(self.pointsBkgd, (self.spacer, self.levelHeight))
      levelVal = joolsFont.render(str(level), 1, mainc, boardc)
      screen.blit(levelVal, (self.spacer, self.levelHeight))


   def setPoints(self, points):
      screen.blit(self.pointsBkgd, (self.spacer, self.pointsHeight))
      pointsVal = joolsFont.render(str(points), 1, mainc, boardc)
      screen.blit(pointsVal, (self.spacer, self.pointsHeight))


   def setJoolsCleared(self, numCleared, level):
      screen.blit(self.pointsBkgd, (self.spacer, self.numJoolsHeight))
      numToLevelUp = level*200 - numCleared
      if numToLevelUp < 0:
         numToLevelUp = 0
      numJoolsVal = joolsFont.render(str(numCleared) + 
         "  [ " + str(numToLevelUp) + " ]",
         1, mainc, boardc)
      screen.blit(numJoolsVal, (self.spacer, self.numJoolsHeight))
   

   def setAvailableMoves(self, numMoves):
      screen.blit(self.pointsBkgd, (self.spacer, self.movesHeight))
      movesVal = joolsFont.render(str(numMoves), 1, mainc, boardc)
      screen.blit(movesVal, (self.spacer, self.movesHeight))


# arch-tag: scoreboard

