/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.mode;

import gnu.javax.crypto.cipher.IBlockCipher;
import gnu.javax.crypto.mode.BaseMode;

public class CBC
extends BaseMode
implements Cloneable {
    private byte[] lastBlock;
    private byte[] scratch;

    public Object clone() {
        return new CBC(this);
    }

    public void setup() {
        if (this.modeBlockSize != this.cipherBlockSize) {
            throw new IllegalArgumentException();
        }
        this.scratch = new byte[this.cipherBlockSize];
        this.lastBlock = new byte[this.cipherBlockSize];
        int n = 0;
        while (n < this.lastBlock.length && n < this.iv.length) {
            this.lastBlock[n] = this.iv[n];
            ++n;
        }
    }

    public void teardown() {
        this.lastBlock = null;
        this.scratch = null;
    }

    public void encryptBlock(byte[] byArray, int n, byte[] byArray2, int n2) {
        int n3 = 0;
        while (n3 < this.scratch.length) {
            this.scratch[n3] = (byte)(this.lastBlock[n3] ^ byArray[n3 + n]);
            ++n3;
        }
        this.cipher.encryptBlock(this.scratch, 0, byArray2, n2);
        System.arraycopy(byArray2, n2, this.lastBlock, 0, this.cipherBlockSize);
    }

    public void decryptBlock(byte[] byArray, int n, byte[] byArray2, int n2) {
        byte[] byArray3 = new byte[this.cipherBlockSize];
        System.arraycopy(byArray, n, byArray3, 0, this.cipherBlockSize);
        this.cipher.decryptBlock(byArray, n, this.scratch, 0);
        int n3 = 0;
        while (n3 < this.scratch.length) {
            byArray2[n2 + n3] = (byte)(this.lastBlock[n3] ^ this.scratch[n3]);
            ++n3;
        }
        System.arraycopy(byArray3, 0, this.lastBlock, 0, this.cipherBlockSize);
    }

    CBC(IBlockCipher iBlockCipher, int n) {
        super("cbc", iBlockCipher, n);
    }

    private CBC(CBC cBC) {
        this((IBlockCipher)cBC.cipher.clone(), cBC.cipherBlockSize);
    }
}

