/*
 * Decompiled with CFR 0.152.
 */
package java.awt.font;

public final class TextHitInfo {
    private int charIndex;
    private boolean leadingEdge;

    public final int getCharIndex() {
        return this.charIndex;
    }

    public final boolean isLeadingEdge() {
        return this.leadingEdge;
    }

    public final int getInsertionIndex() {
        return this.leadingEdge ? this.charIndex : this.charIndex + 1;
    }

    public final int hashCode() {
        return this.charIndex;
    }

    public final boolean equals(Object object) {
        if (object instanceof TextHitInfo) {
            return this.equals((TextHitInfo)object);
        }
        return false;
    }

    public final boolean equals(TextHitInfo textHitInfo) {
        boolean bl = false;
        if (this.charIndex == textHitInfo.getCharIndex() && this.leadingEdge == textHitInfo.isLeadingEdge()) {
            bl = true;
        }
        return bl;
    }

    public static final TextHitInfo leading(int n) {
        return new TextHitInfo(n, true);
    }

    public static final TextHitInfo trailing(int n) {
        return new TextHitInfo(n, false);
    }

    public static final TextHitInfo beforeOffset(int n) {
        return new TextHitInfo(n, false);
    }

    public static final TextHitInfo afterOffset(int n) {
        return new TextHitInfo(n, true);
    }

    public final TextHitInfo getOtherHit() {
        return this.leadingEdge ? TextHitInfo.trailing(this.charIndex - 1) : TextHitInfo.leading(this.charIndex + 1);
    }

    public final TextHitInfo getOffsetHit(int n) {
        return new TextHitInfo(this.charIndex + n, this.leadingEdge);
    }

    public final String toString() {
        return "TextHitInfo[" + this.charIndex + (this.leadingEdge ? "L" : "T") + ']';
    }

    TextHitInfo(int n, boolean bl) {
        this.charIndex = n;
        this.leadingEdge = bl;
    }
}

