/*
 * Decompiled with CFR 0.152.
 */
package org.campagnelab.goby.alignments.filters;

import edu.cornell.med.icb.identifier.IndexedIdentifier;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArraySet;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.io.FastBufferedReader;
import it.unimi.dsi.io.LineIterator;
import it.unimi.dsi.lang.MutableString;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;

public class GeneTranscriptRelationships {
    protected final IndexedIdentifier geneId2Index;
    final Int2ObjectMap<MutableString> geneIndex2GeneId;
    final Int2ObjectOpenHashMap<IntSet> gene2TranscriptIndices;
    private int geneIndexCounter;
    private final Int2IntMap transcriptIndex2GeneIndex;

    public int getNumberOfGenes() {
        return this.geneId2Index.size();
    }

    public GeneTranscriptRelationships() {
        this.geneId2Index = new IndexedIdentifier();
        this.geneId2Index.defaultReturnValue(-1);
        this.gene2TranscriptIndices = new Int2ObjectOpenHashMap();
        this.transcriptIndex2GeneIndex = new Int2IntOpenHashMap();
        this.transcriptIndex2GeneIndex.defaultReturnValue(-1);
        this.geneIndex2GeneId = new Int2ObjectOpenHashMap();
    }

    public GeneTranscriptRelationships(IndexedIdentifier geneIndices) {
        this.geneId2Index = geneIndices;
        this.geneId2Index.defaultReturnValue(-1);
        this.gene2TranscriptIndices = new Int2ObjectOpenHashMap();
        this.transcriptIndex2GeneIndex = new Int2IntOpenHashMap();
        this.geneIndex2GeneId = new Int2ObjectOpenHashMap();
    }

    public void addRelationship(MutableString geneId, int transcriptIndex) {
        int geneIndex = this.getGeneIndex(geneId);
        this.addRelationship(geneIndex, transcriptIndex);
    }

    public void addRelationship(int geneIndex, int transcriptIndex) {
        IntSet transcriptIds = (IntSet)this.gene2TranscriptIndices.get(geneIndex);
        if (transcriptIds == null) {
            transcriptIds = new IntArraySet();
            this.gene2TranscriptIndices.put(geneIndex, (Object)transcriptIds);
        }
        transcriptIds.add(transcriptIndex);
        this.transcriptIndex2GeneIndex.put(transcriptIndex, geneIndex);
    }

    protected int getGeneIndex(MutableString geneId) {
        int index = this.geneId2Index.getInt((Object)geneId);
        if (index == -1) {
            this.geneId2Index.put((Object)geneId, this.geneIndexCounter);
            this.geneIndex2GeneId.put(this.geneIndexCounter, (Object)geneId);
            index = this.geneIndexCounter++;
        }
        return index;
    }

    public MutableString getGeneId(int geneIndex) {
        return (MutableString)this.geneIndex2GeneId.get(geneIndex);
    }

    public IntSet getTranscriptSet(MutableString geneId) {
        return this.getTranscriptSet(this.getGeneIndex(geneId));
    }

    public IntSet getTranscriptSet(int geneIndex) {
        return (IntSet)this.gene2TranscriptIndices.get(geneIndex);
    }

    public IntSet transcript2Genes(int[] transcriptIndices) {
        IntOpenHashSet geneSet = new IntOpenHashSet();
        for (int transcriptIndex : transcriptIndices) {
            geneSet.add(this.transcript2Gene(transcriptIndex));
        }
        return geneSet;
    }

    public int transcript2Gene(int transcriptIndex) {
        return this.transcriptIndex2GeneIndex.get(transcriptIndex);
    }

    public IntSet gene2Transcripts(IntSet genes) {
        IntOpenHashSet trancriptSet = new IntOpenHashSet();
        IntIterator intIterator = genes.iterator();
        while (intIterator.hasNext()) {
            int geneIndex = (Integer)intIterator.next();
            IntSet transcripts = this.getTranscriptSet(geneIndex);
            if (transcripts == null) continue;
            trancriptSet.addAll((IntCollection)transcripts);
        }
        return trancriptSet;
    }

    public IndexedIdentifier load(String geneTranscriptRelFilename) throws FileNotFoundException {
        IndexedIdentifier transcriptIds = new IndexedIdentifier();
        FastBufferedReader reader = new FastBufferedReader((Reader)new FileReader(geneTranscriptRelFilename));
        LineIterator lit = new LineIterator(reader);
        while (lit.hasNext()) {
            MutableString line = lit.next();
            if (line.startsWith("#")) continue;
            String[] tokens = line.toString().split("[\t ]");
            MutableString geneId = new MutableString(tokens[0]).compact();
            if (tokens.length < 2) continue;
            String transcriptId = tokens[1];
            int transcriptIndex = transcriptIds.registerIdentifier(new MutableString(transcriptId).compact());
            this.addRelationship(geneId, transcriptIndex);
        }
        return transcriptIds;
    }
}

