/*
 * Decompiled with CFR 0.152.
 */
package free.util.swing;

import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.beans.PropertyVetoException;
import java.util.Vector;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;

public class InternalFrameSwitcher
implements ContainerListener,
InternalFrameListener {
    private final Vector frames = new Vector();
    private boolean ignoreContainerEvents = false;

    public InternalFrameSwitcher(JDesktopPane jDesktopPane) {
        jDesktopPane.addContainerListener(this);
    }

    public void componentAdded(ContainerEvent containerEvent) {
        if (this.ignoreContainerEvents) {
            return;
        }
        if (containerEvent.getChild() instanceof JInternalFrame) {
            JInternalFrame jInternalFrame = (JInternalFrame)containerEvent.getChild();
            this.frames.addElement(jInternalFrame);
            jInternalFrame.addInternalFrameListener(this);
        }
    }

    public void componentRemoved(ContainerEvent containerEvent) {
        if (this.ignoreContainerEvents) {
            return;
        }
        if (containerEvent.getChild() instanceof JInternalFrame) {
            JInternalFrame jInternalFrame = (JInternalFrame)containerEvent.getChild();
            this.frames.removeElement(jInternalFrame);
            jInternalFrame.removeInternalFrameListener(this);
        }
    }

    public void internalFrameActivated(InternalFrameEvent internalFrameEvent) {
        JInternalFrame jInternalFrame = (JInternalFrame)internalFrameEvent.getSource();
        this.frames.removeElement(jInternalFrame);
        this.frames.insertElementAt(jInternalFrame, 0);
    }

    public void internalFrameClosed(InternalFrameEvent internalFrameEvent) {
    }

    public void internalFrameClosing(InternalFrameEvent internalFrameEvent) {
    }

    public void internalFrameDeactivated(InternalFrameEvent internalFrameEvent) {
    }

    public void internalFrameDeiconified(InternalFrameEvent internalFrameEvent) {
    }

    public void internalFrameIconified(InternalFrameEvent internalFrameEvent) {
    }

    public void internalFrameOpened(InternalFrameEvent internalFrameEvent) {
    }

    public void selectNext() {
        if (!this.frames.isEmpty()) {
            JInternalFrame jInternalFrame = (JInternalFrame)this.frames.elementAt(this.frames.size() - 1);
            try {
                this.ignoreContainerEvents = true;
                jInternalFrame.setSelected(true);
                this.ignoreContainerEvents = false;
                return;
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
    }

    public void selectPrevious() {
        if (!this.frames.isEmpty()) {
            Object e = this.frames.elementAt(0);
            this.frames.removeElementAt(0);
            this.frames.addElement(e);
            try {
                this.ignoreContainerEvents = true;
                ((JInternalFrame)this.frames.elementAt(0)).setSelected(true);
                this.ignoreContainerEvents = false;
                return;
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
    }
}

