/*
 * Decompiled with CFR 0.152.
 */
package com.jclark.xsl.sax;

import com.jclark.xsl.om.Name;
import com.jclark.xsl.tr.OutputMethod;
import org.xml.sax.AttributeList;

class OutputMethodAttributeList
implements AttributeList {
    private final OutputMethod method;
    private final Name[] names;
    private Name[] cdataSectionElements;

    public String getValue(int n) {
        if (this.cdataSectionElements != null && n-- == 0) {
            StringBuffer stringBuffer = new StringBuffer();
            n = 0;
            while (n < this.cdataSectionElements.length) {
                if (n != 0) {
                    stringBuffer.append(' ');
                }
                stringBuffer.append(OutputMethodAttributeList.nameToString(this.cdataSectionElements[n]));
                ++n;
            }
            return stringBuffer.toString();
        }
        return this.method.getAttributeValue(this.names[n]);
    }

    public String getValue(String string) {
        if (string.equals("cdata-section-elements")) {
            if (this.cdataSectionElements == null) {
                return null;
            }
            return this.getValue(0);
        }
        int n = string.lastIndexOf(94);
        Name name = n < 0 ? this.method.getNameTable().createName(string) : this.method.getNameTable().createName(string.substring(0, n), string.substring(n + 1));
        return this.method.getAttributeValue(name);
    }

    OutputMethodAttributeList(OutputMethod outputMethod) {
        this.method = outputMethod;
        this.names = outputMethod.getAttributeNames();
        this.cdataSectionElements = outputMethod.getCdataSectionElements();
        if (this.cdataSectionElements.length == 0) {
            this.cdataSectionElements = null;
        }
    }

    public String getName(int n) {
        if (this.cdataSectionElements != null && n-- == 0) {
            return "cdata-section-elements";
        }
        return OutputMethodAttributeList.nameToString(this.names[n]);
    }

    public String getType(int n) {
        return "CDATA";
    }

    public String getType(String string) {
        return "CDATA";
    }

    public int getLength() {
        return this.names.length;
    }

    private static final String nameToString(Name name) {
        if (name.getNamespace() == null) {
            return name.getLocalPart();
        }
        return name.getNamespace() + '^' + name.getLocalPart();
    }
}

