let array = Js_of_ocaml_compiler.Builtins.register ~name:"array.js" ~content:"// Js_of_ocaml runtime support\n// http://www.ocsigen.org/js_of_ocaml/\n//\n// This program is free software; you can redistribute it and/or modify\n// it under the terms of the GNU Lesser General Public License as published by\n// the Free Software Foundation, with linking exception;\n// either version 2.1 of the License, or (at your option) any later version.\n//\n// This program is distributed in the hope that it will be useful,\n// but WITHOUT ANY WARRANTY; without even the implied warranty of\n// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n// GNU Lesser General Public License for more details.\n//\n// You should have received a copy of the GNU Lesser General Public License\n// along with this program; if not, write to the Free Software\n// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.\n\n///////////// Array\n\n//Provides: caml_array_sub mutable\nfunction caml_array_sub (a, i, len) {\n  var a2 = new Array(len+1);\n  a2[0]=0;\n  for(var i2 = 1, i1= i+1; i2 <= len; i2++,i1++ ){\n    a2[i2]=a[i1];\n  }\n  return a2;\n}\n\n//Provides: caml_array_append mutable\nfunction caml_array_append(a1, a2) {\n  var l1 = a1.length, l2 = a2.length;\n  var l = l1+l2-1\n  var a = new Array(l);\n  a[0] = 0;\n  var i = 1,j = 1;\n  for(;i<l1;i++) a[i]=a1[i];\n  for(;i<l;i++,j++) a[i]=a2[j];\n  return a;\n}\n\n//Provides: caml_array_concat mutable\nfunction caml_array_concat(l) {\n  var a = [0];\n  while (l !== 0) {\n    var b = l[1];\n    for (var i = 1; i < b.length; i++) a.push(b[i]);\n    l = l[2];\n  }\n  return a;\n}\n\n//Provides: caml_array_blit\nfunction caml_array_blit(a1, i1, a2, i2, len) {\n  if (i2 <= i1) {\n    for (var j = 1; j <= len; j++) a2[i2 + j] = a1[i1 + j];\n  } else {\n    for (var j = len; j >= 1; j--) a2[i2 + j] = a1[i1 + j];\n  };\n  return 0;\n}\n\n//Provides: caml_floatarray_blit\nfunction caml_floatarray_blit(a1, i1, a2, i2, len) {\n  if (i2 <= i1) {\n    for (var j = 1; j <= len; j++) a2[i2 + j] = a1[i1 + j];\n  } else {\n    for (var j = len; j >= 1; j--) a2[i2 + j] = a1[i1 + j];\n  };\n  return 0;\n}\n\n///////////// Pervasive\n//Provides: caml_array_set (mutable, const, const)\n//Requires: caml_array_bound_error\nfunction caml_array_set (array, index, newval) {\n  if ((index < 0) || (index >= array.length - 1)) caml_array_bound_error();\n  array[index+1]=newval; return 0;\n}\n\n//Provides: caml_array_get mutable (const, const)\n//Requires: caml_array_bound_error\nfunction caml_array_get (array, index) {\n  if ((index < 0) || (index >= array.length - 1)) caml_array_bound_error();\n  return array[index+1];\n}\n\n//Provides: caml_array_fill\nfunction caml_array_fill(array, ofs, len, v){\n  for(var i = 0; i < len; i++){\n    array[ofs+i+1] = v;\n  }\n  return 0;\n}\n\n//Provides: caml_check_bound (const, const)\n//Requires: caml_array_bound_error\nfunction caml_check_bound (array, index) {\n  if (index >>> 0 >= array.length - 1) caml_array_bound_error();\n  return array;\n}\n\n//Provides: caml_make_vect const (const, const)\n//Requires: caml_array_bound_error\nfunction caml_make_vect (len, init) {\n  if (len < 0) caml_array_bound_error();\n  var len = len + 1 | 0;\n  var b = new Array(len);\n  b[0]=0;\n  for (var i = 1; i < len; i++) b[i] = init;\n  return b;\n}\n\n//Provides: caml_make_float_vect const (const)\n//Requires: caml_array_bound_error\nfunction caml_make_float_vect(len){\n  if (len < 0) caml_array_bound_error();\n  var len = len + 1 | 0;\n  var b = new Array(len);\n  b[0]=254;\n  for (var i = 1; i < len; i++) b[i] = 0;\n  return b\n}\n//Provides: caml_floatarray_create const (const)\n//Requires: caml_array_bound_error\nfunction caml_floatarray_create(len){\n  if (len < 0) caml_array_bound_error();\n  var len = len + 1 | 0;\n  var b = new Array(len);\n  b[0]=254;\n  for (var i = 1; i < len; i++) b[i] = 0;\n  return b\n}\n"
let backtrace = Js_of_ocaml_compiler.Builtins.register ~name:"backtrace.js" ~content:"// Js_of_ocaml runtime support\n// http://www.ocsigen.org/js_of_ocaml/\n//\n// This program is free software; you can redistribute it and/or modify\n// it under the terms of the GNU Lesser General Public License as published by\n// the Free Software Foundation, with linking exception;\n// either version 2.1 of the License, or (at your option) any later version.\n//\n// This program is distributed in the hope that it will be useful,\n// but WITHOUT ANY WARRANTY; without even the implied warranty of\n// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n// GNU Lesser General Public License for more details.\n//\n// You should have received a copy of the GNU Lesser General Public License\n// along with this program; if not, write to the Free Software\n// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.\n\n//Provides: caml_ml_debug_info_status const\nfunction caml_ml_debug_info_status () { return 0; }\n//Provides: caml_backtrace_status const\nfunction caml_backtrace_status () { return 0; }\n//Provides: caml_get_exception_backtrace const\nfunction caml_get_exception_backtrace () { return 0; }\n//Provides: caml_get_exception_raw_backtrace const\nfunction caml_get_exception_raw_backtrace () { return [0]; }\n//Provides: caml_record_backtrace\nfunction caml_record_backtrace () { return 0; }\n//Provides: caml_convert_raw_backtrace const\nfunction caml_convert_raw_backtrace () { return [0]; }\n//Provides: caml_raw_backtrace_length\nfunction caml_raw_backtrace_length() { return 0; }\n//Provides: caml_raw_backtrace_next_slot\nfunction caml_raw_backtrace_next_slot() { return 0 }\n//Provides: caml_raw_backtrace_slot\n//Requires: caml_invalid_argument\nfunction caml_raw_backtrace_slot () {\n  caml_invalid_argument(\"Printexc.get_raw_backtrace_slot: index out of bounds\");\n}\n//Provides: caml_restore_raw_backtrace\nfunction caml_restore_raw_backtrace(exn, bt) { return 0 }\n//Provides: caml_get_current_callstack const\nfunction caml_get_current_callstack () { return [0]; }\n\n//Provides: caml_convert_raw_backtrace_slot\n//Requires: caml_failwith\nfunction caml_convert_raw_backtrace_slot(){\n  caml_failwith(\"caml_convert_raw_backtrace_slot\");\n}\n"
let bigarray = Js_of_ocaml_compiler.Builtins.register ~name:"bigarray.js" ~content:"// Js_of_ocaml runtime support\n// http://www.ocsigen.org/js_of_ocaml/\n// Copyright (C) 2014 J\195\169r\195\180me Vouillon, Hugo Heuzard, Andy Ray\n// Laboratoire PPS - CNRS Universit\195\169 Paris Diderot\n//\n// This program is free software; you can redistribute it and/or modify\n// it under the terms of the GNU Lesser General Public License as published by\n// the Free Software Foundation, with linking exception;\n// either version 2.1 of the License, or (at your option) any later version.\n//\n// This program is distributed in the hope that it will be useful,\n// but WITHOUT ANY WARRANTY; without even the implied warranty of\n// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n// GNU Lesser General Public License for more details.\n//\n// You should have received a copy of the GNU Lesser General Public License\n// along with this program; if not, write to the Free Software\n// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.\n//\n// Bigarray.\n//\n// - all bigarray types including Int64 and Complex.\n// - fortran + c layouts\n// - sub/slice/reshape\n// - retain fast path for 1d array access\n\n//Provides: caml_ba_init const\nfunction caml_ba_init() {\n  return 0;\n}\n\n//Provides: caml_ba_get_size\n//Requires: caml_invalid_argument\nfunction caml_ba_get_size(dims) {\n  var n_dims = dims.length;\n  var size = 1;\n  for (var i = 0; i < n_dims; i++) {\n    if (dims[i] < 0)\n      caml_invalid_argument(\"Bigarray.create: negative dimension\");\n    size = size * dims[i];\n  }\n  return size;\n}\n\n//Provides: caml_ba_get_size_per_element\nfunction caml_ba_get_size_per_element(kind){\n  switch(kind){\n  case 7: case 10: case 11: return 2;\n  default: return 1;\n  }\n}\n\n//Provides: caml_ba_create_buffer\n//Requires: caml_ba_get_size_per_element\n//Requires: caml_invalid_argument\nfunction caml_ba_create_buffer(kind, size){\n  var g = globalThis;\n  var view;\n  switch(kind){\n  case 0:  view = g.Float32Array; break;\n  case 1:  view = g.Float64Array; break;\n  case 2:  view = g.Int8Array; break;\n  case 3:  view = g.Uint8Array; break;\n  case 4:  view = g.Int16Array; break;\n  case 5:  view = g.Uint16Array; break;\n  case 6:  view = g.Int32Array; break;\n  case 7:  view = g.Int32Array; break;\n  case 8:  view = g.Int32Array; break;\n  case 9:  view = g.Int32Array; break;\n  case 10: view = g.Float32Array; break;\n  case 11: view = g.Float64Array; break;\n  case 12: view = g.Uint8Array; break;\n  }\n  if (!view) caml_invalid_argument(\"Bigarray.create: unsupported kind\");\n  var data = new view(size * caml_ba_get_size_per_element(kind));\n  return data;\n}\n\n//Provides: caml_ba_custom_name\n//Version: < 4.11\nvar caml_ba_custom_name = \"_bigarray\"\n\n//Provides: caml_ba_custom_name\n//Version: >= 4.11\nvar caml_ba_custom_name = \"_bigarr02\"\n\n//Provides: Ml_Bigarray\n//Requires: caml_array_bound_error, caml_invalid_argument, caml_ba_custom_name\n//Requires: caml_int64_create_lo_hi, caml_int64_hi32, caml_int64_lo32\nfunction Ml_Bigarray (kind, layout, dims, buffer) {\n\n  this.kind   = kind ;\n  this.layout = layout;\n  this.dims   = dims;\n  this.data = buffer;\n}\n\nMl_Bigarray.prototype.caml_custom = caml_ba_custom_name;\n\nMl_Bigarray.prototype.offset = function (arg) {\n  var ofs = 0;\n  if(typeof arg === \"number\") arg = [arg];\n  if (! (arg instanceof Array)) caml_invalid_argument(\"bigarray.js: invalid offset\");\n  if (this.dims.length != arg.length)\n    caml_invalid_argument(\"Bigarray.get/set: bad number of dimensions\");\n  if(this.layout == 0 /* c_layout */) {\n    for (var i = 0; i < this.dims.length; i++) {\n      if (arg[i] < 0 || arg[i] >= this.dims[i])\n        caml_array_bound_error();\n      ofs = (ofs * this.dims[i]) + arg[i];\n    }\n  } else {\n    for (var i = this.dims.length - 1; i >= 0; i--) {\n      if (arg[i] < 1 || arg[i] > this.dims[i]){\n        caml_array_bound_error();\n      }\n      ofs = (ofs * this.dims[i]) + (arg[i] - 1);\n    }\n  }\n  return ofs;\n}\n\nMl_Bigarray.prototype.get = function (ofs) {\n  switch(this.kind){\n  case 7:\n    // Int64\n    var l = this.data[ofs * 2 + 0];\n    var h = this.data[ofs * 2 + 1];\n    return caml_int64_create_lo_hi(l,h);\n  case 10: case 11:\n    // Complex32, Complex64\n    var r = this.data[ofs * 2 + 0];\n    var i = this.data[ofs * 2 + 1];\n    return [254, r, i];\n  default:\n    return this.data[ofs]\n  }\n}\n\nMl_Bigarray.prototype.set = function (ofs,v) {\n  switch(this.kind){\n  case 7:\n    // Int64\n    this.data[ofs * 2 + 0] = caml_int64_lo32(v);\n    this.data[ofs * 2 + 1] = caml_int64_hi32(v);\n    break;\n  case 10: case 11:\n    // Complex32, Complex64\n    this.data[ofs * 2 + 0] = v[1];\n    this.data[ofs * 2 + 1] = v[2];\n    break;\n  default:\n    this.data[ofs] = v;\n    break;\n  }\n  return 0\n}\n\n\nMl_Bigarray.prototype.fill = function (v) {\n  switch(this.kind){\n  case 7:\n    // Int64\n    var a = caml_int64_lo32(v);\n    var b = caml_int64_hi32(v);\n    if(a == b){\n      this.data.fill(a);\n    }\n    else {\n      for(var i = 0; i<this.data.length; i++){\n        this.data[i] = (i%2 == 0) ? a : b;\n      }\n    }\n    break;\n  case 10: case 11:\n    // Complex32, Complex64\n    var im = v[1];\n    var re = v[2];\n    if(im == re){\n      this.data.fill(im);\n    }\n    else {\n      for(var i = 0; i<this.data.length; i++){\n        this.data[i] = (i%2 == 0) ? im : re;\n      }\n    }\n    break;\n  default:\n    this.data.fill(v);\n    break;\n  }\n}\n\n\nMl_Bigarray.prototype.compare = function (b, total) {\n  if (this.layout != b.layout || this.kind != b.kind) {\n    var k1 = this.kind | (this.layout << 8);\n    var k2 =    b.kind | (b.layout << 8);\n    return k2 - k1;\n  }\n  if (this.dims.length != b.dims.length) {\n    return b.dims.length - this.dims.length;\n  }\n  for (var i = 0; i < this.dims.length; i++)\n    if (this.dims[i] != b.dims[i])\n      return (this.dims[i] < b.dims[i]) ? -1 : 1;\n  switch (this.kind) {\n  case 0:\n  case 1:\n  case 10:\n  case 11:\n    // Floats\n    var x, y;\n    for (var i = 0; i < this.data.length; i++) {\n      x = this.data[i];\n      y = b.data[i];\n      if (x < y)\n        return -1;\n      if (x > y)\n        return 1;\n      if (x != y) {\n        if (!total) return NaN;\n        if (x == x) return 1;\n        if (y == y) return -1;\n      }\n    }\n    break;\n  case 7:\n    // Int64\n    for (var i = 0; i < this.data.length; i+=2) {\n      // Check highest bits first\n      if (this.data[i+1] < b.data[i+1])\n        return -1;\n      if (this.data[i+1] > b.data[i+1])\n        return 1;\n      if ((this.data[i] >>> 0) < (b.data[i] >>> 0))\n        return -1;\n      if ((this.data[i] >>> 0) > (b.data[i] >>> 0))\n        return 1;\n    }\n    break;\n  case 2:\n  case 3:\n  case 4:\n  case 5:\n  case 6:\n  case 8:\n  case 9:\n  case 12:\n    for (var i = 0; i < this.data.length; i++) {\n      if (this.data[i] < b.data[i])\n        return -1;\n      if (this.data[i] > b.data[i])\n        return 1;\n    }\n    break;\n  }\n  return 0;\n}\n\n//Provides: Ml_Bigarray_c_1_1\n//Requires: Ml_Bigarray, caml_array_bound_error, caml_invalid_argument\nfunction Ml_Bigarray_c_1_1(kind, layout, dims, buffer) {\n  this.kind   = kind ;\n  this.layout = layout;\n  this.dims   = dims;\n  this.data   = buffer;\n}\n\nMl_Bigarray_c_1_1.prototype = new Ml_Bigarray()\nMl_Bigarray_c_1_1.prototype.offset = function (arg) {\n  if(typeof arg !== \"number\"){\n    if((arg instanceof Array) && arg.length == 1)\n      arg = arg[0];\n    else caml_invalid_argument(\"Ml_Bigarray_c_1_1.offset\");\n  }\n  if (arg < 0 || arg >= this.dims[0])\n    caml_array_bound_error();\n  return arg;\n}\n\nMl_Bigarray_c_1_1.prototype.get = function (ofs) {\n  return this.data[ofs];\n}\n\nMl_Bigarray_c_1_1.prototype.set = function (ofs,v) {\n  this.data[ofs] = v;\n  return 0\n}\n\nMl_Bigarray_c_1_1.prototype.fill = function (v) {\n  this.data.fill(v);\n  return 0\n}\n\n//Provides: caml_ba_compare\nfunction caml_ba_compare(a,b,total){\n  return a.compare(b,total)\n}\n\n//Provides: caml_ba_create_unsafe\n//Requires: Ml_Bigarray, Ml_Bigarray_c_1_1, caml_ba_get_size, caml_ba_get_size_per_element\n//Requires: caml_invalid_argument\nfunction caml_ba_create_unsafe(kind, layout, dims, data){\n  var size_per_element = caml_ba_get_size_per_element(kind);\n  if(caml_ba_get_size(dims) * size_per_element != data.length) {\n    caml_invalid_argument(\"length doesn't match dims\");\n  }\n  if(layout == 0 && // c_layout\n     dims.length == 1 && // Array1\n     size_per_element == 1) // 1-to-1 mapping\n    return new Ml_Bigarray_c_1_1(kind, layout, dims, data);\n  return new Ml_Bigarray(kind, layout, dims, data);\n\n}\n\n\n//Provides: caml_ba_create\n//Requires: caml_js_from_array\n//Requires: caml_ba_get_size, caml_ba_create_unsafe\n//Requires: caml_ba_create_buffer\nfunction caml_ba_create(kind, layout, dims_ml) {\n  var dims = caml_js_from_array(dims_ml);\n  var data = caml_ba_create_buffer(kind, caml_ba_get_size(dims));\n  return caml_ba_create_unsafe(kind, layout, dims, data);\n}\n\n//Provides: caml_ba_change_layout\n//Requires: caml_ba_create_unsafe\nfunction caml_ba_change_layout(ba, layout) {\n  if(ba.layout == layout) return ba;\n  var new_dims = []\n  for(var i = 0; i < ba.dims.length; i++) new_dims[i] = ba.dims[ba.dims.length - i - 1];\n  return caml_ba_create_unsafe(ba.kind, layout, new_dims, ba.data);\n}\n\n//Provides: caml_ba_kind\nfunction caml_ba_kind(ba) {\n  return ba.kind;\n}\n\n//Provides: caml_ba_layout\nfunction caml_ba_layout(ba) {\n  return ba.layout;\n}\n\n//Provides: caml_ba_num_dims\nfunction caml_ba_num_dims(ba) {\n  return ba.dims.length;\n}\n\n//Provides: caml_ba_dim\n//Requires: caml_invalid_argument\nfunction caml_ba_dim(ba, i) {\n  if (i < 0 || i >= ba.dims.length)\n    caml_invalid_argument(\"Bigarray.dim\");\n  return ba.dims[i];\n}\n\n//Provides: caml_ba_dim_1\n//Requires: caml_ba_dim\nfunction caml_ba_dim_1(ba) {\n  return caml_ba_dim(ba, 0);\n}\n\n//Provides: caml_ba_dim_2\n//Requires: caml_ba_dim\nfunction caml_ba_dim_2(ba) {\n  return caml_ba_dim(ba, 1);\n}\n\n//Provides: caml_ba_dim_3\n//Requires: caml_ba_dim\nfunction caml_ba_dim_3(ba) {\n  return caml_ba_dim(ba, 2);\n}\n\n//Provides: caml_ba_get_generic\n//Requires: caml_js_from_array\nfunction caml_ba_get_generic(ba, i) {\n  var ofs = ba.offset(caml_js_from_array(i));\n  return ba.get(ofs);\n}\n\n//Provides: caml_ba_uint8_get16\n//Requires: caml_array_bound_error\nfunction caml_ba_uint8_get16(ba, i0) {\n  var ofs = ba.offset(i0);\n  if(ofs + 1 >= ba.data.length) caml_array_bound_error();\n  var b1 = ba.get(ofs);\n  var b2 = ba.get(ofs + 1);\n  return (b1 | (b2 << 8));\n}\n\n//Provides: caml_ba_uint8_get32\n//Requires: caml_array_bound_error\nfunction caml_ba_uint8_get32(ba, i0) {\n  var ofs = ba.offset(i0);\n  if(ofs + 3 >= ba.data.length) caml_array_bound_error();\n  var b1 = ba.get(ofs+0);\n  var b2 = ba.get(ofs+1);\n  var b3 = ba.get(ofs+2);\n  var b4 = ba.get(ofs+3);\n  return ( (b1 << 0)  |\n           (b2 << 8)  |\n           (b3 << 16) |\n           (b4 << 24) );\n}\n\n//Provides: caml_ba_uint8_get64\n//Requires: caml_array_bound_error, caml_int64_of_bytes\nfunction caml_ba_uint8_get64(ba, i0) {\n  var ofs = ba.offset(i0);\n  if(ofs + 7 >= ba.data.length) caml_array_bound_error();\n  var b1 = ba.get(ofs+0);\n  var b2 = ba.get(ofs+1);\n  var b3 = ba.get(ofs+2);\n  var b4 = ba.get(ofs+3);\n  var b5 = ba.get(ofs+4);\n  var b6 = ba.get(ofs+5);\n  var b7 = ba.get(ofs+6);\n  var b8 = ba.get(ofs+7);\n  return caml_int64_of_bytes([b8,b7,b6,b5,b4,b3,b2,b1]);\n}\n\n//Provides: caml_ba_get_1\nfunction caml_ba_get_1(ba, i0) {\n  return ba.get(ba.offset(i0));\n}\n\n//Provides: caml_ba_get_2\nfunction caml_ba_get_2(ba, i0, i1) {\n  return ba.get(ba.offset([i0,i1]));\n}\n\n//Provides: caml_ba_get_3\nfunction caml_ba_get_3(ba, i0, i1, i2) {\n  return ba.get(ba.offset([i0,i1,i2]));\n}\n\n//Provides: caml_ba_set_generic\n//Requires: caml_js_from_array\nfunction caml_ba_set_generic(ba, i, v) {\n  ba.set(ba.offset(caml_js_from_array(i)), v);\n  return 0\n}\n\n//Provides: caml_ba_uint8_set16\n//Requires: caml_array_bound_error\nfunction caml_ba_uint8_set16(ba, i0, v) {\n  var ofs = ba.offset(i0);\n  if(ofs + 1 >= ba.data.length) caml_array_bound_error();\n  ba.set(ofs+0,  v        & 0xff);\n  ba.set(ofs+1, (v >>> 8) & 0xff);\n  return 0;\n}\n\n//Provides: caml_ba_uint8_set32\n//Requires: caml_array_bound_error\nfunction caml_ba_uint8_set32(ba, i0, v) {\n  var ofs = ba.offset(i0);\n  if(ofs + 3 >= ba.data.length) caml_array_bound_error();\n  ba.set(ofs+0,  v         & 0xff);\n  ba.set(ofs+1, (v >>> 8)  & 0xff);\n  ba.set(ofs+2, (v >>> 16) & 0xff);\n  ba.set(ofs+3, (v >>> 24) & 0xff);\n  return 0;\n}\n\n//Provides: caml_ba_uint8_set64\n//Requires: caml_array_bound_error, caml_int64_to_bytes\nfunction caml_ba_uint8_set64(ba, i0, v) {\n  var ofs = ba.offset(i0);\n  if(ofs + 7 >= ba.data.length) caml_array_bound_error();\n  var v = caml_int64_to_bytes(v);\n  for(var i = 0; i < 8; i++) ba.set(ofs+i, v[7-i])\n  return 0;\n}\n\n//Provides: caml_ba_set_1\nfunction caml_ba_set_1(ba, i0, v) {\n  ba.set(ba.offset(i0), v);\n  return 0\n}\n\n//Provides: caml_ba_set_2\nfunction caml_ba_set_2(ba, i0, i1, v) {\n  ba.set(ba.offset([i0,i1]), v);\n  return 0;\n}\n\n//Provides: caml_ba_set_3\nfunction caml_ba_set_3(ba, i0, i1, i2, v) {\n  ba.set(ba.offset([i0,i1,i2]), v);\n  return 0;\n}\n\n//Provides: caml_ba_fill\nfunction caml_ba_fill(ba, v) {\n  ba.fill(v);\n  return 0;\n}\n\n//Provides: caml_ba_blit\n//Requires: caml_invalid_argument\nfunction caml_ba_blit(src, dst) {\n  if (dst.dims.length != src.dims.length)\n    caml_invalid_argument(\"Bigarray.blit: dimension mismatch\");\n  for (var i = 0; i < dst.dims.length; i++)\n    if (dst.dims[i] != src.dims[i])\n      caml_invalid_argument(\"Bigarray.blit: dimension mismatch\");\n  dst.data.set(src.data);\n  return 0;\n}\n\n//Provides: caml_ba_sub\n//Requires: caml_invalid_argument, caml_ba_create_unsafe, caml_ba_get_size\n//Requires: caml_ba_get_size_per_element\nfunction caml_ba_sub(ba, ofs, len) {\n  var changed_dim;\n  var mul = 1;\n  if (ba.layout == 0) {\n    for (var i = 1; i < ba.dims.length; i++)\n      mul = mul * ba.dims[i];\n    changed_dim = 0;\n  } else {\n    for (var i = 0; i < (ba.dims.length - 1); i++)\n      mul = mul * ba.dims[i];\n    changed_dim = ba.dims.length - 1;\n    ofs = ofs - 1;\n  }\n  if (ofs < 0 || len < 0 || (ofs + len) > ba.dims[changed_dim]){\n    caml_invalid_argument(\"Bigarray.sub: bad sub-array\");\n  }\n  var new_dims = [];\n  for (var i = 0; i < ba.dims.length; i++)\n    new_dims[i] = ba.dims[i];\n  new_dims[changed_dim] = len;\n  mul *= caml_ba_get_size_per_element(ba.kind);\n  var new_data = ba.data.subarray(ofs * mul, (ofs + len) * mul);\n  return caml_ba_create_unsafe(ba.kind, ba.layout, new_dims, new_data);\n}\n\n//Provides: caml_ba_slice\n//Requires: caml_js_from_array, caml_ba_create_unsafe, caml_invalid_argument, caml_ba_get_size\n//Requires: caml_ba_get_size_per_element\nfunction caml_ba_slice(ba, vind) {\n  vind = caml_js_from_array(vind);\n  var num_inds = vind.length;\n  var index = [];\n  var sub_dims = [];\n  var ofs;\n\n  if (num_inds > ba.dims.length)\n    caml_invalid_argument(\"Bigarray.slice: too many indices\");\n\n  // Compute offset and check bounds\n  if (ba.layout == 0) {\n    for (var i = 0; i < num_inds; i++)\n      index[i] = vind[i];\n    for (; i < ba.dims.length; i++)\n      index[i] = 0;\n    sub_dims = ba.dims.slice(num_inds);\n  } else {\n    for (var i = 0; i < num_inds; i++)\n      index[ba.dims.length - num_inds + i] = vind[i];\n    for (var i = 0; i < ba.dims.length - num_inds; i++)\n      index[i] = 1;\n    sub_dims = ba.dims.slice(0, ba.dims.length - num_inds);\n  }\n  ofs = ba.offset(index);\n  var size = caml_ba_get_size(sub_dims);\n  var size_per_element = caml_ba_get_size_per_element(ba.kind);\n  var new_data = ba.data.subarray(ofs * size_per_element, (ofs + size) * size_per_element);\n  return caml_ba_create_unsafe(ba.kind, ba.layout, sub_dims, new_data);\n}\n\n//Provides: caml_ba_reshape\n//Requires: caml_js_from_array, caml_invalid_argument, caml_ba_create_unsafe, caml_ba_get_size\nfunction caml_ba_reshape(ba, vind) {\n  vind = caml_js_from_array(vind);\n  var new_dim = [];\n  var num_dims = vind.length;\n\n  if (num_dims < 0 || num_dims > 16){\n    caml_invalid_argument(\"Bigarray.reshape: bad number of dimensions\");\n  }\n  var num_elts = 1;\n  for (var i = 0; i < num_dims; i++) {\n    new_dim[i] = vind[i];\n    if (new_dim[i] < 0)\n      caml_invalid_argument(\"Bigarray.reshape: negative dimension\");\n    num_elts = num_elts * new_dim[i];\n  }\n\n  var size = caml_ba_get_size(ba.dims);\n  // Check that sizes agree\n  if (num_elts != size)\n    caml_invalid_argument(\"Bigarray.reshape: size mismatch\");\n  return caml_ba_create_unsafe(ba.kind, ba.layout, new_dim, ba.data);\n}\n\n//Provides: caml_ba_serialize\n//Requires: caml_int64_bits_of_float, caml_int64_to_bytes\n//Requires: caml_int32_bits_of_float\nfunction caml_ba_serialize(writer, ba, sz) {\n  writer.write(32, ba.dims.length);\n  writer.write(32, (ba.kind | (ba.layout << 8)));\n  if(ba.caml_custom == \"_bigarr02\")\n    for(var i = 0; i < ba.dims.length; i++) {\n      if(ba.dims[i] < 0xffff)\n        writer.write(16, ba.dims[i]);\n      else {\n        writer.write(16, 0xffff);\n        writer.write(32, 0);\n        writer.write(32, ba.dims[i]);\n      }\n    }\n  else\n    for(var i = 0; i < ba.dims.length; i++) writer.write(32,ba.dims[i])\n  switch(ba.kind){\n  case 2:  //Int8Array\n  case 3:  //Uint8Array\n  case 12: //Uint8Array\n    for(var i = 0; i < ba.data.length; i++){\n      writer.write(8, ba.data[i]);\n    }\n    break;\n  case 4:  // Int16Array\n  case 5:  // Uint16Array\n    for(var i = 0; i < ba.data.length; i++){\n      writer.write(16, ba.data[i]);\n    }\n    break;\n  case 6:  // Int32Array (int32)\n    for(var i = 0; i < ba.data.length; i++){\n      writer.write(32, ba.data[i]);\n    }\n    break;\n  case 8:  // Int32Array (int)\n  case 9:  // Int32Array (nativeint)\n    writer.write(8,0);\n    for(var i = 0; i < ba.data.length; i++){\n      writer.write(32, ba.data[i]);\n    }\n    break;\n  case 7:  // Int32Array (int64)\n    for(var i = 0; i < ba.data.length / 2; i++){\n      var b = caml_int64_to_bytes(ba.get(i));\n      for (var j = 0; j < 8; j++) writer.write (8, b[j]);\n    }\n    break;\n  case 1:  // Float64Array\n    for(var i = 0; i < ba.data.length; i++){\n      var b = caml_int64_to_bytes(caml_int64_bits_of_float(ba.get(i)));\n      for (var j = 0; j < 8; j++) writer.write (8, b[j]);\n    }\n    break;\n  case 0:  // Float32Array\n    for(var i = 0; i < ba.data.length; i++){\n      var b = caml_int32_bits_of_float(ba.get(i));\n      writer.write(32, b);\n    }\n    break;\n  case 10: // Float32Array (complex32)\n    for(var i = 0; i < ba.data.length / 2; i++){\n      var j = ba.get(i);\n      writer.write(32, caml_int32_bits_of_float(j[1]));\n      writer.write(32, caml_int32_bits_of_float(j[2]));\n    }\n    break;\n  case 11: // Float64Array (complex64)\n    for(var i = 0; i < ba.data.length / 2; i++){\n      var complex = ba.get(i);\n      var b = caml_int64_to_bytes(caml_int64_bits_of_float(complex[1]));\n      for (var j = 0; j < 8; j++) writer.write (8, b[j]);\n      var b = caml_int64_to_bytes(caml_int64_bits_of_float(complex[2]));\n      for (var j = 0; j < 8; j++) writer.write (8, b[j]);\n    }\n    break;\n  }\n  sz[0] = (4 + ba.dims.length) * 4;\n  sz[1] = (4 + ba.dims.length) * 8;\n}\n\n//Provides: caml_ba_deserialize\n//Requires: caml_ba_create_unsafe, caml_failwith\n//Requires: caml_ba_get_size\n//Requires: caml_int64_of_bytes, caml_int64_float_of_bits\n//Requires: caml_int32_float_of_bits\n//Requires: caml_ba_create_buffer\nfunction caml_ba_deserialize(reader, sz, name){\n  var num_dims = reader.read32s();\n  if (num_dims < 0 || num_dims > 16)\n    caml_failwith(\"input_value: wrong number of bigarray dimensions\");\n  var tag = reader.read32s();\n  var kind = tag & 0xff\n  var layout = (tag >> 8) & 1;\n  var dims = []\n  if(name == \"_bigarr02\")\n    for (var i = 0; i < num_dims; i++) {\n      var size_dim = reader.read16u();\n      if(size_dim == 0xffff){\n        var size_dim_hi = reader.read32u();\n        var size_dim_lo = reader.read32u();\n        if(size_dim_hi != 0)\n          caml_failwith(\"input_value: bigarray dimension overflow in 32bit\");\n        size_dim = size_dim_lo;\n      }\n      dims.push(size_dim);\n    }\n  else\n    for (var i = 0; i < num_dims; i++) dims.push(reader.read32u());\n  var size = caml_ba_get_size(dims);\n  var data = caml_ba_create_buffer(kind, size);\n  var ba = caml_ba_create_unsafe(kind, layout, dims, data);\n  switch(kind){\n  case 2:  //Int8Array\n    for(var i = 0; i < size; i++){\n      data[i] = reader.read8s();\n    }\n    break;\n  case 3:  //Uint8Array\n  case 12: //Uint8Array\n    for(var i = 0; i < size; i++){\n      data[i] = reader.read8u();\n    }\n    break;\n  case 4:  // Int16Array\n    for(var i = 0; i < size; i++){\n      data[i] = reader.read16s();\n    }\n    break;\n  case 5:  // Uint16Array\n    for(var i = 0; i < size; i++){\n      data[i] = reader.read16u();\n    }\n    break;\n  case 6:  // Int32Array (int32)\n    for(var i = 0; i < size; i++){\n      data[i] = reader.read32s();\n    }\n    break;\n  case 8:  // Int32Array (int)\n  case 9:  // Int32Array (nativeint)\n    var sixty = reader.read8u();\n    if(sixty) caml_failwith(\"input_value: cannot read bigarray with 64-bit OCaml ints\");\n    for(var i = 0; i < size; i++){\n      data[i] = reader.read32s();\n    }\n    break;\n  case 7: // (int64)\n    var t = new Array(8);;\n    for(var i = 0; i < size; i++){\n      for (var j = 0;j < 8;j++) t[j] = reader.read8u();\n      var int64 = caml_int64_of_bytes(t);\n      ba.set(i,int64);\n    }\n    break;\n  case 1:  // Float64Array\n    var t = new Array(8);;\n    for(var i = 0; i < size; i++){\n      for (var j = 0;j < 8;j++) t[j] = reader.read8u();\n      var f = caml_int64_float_of_bits(caml_int64_of_bytes(t));\n      ba.set(i,f);\n    }\n    break;\n  case 0:  // Float32Array\n    for(var i = 0; i < size; i++){\n      var f = caml_int32_float_of_bits(reader.read32s());\n      ba.set(i,f);\n    }\n    break;\n  case 10: // Float32Array (complex32)\n    for(var i = 0; i < size; i++){\n      var re = caml_int32_float_of_bits(reader.read32s());\n      var im = caml_int32_float_of_bits(reader.read32s());\n      ba.set(i,[254,re,im]);\n    }\n    break;\n  case 11: // Float64Array (complex64)\n    var t = new Array(8);;\n    for(var i = 0; i < size; i++){\n      for (var j = 0;j < 8;j++) t[j] = reader.read8u();\n      var re = caml_int64_float_of_bits(caml_int64_of_bytes(t));\n      for (var j = 0;j < 8;j++) t[j] = reader.read8u();\n      var im = caml_int64_float_of_bits(caml_int64_of_bytes(t));\n      ba.set(i,[254,re,im]);\n    }\n    break\n  }\n  sz[0] = (4 + num_dims) * 4;\n  return caml_ba_create_unsafe(kind, layout, dims, data);\n}\n\n//Deprecated\n//Provides: caml_ba_create_from\n//Requires: caml_ba_create_unsafe, caml_invalid_argument, caml_ba_get_size_per_element\nfunction caml_ba_create_from(data1, data2, jstyp, kind, layout, dims){\n  if(data2 || caml_ba_get_size_per_element(kind) == 2){\n    caml_invalid_argument(\"caml_ba_create_from: use return caml_ba_create_unsafe\");\n  }\n  return caml_ba_create_unsafe(kind, layout, dims, data1);\n}\n\n//Provides: caml_ba_hash const\n//Requires: caml_ba_get_size, caml_hash_mix_int, caml_hash_mix_float\nfunction caml_ba_hash(ba){\n  var num_elts = caml_ba_get_size(ba.dims);\n  var h = 0;\n  switch(ba.kind){\n  case 2:  //Int8Array\n  case 3:  //Uint8Array\n  case 12: //Uint8Array\n    if(num_elts > 256) num_elts = 256;\n    var w = 0, i =0;\n    for(i = 0; i + 4 <= ba.data.length; i+=4){\n      w = ba.data[i+0] | (ba.data[i+1] << 8) | (ba.data[i+2] << 16) | (ba.data[i+3] << 24);\n      h = caml_hash_mix_int(h,w);\n    }\n    w = 0;\n    switch (num_elts & 3) {\n    case 3: w  = ba.data[i+2] << 16;    /* fallthrough */\n    case 2: w |= ba.data[i+1] << 8;     /* fallthrough */\n    case 1: w |= ba.data[i+0];\n      h = caml_hash_mix_int(h, w);\n    }\n    break;\n  case 4:  // Int16Array\n  case 5:  // Uint16Array\n    if(num_elts > 128) num_elts = 128;\n    var w = 0, i =0;\n    for(i = 0; i + 2 <= ba.data.length; i+=2){\n      w = ba.data[i+0] | (ba.data[i+1] << 16);\n      h = caml_hash_mix_int(h,w);\n    }\n    if ((num_elts & 1) != 0)\n      h = caml_hash_mix_int(h, ba.data[i]);\n    break;\n  case 6:  // Int32Array (int32)\n    if (num_elts > 64) num_elts = 64;\n    for (var i = 0; i < num_elts; i++) h = caml_hash_mix_int(h, ba.data[i]);\n    break;\n  case 8:  // Int32Array (int)\n  case 9:  // Int32Array (nativeint)\n    if (num_elts > 64) num_elts = 64;\n    for (var i = 0; i < num_elts; i++) h = caml_hash_mix_int(h, ba.data[i]);\n    break;\n  case 7:  // Int32Array (int64)\n    if (num_elts > 32) num_elts = 32;\n    num_elts *= 2\n    for (var i = 0; i < num_elts; i++) {\n      h = caml_hash_mix_int(h, ba.data[i]);\n    }\n    break;\n  case 10: // Float32Array (complex32)\n    num_elts *=2; /* fallthrough */\n  case 0:  // Float32Array\n    if (num_elts > 64) num_elts = 64;\n    for (var i = 0; i < num_elts; i++) h = caml_hash_mix_float(h, ba.data[i]);\n    break;\n  case 11: // Float64Array (complex64)\n    num_elts *=2; /* fallthrough */\n  case 1:  // Float64Array\n    if (num_elts > 32) num_elts = 32;\n    for (var i = 0; i < num_elts; i++) h = caml_hash_mix_float(h, ba.data[i]);\n    break;\n  }\n  return h;\n}\n\n//Provides: caml_ba_to_typed_array mutable\nfunction caml_ba_to_typed_array(ba){\n  return ba.data;\n}\n\n//Provides: caml_ba_kind_of_typed_array mutable\n//Requires: caml_invalid_argument\nfunction caml_ba_kind_of_typed_array(ta){\n  var g = globalThis;\n  var kind;\n  if (ta instanceof g.Float32Array) kind = 0;\n  else if (ta instanceof g.Float64Array) kind = 1;\n  else if (ta instanceof g.Int8Array) kind = 2;\n  else if (ta instanceof g.Uint8Array) kind = 3;\n  else if (ta instanceof g.Int16Array) kind = 4;\n  else if (ta instanceof g.Uint16Array) kind = 5;\n  else if (ta instanceof g.Int32Array) kind = 6;\n  else if (ta instanceof g.Uint32Array) kind = 6;\n  else caml_invalid_argument(\"caml_ba_kind_of_typed_array: unsupported kind\");\n  return kind;\n}\n\n//Provides: caml_ba_from_typed_array mutable\n//Requires: caml_ba_kind_of_typed_array\n//Requires: caml_ba_create_unsafe\nfunction caml_ba_from_typed_array(ta){\n  var kind = caml_ba_kind_of_typed_array(ta);\n  return caml_ba_create_unsafe(kind, 0, [ta.length], ta);\n}\n"
let bigstring_base_bigstring = Js_of_ocaml_compiler.Builtins.register ~name:"bigstring-base_bigstring.js" ~content:"\n//The following are defined in Base_bigstring\n//There are just provided here for compatibility reasons\n\n//Provides: bigstring_alloc\n//Requires: caml_ba_create\n//Weakdef\nfunction bigstring_alloc(_,size){ return caml_ba_create(12, 0, [0,size]) }\n//Provides: bigstring_blit_stub\n//Requires: caml_bigstring_blit_ba_to_ba\n//Weakdef\nvar bigstring_blit_stub = caml_bigstring_blit_ba_to_ba\n//Provides: bigstring_blit_bytes_bigstring_stub\n//Requires: caml_bigstring_blit_string_to_ba\n//Weakdef\nvar bigstring_blit_bytes_bigstring_stub = caml_bigstring_blit_string_to_ba\n//Provides: bigstring_blit_string_bigstring_stub\n//Requires: caml_bigstring_blit_string_to_ba\n//Weakdef\nvar bigstring_blit_string_bigstring_stub = caml_bigstring_blit_string_to_ba\n//Provides: bigstring_blit_bigstring_bytes_stub\n//Requires: caml_bigstring_blit_ba_to_bytes\n//Weakdef\nvar bigstring_blit_bigstring_bytes_stub = caml_bigstring_blit_ba_to_bytes;\n//Provides: bigstring_blit_bigstring_string_stub\n//Requires: caml_bigstring_blit_ba_to_bytes\n//Weakdef\nvar bigstring_blit_bigstring_string_stub = caml_bigstring_blit_ba_to_bytes\n//Provides: bigstring_memcmp_stub\n//Requires: caml_bigstring_memcmp\n//Weakdef\nvar bigstring_memcmp_stub = caml_bigstring_memcmp\n//Provides: bigstring_find\n//Requires: caml_ba_get_1\n//Weakdef\nfunction bigstring_find(bs, chr, pos, len){\n  while(len > 0){\n    if(caml_ba_get_1(bs,pos) == chr) return pos;\n    pos++;\n    len--;\n  }\n  return -1;\n}\n"
let bigstring_core_kernel = Js_of_ocaml_compiler.Builtins.register ~name:"bigstring-core_kernel.js" ~content:"//The following are defined in Core_kernel\n//There are just provided here for compatibility reasons\n\n//Provides: bigstring_destroy_stub\n//Requires: caml_invalid_argument, caml_ba_create_unsafe\n//Weakdef\nfunction bigstring_destroy_stub(v_bstr) {\n  if (v_bstr.hasOwnProperty('__is_deallocated')) {\n    caml_invalid_argument(\"bigstring_destroy: bigstring is already deallocated\");\n  }\n  // Mutate the original bigstring in-place, to simulate what the C version does\n  v_bstr.__is_deallocated = true;\n  v_bstr.data = new v_bstr.data.__proto__.constructor(0);\n  v_bstr.dims = [0];\n  return 0;\n}\n"
let bigstring_cstruct = Js_of_ocaml_compiler.Builtins.register ~name:"bigstring-cstruct.js" ~content:"//The following are defined in Cstruct\n//There are just provided here for compatibility reasons\n\n//Provides: caml_blit_bigstring_to_bigstring\n//Requires: caml_bigstring_blit_ba_to_ba\n//Weakdef\nvar caml_blit_bigstring_to_bigstring = caml_bigstring_blit_ba_to_ba\n//Provides: caml_blit_bigstring_to_string\n//Requires: caml_bigstring_blit_ba_to_bytes\n//Weakdef\nvar caml_blit_bigstring_to_string = caml_bigstring_blit_ba_to_bytes\n//Provides: caml_blit_string_to_bigstring\n//Requires: caml_bigstring_blit_string_to_ba\n//Weakdef\nvar caml_blit_string_to_bigstring = caml_bigstring_blit_string_to_ba\n"
let bigstring = Js_of_ocaml_compiler.Builtins.register ~name:"bigstring.js" ~content:"///////// BIGSTRING\n\n//Provides: caml_hash_mix_bigstring\n//Requires: caml_hash_mix_bytes_arr\nfunction caml_hash_mix_bigstring(h, bs) {\n  return caml_hash_mix_bytes_arr(h,bs.data);\n}\n\n//Provides: bigstring_to_array_buffer mutable\nfunction bigstring_to_array_buffer(bs) {\n  return bs.data.buffer\n}\n\n//Provides: bigstring_to_typed_array mutable\nfunction bigstring_to_typed_array(bs) {\n  return bs.data\n}\n\n//Provides: bigstring_of_array_buffer mutable\n//Requires: caml_ba_create_unsafe\nfunction bigstring_of_array_buffer(ab) {\n  var ta = new globalThis.Uint8Array(ab);\n  return caml_ba_create_unsafe(12, 0, [ta.length], ta);\n}\n\n//Provides: bigstring_of_typed_array mutable\n//Requires: caml_ba_create_unsafe\nfunction bigstring_of_typed_array(ba) {\n  var ta = new globalThis.Uint8Array(ba.buffer, ba.byteOffset, ba.length * ba.BYTES_PER_ELEMENT);\n  return caml_ba_create_unsafe(12, 0, [ta.length], ta);\n}\n\n//Provides: caml_bigstring_memcmp\n//Requires: caml_ba_get_1\nfunction caml_bigstring_memcmp(s1, pos1, s2, pos2, len){\n  for (var i = 0; i < len; i++) {\n    var a = caml_ba_get_1(s1,pos1 + i);\n    var b = caml_ba_get_1(s2,pos2 + i);\n    if (a < b) return -1;\n    if (a > b) return 1;\n  }\n  return 0;\n}\n\n//Provides: caml_bigstring_blit_ba_to_ba\n//Requires: caml_invalid_argument, caml_array_bound_error\nfunction caml_bigstring_blit_ba_to_ba(ba1, pos1, ba2, pos2, len){\n  if(12 != ba1.kind)\n    caml_invalid_argument(\"caml_bigstring_blit_ba_to_ba: kind mismatch\");\n  if(12 != ba2.kind)\n    caml_invalid_argument(\"caml_bigstring_blit_ba_to_ba: kind mismatch\");\n  if(len == 0) return 0;\n  var ofs1 = ba1.offset(pos1);\n  var ofs2 = ba2.offset(pos2);\n  if(ofs1 + len > ba1.data.length){\n    caml_array_bound_error();\n  }\n  if(ofs2 + len > ba2.data.length){\n    caml_array_bound_error();\n  }\n  var slice = ba1.data.subarray(ofs1,ofs1+len);\n  ba2.data.set(slice,pos2);\n  return 0\n}\n\n//Provides: caml_bigstring_blit_string_to_ba\n//Requires: caml_invalid_argument, caml_array_bound_error, caml_array_of_string\n//Requires: caml_ml_string_length\nfunction caml_bigstring_blit_string_to_ba(str1, pos1, ba2, pos2, len){\n  if(12 != ba2.kind)\n    caml_invalid_argument(\"caml_bigstring_blit_string_to_ba: kind mismatch\");\n  if(len == 0) return 0;\n  var ofs2 = ba2.offset(pos2);\n  if(pos1 + len > caml_ml_string_length(str1)) {\n    caml_array_bound_error();\n  }\n  if(ofs2 + len > ba2.data.length) {\n    caml_array_bound_error();\n  }\n  var slice = caml_array_of_string(str1).slice(pos1,pos1 + len);\n  ba2.data.set(slice,ofs2);\n  return 0\n}\n\n//Provides: caml_bigstring_blit_bytes_to_ba\n//Requires: caml_invalid_argument, caml_array_bound_error, caml_array_of_bytes\n//Requires: caml_ml_bytes_length\nfunction caml_bigstring_blit_bytes_to_ba(str1, pos1, ba2, pos2, len){\n  if(12 != ba2.kind)\n    caml_invalid_argument(\"caml_bigstring_blit_string_to_ba: kind mismatch\");\n  if(len == 0) return 0;\n  var ofs2 = ba2.offset(pos2);\n  if(pos1 + len > caml_ml_bytes_length(str1)) {\n    caml_array_bound_error();\n  }\n  if(ofs2 + len > ba2.data.length) {\n    caml_array_bound_error();\n  }\n  var slice = caml_array_of_bytes(str1).slice(pos1,pos1 + len);\n  ba2.data.set(slice,ofs2);\n  return 0\n}\n\n//Provides: caml_bigstring_blit_ba_to_bytes\n//Requires: caml_invalid_argument, caml_array_bound_error\n//Requires: caml_blit_bytes, caml_bytes_of_array\n//Requires: caml_ml_bytes_length\nfunction caml_bigstring_blit_ba_to_bytes(ba1, pos1, bytes2, pos2, len){\n  if(12 != ba1.kind)\n    caml_invalid_argument(\"caml_bigstring_blit_string_to_ba: kind mismatch\");\n  if(len == 0) return 0;\n  var ofs1 = ba1.offset(pos1);\n  if(ofs1 + len > ba1.data.length){\n    caml_array_bound_error();\n  }\n  if(pos2 + len > caml_ml_bytes_length(bytes2)){\n    caml_array_bound_error();\n  }\n  var slice = ba1.data.slice(ofs1, ofs1+len);\n  caml_blit_bytes(caml_bytes_of_array(slice), 0, bytes2, pos2, len);\n  return 0\n}\n"
let compare = Js_of_ocaml_compiler.Builtins.register ~name:"compare.js" ~content:"// Js_of_ocaml runtime support\n// http://www.ocsigen.org/js_of_ocaml/\n//\n// This program is free software; you can redistribute it and/or modify\n// it under the terms of the GNU Lesser General Public License as published by\n// the Free Software Foundation, with linking exception;\n// either version 2.1 of the License, or (at your option) any later version.\n//\n// This program is distributed in the hope that it will be useful,\n// but WITHOUT ANY WARRANTY; without even the implied warranty of\n// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n// GNU Lesser General Public License for more details.\n//\n// You should have received a copy of the GNU Lesser General Public License\n// along with this program; if not, write to the Free Software\n// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.\n\n//Provides: caml_compare_val_tag\n//Requires: caml_is_ml_string, caml_is_ml_bytes\nfunction caml_compare_val_tag(a){\n  if (typeof a === \"number\") return 1000; // int_tag (we use it for all numbers)\n  else if (caml_is_ml_bytes(a)) return 252; // string_tag\n  else if (caml_is_ml_string(a)) return 1252; // ocaml string (if different from bytes)\n  else if (a instanceof Array && a[0] === (a[0]>>>0) && a[0] <= 255) {\n    // Look like an ocaml block\n    var tag = a[0] | 0;\n    // ignore double_array_tag because we cannot accurately set\n    // this tag when we create an array of float.\n    return (tag == 254)?0:tag\n  }\n  else if (a instanceof String) return 12520; // javascript string, like string_tag (252)\n  else if (typeof a == \"string\") return 12520; // javascript string, like string_tag (252)\n  else if (a instanceof Number) return 1000; // int_tag (we use it for all numbers)\n  else if (a && a.caml_custom) return 1255; // like custom_tag (255)\n  else if (a && a.compare) return 1256; // like custom_tag (255)\n  else if (typeof a == \"function\") return 1247; // like closure_tag (247)\n  else if (typeof a == \"symbol\") return 1251;\n  return 1001; //out_of_heap_tag\n}\n\n//Provides: caml_compare_val_get_custom\n//Requires: caml_custom_ops\nfunction caml_compare_val_get_custom(a){\n  return caml_custom_ops[a.caml_custom] && caml_custom_ops[a.caml_custom].compare;\n}\n\n//Provides: caml_compare_val_number_custom\n//Requires: caml_compare_val_get_custom\nfunction caml_compare_val_number_custom(num, custom, swap, total) {\n  var comp = caml_compare_val_get_custom(custom);\n  if(comp) {\n    var x = (swap > 0)?comp(custom,num,total):comp(num,custom,total);\n    if(total && x != x) return swap; // total && nan\n    if(+x != +x) return +x; // nan\n    if((x | 0) != 0) return (x | 0); // !nan\n  }\n  return swap\n}\n\n//Provides: caml_compare_val (const, const, const)\n//Requires: caml_int_compare, caml_string_compare, caml_bytes_compare\n//Requires: caml_invalid_argument, caml_compare_val_get_custom, caml_compare_val_tag\n//Requires: caml_compare_val_number_custom\n//Requires: caml_jsbytes_of_string\nfunction caml_compare_val (a, b, total) {\n  var stack = [];\n  for(;;) {\n    if (!(total && a === b)) {\n      var tag_a = caml_compare_val_tag(a);\n      // forward_tag ?\n      if(tag_a == 250) { a = a[1]; continue }\n\n      var tag_b = caml_compare_val_tag(b);\n      // forward_tag ?\n      if(tag_b == 250) { b = b[1]; continue }\n\n      // tags are different\n      if(tag_a !== tag_b) {\n        if(tag_a == 1000) {\n          if(tag_b == 1255) { //immediate can compare against custom\n            return caml_compare_val_number_custom(a, b, -1, total);\n          }\n          return -1\n        }\n        if(tag_b == 1000) {\n          if(tag_a == 1255) { //immediate can compare against custom\n            return caml_compare_val_number_custom(b, a, 1, total);\n          }\n          return 1\n        }\n        return (tag_a < tag_b)?-1:1;\n      }\n      switch(tag_a){\n        // 246: Lazy_tag handled bellow\n      case 247: // Closure_tag\n        // Cannot happen\n        caml_invalid_argument(\"compare: functional value\");\n        break\n      case 248: // Object\n        var x = caml_int_compare(a[2], b[2]);\n        if (x != 0) return (x | 0);\n        break;\n      case 249: // Infix\n        // Cannot happen\n        caml_invalid_argument(\"compare: functional value\");\n        break\n      case 250: // Forward tag\n        // Cannot happen, handled above\n        caml_invalid_argument(\"equal: got Forward_tag, should not happen\");\n        break;\n      case 251: //Abstract\n        caml_invalid_argument(\"equal: abstract value\");\n        break;\n      case 252: // OCaml bytes\n        if (a !== b) {\n          var x = caml_bytes_compare(a, b);\n          if (x != 0) return (x | 0);\n        };\n        break;\n      case 253: // Double_tag\n        // Cannot happen\n        caml_invalid_argument(\"equal: got Double_tag, should not happen\");\n        break;\n      case 254: // Double_array_tag\n        // Cannot happen, handled above\n        caml_invalid_argument(\"equal: got Double_array_tag, should not happen\");\n        break\n      case 255: // Custom_tag\n        caml_invalid_argument(\"equal: got Custom_tag, should not happen\");\n        break;\n      case 1247: // Function\n        caml_invalid_argument(\"compare: functional value\");\n        break;\n      case 1255: // Custom\n        var comp = caml_compare_val_get_custom(a);\n        if(comp != caml_compare_val_get_custom(b)){\n          return (a.caml_custom<b.caml_custom)?-1:1;\n        }\n        if(!comp)\n          caml_invalid_argument(\"compare: abstract value\");\n        var x = comp(a,b,total);\n        if(x != x){ // Protect against invalid UNORDERED\n          return total?-1:x;\n        }\n        if(x !== (x|0)){ // Protect against invalid return value\n          return -1\n        }\n        if (x != 0) return (x | 0);\n        break;\n      case 1256: // compare function\n        var x = a.compare(b,total);\n        if(x != x) { // Protect against invalid UNORDERED\n          return total?-1:x;\n        }\n        if(x !== (x|0)){ // Protect against invalid return value\n          return -1\n        }\n        if (x != 0) return (x | 0);\n        break;\n      case 1000: // Number\n        a = +a;\n        b = +b;\n        if (a < b) return -1;\n        if (a > b) return 1;\n        if (a != b) {\n          if (!total) return NaN;\n          if (a == a) return 1;\n          if (b == b) return -1;\n        }\n        break;\n      case 1001: // The rest\n        // Here we can be in the following cases:\n        // 1. JavaScript primitive types\n        // 2. JavaScript object that can be coerced to primitive types\n        // 3. JavaScript object than cannot be coerced to primitive types\n        //\n        // (3) will raise a [TypeError]\n        // (2) will coerce to primitive types using [valueOf] or [toString]\n        // (2) and (3), after eventual coercion\n        // - if a and b are strings, apply lexicographic comparison\n        // - if a or b are not strings, convert a and b to number\n        //   and apply standard comparison\n        //\n        // Exception: `!=` will not coerce/convert if both a and b are objects\n        if (a < b) return -1;\n        if (a > b) return 1;\n        if (a != b) {\n          if (!total) return NaN;\n          if (a == a) return 1;\n          if (b == b) return -1;\n        }\n        break;\n      case 1251: // JavaScript Symbol, no ordering.\n        if(a !== b) {\n          if (!total) return NaN;\n          return 1;\n        }\n        break;\n      case 1252: // ocaml strings\n        var a = caml_jsbytes_of_string(a);\n        var b = caml_jsbytes_of_string(b);\n        if(a !== b) {\n          if(a < b) return -1;\n          if(a > b) return 1;\n        }\n        break;\n      case 12520: // javascript strings\n        var a = a.toString();\n        var b = b.toString();\n        if(a !== b) {\n          if(a < b) return -1;\n          if(a > b) return 1;\n        }\n        break;\n      case 246: // Lazy_tag\n      case 254: // Double_array\n      default: // Block with other tag\n        if (a.length != b.length) return (a.length < b.length)?-1:1;\n        if (a.length > 1) stack.push(a, b, 1);\n        break;\n      }\n    }\n    if (stack.length == 0) return 0;\n    var i = stack.pop();\n    b = stack.pop();\n    a = stack.pop();\n    if (i + 1 < a.length) stack.push(a, b, i + 1);\n    a = a[i];\n    b = b[i];\n  }\n}\n//Provides: caml_compare (const, const)\n//Requires: caml_compare_val\nfunction caml_compare (a, b) { return caml_compare_val (a, b, true); }\n//Provides: caml_int_compare mutable (const, const)\nfunction caml_int_compare (a, b) {\n  if (a < b) return (-1); if (a == b) return 0; return 1;\n}\n//Provides: caml_equal mutable (const, const)\n//Requires: caml_compare_val\nfunction caml_equal (x, y) { return +(caml_compare_val(x,y,false) == 0); }\n//Provides: caml_notequal mutable (const, const)\n//Requires: caml_compare_val\nfunction caml_notequal (x, y) { return +(caml_compare_val(x,y,false) != 0); }\n//Provides: caml_greaterequal mutable (const, const)\n//Requires: caml_compare_val\nfunction caml_greaterequal (x, y) { return +(caml_compare_val(x,y,false) >= 0); }\n//Provides: caml_greaterthan mutable (const, const)\n//Requires: caml_compare_val\nfunction caml_greaterthan (x, y) { return +(caml_compare_val(x,y,false) > 0); }\n//Provides: caml_lessequal mutable (const, const)\n//Requires: caml_compare_val\nfunction caml_lessequal (x, y) { return +(caml_compare_val(x,y,false) <= 0); }\n//Provides: caml_lessthan mutable (const, const)\n//Requires: caml_compare_val\nfunction caml_lessthan (x, y) { return +(caml_compare_val(x,y,false) < 0); }\n"
let dynlink = Js_of_ocaml_compiler.Builtins.register ~name:"dynlink.js" ~content:"// Js_of_ocaml toplevel runtime support\n// http://www.ocsigen.org/js_of_ocaml/\n// Copyright (C) 2015 Hugo Heuzard\n//\n// This program is free software; you can redistribute it and/or modify\n// it under the terms of the GNU Lesser General Public License as published by\n// the Free Software Foundation, with linking exception;\n// either version 2.1 of the License, or (at your option) any later version.\n//\n// This program is distributed in the hope that it will be useful,\n// but WITHOUT ANY WARRANTY; without even the implied warranty of\n// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n// GNU Lesser General Public License for more details.\n//\n// You should have received a copy of the GNU Lesser General Public License\n// along with this program; if not, write to the Free Software\n// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.\n\n//Provides: current_libs\nvar current_libs = [0, globalThis]\n\n//Provides: caml_dynlink_open_lib\n//Requires: current_libs, caml_failwith\n//Requires: caml_jsstring_of_string\nfunction caml_dynlink_open_lib (_mode,file) {\n  var name = caml_jsstring_of_string(file);\n  globalThis.console.log(\"Dynlink: try to open \", name);\n  //caml_failwith(\"file not found: \"+name)\n  current_libs.push({});\n  return current_libs.length;\n}\n\n//Provides: caml_dynlink_close_lib\n//Requires: current_libs\nfunction caml_dynlink_close_lib (idx) {\n  current_libs[idx]=null;\n  return 0;\n}\n\n//Provides: caml_dynlink_lookup_symbol\n//Requires: current_libs\n//Requires: caml_jsstring_of_string\nfunction caml_dynlink_lookup_symbol (idx, fun_name) {\n  var name = caml_jsstring_of_string(fun_name);\n  globalThis.console.log(\"Dynlink: look for symbol \", name);\n  if(current_libs[idx] && current_libs[idx][name])\n    return current_libs[idx][name];\n  return 0;\n}\n\n//Provides: caml_dynlink_add_primitive\n//Requires: caml_global_data\nfunction caml_dynlink_add_primitive (dll_addr) {\n  return caml_global_data.prim_count++;\n}\n\n//Provides: caml_dynlink_get_current_libs\n//Requires: current_libs\nfunction caml_dynlink_get_current_libs () {\n  var len = current_libs.length;\n  var a = new Array(len);\n  for(var i=0; i < len; i++)\n    a[i]=i;\n  return a;\n}\n\n//Provides: caml_register_code_fragment\nfunction caml_register_code_fragment(code, codesize, digest){\n  return 0\n}\n\n//Provides: caml_add_debug_info\nfunction caml_add_debug_info(code, size, events){\n  return 0\n}\n\n//Provides: caml_remove_debug_info\nfunction caml_remove_debug_info(code){\n  return 0\n}\n"
let fail = Js_of_ocaml_compiler.Builtins.register ~name:"fail.js" ~content:"// Js_of_ocaml runtime support\n// http://www.ocsigen.org/js_of_ocaml/\n//\n// This program is free software; you can redistribute it and/or modify\n// it under the terms of the GNU Lesser General Public License as published by\n// the Free Software Foundation, with linking exception;\n// either version 2.1 of the License, or (at your option) any later version.\n//\n// This program is distributed in the hope that it will be useful,\n// but WITHOUT ANY WARRANTY; without even the implied warranty of\n// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n// GNU Lesser General Public License for more details.\n//\n// You should have received a copy of the GNU Lesser General Public License\n// along with this program; if not, write to the Free Software\n// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.\n\n//Raise exception\n\n//Provides: caml_raise_constant (const)\nfunction caml_raise_constant (tag) { throw tag; }\n\n//Provides: caml_return_exn_constant (const)\nfunction caml_return_exn_constant (tag) { return tag; }\n\n//Provides: caml_raise_with_arg (const, const)\nfunction caml_raise_with_arg (tag, arg) { throw [0, tag, arg]; }\n\n//Provides: caml_raise_with_args (const, const)\nfunction caml_raise_with_args (tag, args) { throw [0, tag].concat(args); }\n\n//Provides: caml_raise_with_string (const, const)\n//Requires: caml_raise_with_arg, caml_string_of_jsbytes\nfunction caml_raise_with_string (tag, msg) {\n  caml_raise_with_arg (tag, caml_string_of_jsbytes(msg));\n}\n\n//Provides: caml_failwith (const)\n//Requires: caml_raise_with_string, caml_global_data, caml_string_of_jsbytes\nfunction caml_failwith (msg) {\n  if(!caml_global_data.Failure)\n    caml_global_data.Failure=[248,caml_string_of_jsbytes(\"Failure\"),-3];\n  caml_raise_with_string(caml_global_data.Failure, msg);\n}\n\n\n//Provides: caml_invalid_argument (const)\n//Requires: caml_raise_with_string, caml_global_data\nfunction caml_invalid_argument (msg) {\n  caml_raise_with_string(caml_global_data.Invalid_argument, msg);\n}\n\n//Provides: caml_raise_end_of_file\n//Requires: caml_raise_constant, caml_global_data\nfunction caml_raise_end_of_file () {\n  caml_raise_constant(caml_global_data.End_of_file);\n}\n\n//Provides: caml_raise_zero_divide\n//Requires: caml_raise_constant, caml_global_data\nfunction caml_raise_zero_divide () {\n  caml_raise_constant(caml_global_data.Division_by_zero);\n}\n\n//Provides: caml_raise_not_found\n//Requires: caml_raise_constant, caml_global_data\nfunction caml_raise_not_found () {\n  caml_raise_constant(caml_global_data.Not_found); }\n\n\n//Provides: caml_array_bound_error\n//Requires: caml_invalid_argument\nfunction caml_array_bound_error () {\n  caml_invalid_argument(\"index out of bounds\");\n}\n"
let format = Js_of_ocaml_compiler.Builtins.register ~name:"format.js" ~content:"// Js_of_ocaml runtime support\n// http://www.ocsigen.org/js_of_ocaml/\n//\n// This program is free software; you can redistribute it and/or modify\n// it under the terms of the GNU Lesser General Public License as published by\n// the Free Software Foundation, with linking exception;\n// either version 2.1 of the License, or (at your option) any later version.\n//\n// This program is distributed in the hope that it will be useful,\n// but WITHOUT ANY WARRANTY; without even the implied warranty of\n// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n// GNU Lesser General Public License for more details.\n//\n// You should have received a copy of the GNU Lesser General Public License\n// along with this program; if not, write to the Free Software\n// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.\n\n///////////// Format\n\n//Provides: caml_parse_format\n//Requires: caml_jsbytes_of_string, caml_invalid_argument\nfunction caml_parse_format (fmt) {\n  fmt = caml_jsbytes_of_string(fmt);\n  var len = fmt.length;\n  if (len > 31) caml_invalid_argument(\"format_int: format too long\");\n  var f =\n      { justify:'+', signstyle:'-', filler:' ', alternate:false,\n        base:0, signedconv:false, width:0, uppercase:false,\n        sign:1, prec:-1, conv:'f' };\n  for (var i = 0; i < len; i++) {\n    var c = fmt.charAt(i);\n    switch (c) {\n    case '-':\n      f.justify = '-'; break;\n    case '+': case ' ':\n      f.signstyle = c; break;\n    case '0':\n      f.filler = '0'; break;\n    case '#':\n      f.alternate = true; break;\n    case '1': case '2': case '3': case '4': case '5':\n    case '6': case '7': case '8': case '9':\n      f.width = 0;\n      while (c=fmt.charCodeAt(i) - 48, c >= 0 && c <= 9) {\n        f.width = f.width * 10 + c; i++\n      }\n      i--;\n      break;\n    case '.':\n      f.prec = 0;\n      i++;\n      while (c=fmt.charCodeAt(i) - 48, c >= 0 && c <= 9) {\n        f.prec = f.prec * 10 + c; i++\n      }\n      i--;\n    case 'd': case 'i':\n      f.signedconv = true; /* fallthrough */\n    case 'u':\n      f.base = 10; break;\n    case 'x':\n      f.base = 16; break;\n    case 'X':\n      f.base = 16; f.uppercase = true; break;\n    case 'o':\n      f.base = 8; break;\n    case 'e': case 'f': case 'g':\n      f.signedconv = true; f.conv = c; break;\n    case 'E': case 'F': case 'G':\n      f.signedconv = true; f.uppercase = true;\n      f.conv = c.toLowerCase (); break;\n    }\n  }\n  return f;\n}\n\n//Provides: caml_finish_formatting\n//Requires: caml_string_of_jsbytes\nfunction caml_finish_formatting(f, rawbuffer) {\n  if (f.uppercase) rawbuffer = rawbuffer.toUpperCase();\n  var len = rawbuffer.length;\n  /* Adjust len to reflect additional chars (sign, etc) */\n  if (f.signedconv && (f.sign < 0 || f.signstyle != '-')) len++;\n  if (f.alternate) {\n    if (f.base == 8) len += 1;\n    if (f.base == 16) len += 2;\n  }\n  /* Do the formatting */\n  var buffer = \"\";\n  if (f.justify == '+' && f.filler == ' ')\n    for (var i = len; i < f.width; i++) buffer += ' ';\n  if (f.signedconv) {\n    if (f.sign < 0) buffer += '-';\n    else if (f.signstyle != '-') buffer += f.signstyle;\n  }\n  if (f.alternate && f.base == 8) buffer += '0';\n  if (f.alternate && f.base == 16) buffer += \"0x\";\n  if (f.justify == '+' && f.filler == '0')\n    for (var i = len; i < f.width; i++) buffer += '0';\n  buffer += rawbuffer;\n  if (f.justify == '-')\n    for (var i = len; i < f.width; i++) buffer += ' ';\n  return caml_string_of_jsbytes(buffer);\n}\n"
let fs = Js_of_ocaml_compiler.Builtins.register ~name:"fs.js" ~content:"// Js_of_ocaml runtime support\n// http://www.ocsigen.org/js_of_ocaml/\n// Copyright (C) 2014 J\195\169r\195\180me Vouillon, Hugo Heuzard\n// Laboratoire PPS - CNRS Universit\195\169 Paris Diderot\n//\n// This program is free software; you can redistribute it and/or modify\n// it under the terms of the GNU Lesser General Public License as published by\n// the Free Software Foundation, with linking exception;\n// either version 2.1 of the License, or (at your option) any later version.\n//\n// This program is distributed in the hope that it will be useful,\n// but WITHOUT ANY WARRANTY; without even the implied warranty of\n// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n// GNU Lesser General Public License for more details.\n//\n// You should have received a copy of the GNU Lesser General Public License\n// along with this program; if not, write to the Free Software\n// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.\n\n///////////// Dummy filesystem\n\n//Provides: caml_trailing_slash\nfunction caml_trailing_slash(name){\n  return (name.slice(-1) !== \"/\") ? (name + \"/\") : name;\n}\n\n//Provides: caml_current_dir\n//Requires: caml_trailing_slash, fs_node_supported\nif(fs_node_supported () && globalThis.process && globalThis.process.cwd)\n  var caml_current_dir = globalThis.process.cwd().replace(/\\\\/g,'/');\nelse\n  var caml_current_dir =  \"/static\";\ncaml_current_dir = caml_trailing_slash(caml_current_dir);\n\n//Provides: caml_get_root\n//Requires: path_is_absolute\nfunction caml_get_root(path){\n  var x = path_is_absolute(path);\n  if (!x) return;\n  return x[0] + \"/\"}\n\n//Provides: caml_root\n//Requires: caml_get_root, caml_current_dir, caml_failwith\nvar caml_root = caml_get_root(caml_current_dir) || caml_failwith(\"unable to compute caml_root\");\n\n\n//Provides: MlFile\nfunction MlFile(){  }\n\n//Provides: path_is_absolute\n//Requires: fs_node_supported\nfunction make_path_is_absolute() {\n  function posix(path) {\n    if (path.charAt(0) === '/') return [\"\", path.substring(1)];\n    return;\n  }\n\n  function win32(path) {\n    // https://github.com/nodejs/node/blob/b3fcc245fb25539909ef1d5eaa01dbf92e168633/lib/path.js#L56\n    var splitDeviceRe = /^([a-zA-Z]:|[\\\\/]{2}[^\\\\/]+[\\\\/]+[^\\\\/]+)?([\\\\/])?([\\s\\S]*?)$/;\n    var result = splitDeviceRe.exec(path);\n    var device = result[1] || '';\n    var isUnc = Boolean(device && device.charAt(1) !== ':');\n\n    // UNC paths are always absolute\n    if (Boolean(result[2] || isUnc)) {\n      var root = (result[1] || '');\n      var sep = (result[2] || '');\n      return [root, path.substring(root.length + sep.length)]\n    }\n    return;\n  }\n  if(fs_node_supported () && globalThis.process && globalThis.process.platform) {\n    return globalThis.process.platform === 'win32' ? win32 : posix;\n  }\n  else return posix\n}\nvar path_is_absolute = make_path_is_absolute();\n\n//Provides: caml_make_path\n//Requires: caml_current_dir\n//Requires: caml_jsstring_of_string, path_is_absolute\nfunction caml_make_path (name) {\n  name=caml_jsstring_of_string(name);\n  if( !path_is_absolute(name) )\n    name = caml_current_dir + name;\n  var comp0 = path_is_absolute(name);\n  var comp = comp0[1].split(\"/\");\n  var ncomp = []\n  for(var i = 0; i<comp.length; i++){\n    switch(comp[i]){\n    case \"..\": if(ncomp.length>1) ncomp.pop(); break;\n    case \".\": break;\n    default: ncomp.push(comp[i]);break\n    }\n  }\n  ncomp.unshift(comp0[0]);\n  ncomp.orig = name;\n  return ncomp;\n}\n\n//Provides:jsoo_mount_point\n//Requires: MlFakeDevice, MlNodeDevice, caml_root, fs_node_supported\nvar jsoo_mount_point = []\nif (fs_node_supported()) {\n  jsoo_mount_point.push({path:caml_root,device:new MlNodeDevice(caml_root)});\n} else {\n  jsoo_mount_point.push({path:caml_root,device:new MlFakeDevice(caml_root)});\n}\njsoo_mount_point.push({path:\"/static/\", device:new MlFakeDevice(\"/static/\")});\n\n//Provides:caml_list_mount_point\n//Requires: jsoo_mount_point, caml_string_of_jsbytes\nfunction caml_list_mount_point(){\n  var prev = 0\n  for(var i = 0; i < jsoo_mount_point.length; i++){\n    var old = prev;\n    prev = [0, caml_string_of_jsbytes(jsoo_mount_point[i].path), old]\n  }\n  return prev;\n}\n\n//Provides: resolve_fs_device\n//Requires: caml_make_path, jsoo_mount_point, caml_raise_sys_error, caml_get_root, MlNodeDevice, caml_trailing_slash, fs_node_supported\nfunction resolve_fs_device(name){\n  var path = caml_make_path(name);\n  var name = path.join(\"/\");\n  var name_slash = caml_trailing_slash(name);\n  var res;\n  for(var i = 0; i < jsoo_mount_point.length; i++) {\n    var m = jsoo_mount_point[i];\n    if(name_slash.search(m.path) == 0\n       && (!res || res.path.length < m.path.length))\n      res = {path:m.path,device:m.device,rest:name.substring(m.path.length,name.length)};\n  }\n  if( !res && fs_node_supported()) {\n    var root = caml_get_root(name);\n    if (root && root.match(/^[a-zA-Z]:\\/$/)){\n      var m = {path:root,device:new MlNodeDevice(root)};\n      jsoo_mount_point.push(m);\n      res = {path:m.path,device:m.device,rest:name.substring(m.path.length,name.length)};\n    }\n  }\n  if( res ) return res;\n  caml_raise_sys_error(\"no device found for \" + name_slash);\n}\n\n//Provides: caml_mount_autoload\n//Requires: MlFakeDevice, caml_make_path, jsoo_mount_point, caml_trailing_slash\nfunction caml_mount_autoload(name,f){\n  var path = caml_make_path(name);\n  var name = caml_trailing_slash(path.join(\"/\"));\n  jsoo_mount_point.push({path:name,device:new MlFakeDevice(name,f)})\n  return 0;\n}\n\n//Provides: caml_unmount\n//Requires: jsoo_mount_point, caml_make_path, caml_trailing_slash\nfunction caml_unmount(name){\n  var path = caml_make_path(name);\n  var name = caml_trailing_slash(path.join(\"/\"));\n  var idx = -1;\n  for(var i = 0; i < jsoo_mount_point.length; i++)\n    if(jsoo_mount_point[i].path == name) idx = i;\n  if(idx > -1) jsoo_mount_point.splice(idx,1);\n  return 0\n}\n\n//Provides: caml_sys_getcwd\n//Requires: caml_current_dir, caml_string_of_jsbytes\nfunction caml_sys_getcwd() {\n  return caml_string_of_jsbytes(caml_current_dir);\n}\n\n//Provides: caml_sys_chdir\n//Requires: caml_current_dir, caml_raise_no_such_file, resolve_fs_device, caml_trailing_slash, caml_jsbytes_of_string\nfunction caml_sys_chdir(dir) {\n  var root = resolve_fs_device(dir);\n  if(root.device.exists(root.rest)) {\n    if(root.rest) caml_current_dir = caml_trailing_slash(root.path + root.rest);\n    else caml_current_dir = root.path;\n    return 0;\n  }\n  else {\n    caml_raise_no_such_file(caml_jsbytes_of_string(dir));\n  }\n}\n\n//Provides: caml_raise_no_such_file\n//Requires: caml_raise_sys_error\nfunction caml_raise_no_such_file(name){\n  caml_raise_sys_error (name + \": No such file or directory\");\n}\n\n//Provides: caml_raise_not_a_dir\n//Requires: caml_raise_sys_error\nfunction caml_raise_not_a_dir(name){\n  caml_raise_sys_error (name + \": Not a directory\");\n}\n\n//Provides: caml_sys_file_exists\n//Requires: resolve_fs_device\nfunction caml_sys_file_exists (name) {\n  var root = resolve_fs_device(name);\n  return root.device.exists(root.rest);\n}\n\n//Provides: caml_sys_read_directory\n//Requires: caml_string_of_jsbytes\n//Requires: caml_raise_not_a_dir, resolve_fs_device\nfunction caml_sys_read_directory(name){\n  var root = resolve_fs_device(name);\n  var a = root.device.readdir(root.rest);\n  var l = new Array(a.length + 1);\n  l[0] = 0;\n  for(var i=0;i<a.length;i++)\n    l[i+1] = caml_string_of_jsbytes(a[i]);\n  return l;\n}\n\n//Provides: caml_sys_remove\n//Requires: caml_raise_no_such_file, resolve_fs_device, caml_jsbytes_of_string\nfunction caml_sys_remove(name){\n  var root = resolve_fs_device(name);\n  var ok = root.device.unlink(root.rest);\n  if(ok == 0) caml_raise_no_such_file(caml_jsbytes_of_string(name));\n  return 0;\n}\n\n//Provides: caml_sys_is_directory\n//Requires: resolve_fs_device\nfunction caml_sys_is_directory(name){\n  var root = resolve_fs_device(name);\n  var a = root.device.is_dir(root.rest);\n  return a?1:0;\n}\n\n//Provides: caml_sys_rename\n//Requires: caml_failwith, resolve_fs_device\nfunction caml_sys_rename(o,n){\n  var o_root = resolve_fs_device(o);\n  var n_root = resolve_fs_device(n);\n  if(o_root.device != n_root.device)\n    caml_failwith(\"caml_sys_rename: cannot move file between two filesystem\");\n  if(!o_root.device.rename)\n    caml_failwith(\"caml_sys_rename: no implemented\");\n  o_root.device.rename(o_root.rest, n_root.rest);\n}\n\n//Provides: caml_sys_mkdir\n//Requires: resolve_fs_device, caml_raise_sys_error\nfunction caml_sys_mkdir(name, perm){\n  var root = resolve_fs_device(name);\n  root.device.mkdir(root.rest,perm);\n  return 0;\n}\n\n//Provides: caml_sys_rmdir\n//Requires: resolve_fs_device, caml_raise_sys_error, caml_raise_not_a_dir\nfunction caml_sys_rmdir(name){\n  var root = resolve_fs_device(name);\n  root.device.rmdir(root.rest);\n  return 0;\n}\n\n//Provides: caml_ba_map_file\n//Requires: caml_failwith\nfunction caml_ba_map_file(vfd, kind, layout, shared, dims, pos) {\n  // var data = caml_global_data.fds[vfd];\n  caml_failwith(\"caml_ba_map_file not implemented\");\n}\n\n//Provides: caml_ba_map_file_bytecode\n//Requires: caml_ba_map_file\nfunction caml_ba_map_file_bytecode(argv,argn){\n  return caml_ba_map_file(argv[0],argv[1],argv[2],argv[3],argv[4],argv[5]);\n}\n\n//Provides: jsoo_create_file_extern\nfunction jsoo_create_file_extern(name,content){\n  if(globalThis.jsoo_create_file)\n    globalThis.jsoo_create_file(name,content);\n  else {\n    if(!globalThis.caml_fs_tmp) globalThis.caml_fs_tmp = [];\n    globalThis.caml_fs_tmp.push({name:name,content:content});\n  }\n  return 0;\n}\n\n//Provides: caml_fs_init\n//Requires: jsoo_create_file\nfunction caml_fs_init (){\n  var tmp=globalThis.caml_fs_tmp\n  if(tmp){\n    for(var i = 0; i < tmp.length; i++){\n      jsoo_create_file(tmp[i].name,tmp[i].content);\n    }\n  }\n  globalThis.jsoo_create_file = jsoo_create_file;\n  globalThis.caml_fs_tmp = [];\n  return 0;\n}\n\n//Provides: caml_create_file\n//Requires: caml_failwith, resolve_fs_device\nfunction caml_create_file(name,content) {\n  var root = resolve_fs_device(name);\n  if(! root.device.register) caml_failwith(\"cannot register file\");\n  root.device.register(root.rest,content);\n  return 0;\n}\n\n\n//Provides: jsoo_create_file\n//Requires: caml_create_file, caml_string_of_jsbytes\nfunction jsoo_create_file(name,content) {\n  var name = caml_string_of_jsbytes(name);\n  var content = caml_string_of_jsbytes(content);\n  return caml_create_file(name, content);\n}\n\n\n//Provides: caml_read_file_content\n//Requires: resolve_fs_device, caml_raise_no_such_file, caml_create_bytes, caml_string_of_bytes\n//Requires: caml_string_of_jsbytes, caml_jsbytes_of_string\nfunction caml_read_file_content (name) {\n  var name = (typeof name == \"string\")?caml_string_of_jsbytes(name):name;\n  var root = resolve_fs_device(name);\n  if(root.device.exists(root.rest)) {\n    var file = root.device.open(root.rest,{rdonly:1});\n    var len  = file.length();\n    var buf  = caml_create_bytes(len);\n    file.read(0,buf,0,len);\n    return caml_string_of_bytes(buf)\n  }\n  caml_raise_no_such_file(caml_jsbytes_of_string(name));\n}\n"
let fs_fake = Js_of_ocaml_compiler.Builtins.register ~name:"fs_fake.js" ~content:"// Js_of_ocaml runtime support\n// http://www.ocsigen.org/js_of_ocaml/\n// Copyright (C) 2014 J\195\169r\195\180me Vouillon, Hugo Heuzard\n// Laboratoire PPS - CNRS Universit\195\169 Paris Diderot\n//\n// This program is free software; you can redistribute it and/or modify\n// it under the terms of the GNU Lesser General Public License as published by\n// the Free Software Foundation, with linking exception;\n// either version 2.1 of the License, or (at your option) any later version.\n//\n// This program is distributed in the hope that it will be useful,\n// but WITHOUT ANY WARRANTY; without even the implied warranty of\n// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n// GNU Lesser General Public License for more details.\n//\n// You should have received a copy of the GNU Lesser General Public License\n// along with this program; if not, write to the Free Software\n// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.\n\n//Provides: MlFakeDevice\n//Requires: MlFakeFile, caml_create_bytes\n//Requires: caml_raise_sys_error, caml_raise_no_such_file\n//Requires: caml_string_of_jsbytes, caml_string_of_jsstring\n//Requires: caml_bytes_of_array, caml_bytes_of_string, caml_bytes_of_jsbytes\n//Requires: caml_is_ml_bytes, caml_is_ml_string\n//Requires: caml_named_value, caml_raise_with_args, caml_named_values\n//Requires: make_unix_err_args\nfunction MlFakeDevice (root, f) {\n  this.content={};\n  this.root = root;\n  this.lookupFun = f;\n}\nMlFakeDevice.prototype.nm = function(name) {\n  return (this.root + name);\n}\nMlFakeDevice.prototype.create_dir_if_needed = function(name) {\n  var comp = name.split(\"/\");\n  var res = \"\";\n  for(var i = 0; i < comp.length - 1; i++){\n    res += comp[i] + \"/\";\n    if(this.content[res]) continue;\n    this.content[res] = Symbol(\"directory\");\n  }\n}\nMlFakeDevice.prototype.slash = function(name){\n  return /\\/$/.test(name)?name:(name + \"/\");\n}\nMlFakeDevice.prototype.lookup = function(name) {\n  if(!this.content[name] && this.lookupFun) {\n    var res = this.lookupFun(caml_string_of_jsbytes(this.root), caml_string_of_jsbytes(name));\n    if(res !== 0) {\n      this.create_dir_if_needed(name);\n      this.content[name]=new MlFakeFile(caml_bytes_of_string(res[1]));\n    }\n  }\n}\nMlFakeDevice.prototype.exists = function(name) {\n  // The root of the device exists\n  if(name == \"\") return 1;\n  // Check if a directory exists\n  var name_slash = this.slash(name);\n  if(this.content[name_slash]) return 1;\n  // Check if a file exists\n  this.lookup(name);\n  return this.content[name]?1:0;\n}\nMlFakeDevice.prototype.mkdir = function(name,mode, raise_unix) {\n  var unix_error = raise_unix && caml_named_value('Unix.Unix_error');\n  if(this.exists(name)) {\n    if (unix_error) {\n      caml_raise_with_args(unix_error, make_unix_err_args(\"EEXIST\", \"mkdir\", this.nm(name)));\n    }\n    else {\n      caml_raise_sys_error(name + \": File exists\");\n    }\n  }\n  var parent = /^(.*)\\/[^/]+/.exec(name);\n  parent = (parent && parent[1]) || '';\n  if(!this.exists(parent)){\n    if (unix_error) {\n      caml_raise_with_args(unix_error, make_unix_err_args(\"ENOENT\", \"mkdir\", this.nm(parent)));\n    }\n    else {\n      caml_raise_sys_error(parent + \": No such file or directory\");\n    }\n  }\n  if(!this.is_dir(parent)){\n    if (unix_error) {\n      caml_raise_with_args(unix_error, make_unix_err_args(\"ENOTDIR\", \"mkdir\", this.nm(parent)));\n    }\n    else {\n      caml_raise_sys_error(parent + \": Not a directory\");\n    }\n  }\n  this.create_dir_if_needed(this.slash(name));\n}\nMlFakeDevice.prototype.rmdir = function(name, raise_unix) {\n  var unix_error = raise_unix && caml_named_value('Unix.Unix_error');\n  var name_slash = (name == \"\")?\"\":(this.slash(name));\n  var r = new RegExp(\"^\" + name_slash + \"([^/]+)\");\n  if(!this.exists(name)) {\n    if (unix_error) {\n      caml_raise_with_args(unix_error, make_unix_err_args(\"ENOENT\", \"rmdir\", this.nm(name)));\n    }\n    else {\n      caml_raise_sys_error(name + \": No such file or directory\");\n    }\n  }\n  if(!this.is_dir(name)) {\n    if (unix_error) {\n      caml_raise_with_args(unix_error, make_unix_err_args(\"ENOTDIR\", \"rmdir\", this.nm(name)));\n    }\n    else {\n      caml_raise_sys_error(name + \": Not a directory\");\n    }\n  }\n  for(var n in this.content) {\n    if(n.match(r)) {\n      if (unix_error) {\n        caml_raise_with_args(unix_error, make_unix_err_args(\"ENOTEMPTY\", \"rmdir\", this.nm(name)));\n      } else {\n        caml_raise_sys_error(this.nm(name) + \": Directory not empty\");\n      }\n    }\n  }\n  delete this.content[name_slash];\n}\nMlFakeDevice.prototype.readdir = function(name) {\n  var name_slash = (name == \"\")?\"\":(this.slash(name));\n  if(!this.exists(name)) {\n    caml_raise_sys_error(name + \": No such file or directory\");\n  }\n  if(!this.is_dir(name)) {\n    caml_raise_sys_error(name + \": Not a directory\");\n  }\n  var r = new RegExp(\"^\" + name_slash + \"([^/]+)\");\n  var seen = {}\n  var a = [];\n  for(var n in this.content) {\n    var m = n.match(r);\n    if(m && !seen[m[1]]) {seen[m[1]] = true; a.push(m[1])}\n  }\n  return a;\n}\nMlFakeDevice.prototype.is_dir = function(name) {\n  if(name == \"\")  return true;\n  var name_slash = this.slash(name);\n  return this.content[name_slash]?1:0;\n}\nMlFakeDevice.prototype.unlink = function(name) {\n  var ok = this.content[name]?true:false;\n  delete this.content[name];\n  return ok;\n}\nMlFakeDevice.prototype.open = function(name, f) {\n  if(f.rdonly && f.wronly)\n    caml_raise_sys_error(this.nm(name) + \" : flags Open_rdonly and Open_wronly are not compatible\");\n  if(f.text && f.binary)\n    caml_raise_sys_error(this.nm(name) + \" : flags Open_text and Open_binary are not compatible\");\n  this.lookup(name);\n  if (this.content[name]) {\n    if (this.is_dir(name)) caml_raise_sys_error(this.nm(name) + \" : is a directory\");\n    if (f.create && f.excl) caml_raise_sys_error(this.nm(name) + \" : file already exists\");\n    var file = this.content[name];\n    if(f.truncate) file.truncate();\n    return file;\n  } else if (f.create) {\n    this.create_dir_if_needed(name);\n    this.content[name] = new MlFakeFile(caml_create_bytes(0));\n    return this.content[name];\n  } else {\n    caml_raise_no_such_file (this.nm(name));\n  }\n}\n\nMlFakeDevice.prototype.register= function (name,content){\n  var file;\n  if(this.content[name]) caml_raise_sys_error(this.nm(name) + \" : file already exists\");\n  if(caml_is_ml_bytes(content))\n    file = new MlFakeFile(content);\n  if(caml_is_ml_string(content))\n    file = new MlFakeFile(caml_bytes_of_string(content));\n  else if(content instanceof Array)\n    file = new MlFakeFile(caml_bytes_of_array(content));\n  else if(typeof content === \"string\")\n    file = new MlFakeFile(caml_bytes_of_jsbytes(content));\n  else if(content.toString) {\n    var bytes = caml_bytes_of_string(caml_string_of_jsstring(content.toString()));\n    file = new MlFakeFile(bytes);\n  }\n  if(file){\n    this.create_dir_if_needed(name);\n    this.content[name] = file;\n  }\n  else caml_raise_sys_error(this.nm(name) + \" : registering file with invalid content type\");\n}\n\nMlFakeDevice.prototype.constructor = MlFakeDevice\n\n//Provides: MlFakeFile\n//Requires: MlFile\n//Requires: caml_create_bytes, caml_ml_bytes_length, caml_blit_bytes, caml_blit_string\n//Requires: caml_bytes_get\nfunction MlFakeFile(content){\n  this.data = content;\n}\nMlFakeFile.prototype = new MlFile ();\nMlFakeFile.prototype.truncate = function(len){\n  var old = this.data;\n  this.data = caml_create_bytes(len|0);\n  caml_blit_bytes(old, 0, this.data, 0, len);\n}\nMlFakeFile.prototype.length = function () {\n  return caml_ml_bytes_length(this.data);\n}\nMlFakeFile.prototype.write = function(offset,buf,pos,len){\n  var clen = this.length();\n  if(offset + len >= clen) {\n    var new_str = caml_create_bytes(offset + len);\n    var old_data = this.data;\n    this.data = new_str;\n    caml_blit_bytes(old_data, 0, this.data, 0, clen);\n  }\n  caml_blit_string(buf, pos, this.data, offset, len);\n  return 0\n}\nMlFakeFile.prototype.read = function(offset,buf,pos,len){\n  var clen = this.length();\n  caml_blit_bytes(this.data, offset, buf, pos, len);\n  return 0\n}\nMlFakeFile.prototype.read_one = function(offset){\n  return caml_bytes_get(this.data, offset);\n}\nMlFakeFile.prototype.close = function(){\n\n}\nMlFakeFile.prototype.constructor = MlFakeFile\n"
let fs_node = Js_of_ocaml_compiler.Builtins.register ~name:"fs_node.js" ~content:"// Js_of_ocaml runtime support\n// http://www.ocsigen.org/js_of_ocaml/\n// Copyright (C) 2014 J\195\169r\195\180me Vouillon, Hugo Heuzard\n// Laboratoire PPS - CNRS Universit\195\169 Paris Diderot\n//\n// This program is free software; you can redistribute it and/or modify\n// it under the terms of the GNU Lesser General Public License as published by\n// the Free Software Foundation, with linking exception;\n// either version 2.1 of the License, or (at your option) any later version.\n//\n// This program is distributed in the hope that it will be useful,\n// but WITHOUT ANY WARRANTY; without even the implied warranty of\n// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n// GNU Lesser General Public License for more details.\n//\n// You should have received a copy of the GNU Lesser General Public License\n// along with this program; if not, write to the Free Software\n// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.\n\n//Provides: fs_node_supported\nfunction fs_node_supported () {\n  return (\n    typeof globalThis.process !== 'undefined'\n      && typeof globalThis.process.versions !== 'undefined'\n      && typeof globalThis.process.versions.node !== 'undefined')\n}\n//Provides: fs_node_supported\n//If: browser\nfunction fs_node_supported () {\n  return false\n}\n\n\n//Provides: MlNodeDevice\n//Requires: MlNodeFile, caml_raise_sys_error, caml_raise_with_args\n//Requires: make_unix_err_args, caml_named_value, caml_string_of_jsstring\nfunction MlNodeDevice(root) {\n  this.fs = require('fs');\n  this.root = root;\n}\nMlNodeDevice.prototype.nm = function(name) {\n  return (this.root + name);\n}\nMlNodeDevice.prototype.exists = function(name) {\n  try {\n    return this.fs.existsSync(this.nm(name))?1:0;\n  } catch (err) {\n    return 0;\n  }\n}\nMlNodeDevice.prototype.mkdir = function(name, mode, raise_unix) {\n  try {\n    this.fs.mkdirSync(this.nm(name),{mode:mode});\n    return 0\n  } catch (err) {\n    this.raise_nodejs_error(err, raise_unix);\n  }\n}\nMlNodeDevice.prototype.rmdir = function(name, raise_unix) {\n  try {\n    this.fs.rmdirSync(this.nm(name));\n    return 0\n  } catch (err) {\n    this.raise_nodejs_error(err, raise_unix);\n  }\n}\nMlNodeDevice.prototype.readdir = function(name, raise_unix) {\n  try {\n    return this.fs.readdirSync(this.nm(name));\n  } catch (err) {\n    this.raise_nodejs_error(err, raise_unix);\n  }\n}\nMlNodeDevice.prototype.is_dir = function(name) {\n  try {\n    return this.fs.statSync(this.nm(name)).isDirectory()?1:0;\n  } catch (err) {\n    caml_raise_sys_error(err.toString());\n  }\n}\nMlNodeDevice.prototype.unlink = function(name, raise_unix) {\n  try {\n    var b = this.fs.existsSync(this.nm(name))?1:0;\n    this.fs.unlinkSync(this.nm(name));\n    return b;\n  } catch (err) {\n    this.raise_nodejs_error(err, raise_unix);\n  }\n}\nMlNodeDevice.prototype.open = function(name, f, raise_unix) {\n  var consts = require('constants');\n  var res = 0;\n  for(var key in f){\n    switch(key){\n    case \"rdonly\"  : res |= consts.O_RDONLY; break;\n    case \"wronly\"  : res |= consts.O_WRONLY; break;\n    case \"append\"  :\n      res |= consts.O_WRONLY | consts.O_APPEND;\n      break;\n    case \"create\"   : res |= consts.O_CREAT;    break;\n    case \"truncate\" : res |= consts.O_TRUNC;    break;\n    case \"excl\"     : res |= consts.O_EXCL;     break;\n    case \"binary\"   : res |= consts.O_BINARY;   break;\n    case \"text\"     : res |= consts.O_TEXT;     break;\n    case \"nonblock\" : res |= consts.O_NONBLOCK; break;\n    }\n  }\n  try {\n    var fd = this.fs.openSync(this.nm(name), res);\n    return new MlNodeFile(fd);\n  } catch (err) {\n    this.raise_nodejs_error(err, raise_unix);\n  }\n}\n\nMlNodeDevice.prototype.rename = function(o, n, raise_unix) {\n  try {\n    this.fs.renameSync(this.nm(o), this.nm(n));\n  } catch (err) {\n    this.raise_nodejs_error(err, raise_unix);\n  }\n}\nMlNodeDevice.prototype.stat = function(name, raise_unix) {\n  try {\n    var js_stats = this.fs.statSync(this.nm(name));\n    return this.stats_from_js(js_stats);\n  } catch (err) {\n    this.raise_nodejs_error(err, raise_unix);\n  }\n}\nMlNodeDevice.prototype.lstat = function(name, raise_unix) {\n  try {\n    var js_stats = this.fs.lstatSync(this.nm(name));\n    return this.stats_from_js(js_stats);\n  } catch (err) {\n    this.raise_nodejs_error(err, raise_unix);\n  }\n}\nMlNodeDevice.prototype.symlink = function(to_dir, target, path, raise_unix) {\n  try {\n    this.fs.symlinkSync(this.nm(target), this.nm(path), to_dir ? 'dir' : 'file');\n    return 0;\n  } catch (err) {\n    this.raise_nodejs_error(err, raise_unix);\n  }\n}\nMlNodeDevice.prototype.readlink = function(name, raise_unix) {\n  try {\n    var link = this.fs.readlinkSync(this.nm(name), 'utf8');\n    return caml_string_of_jsstring(link);\n  } catch (err) {\n    this.raise_nodejs_error(err, raise_unix);\n  }\n}\nMlNodeDevice.prototype.raise_nodejs_error = function(err, raise_unix) {\n  var unix_error = caml_named_value(\"Unix.Unix_error\");\n  if (raise_unix && unix_error) {\n    var args = make_unix_err_args(err.code, err.syscall, err.path, err.errno);\n    caml_raise_with_args(unix_error, args);\n  } else {\n    caml_raise_sys_error(err.toString());\n  }\n}\nMlNodeDevice.prototype.stats_from_js = function(js_stats) {\n  /* ===Unix.file_kind===\n   * type file_kind =\n   *     S_REG                       (** Regular file *)\n   *   | S_DIR                       (** Directory *)\n   *   | S_CHR                       (** Character device *)\n   *   | S_BLK                       (** Block device *)\n   *   | S_LNK                       (** Symbolic link *)\n   *   | S_FIFO                      (** Named pipe *)\n   *   | S_SOCK                      (** Socket *)\n   */\n  var file_kind;\n  if (js_stats.isFile()) {\n    file_kind = 0;\n  } else if (js_stats.isDirectory()) {\n    file_kind = 1;\n  } else if (js_stats.isCharacterDevice()) {\n    file_kind = 2;\n  } else if (js_stats.isBlockDevice()) {\n    file_kind = 3;\n  } else if (js_stats.isSymbolicLink()) {\n    file_kind = 4;\n  } else if (js_stats.isFIFO()) {\n    file_kind = 5;\n  } else if (js_stats.isSocket()) {\n    file_kind = 6;\n  }\n  /* ===Unix.stats===\n   * type stats =\n   *  { st_dev : int;               (** Device number *)\n   *    st_ino : int;               (** Inode number *)\n   *    st_kind : file_kind;        (** Kind of the file *)\n   *    st_perm : file_perm;        (** Access rights *)\n   *    st_nlink : int;             (** Number of links *)\n   *    st_uid : int;               (** User id of the owner *)\n   *    st_gid : int;               (** Group ID of the file's group *)\n   *    st_rdev : int;              (** Device ID (if special file) *)\n   *    st_size : int;              (** Size in bytes *)\n   *    st_atime : float;           (** Last access time *)\n   *    st_mtime : float;           (** Last modification time *)\n   *    st_ctime : float;           (** Last status change time *)\n   *  }\n   */\n  return BLOCK(\n    0,\n    js_stats.dev,\n    js_stats.ino,\n    file_kind,\n    js_stats.mode,\n    js_stats.nlink,\n    js_stats.uid,\n    js_stats.gid,\n    js_stats.rdev,\n    js_stats.size,\n    js_stats.atimeMs,\n    js_stats.mtimeMs,\n    js_stats.ctimeMs\n  );\n}\n\nMlNodeDevice.prototype.constructor = MlNodeDevice\n\n//Provides: MlNodeDevice\n//If: browser\nfunction MlNodeDevice() {\n}\n\n//Provides: MlNodeFile\n//Requires: MlFile, caml_array_of_string, caml_array_of_bytes, caml_bytes_set, caml_raise_sys_error\nfunction MlNodeFile(fd){\n  this.fs = require('fs');\n  this.fd = fd;\n}\nMlNodeFile.prototype = new MlFile ();\n\nMlNodeFile.prototype.truncate = function(len){\n  try {\n    this.fs.ftruncateSync(this.fd,len|0)\n  } catch (err) {\n    caml_raise_sys_error(err.toString());\n  }\n}\nMlNodeFile.prototype.length = function () {\n  try {\n    return this.fs.fstatSync(this.fd).size;\n  } catch (err) {\n    caml_raise_sys_error(err.toString());\n  }\n}\nMlNodeFile.prototype.write = function(offset,buf,buf_offset,len){\n  var a = caml_array_of_string(buf);\n  if(! (a instanceof globalThis.Uint8Array))\n    a = new globalThis.Uint8Array(a);\n  var buffer = globalThis.Buffer.from(a);\n  try {\n    this.fs.writeSync(this.fd, buffer, buf_offset, len, offset);\n  } catch (err) {\n    caml_raise_sys_error(err.toString());\n  }\n  return 0;\n}\nMlNodeFile.prototype.read = function(offset,buf,buf_offset,len){\n  var a = caml_array_of_bytes(buf);\n  if(! (a instanceof globalThis.Uint8Array))\n    a = new globalThis.Uint8Array(a);\n  var buffer = globalThis.Buffer.from(a);\n  try {\n    this.fs.readSync(this.fd, buffer, buf_offset, len, offset);\n  } catch (err) {\n    caml_raise_sys_error(err.toString());\n  }\n  for(var i = 0; i < len; i++){\n    caml_bytes_set(buf,buf_offset + i,buffer[buf_offset+i]);\n  }\n  return 0\n}\nMlNodeFile.prototype.read_one = function(offset){\n  var a = new globalThis.Uint8Array(1);\n  var buffer = globalThis.Buffer.from(a);\n  try {\n    this.fs.readSync(this.fd, buffer, 0, 1, offset);\n  } catch (err) {\n    caml_raise_sys_error(err.toString());\n  }\n  return buffer[0];\n}\nMlNodeFile.prototype.close = function(){\n  try {\n    this.fs.closeSync(this.fd);\n  } catch (err) {\n    caml_raise_sys_error(err.toString());\n  }\n}\n\nMlNodeFile.prototype.constructor = MlNodeFile;\n\n//Provides: MlNodeFile\n//If: browser\nfunction MlNodeFile(){\n}\n"
let gc = Js_of_ocaml_compiler.Builtins.register ~name:"gc.js" ~content:"\n\n//Provides: caml_gc_minor\nfunction caml_gc_minor(){ return 0}\n//Provides: caml_gc_major\nfunction caml_gc_major(){ return 0}\n//Provides: caml_gc_full_major\nfunction caml_gc_full_major(){ return 0}\n//Provides: caml_gc_compaction\nfunction caml_gc_compaction(){ return 0}\n//Provides: caml_gc_counters\nfunction caml_gc_counters() { return [254,0,0,0] }\n//Provides: caml_gc_quick_stat\nfunction caml_gc_quick_stat(){\n  return [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0]\n}\n//Provides: caml_gc_stat\nfunction caml_gc_stat() {\n  return [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0]\n}\n\n//Provides: caml_gc_set\nfunction caml_gc_set(_control) {\n  return 0;\n}\n\n//Provides: caml_gc_get\nfunction caml_gc_get(){\n  return [0,0,0,0,0,0,0,0,0]\n}\n\n//Provides: caml_memprof_set\nfunction caml_memprof_set(_control) {\n  return 0;\n}\n\n//Provides: caml_final_register const\nfunction caml_final_register () { return 0; }\n//Provides: caml_final_register_called_without_value const\nfunction caml_final_register_called_without_value () { return 0; }\n//Provides: caml_final_release const\nfunction caml_final_release () { return 0; }\n\n//Provides: caml_memprof_start\nfunction caml_memprof_start(rate,stack_size,tracker){\n  return 0;\n}\n\n//Provides: caml_memprof_stop\nfunction caml_memprof_stop(unit) {\n  return 0;\n}\n\n//Provides: caml_eventlog_resume\nfunction caml_eventlog_resume(unit) { return 0; }\n\n//Provides: caml_eventlog_pause\nfunction caml_eventlog_pause(unit) { return 0; }\n\n//Provides: caml_gc_huge_fallback_count\nfunction caml_gc_huge_fallback_count(unit) { return 0; }\n\n//Provides: caml_gc_major_slice\nfunction caml_gc_major_slice(work) { return 0; }\n\n//Provides: caml_gc_minor_words\nfunction caml_gc_minor_words(unit) { return 0; }\n\n//Provides: caml_get_minor_free\nfunction caml_get_minor_free(unit) { return 0; }\n\n//Provides: caml_get_major_bucket\nfunction caml_get_major_bucket(n) { return 0; }\n\n//Provides: caml_get_major_credit\nfunction caml_get_major_credit(n) { return 0; }\n"
let graphics = Js_of_ocaml_compiler.Builtins.register ~name:"graphics.js" ~content:"// Js_of_ocaml runtime support\n// http://www.ocsigen.org/js_of_ocaml/\n// Copyright (C) 2014 Hugo Heuzard\n\n// This program is free software; you can redistribute it and/or modify\n// it under the terms of the GNU Lesser General Public License as published by\n// the Free Software Foundation, with linking exception;\n// either version 2.1 of the License, or (at your option) any later version.\n\n// This program is distributed in the hope that it will be useful,\n// but WITHOUT ANY WARRANTY; without even the implied warranty of\n// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n// GNU Lesser General Public License for more details.\n\n// You should have received a copy of the GNU Lesser General Public License\n// along with this program; if not, write to the Free Software\n// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.\n\n//Provides: caml_gr_state\nvar caml_gr_state;\n\n//Provides: caml_gr_state_get\n//Requires: caml_gr_state\n//Requires: caml_named_value, caml_string_of_jsbytes\nfunction caml_gr_state_get() {\n  if(caml_gr_state) {\n    return caml_gr_state;\n  }\n  throw [0,caml_named_value(\"Graphics.Graphic_failure\"), caml_string_of_jsbytes(\"Not initialized\")]\n}\n//Provides: caml_gr_state_set\n//Requires: caml_gr_state,caml_gr_state_init\nfunction caml_gr_state_set(ctx) {\n  caml_gr_state=ctx;\n  caml_gr_state_init()\n  return 0;\n}\n\n//Provides: caml_gr_open_graph\n//Requires: caml_gr_state_create\n//Requires: caml_gr_state_set\n//Requires: caml_failwith\n//Requires: caml_jsstring_of_string\nfunction caml_gr_open_graph(info){\n  var g = globalThis;\n  var info = caml_jsstring_of_string(info);\n  function get(name){\n    var res = info.match(\"(^|,) *\"+name+\" *= *([a-zA-Z0-9_]+) *(,|$)\");\n    if(res) return res[2];\n  }\n  var specs = [];\n  if(!(info==\"\")) specs.push(info);\n  var target = get(\"target\");\n  if(!target) target=\"\";\n  var status = get(\"status\");\n  if(!status) specs.push(\"status=1\")\n\n  var w = get(\"width\");\n  w = w?parseInt(w):200;\n  specs.push(\"width=\"+w);\n\n  var h = get(\"height\");\n  h = h?parseInt(h):200;\n  specs.push(\"height=\"+h);\n\n  var win = g.open(\"about:blank\",target,specs.join(\",\"));\n  if(!win) {caml_failwith(\"Graphics.open_graph: cannot open the window\")}\n  var doc = win.document;\n  var canvas = doc.createElement(\"canvas\");\n  canvas.width = w;\n  canvas.height = h;\n  var ctx = caml_gr_state_create(canvas,w,h);\n  ctx.set_title = function (title) {\n    doc.title = title;\n  };\n  caml_gr_state_set(ctx);\n  var body = doc.body;\n  body.style.margin = \"0px\";\n  body.appendChild(canvas);\n  return 0;\n}\n\n//Provides: caml_gr_state_init\n//Requires: caml_gr_state\n//Requires: caml_gr_set_color,caml_gr_moveto,caml_gr_resize_window\n//Requires: caml_gr_set_line_width,caml_gr_set_text_size,caml_gr_set_font\n//Requires: caml_gr_set_window_title\nfunction caml_gr_state_init(){\n  caml_gr_moveto(caml_gr_state.x,caml_gr_state.y);\n  caml_gr_resize_window(caml_gr_state.width,caml_gr_state.height);\n  caml_gr_set_line_width(caml_gr_state.line_width);\n  caml_gr_set_text_size(caml_gr_state.text_size);\n  caml_gr_set_font(caml_gr_state.font);\n  caml_gr_set_color(caml_gr_state.color);\n  caml_gr_set_window_title(caml_gr_state.title);\n  //caml_gr_resize_window might reset some canvas' properties\n  caml_gr_state.context.textBaseline = 'bottom';\n}\n\n//Provides: caml_gr_state_create\n//Requires: caml_string_of_jsbytes\nfunction caml_gr_state_create(canvas,w,h){\n  var context = canvas.getContext(\"2d\");\n  return {\n    context: context,\n    canvas : canvas,\n    x : 0,\n    y : 0,\n    width : w,\n    height : h,\n    line_width : 1,\n    font : caml_string_of_jsbytes(\"fixed\"),\n    text_size : 26,\n    color : 0x000000,\n    title : caml_string_of_jsbytes(\"\")\n  };\n}\n\n//Provides: caml_gr_doc_of_state\nfunction caml_gr_doc_of_state(state) {\n  if(state.canvas.ownerDocument)\n    return state.canvas.ownerDocument;\n}\n\n//Provides: caml_gr_close_graph\n//Requires: caml_gr_state_get\nfunction caml_gr_close_graph(){\n  var s = caml_gr_state_get();\n  s.canvas.width = 0;\n  s.canvas.height = 0;\n  return 0;\n}\n\n//Provides: caml_gr_set_window_title\n//Requires: caml_gr_state_get\n//Requires: caml_jsstring_of_string\nfunction caml_gr_set_window_title(name){\n  var s = caml_gr_state_get();\n  s.title = name;\n  var jsname = caml_jsstring_of_string(name);\n  if(s.set_title) s.set_title(jsname);\n  return 0;\n}\n\n//Provides: caml_gr_resize_window\n//Requires: caml_gr_state_get\nfunction caml_gr_resize_window(w,h){\n  var s = caml_gr_state_get()\n  s.width = w;\n  s.height = h;\n  s.canvas.width = w;\n  s.canvas.height = h;\n  return 0;\n}\n\n//Provides: caml_gr_clear_graph\n//Requires: caml_gr_state_get\nfunction caml_gr_clear_graph(){\n  var s = caml_gr_state_get();\n  s.canvas.width = s.width;\n  s.canvas.height = s.height;\n  //  s.context.strokeRect (0., 0., s.width, s.height);\n  return 0;\n}\n\n//Provides: caml_gr_size_x\n//Requires: caml_gr_state_get\nfunction caml_gr_size_x(){\n  var s = caml_gr_state_get();\n  return s.width;\n}\n//Provides: caml_gr_size_y\n//Requires: caml_gr_state_get\nfunction caml_gr_size_y(){\n  var s = caml_gr_state_get();\n  return s.height;\n}\n\n\n//Provides: caml_gr_set_color\n//Requires: caml_gr_state_get\nfunction caml_gr_set_color(color){\n  var s = caml_gr_state_get();\n  function convert(number) {\n    var str = '' + number.toString(16);\n    while (str.length < 2) str = '0' + str;\n    return str;\n  }\n  var\n  r = (color >> 16) & 0xff,\n  g = (color >> 8)  & 0xff,\n  b = (color >> 0)  & 0xff;\n  s.color=color;\n  var c_str = '#' + convert(r) + convert(g) + convert(b);\n  s.context.fillStyle =   c_str;\n  s.context.strokeStyle = c_str;\n  return 0;\n}\n//Provides: caml_gr_plot\n//Requires: caml_gr_state_get\nfunction caml_gr_plot(x,y){\n  var s = caml_gr_state_get();\n  var im=s.context.createImageData(1,1);\n  var d = im.data;\n  var color = s.color;\n  d[0] = (color >> 16) & 0xff; //r\n  d[1] = (color >> 8)  & 0xff, //g\n  d[2] = (color >> 0)  & 0xff; //b\n  d[3] = 0xFF; //a\n  s.x=x;\n  s.y=y;\n  s.context.putImageData(im,x,s.height - y);\n  return 0;\n}\n\n//Provides: caml_gr_point_color\n//Requires: caml_gr_state_get\nfunction caml_gr_point_color(x,y){\n  var s = caml_gr_state_get();\n  var im=s.context.getImageData(x,s.height - y,1,1);\n  var d = im.data;\n  return (d[0] << 16) + (d[1] << 8) + d[2];\n}\n//Provides: caml_gr_moveto\n//Requires: caml_gr_state_get\nfunction caml_gr_moveto(x,y){\n  var s = caml_gr_state_get();\n  s.x=x;\n  s.y=y;\n  return 0;\n}\n\n//Provides: caml_gr_current_x\n//Requires: caml_gr_state_get\nfunction caml_gr_current_x(){\n  var s = caml_gr_state_get();\n  return s.x\n}\n//Provides: caml_gr_current_y\n//Requires: caml_gr_state_get\nfunction caml_gr_current_y(){\n  var s = caml_gr_state_get();\n  return s.y\n}\n//Provides: caml_gr_lineto\n//Requires: caml_gr_state_get\nfunction caml_gr_lineto(x,y){\n  var s = caml_gr_state_get();\n  s.context.beginPath();\n  s.context.moveTo(s.x,s.height - s.y);\n  s.context.lineTo(x,s.height - y);\n  s.context.stroke();\n  s.x=x;\n  s.y=y;\n  return 0;\n}\n//Provides: caml_gr_draw_rect\n//Requires: caml_gr_state_get\nfunction caml_gr_draw_rect(x,y,w,h){\n  var s = caml_gr_state_get();\n  s.context.strokeRect(x,s.height - y,w,-h);\n  return 0;\n}\n\n//Provides: caml_gr_arc_aux\nfunction caml_gr_arc_aux(ctx,cx,cy,ry,rx,a1,a2){\n  while(a1>a2) a2+=360;\n  a1 /= 180;\n  a2 /= 180;\n  var rot = 0,xPos,yPos,xPos_prev,yPos_prev;\n  var space = 2;\n  var num = (((a2 - a1) * Math.PI * ((rx+ry)/2)) / space) | 0;\n  var delta = (a2 - a1) * Math.PI / num;\n  var i = a1 * Math.PI;\n  for (var j=0;j<=num;j++){\n    xPos = cx - (rx * Math.sin(i)) * Math.sin(rot * Math.PI) + (ry * Math.cos(i)) * Math.cos(rot * Math.PI);\n    xPos = xPos.toFixed(2);\n    yPos = cy + (ry * Math.cos(i)) * Math.sin(rot * Math.PI) + (rx * Math.sin(i)) * Math.cos(rot * Math.PI);\n    yPos = yPos.toFixed(2);\n    if (j==0) {\n      ctx.moveTo(xPos, yPos);\n    } else if (xPos_prev!=xPos || yPos_prev!=yPos){\n      ctx.lineTo(xPos, yPos);\n    }\n    xPos_prev=xPos;\n    yPos_prev=yPos;\n    i-= delta;//ccw\n  }\n  return 0;\n}\n\n\n//Provides: caml_gr_draw_arc\n//Requires: caml_gr_state_get, caml_gr_arc_aux\nfunction caml_gr_draw_arc(x,y,rx,ry,a1,a2){\n  var s = caml_gr_state_get();\n  s.context.beginPath();\n  caml_gr_arc_aux(s.context,x,s.height - y,rx,ry,a1,a2);\n  s.context.stroke();\n  return 0;\n}\n\n//Provides: caml_gr_set_line_width\n//Requires: caml_gr_state_get\nfunction caml_gr_set_line_width(w){\n  var s = caml_gr_state_get();\n  s.line_width = w;\n  s.context.lineWidth = w\n  return 0;\n}\n\n//Provides: caml_gr_fill_rect\n//Requires: caml_gr_state_get\nfunction caml_gr_fill_rect(x,y,w,h){\n  var s = caml_gr_state_get();\n  s.context.fillRect(x,s.height - y,w,-h);\n  return 0;\n}\n//Provides: caml_gr_fill_poly\n//Requires: caml_gr_state_get\nfunction caml_gr_fill_poly(ar){\n  var s = caml_gr_state_get();\n  s.context.beginPath();\n  s.context.moveTo(ar[1][1],s.height - ar[1][2]);\n  for(var i = 2; i < ar.length; i++)\n    s.context.lineTo(ar[i][1],s.height - ar[i][2]);\n  s.context.lineTo(ar[1][1],s.height - ar[1][2]);\n  s.context.fill();\n  return 0;\n}\n\n//Provides: caml_gr_fill_arc\n//Requires: caml_gr_state_get, caml_gr_arc_aux\nfunction caml_gr_fill_arc(x,y,rx,ry,a1,a2){\n  var s = caml_gr_state_get();\n  s.context.beginPath();\n  caml_gr_arc_aux(s.context,x,s.height - y,rx,ry,a1,a2);\n  s.context.fill();\n  return 0;\n}\n\n//Provides: caml_gr_draw_str\n//Requires: caml_gr_state_get\nfunction caml_gr_draw_str(str){\n  var s = caml_gr_state_get();\n  var m = s.context.measureText(str);\n  var dx = m.width;\n  s.context.fillText(str,s.x,s.height - s.y);\n  s.x += dx | 0;\n  return 0;\n}\n\n//Provides: caml_gr_draw_char\n//Requires: caml_gr_draw_str\nfunction caml_gr_draw_char(c){\n  caml_gr_draw_str(String.fromCharCode(c));\n  return 0;\n}\n\n//Provides: caml_gr_draw_string\n//Requires: caml_gr_draw_str\n//Requires: caml_jsstring_of_string\nfunction caml_gr_draw_string(str){\n  caml_gr_draw_str(caml_jsstring_of_string(str));\n  return 0;\n}\n\n//Provides: caml_gr_set_font\n//Requires: caml_gr_state_get\n//Requires: caml_jsstring_of_string\nfunction caml_gr_set_font(f){\n  var s = caml_gr_state_get();\n  s.font = f;\n  s.context.font = s.text_size + \"px \" + caml_jsstring_of_string(s.font);\n  return 0;\n}\n\n//Provides: caml_gr_set_text_size\n//Requires: caml_gr_state_get\n//Requires: caml_jsstring_of_string\nfunction caml_gr_set_text_size(size){\n  var s = caml_gr_state_get();\n  s.text_size = size;\n  s.context.font = s.text_size + \"px \" + caml_jsstring_of_string(s.font);\n  return 0;\n}\n\n//Provides: caml_gr_text_size\n//Requires: caml_gr_state_get\n//Requires: caml_jsstring_of_string\nfunction caml_gr_text_size(txt){\n  var s = caml_gr_state_get();\n  var w = s.context.measureText(caml_jsstring_of_string(txt)).width;\n  return [0,w,s.text_size];\n}\n\n\n//Provides: caml_gr_make_image\n//Requires: caml_gr_state_get\nfunction caml_gr_make_image(arr){\n  var s = caml_gr_state_get();\n  var h = arr.length - 1 ;\n  var w = arr[1].length - 1;\n  var im = s.context.createImageData(w,h);\n  for(var i=0;i<h;i++){\n    for(var j=0;j<w;j++){\n      var c = arr[i+1][j+1];\n      var o = i*(w*4) + (j * 4);\n      if(c == -1) {\n        im.data[o + 0] = 0;\n        im.data[o + 1] = 0;\n        im.data[o + 2] = 0;\n        im.data[o + 3] = 0;\n      } else {\n        im.data[o + 0] = c >> 16 & 0xff;\n        im.data[o + 1] = c >>  8 & 0xff;\n        im.data[o + 2] = c >>  0 & 0Xff;\n        im.data[o + 3] = 0xff;\n      }\n    }\n  }\n  return im\n}\n//Provides: caml_gr_dump_image\n//Requires: caml_gr_state_get\nfunction caml_gr_dump_image(im){\n  var data = [0]\n  for(var i=0; i<im.height;i++){\n    data[i+1] = [0]\n    for(var j=0; j<im.width;j++){\n      var o = i*(im.width*4) + (j * 4),\n          r = im.data[o+0],\n          g = im.data[o+1],\n          b = im.data[o+2];\n      data[i+1][j+1] = (r << 16) + (g << 8) + b\n    }\n  }\n  return data\n}\n//Provides: caml_gr_draw_image\n//Requires: caml_gr_state_get\nfunction caml_gr_draw_image(im,x,y){\n  var s = caml_gr_state_get();\n  if(!im.image) {\n    var canvas = document.createElement(\"canvas\");\n    canvas.width = s.width;\n    canvas.height = s.height;\n    canvas.getContext(\"2d\").putImageData(im,0,0);\n    var image = new globalThis.Image();\n    image.onload = function () {\n      s.context.drawImage(image,x,s.height - im.height - y);\n      im.image = image;\n    }\n    image.src = canvas.toDataURL(\"image/png\");\n  } else {\n    s.context.drawImage(im.image,x,s.height - im.height - y);\n  }\n  return 0;\n}\n//Provides: caml_gr_create_image\n//Requires: caml_gr_state_get\nfunction caml_gr_create_image(x,y){\n  var s = caml_gr_state_get();\n  return s.context.createImageData(x,y);\n}\n//Provides: caml_gr_blit_image\n//Requires: caml_gr_state_get\nfunction caml_gr_blit_image(im,x,y){\n  var s = caml_gr_state_get();\n  var im2 = s.context.getImageData(x,s.height - im.height - y,im.width,im.height);\n  for (var i = 0; i < im2.data.length; i+=4){\n    im.data[i] = im2.data[i];\n    im.data[i+1] = im2.data[i+1];\n    im.data[i+2] = im2.data[i+2];\n    im.data[i+3] = im2.data[i+3];\n  }\n  return 0;\n}\n//Provides: caml_gr_sigio_handler\nfunction caml_gr_sigio_handler(){return 0}\n//Provides: caml_gr_sigio_signal\nfunction caml_gr_sigio_signal(){return 0}\n//Provides: caml_gr_wait_event\n//Requires: caml_failwith\nfunction caml_gr_wait_event(_evl){\n  caml_failwith(\"caml_gr_wait_event not Implemented: use Graphics_js instead\");\n}\n\n//Provides: caml_gr_synchronize\n//Requires: caml_failwith\nfunction caml_gr_synchronize () {\n  caml_failwith(\"caml_gr_synchronize not Implemented\");\n}\n//Provides: caml_gr_remember_mode\n//Requires: caml_failwith\nfunction caml_gr_remember_mode () {\n  caml_failwith(\"caml_gr_remember_mode not Implemented\");\n}\n//Provides: caml_gr_display_mode\n//Requires: caml_failwith\nfunction caml_gr_display_mode() {\n  caml_failwith(\"caml_gr_display_mode not Implemented\");\n}\n\n//Provides: caml_gr_window_id\n//Requires: caml_failwith\nfunction caml_gr_window_id(a) {\n  caml_failwith(\"caml_gr_window_id not Implemented\");\n}\n\n//Provides: caml_gr_open_subwindow\n//Requires: caml_failwith\nfunction caml_gr_open_subwindow(a,b,c,d) {\n  caml_failwith(\"caml_gr_open_subwindow not Implemented\");\n}\n\n//Provides: caml_gr_close_subwindow\n//Requires: caml_failwith\nfunction caml_gr_close_subwindow(a) {\n  caml_failwith(\"caml_gr_close_subwindow not Implemented\");\n}\n"
let hash = Js_of_ocaml_compiler.Builtins.register ~name:"hash.js" ~content:"// Js_of_ocaml runtime support\n// http://www.ocsigen.org/js_of_ocaml/\n//\n// This program is free software; you can redistribute it and/or modify\n// it under the terms of the GNU Lesser General Public License as published by\n// the Free Software Foundation, with linking exception;\n// either version 2.1 of the License, or (at your option) any later version.\n//\n// This program is distributed in the hope that it will be useful,\n// but WITHOUT ANY WARRANTY; without even the implied warranty of\n// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n// GNU Lesser General Public License for more details.\n//\n// You should have received a copy of the GNU Lesser General Public License\n// along with this program; if not, write to the Free Software\n// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.\n\n///////////// Hashtbl\n\n//Provides: caml_hash_univ_param mutable\n//Requires: caml_is_ml_string, caml_is_ml_bytes\n//Requires: caml_ml_bytes_content\n//Requires: caml_int64_to_bytes, caml_int64_bits_of_float, caml_custom_ops\n//Requires: caml_ml_bytes_length, caml_jsbytes_of_string\nfunction caml_hash_univ_param (count, limit, obj) {\n  var hash_accu = 0;\n  function hash_aux (obj) {\n    limit --;\n    if (count < 0 || limit < 0) return;\n    if (obj instanceof Array && obj[0] === (obj[0]|0)) {\n      switch (obj[0]) {\n      case 248:\n        // Object\n        count --;\n        hash_accu = (hash_accu * 65599 + obj[2]) | 0;\n        break;\n      case 250:\n        // Forward\n        limit++; hash_aux(obj); break;\n      default:\n        count --;\n        hash_accu = (hash_accu * 19 + obj[0]) | 0;\n        for (var i = obj.length - 1; i > 0; i--) hash_aux (obj[i]);\n      }\n    } else if (caml_is_ml_bytes(obj)) {\n      count --;\n      var content = caml_ml_bytes_content(obj);\n      if(typeof content === \"string\") {\n\tfor (var b = content, l = b.length, i = 0; i < l; i++)\n          hash_accu = (hash_accu * 19 + b.charCodeAt(i)) | 0;\n      } else { /* ARRAY */\n        for (var a = content, l = a.length, i = 0; i < l; i++)\n          hash_accu = (hash_accu * 19 + a[i]) | 0;\n      }\n    } else if (caml_is_ml_string(obj)) {\n      var jsbytes = caml_jsbytes_of_string(obj);\n      for (var b = jsbytes, l = jsbytes.length, i = 0; i < l; i++)\n        hash_accu = (hash_accu * 19 + b.charCodeAt(i)) | 0;\n    } else if (typeof obj === \"string\") {\n      for (var b = obj, l = obj.length, i = 0; i < l; i++)\n        hash_accu = (hash_accu * 19 + b.charCodeAt(i)) | 0;\n    } else if (obj === (obj|0)) {\n      // Integer\n      count --;\n      hash_accu = (hash_accu * 65599 + obj) | 0;\n    } else if (obj === +obj) {\n      // Float\n      count--;\n      var p = caml_int64_to_bytes (caml_int64_bits_of_float (obj));\n      for (var i = 7; i >= 0; i--) hash_accu = (hash_accu * 19 + p[i]) | 0;\n    } else if(obj && obj.caml_custom) {\n      if(caml_custom_ops[obj.caml_custom] && caml_custom_ops[obj.caml_custom].hash) {\n        var h = caml_custom_ops[obj.caml_custom].hash(obj) | 0;\n        hash_accu = (hash_accu * 65599 + h) | 0;\n      }\n    }\n  }\n  hash_aux (obj);\n  return hash_accu & 0x3FFFFFFF;\n}\n\n//function ROTL32(x,n) { return ((x << n) | (x >>> (32-n))); }\n//Provides: caml_hash_mix_int\n//Requires: caml_mul\nfunction caml_hash_mix_int(h,d) {\n  d = caml_mul(d, 0xcc9e2d51|0);\n  d = ((d << 15) | (d >>> (32-15))); // ROTL32(d, 15);\n  d = caml_mul(d, 0x1b873593);\n  h ^= d;\n  h = ((h << 13) | (h >>> (32-13)));   //ROTL32(h, 13);\n  return (((h + (h << 2))|0) + (0xe6546b64|0))|0;\n}\n\n//Provides: caml_hash_mix_final\n//Requires: caml_mul\nfunction caml_hash_mix_final(h) {\n  h ^= h >>> 16;\n  h = caml_mul (h, 0x85ebca6b|0);\n  h ^= h >>> 13;\n  h = caml_mul (h, 0xc2b2ae35|0);\n  h ^= h >>> 16;\n  return h;\n}\n\n//Provides: caml_hash_mix_float\n//Requires: caml_int64_bits_of_float, caml_hash_mix_int64\nfunction caml_hash_mix_float (h, v0) {\n  return caml_hash_mix_int64(h, caml_int64_bits_of_float (v0));\n}\n//Provides: caml_hash_mix_int64\n//Requires: caml_hash_mix_int\n//Requires: caml_int64_lo32, caml_int64_hi32\nfunction caml_hash_mix_int64 (h, v) {\n  h = caml_hash_mix_int(h, caml_int64_lo32(v));\n  h = caml_hash_mix_int(h, caml_int64_hi32(v));\n  return h;\n}\n\n//Provides: caml_hash_mix_jsbytes\n//Requires: caml_hash_mix_int\nfunction caml_hash_mix_jsbytes(h, s) {\n  var len = s.length, i, w;\n  for (i = 0; i + 4 <= len; i += 4) {\n    w = s.charCodeAt(i)\n      | (s.charCodeAt(i+1) << 8)\n      | (s.charCodeAt(i+2) << 16)\n      | (s.charCodeAt(i+3) << 24);\n    h = caml_hash_mix_int(h, w);\n  }\n  w = 0;\n  switch (len & 3) {\n  case 3: w  = s.charCodeAt(i+2) << 16;\n  case 2: w |= s.charCodeAt(i+1) << 8;\n  case 1:\n    w |= s.charCodeAt(i);\n    h = caml_hash_mix_int(h, w);\n  default:\n  }\n  h ^= len;\n  return h;\n}\n\n//Provides: caml_hash_mix_bytes_arr\n//Requires: caml_hash_mix_int\nfunction caml_hash_mix_bytes_arr(h, s) {\n  var len = s.length, i, w;\n  for (i = 0; i + 4 <= len; i += 4) {\n    w = s[i]\n      | (s[i+1] << 8)\n      | (s[i+2] << 16)\n      | (s[i+3] << 24);\n    h = caml_hash_mix_int(h, w);\n  }\n  w = 0;\n  switch (len & 3) {\n  case 3: w  = s[i+2] << 16;\n  case 2: w |= s[i+1] << 8;\n  case 1: w |= s[i];\n    h = caml_hash_mix_int(h, w);\n  default:\n  }\n  h ^= len;\n  return h;\n}\n\n//Provides: caml_hash_mix_bytes\n//Requires: caml_ml_bytes_content\n//Requires: caml_hash_mix_jsbytes\n//Requires: caml_hash_mix_bytes_arr\nfunction caml_hash_mix_bytes(h, v) {\n  var content = caml_ml_bytes_content(v);\n  if(typeof content === \"string\")\n    return caml_hash_mix_jsbytes(h, content)\n  else /* ARRAY */\n    return caml_hash_mix_bytes_arr(h, content);\n}\n\n//Provides: caml_hash_mix_string\n//Requires: caml_hash_mix_jsbytes, caml_jsbytes_of_string\nfunction caml_hash_mix_string(h, v) {\n  return caml_hash_mix_jsbytes(h, caml_jsbytes_of_string(v));\n}\n\n\n//Provides: caml_hash mutable\n//Requires: caml_is_ml_string, caml_is_ml_bytes\n//Requires: caml_hash_mix_int, caml_hash_mix_final\n//Requires: caml_hash_mix_float, caml_hash_mix_string, caml_hash_mix_bytes, caml_custom_ops\n//Requires: caml_hash_mix_jsbytes\nfunction caml_hash (count, limit, seed, obj) {\n  var queue, rd, wr, sz, num, h, v, i, len;\n  sz = limit;\n  if (sz < 0 || sz > 256) sz = 256;\n  num = count;\n  h = seed;\n  queue = [obj]; rd = 0; wr = 1;\n  while (rd < wr && num > 0) {\n    v = queue[rd++];\n    if (v && v.caml_custom){\n      if(caml_custom_ops[v.caml_custom] && caml_custom_ops[v.caml_custom].hash) {\n        var hh = caml_custom_ops[v.caml_custom].hash(v);\n        h = caml_hash_mix_int (h, hh);\n        num --;\n      }\n    }\n    else if (v instanceof Array && v[0] === (v[0]|0)) {\n      switch (v[0]) {\n      case 248:\n        // Object\n        h = caml_hash_mix_int(h, v[2]);\n        num--;\n        break;\n      case 250:\n        // Forward\n        queue[--rd] = v[1];\n        break;\n      default:\n        var tag = ((v.length - 1) << 10) | v[0];\n        h = caml_hash_mix_int(h, tag);\n        for (i = 1, len = v.length; i < len; i++) {\n          if (wr >= sz) break;\n          queue[wr++] = v[i];\n        }\n        break;\n      }\n    } else if (caml_is_ml_bytes(v)) {\n      h = caml_hash_mix_bytes(h,v)\n      num--;\n    } else if (caml_is_ml_string(v)) {\n      h = caml_hash_mix_string(h,v)\n      num--;\n    } else if (typeof v === \"string\") {\n      h = caml_hash_mix_jsbytes(h,v)\n      num--;\n    } else if (v === (v|0)) {\n      // Integer\n      h = caml_hash_mix_int(h, v+v+1);\n      num--;\n    } else if (v === +v) {\n      // Float\n      h = caml_hash_mix_float(h,v);\n      num--;\n    }\n  }\n  h = caml_hash_mix_final(h);\n  return h & 0x3FFFFFFF;\n}\n"
let ieee_754 = Js_of_ocaml_compiler.Builtins.register ~name:"ieee_754.js" ~content:"// Js_of_ocaml runtime support\n// http://www.ocsigen.org/js_of_ocaml/\n// Copyright (C) 2010 J\195\169r\195\180me Vouillon\n// Laboratoire PPS - CNRS Universit\195\169 Paris Diderot\n//\n// This program is free software; you can redistribute it and/or modify\n// it under the terms of the GNU Lesser General Public License as published by\n// the Free Software Foundation, with linking exception;\n// either version 2.1 of the License, or (at your option) any later version.\n//\n// This program is distributed in the hope that it will be useful,\n// but WITHOUT ANY WARRANTY; without even the implied warranty of\n// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n// GNU Lesser General Public License for more details.\n//\n// You should have received a copy of the GNU Lesser General Public License\n// along with this program; if not, write to the Free Software\n// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.\n\n//Provides: jsoo_floor_log2\nvar log2_ok = Math.log2 && Math.log2(1.1235582092889474E+307) == 1020\nfunction jsoo_floor_log2(x) {\n  if(log2_ok) return Math.floor(Math.log2(x))\n  var i = 0;\n  if (x == 0) return -Infinity;\n  if(x>=1) {while (x>=2) {x/=2; i++} }\n  else {while (x < 1) {x*=2; i--} };\n  return i;\n}\n\n//Provides: caml_int64_bits_of_float const\n//Requires: jsoo_floor_log2, caml_int64_create_lo_mi_hi\nfunction caml_int64_bits_of_float (x) {\n  if (!isFinite(x)) {\n    if (isNaN(x))\n      return caml_int64_create_lo_mi_hi(1, 0, 0x7ff0);\n    if (x > 0)\n      return caml_int64_create_lo_mi_hi(0, 0, 0x7ff0)\n    else\n      return caml_int64_create_lo_mi_hi(0, 0, 0xfff0)\n  }\n  var sign = (x==0 && 1/x == -Infinity)?0x8000:(x>=0)?0:0x8000;\n  if (sign) x = -x;\n  // Int64.bits_of_float 1.1235582092889474E+307 = 0x7fb0000000000000L\n  // using Math.LOG2E*Math.log(x) in place of Math.log2 result in precision lost\n  var exp = jsoo_floor_log2(x) + 1023;\n  if (exp <= 0) {\n    exp = 0;\n    x /= Math.pow(2,-1026);\n  } else {\n    x /= Math.pow(2,exp-1027);\n    if (x < 16) {\n      x *= 2; exp -=1; }\n    if (exp == 0) {\n      x /= 2; }\n  }\n  var k = Math.pow(2,24);\n  var r3 = x|0;\n  x = (x - r3) * k;\n  var r2 = x|0;\n  x = (x - r2) * k;\n  var r1 = x|0;\n  r3 = (r3 &0xf) | sign | exp << 4;\n  return caml_int64_create_lo_mi_hi(r1, r2, r3);\n}\n\n//Provides: caml_int32_bits_of_float const\n//Requires: jsoo_floor_log2\nfunction caml_int32_bits_of_float (x) {\n  var float32a = new globalThis.Float32Array(1);\n  float32a[0] = x;\n  var int32a = new globalThis.Int32Array(float32a.buffer);\n  return int32a[0] | 0;\n}\n\n//FP literals can be written using the hexadecimal\n//notation 0x<mantissa in hex>p<exponent> from ISO C99.\n//https://github.com/dankogai/js-hexfloat/blob/master/hexfloat.js\n//Provides: caml_hexstring_of_float const\n//Requires: caml_string_of_jsstring, caml_str_repeat\nfunction caml_hexstring_of_float (x, prec, style) {\n  if (!isFinite(x)) {\n    if (isNaN(x)) return caml_string_of_jsstring(\"nan\");\n    return caml_string_of_jsstring ((x > 0)?\"infinity\":\"-infinity\");\n  }\n  var sign = (x==0 && 1/x == -Infinity)?1:(x>=0)?0:1;\n  if(sign) x = -x;\n  var exp = 0;\n  if (x == 0) { }\n  else if (x < 1) {\n    while (x < 1 && exp > -1022)  { x *= 2; exp-- }\n  } else {\n    while (x >= 2) { x /= 2; exp++ }\n  }\n  var exp_sign = exp < 0 ? '' : '+';\n  var sign_str = '';\n  if (sign) sign_str = '-'\n  else {\n    switch(style){\n    case 43 /* '+' */: sign_str = '+'; break;\n    case 32 /* ' ' */: sign_str = ' '; break;\n    default: break;\n    }\n  }\n  if (prec >= 0 && prec < 13) {\n    /* If a precision is given, and is small, round mantissa accordingly */\n    var cst = Math.pow(2,prec * 4);\n    x = Math.round(x * cst) / cst;\n  }\n  var x_str = x.toString(16);\n  if(prec >= 0){\n    var idx = x_str.indexOf('.');\n    if(idx<0) {\n      x_str += '.' + caml_str_repeat(prec, '0');\n    }\n    else {\n      var size = idx+1+prec;\n      if(x_str.length < size)\n        x_str += caml_str_repeat(size - x_str.length, '0');\n      else\n        x_str = x_str.substr(0,size);\n    }\n  }\n  return caml_string_of_jsstring (sign_str + '0x' + x_str + 'p' + exp_sign + exp.toString(10));\n}\n\n//Provides: caml_int64_float_of_bits const\nfunction caml_int64_float_of_bits (x) {\n  var lo = x.lo;\n  var mi = x.mi;\n  var hi = x.hi;\n  var exp = (hi & 0x7fff) >> 4;\n  if (exp == 2047) {\n    if ((lo|mi|(hi&0xf)) == 0)\n      return (hi & 0x8000)?(-Infinity):Infinity;\n    else\n      return NaN;\n  }\n  var k = Math.pow(2,-24);\n  var res = (lo*k+mi)*k+(hi&0xf);\n  if (exp > 0) {\n    res += 16;\n    res *= Math.pow(2,exp-1027);\n  } else\n    res *= Math.pow(2,-1026);\n  if (hi & 0x8000) res = - res;\n  return res;\n}\n\n//Provides: caml_nextafter_float const\n//Requires: caml_int64_float_of_bits, caml_int64_bits_of_float, caml_int64_add, caml_int64_sub,caml_int64_of_int32\nfunction caml_nextafter_float (x,y) {\n  if(isNaN(x) || isNaN(y)) return NaN;\n  if(x==y) return y;\n  if(x==0){\n    if(y < 0)\n      return -Math.pow(2, -1074)\n    else\n      return Math.pow(2, -1074)\n  }\n  var bits = caml_int64_bits_of_float(x);\n  var one = caml_int64_of_int32(1);\n  if ((x<y) == (x>0))\n    bits = caml_int64_add(bits, one)\n  else\n    bits = caml_int64_sub(bits, one)\n  return caml_int64_float_of_bits(bits);\n}\n\n//Provides: caml_trunc_float\nfunction caml_trunc_float(x){\n  return Math.trunc(x);\n}\n\n//Provides: caml_int32_float_of_bits const\nfunction caml_int32_float_of_bits (x) {\n  var int32a = new globalThis.Int32Array(1);\n  int32a[0] = x;\n  var float32a = new globalThis.Float32Array(int32a.buffer);\n  return float32a[0];\n}\n\n//Provides: caml_classify_float const\nfunction caml_classify_float (x) {\n  if (isFinite (x)) {\n    if (Math.abs(x) >= 2.2250738585072014e-308) return 0;\n    if (x != 0) return 1;\n    return 2;\n  }\n  return isNaN(x)?4:3;\n}\n//Provides: caml_modf_float const\nfunction caml_modf_float (x) {\n  if (isFinite (x)) {\n    var neg = (1/x) < 0;\n    x = Math.abs(x);\n    var i = Math.floor (x);\n    var f = x - i;\n    if (neg) { i = -i; f = -f; }\n    return [0, f, i];\n  }\n  if (isNaN (x)) return [0, NaN, NaN];\n  return [0, 1/x, x];\n}\n//Provides: caml_ldexp_float const\nfunction caml_ldexp_float (x,exp) {\n  exp |= 0;\n  if (exp > 1023) {\n    exp -= 1023;\n    x *= Math.pow(2, 1023);\n    if (exp > 1023) {  // in case x is subnormal\n      exp -= 1023;\n      x *= Math.pow(2, 1023);\n    }\n  }\n  if (exp < -1023) {\n    exp += 1023;\n    x *= Math.pow(2, -1023);\n  }\n  x *= Math.pow(2, exp);\n  return x;\n}\n//Provides: caml_frexp_float const\n//Requires: jsoo_floor_log2\nfunction caml_frexp_float (x) {\n  if ((x == 0) || !isFinite(x)) return [0, x, 0];\n  var neg = x < 0;\n  if (neg) x = - x;\n  var exp = Math.max(-1023, jsoo_floor_log2(x) + 1);\n  x *= Math.pow(2,-exp);\n  while (x < 0.5) {\n    x *= 2;\n    exp--;\n  }\n  while (x >= 1) {\n    x *= 0.5;\n    exp++;\n  }\n  if (neg) x = - x;\n  return [0, x, exp];\n}\n\n//Provides: caml_float_compare const\nfunction caml_float_compare (x, y) {\n  if (x === y) return 0;\n  if (x < y) return -1;\n  if (x > y) return 1;\n  if (x === x) return 1;\n  if (y === y) return -1;\n  return 0;\n}\n\n//Provides: caml_copysign_float const\nfunction caml_copysign_float (x, y) {\n  if (y == 0) y = 1 / y;\n  x = Math.abs(x);\n  return (y < 0)?(-x):x;\n}\n\n//Provides: caml_signbit_float const\nfunction caml_signbit_float(x) {\n  if (x == 0) x = 1 / x;\n  return (x < 0)?1:0;\n}\n\n//Provides: caml_expm1_float const\nfunction caml_expm1_float (x) { return Math.expm1(x); }\n//Provides: caml_exp2_float const\nfunction caml_exp2_float(x) { return Math.pow(2, x); }\n//Provides: caml_log1p_float const\nfunction caml_log1p_float(x) { return Math.log1p(x); }\n//Provides: caml_log2_float const\nfunction caml_log2_float(x) { return Math.log2(x); }\n//Provides: caml_hypot_float const\nfunction caml_hypot_float (x, y) { return Math.hypot(x, y); }\n//Provides: caml_log10_float const\nfunction caml_log10_float (x) { return Math.log10(x); }\n//Provides: caml_cosh_float const\nfunction caml_cosh_float (x) { return Math.cosh(x); }\n//Provides: caml_acosh_float const\nfunction caml_acosh_float (x) { return Math.acosh(x); }\n//Provides: caml_sinh_float const\nfunction caml_sinh_float (x) { return Math.sinh(x); }\n//Provides: caml_asinh_float const\nfunction caml_asinh_float (x) { return Math.asinh(x); }\n//Provides: caml_tanh_float const\nfunction caml_tanh_float (x) { return Math.tanh(x); }\n//Provides: caml_atanh_float const\nfunction caml_atanh_float (x) { return Math.atanh(x); }\n//Provides: caml_round_float const\nfunction caml_round_float (x) { return Math.round(x); }\n//Provides: caml_cbrt_float const\nfunction caml_cbrt_float (x) { return Math.cbrt(x); }\n\n//Provides: caml_erf_float const\nfunction caml_erf_float(x) {\n  var a1 = 0.254829592;\n  var a2 = -0.284496736;\n  var a3 = 1.421413741;\n  var a4 = -1.453152027;\n  var a5 = 1.061405429;\n  var p = 0.3275911;\n\n  var sign = 1;\n  if (x < 0) {\n    sign = -1;\n  }\n  x = Math.abs(x);\n  var t = 1.0 / (1.0 + p * x);\n  var y = 1.0 - ((((a5 * t + a4) * t + a3) * t + a2) * t + a1) * t * Math.exp(-x * x);\n\n  return sign * y;\n}\n\n//Provides: caml_erfc_float const\n//Requires: caml_erf_float\nfunction caml_erfc_float(x) {\n  return 1 - caml_erf_float(x);\n}\n\n\n//Provides: caml_fma_float const\nfunction caml_fma_float(x, y, z) {\n  var SPLIT = Math.pow(2, 27) + 1;\n  var MIN_VALUE = Math.pow(2, -1022);\n  var EPSILON = Math.pow(2, -52);\n  var C = 416;\n  var A = Math.pow(2, +C);\n  var B = Math.pow(2, -C);\n\n  function multiply (a, b) {\n    var at = SPLIT * a;\n    var ahi = at - (at - a);\n    var alo = a - ahi;\n    var bt = SPLIT * b;\n    var bhi = bt - (bt - b);\n    var blo = b - bhi;\n    var p = a * b;\n    var e = ((ahi * bhi - p) + ahi * blo + alo * bhi) + alo * blo;\n    return {\n      p: p,\n      e: e\n    };\n  };\n\n  function add (a, b) {\n    var s = a + b;\n    var v = s - a;\n    var e = (a - (s - v)) + (b - v);\n    return {\n      s: s,\n      e: e\n    };\n  };\n\n  function adjust (x, y) {\n    return x !== 0 && y !== 0 && SPLIT * x - (SPLIT * x - x) === x ? x * (1 + (x < 0 ? -1 : +1) * (y < 0 ? -1 : +1) * EPSILON) : x;\n  };\n\n  if (x === 0 || x !== x || x === +1 / 0 || x === -1 / 0 ||\n      y === 0 || y !== y || y === +1 / 0 || y === -1 / 0) {\n    return x * y + z;\n  }\n  if (z === 0) {\n    return x * y;\n  }\n  if (z !== z || z === +1 / 0 || z === -1 / 0) {\n    return z;\n  }\n\n  var scale = 1;\n  while (Math.abs(x) > A) {\n    scale *= A;\n    x *= B;\n  }\n  while (Math.abs(y) > A) {\n    scale *= A;\n    y *= B;\n  }\n  if (scale === 1 / 0) {\n    return x * y * scale;\n  }\n  while (Math.abs(x) < B) {\n    scale *= B;\n    x *= A;\n  }\n  while (Math.abs(y) < B) {\n    scale *= B;\n    y *= A;\n  }\n  if (scale === 0) {\n    return z;\n  }\n\n  var xs = x;\n  var ys = y;\n  var zs = z / scale;\n\n  if (Math.abs(zs) > Math.abs(xs * ys) * 4 / EPSILON) {\n    return z;\n  }\n  if (Math.abs(zs) < Math.abs(xs * ys) * EPSILON / 4 * EPSILON / 4) {\n    zs = (z < 0 ? -1 : +1) * MIN_VALUE;\n  }\n\n  var xy = multiply(xs, ys);\n  var s = add(xy.p, zs);\n  var u = add(xy.e, s.e);\n  var i = add(s.s, u.s);\n\n  var f = i.s + adjust(i.e, u.e);\n  if (f === 0) {\n    return f;\n  }\n\n  var fs = f * scale;\n  if (Math.abs(fs) > MIN_VALUE) {\n    return fs;\n  }\n\n  // It is possible that there was extra rounding for a denormalized value.\n  return fs + adjust(f - fs / scale, i.e) * scale;\n}\n\n//Provides: caml_format_float const\n//Requires: caml_parse_format, caml_finish_formatting\nfunction caml_format_float (fmt, x) {\n  function toFixed(x,dp) {\n    if (Math.abs(x) < 1.0) {\n      return x.toFixed(dp);\n    } else {\n      var e = parseInt(x.toString().split('+')[1]);\n      if (e > 20) {\n        e -= 20;\n        x /= Math.pow(10,e);\n        x += (new Array(e+1)).join('0');\n        if(dp > 0) {\n          x = x + '.' + (new Array(dp+1)).join('0');\n        }\n        return x;\n      }\n      else return x.toFixed(dp)\n    }\n  }\n  var s, f = caml_parse_format(fmt);\n  var prec = (f.prec < 0)?6:f.prec;\n  if (x < 0 || (x == 0 && 1/x == -Infinity)) { f.sign = -1; x = -x; }\n  if (isNaN(x)) { s = \"nan\"; f.filler = ' '; }\n  else if (!isFinite(x)) { s = \"inf\"; f.filler = ' '; }\n  else\n    switch (f.conv) {\n    case 'e':\n      var s = x.toExponential(prec);\n      // exponent should be at least two digits\n      var i = s.length;\n      if (s.charAt(i - 3) == 'e')\n        s = s.slice (0, i - 1) + '0' + s.slice (i - 1);\n      break;\n    case 'f':\n      s = toFixed(x, prec); break;\n    case 'g':\n      prec = prec?prec:1;\n      s = x.toExponential(prec - 1);\n      var j = s.indexOf('e');\n      var exp = +s.slice(j + 1);\n      if (exp < -4 || x >= 1e21 || x.toFixed(0).length > prec) {\n        // remove trailing zeroes\n        var i = j - 1; while (s.charAt(i) == '0') i--;\n        if (s.charAt(i) == '.') i--;\n        s = s.slice(0, i + 1) + s.slice(j);\n        i = s.length;\n        if (s.charAt(i - 3) == 'e')\n          s = s.slice (0, i - 1) + '0' + s.slice (i - 1);\n        break;\n      } else {\n        var p = prec;\n        if (exp < 0) { p -= exp + 1; s = x.toFixed(p); }\n        else while (s = x.toFixed(p), s.length > prec + 1) p--;\n        if (p) {\n          // remove trailing zeroes\n          var i = s.length - 1; while (s.charAt(i) == '0') i--;\n          if (s.charAt(i) == '.') i--;\n          s = s.slice(0, i + 1);\n        }\n      }\n      break;\n    }\n  return caml_finish_formatting(f, s);\n}\n\n//Provides: caml_float_of_string (const)\n//Requires: caml_failwith, caml_jsbytes_of_string\nfunction caml_float_of_string(s) {\n  var res;\n  s = caml_jsbytes_of_string(s)\n  res = +s;\n  if ((s.length > 0) && (res === res)) return res;\n  s = s.replace(/_/g,\"\");\n  res = +s;\n  if (((s.length > 0) && (res === res)) || /^[+-]?nan$/i.test(s)) return res;\n  var m = /^ *([+-]?)0x([0-9a-f]+)\\.?([0-9a-f]*)(p([+-]?[0-9]+))?/i.exec(s);\n  //          1        2             3           5\n  if(m){\n    var m3 = m[3].replace(/0+$/,'');\n    var mantissa = parseInt(m[1] + m[2] + m3, 16);\n    var exponent = (m[5]|0) - 4*m3.length;\n    res = mantissa * Math.pow(2, exponent);\n    return res;\n  }\n  if(/^\\+?inf(inity)?$/i.test(s)) return Infinity;\n  if(/^-inf(inity)?$/i.test(s)) return -Infinity;\n  caml_failwith(\"float_of_string\");\n}\n"
let int64 = Js_of_ocaml_compiler.Builtins.register ~name:"int64.js" ~content:"// Js_of_ocaml runtime support\n// http://www.ocsigen.org/js_of_ocaml/\n// Copyright (C) 2010 J\195\169r\195\180me Vouillon\n// Laboratoire PPS - CNRS Universit\195\169 Paris Diderot\n//\n// This program is free software; you can redistribute it and/or modify\n// it under the terms of the GNU Lesser General Public License as published by\n// the Free Software Foundation, with linking exception;\n// either version 2.1 of the License, or (at your option) any later version.\n//\n// This program is distributed in the hope that it will be useful,\n// but WITHOUT ANY WARRANTY; without even the implied warranty of\n// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n// GNU Lesser General Public License for more details.\n//\n// You should have received a copy of the GNU Lesser General Public License\n// along with this program; if not, write to the Free Software\n// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.\n\n//Provides: caml_int64_offset\nvar caml_int64_offset = Math.pow(2, -24);\n\n//Provides: MlInt64\n//Requires: caml_int64_offset, caml_raise_zero_divide\nfunction MlInt64 (lo,mi,hi) {\n  this.lo = lo & 0xffffff;\n  this.mi = mi & 0xffffff;\n  this.hi = hi & 0xffff;\n}\nMlInt64.prototype.caml_custom = \"_j\"\nMlInt64.prototype.copy = function () {\n  return new MlInt64(this.lo,this.mi,this.hi);\n}\n\nMlInt64.prototype.ucompare = function (x) {\n  if (this.hi > x.hi) return 1;\n  if (this.hi < x.hi) return -1;\n  if (this.mi > x.mi) return 1;\n  if (this.mi < x.mi) return -1;\n  if (this.lo > x.lo) return 1;\n  if (this.lo < x.lo) return -1;\n  return 0;\n}\nMlInt64.prototype.compare = function (x) {\n  var hi = this.hi << 16;\n  var xhi = x.hi << 16;\n  if (hi > xhi) return 1;\n  if (hi < xhi) return -1;\n  if (this.mi > x.mi) return 1;\n  if (this.mi < x.mi) return -1;\n  if (this.lo > x.lo) return 1;\n  if (this.lo < x.lo) return -1;\n  return 0;\n}\nMlInt64.prototype.neg = function () {\n  var lo = - this.lo;\n  var mi = - this.mi + (lo >> 24);\n  var hi = - this.hi + (mi >> 24);\n  return new MlInt64(lo, mi, hi);\n}\nMlInt64.prototype.add = function (x) {\n  var lo = this.lo + x.lo;\n  var mi = this.mi + x.mi + (lo >> 24);\n  var hi = this.hi + x.hi + (mi >> 24);\n  return new MlInt64(lo, mi, hi);\n}\nMlInt64.prototype.sub = function (x) {\n  var lo = this.lo - x.lo;\n  var mi = this.mi - x.mi + (lo >> 24);\n  var hi = this.hi - x.hi + (mi >> 24);\n  return new MlInt64(lo, mi, hi);\n}\nMlInt64.prototype.mul = function (x) {\n  var lo = this.lo * x.lo;\n  var mi = ((lo * caml_int64_offset) | 0) + this.mi * x.lo + this.lo * x.mi;\n  var hi = ((mi * caml_int64_offset) | 0) + this.hi * x.lo + this.mi * x.mi + this.lo * x.hi;\n  return new MlInt64(lo, mi, hi);\n}\nMlInt64.prototype.isZero = function () {\n  return (this.lo|this.mi|this.hi) == 0;\n}\nMlInt64.prototype.isNeg = function () {\n  return (this.hi << 16) < 0;\n}\nMlInt64.prototype.and = function (x) {\n  return new MlInt64(this.lo & x.lo, this.mi & x.mi, this.hi & x.hi);\n}\nMlInt64.prototype.or = function (x) {\n  return new MlInt64(this.lo|x.lo, this.mi|x.mi, this.hi|x.hi);\n}\nMlInt64.prototype.xor = function (x) {\n  return new MlInt64(this.lo^x.lo, this.mi^x.mi, this.hi^x.hi);\n}\nMlInt64.prototype.shift_left = function (s) {\n  s = s & 63;\n  if (s == 0) return this;\n  if (s < 24) {\n    return new MlInt64 (this.lo << s,\n                        (this.mi << s) | (this.lo >> (24 - s)),\n                        (this.hi << s) | (this.mi >> (24 - s)));\n  }\n  if (s < 48)\n    return new MlInt64 (0,\n                        this.lo << (s - 24),\n                        (this.mi << (s - 24)) | (this.lo >> (48 - s)));\n  return new MlInt64(0, 0, this.lo << (s - 48))\n}\nMlInt64.prototype.shift_right_unsigned = function (s) {\n  s = s & 63;\n  if (s == 0) return this;\n  if (s < 24)\n    return new MlInt64 (\n      (this.lo >> s) | (this.mi << (24 - s)),\n      (this.mi >> s) | (this.hi << (24 - s)),\n      (this.hi >> s));\n  if (s < 48)\n    return new MlInt64 (\n      (this.mi >> (s - 24)) | (this.hi << (48 - s)),\n      (this.hi >> (s - 24)),\n      0);\n  return new MlInt64 (this.hi >> (s - 48), 0, 0);\n}\nMlInt64.prototype.shift_right = function (s) {\n  s = s & 63;\n  if (s == 0) return this;\n  var h = (this.hi << 16) >> 16;\n  if (s < 24)\n    return new MlInt64 (\n      (this.lo >> s) | (this.mi << (24 - s)),\n      (this.mi >> s) | (h << (24 - s)),\n      ((this.hi << 16) >> s) >>> 16);\n  var sign = (this.hi << 16) >> 31;\n  if (s < 48)\n    return new MlInt64 (\n      (this.mi >> (s - 24)) | (this.hi << (48 - s)),\n      (this.hi << 16) >> (s - 24) >> 16,\n      sign & 0xffff);\n  return new MlInt64 ((this.hi << 16) >> (s - 32), sign, sign);\n}\nMlInt64.prototype.lsl1 = function () {\n  this.hi = (this.hi << 1) | (this.mi >> 23);\n  this.mi = ((this.mi << 1) | (this.lo >> 23)) & 0xffffff;\n  this.lo = (this.lo << 1) & 0xffffff;\n}\nMlInt64.prototype.lsr1 = function () {\n  this.lo = ((this.lo >>> 1) | (this.mi << 23)) & 0xffffff;\n  this.mi = ((this.mi >>> 1) | (this.hi << 23)) & 0xffffff;\n  this.hi = this.hi >>> 1;\n}\nMlInt64.prototype.udivmod = function (x) {\n  var offset = 0;\n  var modulus = this.copy();\n  var divisor = x.copy();\n  var quotient = new MlInt64(0,0,0);\n  while (modulus.ucompare(divisor) > 0) {\n    offset++;\n    divisor.lsl1();\n  }\n  while (offset >= 0) {\n    offset --;\n    quotient.lsl1();\n    if (modulus.ucompare(divisor) >= 0) {\n      quotient.lo ++;\n      modulus = modulus.sub(divisor);\n    }\n    divisor.lsr1();\n  }\n  return { quotient : quotient, modulus : modulus };\n}\nMlInt64.prototype.div = function (y)\n{\n  var x = this;\n  if (y.isZero()) caml_raise_zero_divide ();\n  var sign = x.hi ^ y.hi;\n  if (x.hi & 0x8000) x = x.neg();\n  if (y.hi & 0x8000) y = y.neg();\n  var q = x.udivmod(y).quotient;\n  if (sign & 0x8000) q = q.neg();\n  return q;\n}\nMlInt64.prototype.mod = function (y)\n{\n  var x = this;\n  if (y.isZero()) caml_raise_zero_divide ();\n  var sign = x.hi;\n  if (x.hi & 0x8000) x = x.neg();\n  if (y.hi & 0x8000) y = y.neg();\n  var r = x.udivmod(y).modulus;\n  if (sign & 0x8000) r = r.neg();\n  return r;\n}\nMlInt64.prototype.toInt = function () {\n  return this.lo | (this.mi << 24);\n}\nMlInt64.prototype.toFloat = function () {\n  return ((this.hi << 16) * Math.pow(2, 32) + this.mi * Math.pow(2, 24)) + this.lo;\n}\nMlInt64.prototype.toArray = function () {\n  return [this.hi >> 8,\n          this.hi & 0xff,\n          this.mi >> 16,\n          (this.mi >> 8) & 0xff,\n          this.mi & 0xff,\n          this.lo >> 16,\n          (this.lo >> 8) & 0xff,\n          this.lo & 0xff];\n}\nMlInt64.prototype.lo32 = function () {\n  return this.lo | ((this.mi & 0xff) << 24);\n}\nMlInt64.prototype.hi32 = function () {\n  return ((this.mi >>> 8) & 0xffff) | (this.hi << 16);\n}\n\n//Provides: caml_int64_ult const\nfunction caml_int64_ult(x,y) { return x.ucompare(y) < 0; }\n\n//Provides: caml_int64_compare const\nfunction caml_int64_compare(x,y, total) { return x.compare(y) }\n\n//Provides: caml_int64_neg const\nfunction caml_int64_neg (x) { return x.neg() }\n\n//Provides: caml_int64_add const\nfunction caml_int64_add (x, y) { return x.add(y) }\n\n//Provides: caml_int64_sub const\nfunction caml_int64_sub (x, y) { return x.sub(y) }\n\n//Provides: caml_int64_mul const\n//Requires: caml_int64_offset\nfunction caml_int64_mul(x,y) { return x.mul(y) }\n\n//Provides: caml_int64_is_zero const\nfunction caml_int64_is_zero(x) { return +x.isZero(); }\n\n//Provides: caml_int64_is_negative const\nfunction caml_int64_is_negative(x) { return +x.isNeg(); }\n\n//Provides: caml_int64_and const\nfunction caml_int64_and (x, y) { return x.and(y); }\n\n//Provides: caml_int64_or const\nfunction caml_int64_or (x, y) { return x.or(y); }\n\n//Provides: caml_int64_xor const\nfunction caml_int64_xor (x, y) { return x.xor(y) }\n\n//Provides: caml_int64_shift_left const\nfunction caml_int64_shift_left (x, s) { return x.shift_left(s) }\n\n//Provides: caml_int64_shift_right_unsigned const\nfunction caml_int64_shift_right_unsigned (x, s) { return x.shift_right_unsigned(s) }\n\n//Provides: caml_int64_shift_right const\nfunction caml_int64_shift_right (x, s) { return x.shift_right(s) }\n\n//Provides: caml_int64_div const\nfunction caml_int64_div (x, y) { return x.div(y) }\n\n//Provides: caml_int64_mod const\nfunction caml_int64_mod (x, y) { return x.mod(y) }\n\n//Provides: caml_int64_of_int32 const\n//Requires: MlInt64\nfunction caml_int64_of_int32 (x) {\n  return new MlInt64(x & 0xffffff, (x >> 24) & 0xffffff, (x >> 31) & 0xffff)\n}\n\n//Provides: caml_int64_to_int32 const\nfunction caml_int64_to_int32 (x) { return x.toInt() }\n\n//Provides: caml_int64_to_float const\nfunction caml_int64_to_float (x) { return x.toFloat () }\n\n//Provides: caml_int64_of_float const\n//Requires: caml_int64_offset, MlInt64\nfunction caml_int64_of_float (x) {\n  if (x < 0) x = Math.ceil(x);\n  return new MlInt64(\n    x & 0xffffff,\n    Math.floor(x * caml_int64_offset) & 0xffffff,\n    Math.floor(x * caml_int64_offset * caml_int64_offset) & 0xffff);\n}\n\n//Provides: caml_int64_format const\n//Requires: caml_parse_format, caml_finish_formatting\n//Requires: caml_int64_is_negative, caml_int64_neg\n//Requires: caml_int64_of_int32, caml_int64_to_int32\n//Requires: caml_int64_is_zero, caml_str_repeat\nfunction caml_int64_format (fmt, x) {\n  var f = caml_parse_format(fmt);\n  if (f.signedconv && caml_int64_is_negative(x)) {\n    f.sign = -1; x = caml_int64_neg(x);\n  }\n  var buffer = \"\";\n  var wbase = caml_int64_of_int32(f.base);\n  var cvtbl = \"0123456789abcdef\";\n  do {\n    var p = x.udivmod(wbase);\n    x = p.quotient;\n    buffer = cvtbl.charAt(caml_int64_to_int32(p.modulus)) + buffer;\n  } while (! caml_int64_is_zero(x));\n  if (f.prec >= 0) {\n    f.filler = ' ';\n    var n = f.prec - buffer.length;\n    if (n > 0) buffer = caml_str_repeat (n, '0') + buffer;\n  }\n  return caml_finish_formatting(f, buffer);\n}\n\n//Provides: caml_int64_of_string\n//Requires: caml_parse_sign_and_base, caml_failwith, caml_parse_digit\n//Requires: caml_int64_of_int32, caml_int64_ult\n//Requires: caml_int64_add, caml_int64_mul, caml_int64_neg\n//Requires: caml_ml_string_length,caml_string_unsafe_get, MlInt64\nfunction caml_int64_of_string(s) {\n  var r = caml_parse_sign_and_base (s);\n  var i = r[0], sign = r[1], base = r[2];\n  var base64 = caml_int64_of_int32(base);\n  var threshold =\n      new MlInt64(0xffffff, 0xfffffff, 0xffff).udivmod(base64).quotient;\n  var c = caml_string_unsafe_get(s, i);\n  var d = caml_parse_digit(c);\n  if (d < 0 || d >= base) caml_failwith(\"int_of_string\");\n  var res = caml_int64_of_int32(d);\n  for (;;) {\n    i++;\n    c = caml_string_unsafe_get(s, i);\n    if (c == 95) continue;\n    d = caml_parse_digit(c);\n    if (d < 0 || d >= base) break;\n    /* Detect overflow in multiplication base * res */\n    if (caml_int64_ult(threshold, res)) caml_failwith(\"int_of_string\");\n    d = caml_int64_of_int32(d);\n    res = caml_int64_add(caml_int64_mul(base64, res), d);\n    /* Detect overflow in addition (base * res) + d */\n    if (caml_int64_ult(res, d)) caml_failwith(\"int_of_string\");\n  }\n  if (i != caml_ml_string_length(s)) caml_failwith(\"int_of_string\");\n  if (base == 10 && caml_int64_ult(new MlInt64(0, 0, 0x8000), res))\n    caml_failwith(\"int_of_string\");\n  if (sign < 0) res = caml_int64_neg(res);\n  return res;\n}\n\n//Provides: caml_int64_create_lo_mi_hi const\n//Requires: MlInt64\nfunction caml_int64_create_lo_mi_hi(lo, mi, hi){\n  return new MlInt64(lo, mi, hi)\n}\n//Provides: caml_int64_create_lo_hi const\n//Requires: MlInt64\nfunction caml_int64_create_lo_hi(lo, hi){\n  return new MlInt64 (\n    lo & 0xffffff,\n    ((lo >>> 24) & 0xff) | ((hi & 0xffff) << 8),\n    (hi >>> 16) & 0xffff);\n}\n//Provides: caml_int64_lo32 const\nfunction caml_int64_lo32(v){ return v.lo32() }\n\n//Provides: caml_int64_hi32 const\nfunction caml_int64_hi32(v){ return v.hi32() }\n\n//Provides: caml_int64_of_bytes const\n//Requires: MlInt64\nfunction caml_int64_of_bytes(a) {\n  return new MlInt64(a[7] << 0 | (a[6] << 8) | (a[5] << 16),\n                     a[4] << 0 | (a[3] << 8) | (a[2] << 16),\n                     a[1] << 0 | (a[0] << 8));\n}\n//Provides: caml_int64_to_bytes const\nfunction caml_int64_to_bytes(x) { return x.toArray() }\n\n//Provides: caml_int64_hash const\nfunction caml_int64_hash(v){\n  return (v.lo32()) ^ (v.hi32())\n}\n"
let internalMod = Js_of_ocaml_compiler.Builtins.register ~name:"internalMod.js" ~content:"// Js_of_ocaml runtime support\n// http://www.ocsigen.org/js_of_ocaml/\n// Copyright (C) 2014 J\195\169r\195\180me Vouillon, Hugo Heuzard\n// Laboratoire PPS - CNRS Universit\195\169 Paris Diderot\n//\n// This program is free software; you can redistribute it and/or modify\n// it under the terms of the GNU Lesser General Public License as published by\n// the Free Software Foundation, with linking exception;\n// either version 2.1 of the License, or (at your option) any later version.\n//\n// This program is distributed in the hope that it will be useful,\n// but WITHOUT ANY WARRANTY; without even the implied warranty of\n// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n// GNU Lesser General Public License for more details.\n//\n// You should have received a copy of the GNU Lesser General Public License\n// along with this program; if not, write to the Free Software\n// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.\n\n//Provides: caml_CamlinternalMod_init_mod\n//Requires: caml_raise_with_arg, caml_global_data\n//Version: < 4.13\nfunction caml_CamlinternalMod_init_mod(loc,shape) {\n  function undef_module (_x) {\n    caml_raise_with_arg(caml_global_data.Undefined_recursive_module, loc);\n  }\n  function loop (shape,struct,idx){\n    if(typeof shape === \"number\")\n      switch(shape){\n      case 0://function\n        struct[idx]={fun:undef_module};\n        break;\n      case 1://lazy\n        struct[idx]=[246, undef_module];\n        break;\n      default://case 2://class\n        struct[idx]=[];\n      }\n    else\n      switch(shape[0]){\n      case 0://module\n        struct[idx] = [0];\n        for(var i=1;i<shape[1].length;i++)\n          loop(shape[1][i],struct[idx],i);\n        break;\n      default://case 1://Value\n        struct[idx] = shape[1];\n      }\n  }\n  var res = [];\n  loop(shape,res,0);\n  return res[0]\n}\n//Provides: caml_CamlinternalMod_update_mod\n//Requires: caml_update_dummy\n//Version: < 4.13\nfunction caml_CamlinternalMod_update_mod(shape,real,x) {\n  if(typeof shape === \"number\")\n    switch(shape){\n    case 0://function\n    case 1://lazy\n    case 2://class\n    default:\n      caml_update_dummy(real,x);\n    }\n  else\n    switch(shape[0]){\n    case 0://module\n      for(var i=1;i<shape[1].length;i++)\n        caml_CamlinternalMod_update_mod(shape[1][i],real[i],x[i]);\n      break;\n      //case 1://Value\n    default:\n    };\n  return 0\n}\n"
let ints = Js_of_ocaml_compiler.Builtins.register ~name:"ints.js" ~content:"// Js_of_ocaml runtime support\n// http://www.ocsigen.org/js_of_ocaml/\n//\n// This program is free software; you can redistribute it and/or modify\n// it under the terms of the GNU Lesser General Public License as published by\n// the Free Software Foundation, with linking exception;\n// either version 2.1 of the License, or (at your option) any later version.\n//\n// This program is distributed in the hope that it will be useful,\n// but WITHOUT ANY WARRANTY; without even the implied warranty of\n// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n// GNU Lesser General Public License for more details.\n//\n// You should have received a copy of the GNU Lesser General Public License\n// along with this program; if not, write to the Free Software\n// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.\n\n//Provides: caml_format_int const (const, const)\n//Requires: caml_parse_format, caml_finish_formatting, caml_str_repeat\n//Requires: caml_string_of_jsbytes, caml_jsbytes_of_string\nfunction caml_format_int(fmt, i) {\n  if (caml_jsbytes_of_string(fmt) == \"%d\") return caml_string_of_jsbytes(\"\"+i);\n  var f = caml_parse_format(fmt);\n  if (i < 0) { if (f.signedconv) { f.sign = -1; i = -i; } else i >>>= 0; }\n  var s = i.toString(f.base);\n  if (f.prec >= 0) {\n    f.filler = ' ';\n    var n = f.prec - s.length;\n    if (n > 0) s = caml_str_repeat (n, '0') + s;\n  }\n  return caml_finish_formatting(f, s);\n}\n\n//Provides: caml_parse_sign_and_base\n//Requires: caml_string_unsafe_get, caml_ml_string_length\nfunction caml_parse_sign_and_base (s) {\n  var i = 0, len = caml_ml_string_length(s), base = 10, sign = 1;\n  if (len > 0) {\n    switch (caml_string_unsafe_get(s,i)) {\n    case 45: i++; sign = -1; break;\n    case 43: i++; sign = 1; break;\n    }\n  }\n  if (i + 1 < len && caml_string_unsafe_get(s, i) == 48)\n    switch (caml_string_unsafe_get(s, i + 1)) {\n    case 120: case 88: base = 16; i += 2; break;\n    case 111: case 79: base =  8; i += 2; break;\n    case  98: case 66: base =  2; i += 2; break;\n    case 117: case 85: i += 2; break;\n    }\n  return [i, sign, base];\n}\n\n//Provides: caml_parse_digit\nfunction caml_parse_digit(c) {\n  if (c >= 48 && c <= 57)  return c - 48;\n  if (c >= 65 && c <= 90)  return c - 55;\n  if (c >= 97 && c <= 122) return c - 87;\n  return -1;\n}\n\n//Provides: caml_int_of_string (const)\n//Requires: caml_ml_string_length, caml_string_unsafe_get\n//Requires: caml_parse_sign_and_base, caml_parse_digit, caml_failwith\nfunction caml_int_of_string (s) {\n  var r = caml_parse_sign_and_base (s);\n  var i = r[0], sign = r[1], base = r[2];\n  var len = caml_ml_string_length(s);\n  var threshold = -1 >>> 0;\n  var c = (i < len)?caml_string_unsafe_get(s, i):0;\n  var d = caml_parse_digit(c);\n  if (d < 0 || d >= base) caml_failwith(\"int_of_string\");\n  var res = d;\n  for (i++;i<len;i++) {\n    c = caml_string_unsafe_get(s, i);\n    if (c == 95) continue;\n    d = caml_parse_digit(c);\n    if (d < 0 || d >= base) break;\n    res = base * res + d;\n    if (res > threshold) caml_failwith(\"int_of_string\");\n  }\n  if (i != len) caml_failwith(\"int_of_string\");\n  // For base different from 10, we expect an unsigned representation,\n  // hence any value of 'res' (less than 'threshold') is acceptable.\n  // But we have to convert the result back to a signed integer.\n  res = sign * res;\n  if ((base == 10) && ((res | 0) != res))\n    /* Signed representation expected, allow -2^(nbits-1) to 2^(nbits-1) - 1 */\n    caml_failwith(\"int_of_string\");\n  return res | 0;\n}\n\n//Provides: caml_mul const\nfunction caml_mul(a,b){\n  return Math.imul(a,b);\n}\n\n//Provides: caml_div\n//Requires: caml_raise_zero_divide\nfunction caml_div(x,y) {\n  if (y == 0) caml_raise_zero_divide ();\n  return (x/y)|0;\n}\n\n//Provides: caml_mod\n//Requires: caml_raise_zero_divide\nfunction caml_mod(x,y) {\n  if (y == 0) caml_raise_zero_divide ();\n  return x%y;\n}\n\n//Provides: caml_bswap16\nfunction caml_bswap16(x) {\n  return ((((x & 0x00FF) << 8) |\n           ((x & 0xFF00) >> 8)));\n}\n//Provides: caml_int32_bswap\nfunction caml_int32_bswap(x) {\n  return (((x & 0x000000FF) << 24) |\n          ((x & 0x0000FF00) << 8) |\n          ((x & 0x00FF0000) >>> 8) |\n          ((x & 0xFF000000) >>> 24));\n}\n//Provides: caml_int64_bswap\n//Requires: caml_int64_to_bytes, caml_int64_of_bytes\nfunction caml_int64_bswap(x) {\n  var y = caml_int64_to_bytes(x);\n  return caml_int64_of_bytes([y[7], y[6], y[5], y[4], y[3], y[2], y[1], y[0]]);\n}\n"
let io = Js_of_ocaml_compiler.Builtins.register ~name:"io.js" ~content:"// Js_of_ocaml runtime support\n// http://www.ocsigen.org/js_of_ocaml/\n// Copyright (C) 2014 J\195\169r\195\180me Vouillon, Hugo Heuzard\n// Laboratoire PPS - CNRS Universit\195\169 Paris Diderot\n//\n// This program is free software; you can redistribute it and/or modify\n// it under the terms of the GNU Lesser General Public License as published by\n// the Free Software Foundation, with linking exception;\n// either version 2.1 of the License, or (at your option) any later version.\n//\n// This program is distributed in the hope that it will be useful,\n// but WITHOUT ANY WARRANTY; without even the implied warranty of\n// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n// GNU Lesser General Public License for more details.\n//\n// You should have received a copy of the GNU Lesser General Public License\n// along with this program; if not, write to the Free Software\n// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.\n\n///////////// Io\n\n//Provides: caml_sys_close\n//Requires: caml_global_data\nfunction caml_sys_close(fd) {\n  delete caml_global_data.fds[fd];\n  return 0;\n}\n\n//Provides: caml_std_output\n//Requires: caml_string_of_jsbytes, caml_ml_string_length, caml_ml_channels\nfunction caml_std_output(chanid,s){\n  var chan = caml_ml_channels[chanid];\n  var str = caml_string_of_jsbytes(s);\n  var slen = caml_ml_string_length(str);\n  chan.file.write(chan.offset, str, 0, slen);\n  chan.offset += slen;\n  return 0;\n}\n\n//Provides: caml_sys_open\n//Requires: caml_raise_sys_error, caml_global_data\n//Requires: caml_create_bytes,MlFakeFile\n//Requires: js_print_stderr, js_print_stdout\n//Requires: caml_std_output\n//Requires: resolve_fs_device\n//Requires: caml_jsbytes_of_string\nfunction caml_sys_open_internal(idx,output,file,flags) {\n  if(caml_global_data.fds === undefined) caml_global_data.fds = new Array();\n  flags=flags?flags:{};\n  var info = {};\n  info.file = file;\n  info.offset = flags.append?file.length():0;\n  info.flags = flags;\n  info.output = output;\n  caml_global_data.fds[idx] = info;\n  if(!caml_global_data.fd_last_idx || idx > caml_global_data.fd_last_idx)\n    caml_global_data.fd_last_idx = idx;\n  return idx;\n}\nfunction caml_sys_open (name, flags, _perms) {\n  var f = {};\n  while(flags){\n    switch(flags[1]){\n    case 0: f.rdonly = 1;break;\n    case 1: f.wronly = 1;break;\n    case 2: f.append = 1;break;\n    case 3: f.create = 1;break;\n    case 4: f.truncate = 1;break;\n    case 5: f.excl = 1; break;\n    case 6: f.binary = 1;break;\n    case 7: f.text = 1;break;\n    case 8: f.nonblock = 1;break;\n    }\n    flags=flags[2];\n  }\n  if(f.rdonly && f.wronly)\n    caml_raise_sys_error(caml_jsbytes_of_string(name) + \" : flags Open_rdonly and Open_wronly are not compatible\");\n  if(f.text && f.binary)\n    caml_raise_sys_error(caml_jsbytes_of_string(name) + \" : flags Open_text and Open_binary are not compatible\");\n  var root = resolve_fs_device(name);\n  var file = root.device.open(root.rest,f);\n  var idx = caml_global_data.fd_last_idx?caml_global_data.fd_last_idx:0;\n  return caml_sys_open_internal (idx+1,caml_std_output,file,f);\n}\ncaml_sys_open_internal(0,caml_std_output, new MlFakeFile(caml_create_bytes(0))); //stdin\ncaml_sys_open_internal(1,js_print_stdout, new MlFakeFile(caml_create_bytes(0))); //stdout\ncaml_sys_open_internal(2,js_print_stderr, new MlFakeFile(caml_create_bytes(0))); //stderr\n\n\n// ocaml Channels\n\n//Provides: caml_ml_set_channel_name\nfunction caml_ml_set_channel_name() {\n  return 0\n}\n\n//Provides: caml_ml_channels\nvar caml_ml_channels = new Array();\n\n//Provides: caml_ml_out_channels_list\n//Requires: caml_ml_channels\nfunction caml_ml_out_channels_list () {\n  var l = 0;\n  for(var c = 0; c < caml_ml_channels.length; c++){\n    if(caml_ml_channels[c] && caml_ml_channels[c].opened && caml_ml_channels[c].out)\n      l=[0,caml_ml_channels[c].fd,l];\n  }\n  return l;\n}\n\n\n//Provides: caml_ml_open_descriptor_out\n//Requires: caml_ml_channels, caml_global_data\n//Requires: caml_raise_sys_error\nfunction caml_ml_open_descriptor_out (fd) {\n  var data = caml_global_data.fds[fd];\n  if(data.flags.rdonly) caml_raise_sys_error(\"fd \"+ fd + \" is readonly\");\n  var channel = {\n    file:data.file,\n    offset:data.offset,\n    fd:fd,\n    opened:true,\n    out:true,\n    buffer:\"\"\n  };\n  caml_ml_channels[channel.fd]=channel;\n  return channel.fd;\n}\n\n//Provides: caml_ml_open_descriptor_in\n//Requires: caml_global_data,caml_sys_open,caml_raise_sys_error, caml_ml_channels\n//Requires: fs_node_supported, caml_string_of_jsstring\nfunction caml_ml_open_descriptor_in (fd)  {\n  var data = caml_global_data.fds[fd];\n  if(data.flags.wronly) caml_raise_sys_error(\"fd \"+ fd + \" is writeonly\");\n  var refill = null;\n  if(fd == 0 && fs_node_supported()){\n    var fs = require('fs');\n    refill = function () {\n      return caml_string_of_jsstring(fs.readFileSync(0, 'utf8'))};\n  }\n  var channel = {\n    file:data.file,\n    offset:data.offset,\n    fd:fd,\n    opened:true,\n    out: false,\n    refill:refill\n  };\n  caml_ml_channels[channel.fd]=channel;\n  return channel.fd;\n}\n\n\n//Provides: caml_channel_descriptor\n//Requires: caml_global_data, caml_ml_channels\nfunction caml_channel_descriptor(chanid){\n  var chan = caml_ml_channels[chanid];\n  return chan.fd;\n}\n\n//Provides: win_filedescr_of_channel\n//Requires: caml_channel_descriptor\nvar win_filedescr_of_channel = caml_channel_descriptor\n\n//Provides: caml_ml_set_binary_mode\n//Requires: caml_global_data, caml_ml_channels\nfunction caml_ml_set_binary_mode(chanid,mode){\n  var chan = caml_ml_channels[chanid];\n  var data = caml_global_data.fds[chan.fd];\n  data.flags.text = !mode\n  data.flags.binary = mode\n  return 0;\n}\n\n//Input from in_channel\n\n//Provides: caml_ml_close_channel\n//Requires: caml_ml_flush, caml_ml_channels\n//Requires: caml_sys_close\nfunction caml_ml_close_channel (chanid) {\n  var chan = caml_ml_channels[chanid];\n  caml_ml_flush(chanid);\n  chan.opened = false;\n  chan.file.close();\n  caml_sys_close(chan.fd)\n  return 0;\n}\n\n//Provides: caml_ml_channel_size\n//Requires: caml_ml_channels\nfunction caml_ml_channel_size(chanid) {\n  var chan = caml_ml_channels[chanid];\n  return chan.file.length();\n}\n\n//Provides: caml_ml_channel_size_64\n//Requires: caml_int64_of_float,caml_ml_channels\nfunction caml_ml_channel_size_64(chanid) {\n  var chan = caml_ml_channels[chanid];\n  return caml_int64_of_float(chan.file.length ());\n}\n\n//Provides: caml_ml_set_channel_output\n//Requires: caml_ml_channels, caml_global_data\nfunction caml_ml_set_channel_output(chanid,f) {\n  var chan = caml_ml_channels[chanid];\n  caml_global_data.fds[chan.fd].output = f;\n  return 0;\n}\n\n//Provides: caml_ml_set_channel_refill\n//Requires: caml_ml_channels, caml_global_data\nfunction caml_ml_set_channel_refill(chanid,f) {\n  caml_ml_channels[chanid].refill = f;\n  return 0;\n}\n\n//Provides: caml_ml_refill_input\n//Requires: caml_ml_string_length\nfunction caml_ml_refill_input (chan) {\n  var str = chan.refill();\n  var str_len = caml_ml_string_length(str);\n  if (str_len == 0) chan.refill = null;\n  chan.file.write(chan.file.length(), str, 0, str_len);\n  return str_len;\n}\n\n//Provides: caml_ml_may_refill_input\n//Requires: caml_ml_refill_input, caml_ml_channels\nfunction caml_ml_may_refill_input (chanid) {\n  var chan = caml_ml_channels[chanid];\n  if (chan.refill == null) return;\n  if (chan.file.length() != chan.offset) return;\n  caml_ml_refill_input (chan);\n}\n\n//Provides: caml_ml_input\n//Requires: caml_ml_refill_input, caml_ml_channels\nfunction caml_ml_input (chanid, s, i, l) {\n  var chan = caml_ml_channels[chanid];\n  var l2 = chan.file.length() - chan.offset;\n  if (l2 == 0 && chan.refill != null) l2 = caml_ml_refill_input(chan);\n  if (l2 < l) l = l2;\n  chan.file.read(chan.offset, s, i, l);\n  chan.offset += l;\n  return l;\n}\n\n//Provides: caml_input_value\n//Requires: caml_marshal_data_size, caml_input_value_from_bytes, caml_create_bytes, caml_ml_channels\nfunction caml_input_value (chanid) {\n  var chan = caml_ml_channels[chanid];\n\n  var buf = caml_create_bytes(8);\n  chan.file.read(chan.offset,buf,0,8);\n\n  // Header is 20 bytes\n  var len = caml_marshal_data_size (buf, 0) + 20;\n\n  var buf = caml_create_bytes(len);\n  chan.file.read(chan.offset,buf,0,len);\n\n  var offset = [0];\n  var res = caml_input_value_from_bytes(buf, offset);\n  chan.offset = chan.offset + offset[0];\n  return res;\n}\n\n//Provides: caml_ml_input_char\n//Requires: caml_raise_end_of_file, caml_array_bound_error\n//Requires: caml_ml_may_refill_input, caml_ml_channels\nfunction caml_ml_input_char (chanid) {\n  var chan = caml_ml_channels[chanid];\n  caml_ml_may_refill_input(chanid);\n  if (chan.offset >= chan.file.length())\n    caml_raise_end_of_file();\n  var res = chan.file.read_one(chan.offset);\n  chan.offset++;\n  return res;\n}\n\n//Provides: caml_ml_input_int\n//Requires: caml_raise_end_of_file\n//Requires: caml_ml_refill_input, caml_ml_channels\nfunction caml_ml_input_int (chanid) {\n  var chan = caml_ml_channels[chanid];\n  var file = chan.file;\n  while ((chan.offset + 3) >= file.length()) {\n    var l = caml_ml_refill_input(chan);\n    if (l == 0) caml_raise_end_of_file();\n  }\n  var o = chan.offset;\n  var r =(file.read_one(o  ) << 24)\n      |  (file.read_one(o+1) << 16)\n      |  (file.read_one(o+2) << 8)\n      |  (file.read_one(o+3));\n  chan.offset+=4;\n  return r;\n}\n\n//Provides: caml_ml_seek_in\n//Requires: caml_raise_sys_error, caml_ml_channels\nfunction caml_ml_seek_in(chanid,pos){\n  var chan = caml_ml_channels[chanid];\n  if (chan.refill != null) caml_raise_sys_error(\"Illegal seek\");\n  chan.offset = pos;\n  return 0;\n}\n\n//Provides: caml_ml_seek_in_64\n//Requires: caml_int64_to_float, caml_raise_sys_error, caml_ml_channels\nfunction caml_ml_seek_in_64(chanid,pos){\n  var chan = caml_ml_channels[chanid];\n  if (chan.refill != null) caml_raise_sys_error(\"Illegal seek\");\n  chan.offset = caml_int64_to_float(pos);\n  return 0;\n}\n\n//Provides: caml_ml_pos_in\n//Requires: caml_ml_channels\nfunction caml_ml_pos_in(chanid) {return caml_ml_channels[chanid].offset}\n\n//Provides: caml_ml_pos_in_64\n//Requires: caml_int64_of_float, caml_ml_channels\nfunction caml_ml_pos_in_64(chanid) {return caml_int64_of_float(caml_ml_channels[chanid].offset)}\n\n//Provides: caml_ml_input_scan_line\n//Requires: caml_array_bound_error\n//Requires: caml_ml_may_refill_input, caml_ml_channels\nfunction caml_ml_input_scan_line(chanid){\n  var chan = caml_ml_channels[chanid];\n  caml_ml_may_refill_input(chanid);\n  var p = chan.offset;\n  var len = chan.file.length();\n  if(p >= len) { return 0;}\n  while(true) {\n    if(p >= len) return - (p - chan.offset);\n    if(chan.file.read_one(p) == 10) return p - chan.offset + 1;\n    p++;\n  }\n}\n\n//Provides: caml_ml_flush\n//Requires: caml_raise_sys_error, caml_global_data, caml_ml_channels\nfunction caml_ml_flush (chanid) {\n  var chan = caml_ml_channels[chanid];\n  if(! chan.opened) caml_raise_sys_error(\"Cannot flush a closed channel\");\n  if(!chan.buffer || chan.buffer == \"\") return 0;\n  if(chan.fd\n     && caml_global_data.fds[chan.fd]\n     && caml_global_data.fds[chan.fd].output) {\n    var output = caml_global_data.fds[chan.fd].output;\n    switch(output.length){\n    case 2: output(chanid,chan.buffer);break;\n    default: output(chan.buffer)\n    };\n  }\n  chan.buffer = \"\";\n  return 0;\n}\n\n//output to out_channel\n\n//Provides: caml_ml_output_bytes\n//Requires: caml_ml_flush,caml_ml_bytes_length\n//Requires: caml_create_bytes, caml_blit_bytes, caml_raise_sys_error, caml_ml_channels, caml_string_of_bytes\n//Requires: caml_jsbytes_of_string\nfunction caml_ml_output_bytes(chanid,buffer,offset,len) {\n  var chan = caml_ml_channels[chanid];\n  if(! chan.opened) caml_raise_sys_error(\"Cannot output to a closed channel\");\n  var bytes;\n  if(offset == 0 && caml_ml_bytes_length(buffer) == len)\n    bytes = buffer;\n  else {\n    bytes = caml_create_bytes(len);\n    caml_blit_bytes(buffer,offset,bytes,0,len);\n  }\n  var string = caml_string_of_bytes(bytes);\n  var jsstring = caml_jsbytes_of_string(string);\n  var id = jsstring.lastIndexOf(\"\\n\");\n  if(id < 0)\n    chan.buffer+=jsstring;\n  else {\n    chan.buffer+=jsstring.substr(0,id+1);\n    caml_ml_flush (chanid);\n    chan.buffer += jsstring.substr(id+1);\n  }\n  return 0;\n}\n\n//Provides: caml_ml_output\n//Requires: caml_ml_output_bytes, caml_bytes_of_string\nfunction caml_ml_output(chanid,buffer,offset,len){\n  return caml_ml_output_bytes(chanid,caml_bytes_of_string(buffer),offset,len);\n}\n\n//Provides: caml_ml_output_char\n//Requires: caml_ml_output\n//Requires: caml_string_of_jsbytes\nfunction caml_ml_output_char (chanid,c) {\n  var s = caml_string_of_jsbytes(String.fromCharCode(c));\n  caml_ml_output(chanid,s,0,1);\n  return 0;\n}\n\n//Provides: caml_output_value\n//Requires: caml_output_value_to_string, caml_ml_output,caml_ml_string_length\nfunction caml_output_value (chanid,v,flags) {\n  var s = caml_output_value_to_string(v, flags);\n  caml_ml_output(chanid,s,0,caml_ml_string_length(s));\n  return 0;\n}\n\n\n//Provides: caml_ml_seek_out\n//Requires: caml_ml_channels, caml_ml_flush\nfunction caml_ml_seek_out(chanid,pos){\n  caml_ml_flush(chanid);\n  caml_ml_channels[chanid].offset = pos;\n  return 0;\n}\n\n//Provides: caml_ml_seek_out_64\n//Requires: caml_int64_to_float, caml_ml_channels, caml_ml_flush\nfunction caml_ml_seek_out_64(chanid,pos){\n  caml_ml_flush(chanid);\n  caml_ml_channels[chanid].offset = caml_int64_to_float(pos);\n  return 0;\n}\n\n//Provides: caml_ml_pos_out\n//Requires: caml_ml_channels, caml_ml_flush\nfunction caml_ml_pos_out(chanid) {\n  caml_ml_flush(chanid);\n  return caml_ml_channels[chanid].offset\n}\n\n//Provides: caml_ml_pos_out_64\n//Requires: caml_int64_of_float, caml_ml_channels, caml_ml_flush\nfunction caml_ml_pos_out_64(chanid) {\n  caml_ml_flush(chanid);\n  return caml_int64_of_float (caml_ml_channels[chanid].offset);\n}\n\n//Provides: caml_ml_output_int\n//Requires: caml_ml_output\n//Requires: caml_string_of_array\nfunction caml_ml_output_int (chanid,i) {\n  var arr = [(i>>24) & 0xFF,(i>>16) & 0xFF,(i>>8) & 0xFF,i & 0xFF ];\n  var s = caml_string_of_array(arr);\n  caml_ml_output(chanid,s,0,4);\n  return 0\n}\n\n//Provides: caml_ml_is_buffered\nfunction caml_ml_is_buffered(c) { return 1 }\n\n//Provides: caml_ml_set_buffered\nfunction caml_ml_set_buffered(c,v) { return 0 }\n"
let jslib = Js_of_ocaml_compiler.Builtins.register ~name:"jslib.js" ~content:"// Js_of_ocaml library\n// http://www.ocsigen.org/js_of_ocaml/\n// Copyright (C) 2010 J\195\169r\195\180me Vouillon\n// Laboratoire PPS - CNRS Universit\195\169 Paris Diderot\n//\n// This program is free software; you can redistribute it and/or modify\n// it under the terms of the GNU Lesser General Public License as published by\n// the Free Software Foundation, with linking exception;\n// either version 2.1 of the License, or (at your option) any later version.\n//\n// This program is distributed in the hope that it will be useful,\n// but WITHOUT ANY WARRANTY; without even the implied warranty of\n// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n// GNU Lesser General Public License for more details.\n//\n// You should have received a copy of the GNU Lesser General Public License\n// along with this program; if not, write to the Free Software\n// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.\n\n///////////// Jslib\n\n//Provides: caml_js_pure_expr const\nfunction caml_js_pure_expr (f) { return f(); }\n\n//Provides: caml_js_set (mutable, const, const)\nfunction caml_js_set(o,f,v) { o[f]=v;return 0}\n//Provides: caml_js_get mutable (const, const)\nfunction caml_js_get(o,f) { return o[f]; }\n//Provides: caml_js_delete (mutable, const)\nfunction caml_js_delete(o,f) { delete o[f]; return 0}\n\n//Provides: caml_js_instanceof (const, const)\nfunction caml_js_instanceof(o,c) { return (o instanceof c) ? 1 : 0; }\n\n//Provides: caml_js_typeof (const)\nfunction caml_js_typeof(o) { return typeof o; }\n\n//Provides:caml_trampoline\nfunction caml_trampoline(res) {\n  var c = 1;\n  while(res && res.joo_tramp){\n    res = res.joo_tramp.apply(null, res.joo_args);\n    c++;\n  }\n  return res;\n}\n\n//Provides:caml_trampoline_return\nfunction caml_trampoline_return(f,args) {\n  return {joo_tramp:f,joo_args:args};\n}\n\n//Provides: js_print_stdout (const)\n//Requires: caml_utf16_of_utf8\nfunction js_print_stdout(s) {\n  var s = caml_utf16_of_utf8(s);\n  var g = globalThis;\n  if (g.process && g.process.stdout && g.process.stdout.write) {\n    g.process.stdout.write(s)\n  } else {\n    // Do not output the last \\n if present\n    // as console logging display a newline at the end\n    if(s.charCodeAt(s.length - 1) == 10)\n      s = s.substr(0,s.length - 1 );\n    var v = g.console;\n    v  && v.log && v.log(s);\n  }\n}\n//Provides: js_print_stderr (const)\n//Requires: caml_utf16_of_utf8\nfunction js_print_stderr(s) {\n  var s = caml_utf16_of_utf8(s);\n  var g = globalThis;\n  if (g.process && g.process.stdout && g.process.stdout.write) {\n    g.process.stderr.write(s)\n  } else {\n    // Do not output the last \\n if present\n    // as console logging display a newline at the end\n    if(s.charCodeAt(s.length - 1) == 10)\n      s = s.substr(0,s.length - 1 );\n    var v = g.console;\n    v && v.error && v.error(s);\n  }\n}\n\n//Provides: caml_is_js\nfunction caml_is_js() {\n  return 1;\n}\n\n//Provides: caml_wrap_exception const (const)\n//Requires: caml_global_data,caml_string_of_jsstring,caml_named_value\n//Requires: caml_return_exn_constant\nfunction caml_wrap_exception(e) {\n  if(e instanceof Array) return e;\n  //Stack_overflow: chrome, safari\n  if(globalThis.RangeError\n     && e instanceof globalThis.RangeError\n     && e.message\n     && e.message.match(/maximum call stack/i))\n    return caml_return_exn_constant(caml_global_data.Stack_overflow);\n  //Stack_overflow: firefox\n  if(globalThis.InternalError\n     && e instanceof globalThis.InternalError\n     && e.message\n     && e.message.match(/too much recursion/i))\n    return caml_return_exn_constant(caml_global_data.Stack_overflow);\n  //Wrap Error in Js.Error exception\n  if(e instanceof globalThis.Error && caml_named_value(\"jsError\"))\n    return [0,caml_named_value(\"jsError\"),e];\n  //fallback: wrapped in Failure\n  return [0,caml_global_data.Failure,caml_string_of_jsstring (String(e))];\n}\n\n// Experimental\n//Provides: caml_exn_with_js_backtrace\n//Requires: caml_global_data\nfunction caml_exn_with_js_backtrace(exn, force) {\n  //never reraise for constant exn\n  if(!exn.js_error || force || exn[0] == 248) exn.js_error = new globalThis.Error(\"Js exception containing backtrace\");\n  return exn;\n}\n\n\n//Provides: caml_js_error_option_of_exception\nfunction caml_js_error_option_of_exception(exn) {\n  if(exn.js_error) { return [0, exn.js_error]; }\n  return 0;\n}\n\n\n\n//Provides: caml_js_from_bool const (const)\nfunction caml_js_from_bool(x) { return !!x; }\n//Provides: caml_js_to_bool const (const)\nfunction caml_js_to_bool(x) { return +x; }\n//Provides: caml_js_from_float const (const)\nfunction caml_js_from_float(x) { return x; }\n//Provides: caml_js_to_float const (const)\nfunction caml_js_to_float(x) { return x; }\n\n//Provides: caml_js_from_array mutable (shallow)\nfunction caml_js_from_array(a) {\n  return a.slice(1);\n}\n//Provides: caml_js_to_array mutable (shallow)\nfunction caml_js_to_array(a) {\n  var len = a.length;\n  var b = new Array(len+1);\n  b[0] = 0;\n  for(var i=0;i<len;i++) b[i+1] = a[i];\n  return b;\n}\n\n//Provides: caml_list_of_js_array const (const)\nfunction caml_list_of_js_array(a){\n  var l = 0;\n  for(var i=a.length - 1; i>=0; i--){\n    var e = a[i];\n    l = [0,e,l];\n  }\n  return l\n}\n\n//Provides: caml_list_to_js_array const (const)\nfunction caml_list_to_js_array(l){\n  var a = [];\n  for(; l !== 0; l = l[2]) {\n    a.push(l[1]);\n  }\n  return a;\n}\n\n//Provides: caml_js_var mutable (const)\n//Requires: js_print_stderr\n//Requires: caml_jsstring_of_string\nfunction caml_js_var(x) {\n  var x = caml_jsstring_of_string(x);\n  //Checks that x has the form ident[.ident]*\n  if(!x.match(/^[a-zA-Z_$][a-zA-Z_$0-9]*(\\.[a-zA-Z_$][a-zA-Z_$0-9]*)*$/)){\n    js_print_stderr(\"caml_js_var: \\\"\" + x + \"\\\" is not a valid JavaScript variable. continuing ..\");\n    //globalThis.console.error(\"Js.Unsafe.eval_string\")\n  }\n  return eval(x);\n}\n//Provides: caml_js_call (const, mutable, shallow)\n//Requires: caml_js_from_array\nfunction caml_js_call(f, o, args) { return f.apply(o, caml_js_from_array(args)); }\n//Provides: caml_js_fun_call (const, shallow)\n//Requires: caml_js_from_array\nfunction caml_js_fun_call(f, a) {\n  switch (a.length) {\n  case 1: return f();\n  case 2: return f (a[1]);\n  case 3: return f (a[1],a[2]);\n  case 4: return f (a[1],a[2],a[3]);\n  case 5: return f (a[1],a[2],a[3],a[4]);\n  case 6: return f (a[1],a[2],a[3],a[4],a[5]);\n  case 7: return f (a[1],a[2],a[3],a[4],a[5],a[6]);\n  case 8: return f (a[1],a[2],a[3],a[4],a[5],a[6],a[7]);\n  }\n  return f.apply(null, caml_js_from_array(a));\n}\n//Provides: caml_js_meth_call (mutable, const, shallow)\n//Requires: caml_jsstring_of_string\n//Requires: caml_js_from_array\nfunction caml_js_meth_call(o, f, args) {\n  return o[caml_jsstring_of_string(f)].apply(o, caml_js_from_array(args));\n}\n//Provides: caml_js_new (const, shallow)\n//Requires: caml_js_from_array\nfunction caml_js_new(c, a) {\n  switch (a.length) {\n  case 1: return new c;\n  case 2: return new c (a[1]);\n  case 3: return new c (a[1],a[2]);\n  case 4: return new c (a[1],a[2],a[3]);\n  case 5: return new c (a[1],a[2],a[3],a[4]);\n  case 6: return new c (a[1],a[2],a[3],a[4],a[5]);\n  case 7: return new c (a[1],a[2],a[3],a[4],a[5],a[6]);\n  case 8: return new c (a[1],a[2],a[3],a[4],a[5],a[6],a[7]);\n  }\n  function F() { return c.apply(this, caml_js_from_array(a)); }\n  F.prototype = c.prototype;\n  return new F;\n}\n//Provides: caml_ojs_new_arr (const, shallow)\n//Requires: caml_js_from_array\nfunction caml_ojs_new_arr(c, a) {\n  switch (a.length) {\n  case 0: return new c;\n  case 1: return new c (a[0]);\n  case 2: return new c (a[0],a[1]);\n  case 3: return new c (a[0],a[1],a[2]);\n  case 4: return new c (a[0],a[1],a[2],a[3]);\n  case 5: return new c (a[0],a[1],a[2],a[3],a[4]);\n  case 6: return new c (a[0],a[1],a[2],a[3],a[4],a[5]);\n  case 7: return new c (a[0],a[1],a[2],a[3],a[4],a[5],a[6]);\n  }\n  function F() { return c.apply(this, a); }\n  F.prototype = c.prototype;\n  return new F;\n}\n//Provides: caml_js_wrap_callback const (const)\n//Requires: caml_call_gen\nfunction caml_js_wrap_callback(f) {\n  return function () {\n    var len = arguments.length;\n    if(len > 0){\n      var args = new Array(len);\n      for (var i = 0; i < len; i++) args[i] = arguments[i];\n      return caml_call_gen(f, args);\n    } else {\n      return caml_call_gen(f, [undefined]);\n    }\n  }\n}\n\n//Provides: caml_js_wrap_callback_arguments\n//Requires: caml_call_gen\nfunction caml_js_wrap_callback_arguments(f) {\n  return function() {\n    var len = arguments.length;\n    var args = new Array(len);\n    for (var i = 0; i < len; i++) args[i] = arguments[i];\n    return caml_call_gen(f, [args]);\n  }\n}\n//Provides: caml_js_wrap_callback_strict const\n//Requires: caml_call_gen\nfunction caml_js_wrap_callback_strict(arity, f) {\n  return function () {\n    var n = arguments.length;\n    if(n == arity && f.length == arity) return f.apply(null, arguments);\n    var args = new Array(arity);\n    var len = Math.min(arguments.length, arity)\n    for (var i = 0; i < len; i++) args[i] = arguments[i];\n    return caml_call_gen(f, args);\n  };\n}\n//Provides: caml_js_wrap_meth_callback const (const)\n//Requires: caml_call_gen\nfunction caml_js_wrap_meth_callback(f) {\n  return function () {\n    var len = arguments.length;\n    var args = new Array(len + 1);\n    args[0] = this;\n    for (var i = 0; i < len; i++) args[i+1] = arguments[i];\n    return caml_call_gen(f,args);\n  }\n}\n//Provides: caml_js_wrap_meth_callback_arguments const (const)\n//Requires: caml_call_gen\nfunction caml_js_wrap_meth_callback_arguments(f) {\n  return function () {\n    var len = arguments.length;\n    var args = new Array(len);\n    for (var i = 0; i < len; i++) args[i] = arguments[i];\n    return caml_call_gen(f,[this,args]);\n  }\n}\n//Provides: caml_js_wrap_meth_callback_strict const\n//Requires: caml_call_gen\nfunction caml_js_wrap_meth_callback_strict(arity, f) {\n  return function () {\n    var args = new Array(arity + 1);\n    var len = Math.min(arguments.length, arity)\n    args[0] = this;\n    for (var i = 0; i < len; i++) args[i+1] = arguments[i];\n    return caml_call_gen(f, args);\n  };\n}\n//Provides: caml_js_wrap_meth_callback_unsafe const (const)\n//Requires: caml_call_gen\nfunction caml_js_wrap_meth_callback_unsafe(f) {\n  return function () {\n    var len = arguments.length;\n    var args = new Array(len + 1);\n    args[0] = this;\n    for (var i = 0; i < len; i++) args[i+1] = arguments[i];\n    return f.apply(null, args); }\n}\n//Provides: caml_js_equals mutable (const, const)\nfunction caml_js_equals (x, y) { return +(x == y); }\n\n//Provides: caml_js_eval_string (const)\n//Requires: caml_jsstring_of_string\nfunction caml_js_eval_string (s) {return eval(caml_jsstring_of_string(s));}\n\n//Provides: caml_js_expr (const)\n//Requires: js_print_stderr\n//Requires: caml_jsstring_of_string\nfunction caml_js_expr(s) {\n  js_print_stderr(\"caml_js_expr: fallback to runtime evaluation\\n\");\n  return eval(caml_jsstring_of_string(s));}\n\n//Provides: caml_pure_js_expr const (const)\n//Requires: js_print_stderr\n//Requires: caml_jsstring_of_string\nfunction caml_pure_js_expr (s){\n  js_print_stderr(\"caml_pure_js_expr: fallback to runtime evaluation\\n\");\n  return eval(caml_jsstring_of_string(s));}\n\n//Provides: caml_js_object (object_literal)\n//Requires: caml_jsstring_of_string\nfunction caml_js_object (a) {\n  var o = {};\n  for (var i = 1; i < a.length; i++) {\n    var p = a[i];\n    o[caml_jsstring_of_string(p[1])] = p[2];\n  }\n  return o;\n}\n"
let jslib_js_of_ocaml = Js_of_ocaml_compiler.Builtins.register ~name:"jslib_js_of_ocaml.js" ~content:"// Js_of_ocaml library\n// http://www.ocsigen.org/js_of_ocaml/\n// Copyright (C) 2010 J\195\169r\195\180me Vouillon\n// Laboratoire PPS - CNRS Universit\195\169 Paris Diderot\n//\n// This program is free software; you can redistribute it and/or modify\n// it under the terms of the GNU Lesser General Public License as published by\n// the Free Software Foundation, with linking exception;\n// either version 2.1 of the License, or (at your option) any later version.\n//\n// This program is distributed in the hope that it will be useful,\n// but WITHOUT ANY WARRANTY; without even the implied warranty of\n// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n// GNU Lesser General Public License for more details.\n//\n// You should have received a copy of the GNU Lesser General Public License\n// along with this program; if not, write to the Free Software\n// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.\n\n///////////// Jslib: code specific to Js_of_ocaml\n\n//Provides: caml_js_on_ie const\nfunction caml_js_on_ie () {\n  var ua =\n      globalThis.navigator?globalThis.navigator.userAgent:\"\";\n  return ua.indexOf(\"MSIE\") != -1 && ua.indexOf(\"Opera\") != 0;\n}\n\n//Provides: caml_js_html_escape const (const)\nvar caml_js_regexps = { amp:/&/g, lt:/</g, quot:/\\\"/g, all:/[&<\\\"]/ };\nfunction caml_js_html_escape (s) {\n  if (!caml_js_regexps.all.test(s)) return s;\n  return s.replace(caml_js_regexps.amp, \"&amp;\")\n    .replace(caml_js_regexps.lt, \"&lt;\")\n    .replace(caml_js_regexps.quot, \"&quot;\");\n}\n\n//Provides: caml_js_html_entities\n//Requires: caml_failwith\nfunction caml_js_html_entities(s) {\n  var entity = /^&#?[0-9a-zA-Z]+;$/\n  if(s.match(entity))\n  {\n    var str, temp = document.createElement('p');\n    temp.innerHTML= s;\n    str= temp.textContent || temp.innerText;\n    temp=null;\n    return str;\n  }\n  else {\n    caml_failwith(\"Invalid entity \" + s);\n  }\n}\n\n//Provides: caml_js_get_console const\nfunction caml_js_get_console () {\n  var c = globalThis.console?globalThis.console:{};\n  var m = [\"log\", \"debug\", \"info\", \"warn\", \"error\", \"assert\", \"dir\", \"dirxml\",\n           \"trace\", \"group\", \"groupCollapsed\", \"groupEnd\", \"time\", \"timeEnd\"];\n  function f () {}\n  for (var i = 0; i < m.length; i++) if (!c[m[i]]) c[m[i]]=f;\n  return c;\n}\n\n//Provides: caml_xmlhttprequest_create\n//Requires: caml_failwith\n//Weakdef\nfunction caml_xmlhttprequest_create(unit){\n  var g = globalThis;\n  if(typeof g.XMLHttpRequest !== 'undefined') {\n    try { return new g.XMLHttpRequest } catch (e) { };\n  }\n  if(typeof g.activeXObject !== 'undefined') {\n    try { return new g.activeXObject(\"Msxml2.XMLHTTP\") } catch(e){ };\n    try { return new g.activeXObject(\"Msxml3.XMLHTTP\") } catch(e){ };\n    try { return new g.activeXObject(\"Microsoft.XMLHTTP\") } catch(e){ };\n  }\n  caml_failwith(\"Cannot create a XMLHttpRequest\");\n}\n\n//Provides: caml_js_error_of_exception\nfunction caml_js_error_of_exception(exn) {\n  if(exn.js_error) { return exn.js_error; }\n  return null;\n}\n"
let lexing = Js_of_ocaml_compiler.Builtins.register ~name:"lexing.js" ~content:"/***********************************************************************/\n/*                                                                     */\n/*                           Objective Caml                            */\n/*                                                                     */\n/*            Xavier Leroy, projet Cristal, INRIA Rocquencourt         */\n/*                                                                     */\n/*  Copyright 1996 Institut National de Recherche en Informatique et   */\n/*  en Automatique.  All rights reserved.  This file is distributed    */\n/*  under the terms of the GNU Lesser General Public License, with     */\n/*  the special exception on linking described in file ../LICENSE.     */\n/*                                                                     */\n/***********************************************************************/\n\n/* $Id: lexing.c 6045 2004-01-01 16:42:43Z doligez $ */\n\n/* The table-driven automaton for lexers generated by camllex. */\n\n//Provides: caml_lex_array\n//Requires: caml_jsbytes_of_string\nfunction caml_lex_array(s) {\n  s = caml_jsbytes_of_string(s);\n  var l = s.length / 2;\n  var a = new Array(l);\n  for (var i = 0; i < l; i++)\n    a[i] = (s.charCodeAt(2 * i) | (s.charCodeAt(2 * i + 1) << 8)) << 16 >> 16;\n  return a;\n}\n\n//Provides: caml_lex_engine\n//Requires: caml_failwith, caml_lex_array, caml_array_of_bytes\nfunction caml_lex_engine(tbl, start_state, lexbuf) {\n  var lex_buffer = 2;\n  var lex_buffer_len = 3;\n  var lex_start_pos = 5;\n  var lex_curr_pos = 6;\n  var lex_last_pos = 7;\n  var lex_last_action = 8;\n  var lex_eof_reached = 9;\n  var lex_base = 1;\n  var lex_backtrk = 2;\n  var lex_default = 3;\n  var lex_trans = 4;\n  var lex_check = 5;\n\n  if (!tbl.lex_default) {\n    tbl.lex_base =    caml_lex_array (tbl[lex_base]);\n    tbl.lex_backtrk = caml_lex_array (tbl[lex_backtrk]);\n    tbl.lex_check =   caml_lex_array (tbl[lex_check]);\n    tbl.lex_trans =   caml_lex_array (tbl[lex_trans]);\n    tbl.lex_default = caml_lex_array (tbl[lex_default]);\n  }\n\n  var c, state = start_state;\n\n  var buffer = caml_array_of_bytes(lexbuf[lex_buffer]);\n\n  if (state >= 0) {\n    /* First entry */\n    lexbuf[lex_last_pos] = lexbuf[lex_start_pos] = lexbuf[lex_curr_pos];\n    lexbuf[lex_last_action] = -1;\n  } else {\n    /* Reentry after refill */\n    state = -state - 1;\n  }\n  for(;;) {\n    /* Lookup base address or action number for current state */\n    var base = tbl.lex_base[state];\n    if (base < 0) return -base-1;\n    /* See if it's a backtrack point */\n    var backtrk = tbl.lex_backtrk[state];\n    if (backtrk >= 0) {\n      lexbuf[lex_last_pos] = lexbuf[lex_curr_pos];\n      lexbuf[lex_last_action] = backtrk;\n    }\n    /* See if we need a refill */\n    if (lexbuf[lex_curr_pos] >= lexbuf[lex_buffer_len]){\n      if (lexbuf[lex_eof_reached] == 0)\n        return -state - 1;\n      else\n        c = 256;\n    }else{\n      /* Read next input char */\n      c = buffer[lexbuf[lex_curr_pos]];\n      lexbuf[lex_curr_pos] ++;\n    }\n    /* Determine next state */\n    if (tbl.lex_check[base + c] == state)\n      state = tbl.lex_trans[base + c];\n    else\n      state = tbl.lex_default[state];\n    /* If no transition on this char, return to last backtrack point */\n    if (state < 0) {\n      lexbuf[lex_curr_pos] = lexbuf[lex_last_pos];\n      if (lexbuf[lex_last_action] == -1)\n        caml_failwith(\"lexing: empty token\");\n      else\n        return lexbuf[lex_last_action];\n    }else{\n      /* Erase the EOF condition only if the EOF pseudo-character was\n         consumed by the automaton (i.e. there was no backtrack above)\n      */\n      if (c == 256) lexbuf[lex_eof_reached] = 0;\n    }\n  }\n}\n\n/***********************************************/\n/* New lexer engine, with memory of positions  */\n/***********************************************/\n\n//Provides: caml_new_lex_engine\n//Requires: caml_failwith, caml_lex_array\n//Requires: caml_jsbytes_of_string, caml_array_of_bytes\nfunction caml_lex_run_mem(s, i, mem, curr_pos) {\n  for (;;) {\n    var dst = s.charCodeAt(i); i++;\n    if (dst == 0xff) return;\n    var src = s.charCodeAt(i); i++;\n    if (src == 0xff)\n      mem [dst + 1] = curr_pos;\n    else\n      mem [dst + 1] = mem [src + 1];\n  }\n}\n\nfunction caml_lex_run_tag(s, i, mem) {\n  for (;;) {\n    var dst = s.charCodeAt(i); i++;\n    if (dst == 0xff) return ;\n    var src = s.charCodeAt(i); i++;\n    if (src == 0xff)\n      mem [dst + 1] = -1;\n    else\n      mem [dst + 1] = mem [src + 1];\n  }\n}\n\nfunction caml_new_lex_engine(tbl, start_state, lexbuf) {\n  var lex_buffer = 2;\n  var lex_buffer_len = 3;\n  var lex_start_pos = 5;\n  var lex_curr_pos = 6;\n  var lex_last_pos = 7;\n  var lex_last_action = 8;\n  var lex_eof_reached = 9;\n  var lex_mem = 10;\n  var lex_base = 1;\n  var lex_backtrk = 2;\n  var lex_default = 3;\n  var lex_trans = 4;\n  var lex_check = 5;\n  var lex_base_code = 6;\n  var lex_backtrk_code = 7;\n  var lex_default_code = 8;\n  var lex_trans_code = 9;\n  var lex_check_code = 10;\n  var lex_code = 11;\n\n  if (!tbl.lex_default) {\n    tbl.lex_base =    caml_lex_array (tbl[lex_base]);\n    tbl.lex_backtrk = caml_lex_array (tbl[lex_backtrk]);\n    tbl.lex_check =   caml_lex_array (tbl[lex_check]);\n    tbl.lex_trans =   caml_lex_array (tbl[lex_trans]);\n    tbl.lex_default = caml_lex_array (tbl[lex_default]);\n  }\n  if (!tbl.lex_default_code) {\n    tbl.lex_base_code =    caml_lex_array (tbl[lex_base_code]);\n    tbl.lex_backtrk_code = caml_lex_array (tbl[lex_backtrk_code]);\n    tbl.lex_check_code =   caml_lex_array (tbl[lex_check_code]);\n    tbl.lex_trans_code =   caml_lex_array (tbl[lex_trans_code]);\n    tbl.lex_default_code = caml_lex_array (tbl[lex_default_code]);\n  }\n  if (tbl.lex_code == null) tbl.lex_code = caml_jsbytes_of_string(tbl[lex_code]);\n\n  var c, state = start_state;\n\n  var buffer = caml_array_of_bytes(lexbuf[lex_buffer]);\n\n  if (state >= 0) {\n    /* First entry */\n    lexbuf[lex_last_pos] = lexbuf[lex_start_pos] = lexbuf[lex_curr_pos];\n    lexbuf[lex_last_action] = -1;\n  } else {\n    /* Reentry after refill */\n    state = -state - 1;\n  }\n  for(;;) {\n    /* Lookup base address or action number for current state */\n    var base = tbl.lex_base[state];\n    if (base < 0) {\n      var pc_off = tbl.lex_base_code[state];\n      caml_lex_run_tag(tbl.lex_code, pc_off, lexbuf[lex_mem]);\n      return -base-1;\n    }\n    /* See if it's a backtrack point */\n    var backtrk = tbl.lex_backtrk[state];\n    if (backtrk >= 0) {\n      var pc_off = tbl.lex_backtrk_code[state];\n      caml_lex_run_tag(tbl.lex_code, pc_off, lexbuf[lex_mem]);\n      lexbuf[lex_last_pos] = lexbuf[lex_curr_pos];\n      lexbuf[lex_last_action] = backtrk;\n    }\n    /* See if we need a refill */\n    if (lexbuf[lex_curr_pos] >= lexbuf[lex_buffer_len]){\n      if (lexbuf[lex_eof_reached] == 0)\n        return -state - 1;\n      else\n        c = 256;\n    }else{\n      /* Read next input char */\n      c = buffer[lexbuf[lex_curr_pos]];\n      lexbuf[lex_curr_pos] ++;\n    }\n    /* Determine next state */\n    var pstate = state ;\n    if (tbl.lex_check[base + c] == state)\n      state = tbl.lex_trans[base + c];\n    else\n      state = tbl.lex_default[state];\n    /* If no transition on this char, return to last backtrack point */\n    if (state < 0) {\n      lexbuf[lex_curr_pos] = lexbuf[lex_last_pos];\n      if (lexbuf[lex_last_action] == -1)\n        caml_failwith(\"lexing: empty token\");\n      else\n        return lexbuf[lex_last_action];\n    }else{\n      /* If some transition, get and perform memory moves */\n      var base_code = tbl.lex_base_code[pstate], pc_off;\n      if (tbl.lex_check_code[base_code + c] == pstate)\n        pc_off = tbl.lex_trans_code[base_code + c];\n      else\n        pc_off = tbl.lex_default_code[pstate];\n      if (pc_off > 0)\n        caml_lex_run_mem\n      (tbl.lex_code, pc_off, lexbuf[lex_mem], lexbuf[lex_curr_pos]);\n      /* Erase the EOF condition only if the EOF pseudo-character was\n         consumed by the automaton (i.e. there was no backtrack above)\n      */\n      if (c == 256) lexbuf[lex_eof_reached] = 0;\n    }\n  }\n}\n"
let marshal = Js_of_ocaml_compiler.Builtins.register ~name:"marshal.js" ~content:"// Js_of_ocaml runtime support\n// http://www.ocsigen.org/js_of_ocaml/\n// Copyright (C) 2010 J\195\169r\195\180me Vouillon\n// Laboratoire PPS - CNRS Universit\195\169 Paris Diderot\n//\n// This program is free software; you can redistribute it and/or modify\n// it under the terms of the GNU Lesser General Public License as published by\n// the Free Software Foundation, with linking exception;\n// either version 2.1 of the License, or (at your option) any later version.\n//\n// This program is distributed in the hope that it will be useful,\n// but WITHOUT ANY WARRANTY; without even the implied warranty of\n// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n// GNU Lesser General Public License for more details.\n//\n// You should have received a copy of the GNU Lesser General Public License\n// along with this program; if not, write to the Free Software\n// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.\n\n//Provides: caml_marshal_constants\nvar caml_marshal_constants = {\n  PREFIX_SMALL_BLOCK:         0x80,\n  PREFIX_SMALL_INT:           0x40,\n  PREFIX_SMALL_STRING:        0x20,\n  CODE_INT8:                  0x00,\n  CODE_INT16:                 0x01,\n  CODE_INT32:                 0x02,\n  CODE_INT64:                 0x03,\n  CODE_SHARED8:               0x04,\n  CODE_SHARED16:              0x05,\n  CODE_SHARED32:              0x06,\n  CODE_BLOCK32:               0x08,\n  CODE_BLOCK64:               0x13,\n  CODE_STRING8:               0x09,\n  CODE_STRING32:              0x0A,\n  CODE_DOUBLE_BIG:            0x0B,\n  CODE_DOUBLE_LITTLE:         0x0C,\n  CODE_DOUBLE_ARRAY8_BIG:     0x0D,\n  CODE_DOUBLE_ARRAY8_LITTLE:  0x0E,\n  CODE_DOUBLE_ARRAY32_BIG:    0x0F,\n  CODE_DOUBLE_ARRAY32_LITTLE: 0x07,\n  CODE_CODEPOINTER:           0x10,\n  CODE_INFIXPOINTER:          0x11,\n  CODE_CUSTOM:                0x12,\n  CODE_CUSTOM_LEN:            0x18,\n  CODE_CUSTOM_FIXED:          0x19\n}\n\n\n//Provides: MlStringReader\n//Requires: caml_string_of_jsbytes, caml_jsbytes_of_string\nfunction MlStringReader (s, i) { this.s = caml_jsbytes_of_string(s); this.i = i; }\nMlStringReader.prototype = {\n  read8u:function () { return this.s.charCodeAt(this.i++); },\n  read8s:function () { return this.s.charCodeAt(this.i++) << 24 >> 24; },\n  read16u:function () {\n    var s = this.s, i = this.i;\n    this.i = i + 2;\n    return (s.charCodeAt(i) << 8) | s.charCodeAt(i + 1)\n  },\n  read16s:function () {\n    var s = this.s, i = this.i;\n    this.i = i + 2;\n    return (s.charCodeAt(i) << 24 >> 16) | s.charCodeAt(i + 1);\n  },\n  read32u:function () {\n    var s = this.s, i = this.i;\n    this.i = i + 4;\n    return ((s.charCodeAt(i) << 24) | (s.charCodeAt(i+1) << 16) |\n            (s.charCodeAt(i+2) << 8) | s.charCodeAt(i+3)) >>> 0;\n  },\n  read32s:function () {\n    var s = this.s, i = this.i;\n    this.i = i + 4;\n    return (s.charCodeAt(i) << 24) | (s.charCodeAt(i+1) << 16) |\n      (s.charCodeAt(i+2) << 8) | s.charCodeAt(i+3);\n  },\n  readstr:function (len) {\n    var i = this.i;\n    this.i = i + len;\n    return caml_string_of_jsbytes(this.s.substring(i, i + len));\n  }\n}\n\n//Provides: BigStringReader\n//Requires: caml_string_of_array, caml_ba_get_1\nfunction BigStringReader (bs, i) { this.s = bs; this.i = i; }\nBigStringReader.prototype = {\n  read8u:function () { return caml_ba_get_1(this.s,this.i++); },\n  read8s:function () { return caml_ba_get_1(this.s,this.i++) << 24 >> 24; },\n  read16u:function () {\n    var s = this.s, i = this.i;\n    this.i = i + 2;\n    return (caml_ba_get_1(s,i) << 8) | caml_ba_get_1(s,i + 1)\n  },\n  read16s:function () {\n    var s = this.s, i = this.i;\n    this.i = i + 2;\n    return (caml_ba_get_1(s,i) << 24 >> 16) | caml_ba_get_1(s,i + 1);\n  },\n  read32u:function () {\n    var s = this.s, i = this.i;\n    this.i = i + 4;\n    return ((caml_ba_get_1(s,i)   << 24) | (caml_ba_get_1(s,i+1) << 16) |\n            (caml_ba_get_1(s,i+2) << 8)  | caml_ba_get_1(s,i+3)         ) >>> 0;\n  },\n  read32s:function () {\n    var s = this.s, i = this.i;\n    this.i = i + 4;\n    return (caml_ba_get_1(s,i)   << 24) | (caml_ba_get_1(s,i+1) << 16) |\n      (caml_ba_get_1(s,i+2) << 8)  | caml_ba_get_1(s,i+3);\n  },\n  readstr:function (len) {\n    var i = this.i;\n    var arr = new Array(len)\n    for(var j = 0; j < len; j++){\n      arr[j] = caml_ba_get_1(this.s, i+j);\n    }\n    this.i = i + len;\n    return caml_string_of_array(arr);\n  }\n}\n\n\n\n//Provides: caml_float_of_bytes\n//Requires: caml_int64_float_of_bits, caml_int64_of_bytes\nfunction caml_float_of_bytes (a) {\n  return caml_int64_float_of_bits (caml_int64_of_bytes (a));\n}\n\n//Provides: caml_input_value_from_string mutable\n//Requires: MlStringReader, caml_input_value_from_reader\nfunction caml_input_value_from_string(s,ofs) {\n  var reader = new MlStringReader (s, typeof ofs==\"number\"?ofs:ofs[0]);\n  return caml_input_value_from_reader(reader, ofs)\n}\n\n//Provides: caml_input_value_from_bytes mutable\n//Requires: MlStringReader, caml_input_value_from_reader, caml_string_of_bytes\nfunction caml_input_value_from_bytes(s,ofs) {\n  var reader = new MlStringReader (caml_string_of_bytes(s), typeof ofs==\"number\"?ofs:ofs[0]);\n  return caml_input_value_from_reader(reader, ofs)\n}\n\n//Provides: caml_int64_unmarshal\n//Requires: caml_int64_of_bytes\nfunction caml_int64_unmarshal(reader, size){\n  var t = new Array(8);;\n  for (var j = 0;j < 8;j++) t[j] = reader.read8u();\n  size[0] = 8;\n  return caml_int64_of_bytes (t);\n}\n\n//Provides: caml_int64_marshal\n//Requires: caml_int64_to_bytes\nfunction caml_int64_marshal(writer, v, sizes) {\n  var b = caml_int64_to_bytes (v);\n  for (var i = 0; i < 8; i++) writer.write (8, b[i]);\n  sizes[0] = 8; sizes[1] = 8;\n}\n\n//Provides: caml_int32_unmarshal\nfunction caml_int32_unmarshal(reader, size){\n  size[0] = 4;\n  return reader.read32s ();\n}\n\n//Provides: caml_nativeint_unmarshal\n//Requires: caml_failwith\nfunction caml_nativeint_unmarshal(reader, size){\n  switch (reader.read8u ()) {\n  case 1:\n    size[0] = 4;\n    return reader.read32s ();\n  case 2:\n    caml_failwith(\"input_value: native integer value too large\");\n  default: caml_failwith(\"input_value: ill-formed native integer\");\n  }\n}\n\n//Provides: caml_custom_ops\n//Requires: caml_int64_unmarshal, caml_int64_marshal, caml_int64_compare, caml_int64_hash\n//Requires: caml_int32_unmarshal, caml_nativeint_unmarshal\n//Requires: caml_ba_serialize, caml_ba_deserialize, caml_ba_compare, caml_ba_hash\nvar caml_custom_ops =\n    {\"_j\": {\n      deserialize : caml_int64_unmarshal,\n      serialize  : caml_int64_marshal,\n      fixed_length : 8,\n      compare : caml_int64_compare,\n      hash : caml_int64_hash\n    },\n     \"_i\": {\n       deserialize : caml_int32_unmarshal,\n       fixed_length : 4,\n     },\n     \"_n\": {\n       deserialize : caml_nativeint_unmarshal,\n       fixed_length : 4,\n     },\n     \"_bigarray\":{\n       deserialize : (function (reader, sz) {return caml_ba_deserialize (reader,sz,\"_bigarray\")}),\n       serialize : caml_ba_serialize,\n       compare : caml_ba_compare,\n       hash: caml_ba_hash,\n     },\n     \"_bigarr02\":{\n       deserialize : (function (reader, sz) {return caml_ba_deserialize (reader,sz,\"_bigarr02\")}),\n       serialize : caml_ba_serialize,\n       compare : caml_ba_compare,\n       hash: caml_ba_hash,\n     }\n    }\n\n//Provides: caml_input_value_from_reader mutable\n//Requires: caml_failwith\n//Requires: caml_float_of_bytes, caml_custom_ops\n\nfunction caml_input_value_from_reader(reader, ofs) {\n  var _magic = reader.read32u ()\n  var _block_len = reader.read32u ();\n  var num_objects = reader.read32u ();\n  var _size_32 = reader.read32u ();\n  var _size_64 = reader.read32u ();\n  var stack = [];\n  var intern_obj_table = (num_objects > 0)?[]:null;\n  var obj_counter = 0;\n  function intern_rec () {\n    var code = reader.read8u ();\n    if (code >= 0x40 /*cst.PREFIX_SMALL_INT*/) {\n      if (code >= 0x80 /*cst.PREFIX_SMALL_BLOCK*/) {\n        var tag = code & 0xF;\n        var size = (code >> 4) & 0x7;\n        var v = [tag];\n        if (size == 0) return v;\n        if (intern_obj_table) intern_obj_table[obj_counter++] = v;\n        stack.push(v, size);\n        return v;\n      } else\n        return (code & 0x3F);\n    } else {\n      if (code >= 0x20/*cst.PREFIX_SMALL_STRING */) {\n        var len = code & 0x1F;\n        var v = reader.readstr (len);\n        if (intern_obj_table) intern_obj_table[obj_counter++] = v;\n        return v;\n      } else {\n        switch(code) {\n        case 0x00: //cst.CODE_INT8:\n          return reader.read8s ();\n        case 0x01: //cst.CODE_INT16:\n          return reader.read16s ();\n        case 0x02: //cst.CODE_INT32:\n          return reader.read32s ();\n        case 0x03: //cst.CODE_INT64:\n          caml_failwith(\"input_value: integer too large\");\n          break;\n        case 0x04: //cst.CODE_SHARED8:\n          var offset = reader.read8u ();\n          return intern_obj_table[obj_counter - offset];\n        case 0x05: //cst.CODE_SHARED16:\n          var offset = reader.read16u ();\n          return intern_obj_table[obj_counter - offset];\n        case 0x06: //cst.CODE_SHARED32:\n          var offset = reader.read32u ();\n          return intern_obj_table[obj_counter - offset];\n        case 0x08: //cst.CODE_BLOCK32:\n          var header = reader.read32u ();\n          var tag = header & 0xFF;\n          var size = header >> 10;\n          var v = [tag];\n          if (size == 0) return v;\n          if (intern_obj_table) intern_obj_table[obj_counter++] = v;\n          stack.push(v, size);\n          return v;\n        case 0x13: //cst.CODE_BLOCK64:\n          caml_failwith (\"input_value: data block too large\");\n          break;\n        case 0x09: //cst.CODE_STRING8:\n          var len = reader.read8u();\n          var v = reader.readstr (len);\n          if (intern_obj_table) intern_obj_table[obj_counter++] = v;\n          return v;\n        case 0x0A: //cst.CODE_STRING32:\n          var len = reader.read32u();\n          var v = reader.readstr (len);\n          if (intern_obj_table) intern_obj_table[obj_counter++] = v;\n          return v;\n        case 0x0C: //cst.CODE_DOUBLE_LITTLE:\n          var t = new Array(8);;\n          for (var i = 0;i < 8;i++) t[7 - i] = reader.read8u ();\n          var v = caml_float_of_bytes (t);\n          if (intern_obj_table) intern_obj_table[obj_counter++] = v;\n          return v;\n        case 0x0B: //cst.CODE_DOUBLE_BIG:\n          var t = new Array(8);;\n          for (var i = 0;i < 8;i++) t[i] = reader.read8u ();\n          var v = caml_float_of_bytes (t);\n          if (intern_obj_table) intern_obj_table[obj_counter++] = v;\n          return v;\n        case 0x0E: //cst.CODE_DOUBLE_ARRAY8_LITTLE:\n          var len = reader.read8u();\n          var v = new Array(len+1);\n          v[0] = 254;\n          var t = new Array(8);;\n          if (intern_obj_table) intern_obj_table[obj_counter++] = v;\n          for (var i = 1;i <= len;i++) {\n            for (var j = 0;j < 8;j++) t[7 - j] = reader.read8u();\n            v[i] = caml_float_of_bytes (t);\n          }\n          return v;\n        case 0x0D: //cst.CODE_DOUBLE_ARRAY8_BIG:\n          var len = reader.read8u();\n          var v = new Array(len+1);\n          v[0] = 254;\n          var t = new Array(8);;\n          if (intern_obj_table) intern_obj_table[obj_counter++] = v;\n          for (var i = 1;i <= len;i++) {\n            for (var j = 0;j < 8;j++) t[j] = reader.read8u();\n            v [i] = caml_float_of_bytes (t);\n          }\n          return v;\n        case 0x07: //cst.CODE_DOUBLE_ARRAY32_LITTLE:\n          var len = reader.read32u();\n          var v = new Array(len+1);\n          v[0] = 254;\n          if (intern_obj_table) intern_obj_table[obj_counter++] = v;\n          var t = new Array(8);;\n          for (var i = 1;i <= len;i++) {\n            for (var j = 0;j < 8;j++) t[7 - j] = reader.read8u();\n            v[i] = caml_float_of_bytes (t);\n          }\n          return v;\n        case 0x0F: //cst.CODE_DOUBLE_ARRAY32_BIG:\n          var len = reader.read32u();\n          var v = new Array(len+1);\n          v[0] = 254;\n          var t = new Array(8);;\n          for (var i = 1;i <= len;i++) {\n            for (var j = 0;j < 8;j++) t[j] = reader.read8u();\n            v [i] = caml_float_of_bytes (t);\n          }\n          return v;\n        case 0x10: //cst.CODE_CODEPOINTER:\n        case 0x11: //cst.CODE_INFIXPOINTER:\n          caml_failwith (\"input_value: code pointer\");\n          break;\n        case 0x12: //cst.CODE_CUSTOM:\n        case 0x18: //cst.CODE_CUSTOM_LEN:\n        case 0x19: //cst.CODE_CUSTOM_FIXED:\n          var c, s = \"\";\n          while ((c = reader.read8u ()) != 0) s += String.fromCharCode (c);\n          var ops = caml_custom_ops[s];\n          var expected_size;\n          if(!ops)\n            caml_failwith(\"input_value: unknown custom block identifier\");\n          switch(code){\n          case 0x12: // cst.CODE_CUSTOM (deprecated)\n            break;\n          case 0x19: // cst.CODE_CUSTOM_FIXED\n            if(!ops.fixed_length)\n              caml_failwith(\"input_value: expected a fixed-size custom block\");\n            expected_size = ops.fixed_length;\n            break;\n          case 0x18: // cst.CODE_CUSTOM_LEN\n            expected_size = reader.read32u ();\n            // Skip size64\n            reader.read32s(); reader.read32s();\n            break;\n          }\n          var old_pos = reader.i;\n          var size = [0];\n          var v = ops.deserialize(reader, size);\n          if(expected_size != undefined){\n            if(expected_size != size[0])\n              caml_failwith(\"input_value: incorrect length of serialized custom block\");\n          }\n          if (intern_obj_table) intern_obj_table[obj_counter++] = v;\n          return v;\n        default:\n          caml_failwith (\"input_value: ill-formed message\");\n        }\n      }\n    }\n  }\n  var res = intern_rec ();\n  while (stack.length > 0) {\n    var size = stack.pop();\n    var v = stack.pop();\n    var d = v.length;\n    if (d < size) stack.push(v, size);\n    v[d] = intern_rec ();\n  }\n  if (typeof ofs!=\"number\") ofs[0] = reader.i;\n  return res;\n}\n\n//Provides: caml_marshal_data_size mutable\n//Requires: caml_failwith, caml_bytes_unsafe_get\nfunction caml_marshal_data_size (s, ofs) {\n  function get32(s,i) {\n    return (caml_bytes_unsafe_get(s, i) << 24) |\n      (caml_bytes_unsafe_get(s, i + 1) << 16) |\n      (caml_bytes_unsafe_get(s, i + 2) << 8) |\n      caml_bytes_unsafe_get(s, i + 3);\n  }\n  if (get32(s, ofs) != (0x8495A6BE|0))\n    caml_failwith(\"Marshal.data_size: bad object\");\n  return (get32(s, ofs + 4));\n}\n\n//Provides: MlObjectTable\nvar MlObjectTable;\nif (typeof globalThis.WeakMap === 'undefined') {\n  MlObjectTable = function() {\n    /* polyfill (using linear search) */\n    function NaiveLookup(objs) { this.objs = objs; }\n    NaiveLookup.prototype.get = function(v) {\n      for (var i = 0; i < this.objs.length; i++) {\n        if (this.objs[i] === v) return i;\n      }\n    };\n    NaiveLookup.prototype.set = function() {\n      // Do nothing here. [MlObjectTable.store] will push to [this.objs] directly.\n    };\n\n    return function MlObjectTable() {\n      this.objs = []; this.lookup = new NaiveLookup(this.objs);\n    };\n  }();\n}\nelse {\n  MlObjectTable = function MlObjectTable() {\n    this.objs = []; this.lookup = new globalThis.WeakMap();\n  };\n}\n\nMlObjectTable.prototype.store = function(v) {\n  this.lookup.set(v, this.objs.length);\n  this.objs.push(v);\n}\n\nMlObjectTable.prototype.recall = function(v) {\n  var i = this.lookup.get(v);\n  return (i === undefined)\n    ? undefined : this.objs.length - i;   /* index is relative */\n}\n\n//Provides: caml_legacy_custom_code\n//Version: >= 4.08\nvar caml_legacy_custom_code = false\n\n//Provides: caml_legacy_custom_code\n//Version: < 4.08\nvar caml_legacy_custom_code = true\n\n//Provides: caml_output_val\n//Requires: caml_int64_to_bytes, caml_failwith\n//Requires: caml_int64_bits_of_float\n//Requires: caml_is_ml_bytes, caml_ml_bytes_length, caml_bytes_unsafe_get\n//Requires: caml_is_ml_string, caml_ml_string_length, caml_string_unsafe_get\n//Requires: MlObjectTable, caml_list_to_js_array, caml_legacy_custom_code, caml_custom_ops\n//Requires: caml_invalid_argument,caml_string_of_jsbytes\nvar caml_output_val = function (){\n  function Writer () { this.chunk = []; }\n  Writer.prototype = {\n    chunk_idx:20, block_len:0, obj_counter:0, size_32:0, size_64:0,\n    write:function (size, value) {\n      for (var i = size - 8;i >= 0;i -= 8)\n        this.chunk[this.chunk_idx++] = (value >> i) & 0xFF;\n    },\n    write_at:function (pos, size, value) {\n      var pos = pos;\n      for (var i = size - 8;i >= 0;i -= 8)\n        this.chunk[pos++] = (value >> i) & 0xFF;\n    },\n    write_code:function (size, code, value) {\n      this.chunk[this.chunk_idx++] = code;\n      for (var i = size - 8;i >= 0;i -= 8)\n        this.chunk[this.chunk_idx++] = (value >> i) & 0xFF;\n    },\n    write_shared:function (offset) {\n      if (offset < (1 << 8)) this.write_code(8, 0x04 /*cst.CODE_SHARED8*/, offset);\n      else if (offset < (1 << 16)) this.write_code(16, 0x05 /*cst.CODE_SHARED16*/, offset);\n      else this.write_code(32, 0x06 /*cst.CODE_SHARED32*/, offset);\n    },\n    pos:function () { return this.chunk_idx },\n    finalize:function () {\n      this.block_len = this.chunk_idx - 20;\n      this.chunk_idx = 0;\n      this.write (32, 0x8495A6BE);\n      this.write (32, this.block_len);\n      this.write (32, this.obj_counter);\n      this.write (32, this.size_32);\n      this.write (32, this.size_64);\n      return this.chunk;\n    }\n  }\n  return function (v, flags) {\n    flags = caml_list_to_js_array(flags);\n\n    var no_sharing = (flags.indexOf(0 /*Marshal.No_sharing*/) !== -1),\n        closures =  (flags.indexOf(1 /*Marshal.Closures*/) !== -1);\n    /* Marshal.Compat_32 is redundant since integers are 32-bit anyway */\n\n    if (closures)\n      globalThis.console.warn(\"in caml_output_val: flag Marshal.Closures is not supported.\");\n\n    var writer = new Writer ();\n    var stack = [];\n    var intern_obj_table = no_sharing ? null : new MlObjectTable();\n\n    function memo(v) {\n      if (no_sharing) return false;\n      var existing_offset = intern_obj_table.recall(v);\n      if (existing_offset) { writer.write_shared(existing_offset); return true; }\n      else { intern_obj_table.store(v); return false; }\n    }\n\n    function extern_rec (v) {\n      if (v.caml_custom) {\n        if (memo(v)) return;\n        var name = v.caml_custom;\n        var ops = caml_custom_ops[name];\n        var sz_32_64 = [0,0];\n        if(!ops.serialize)\n          caml_invalid_argument(\"output_value: abstract value (Custom)\");\n        if(caml_legacy_custom_code) {\n          writer.write (8, 0x12 /*cst.CODE_CUSTOM*/);\n          for (var i = 0; i < name.length; i++)\n            writer.write (8, name.charCodeAt(i));\n          writer.write(8, 0);\n          ops.serialize(writer, v, sz_32_64);\n        } else if(ops.fixed_length == undefined){\n          writer.write (8, 0x18 /*cst.CODE_CUSTOM_LEN*/);\n          for (var i = 0; i < name.length; i++)\n            writer.write (8, name.charCodeAt(i));\n          writer.write(8, 0);\n          var header_pos = writer.pos ();\n          for(var i = 0; i < 12; i++) {\n            writer.write(8, 0);\n          }\n          ops.serialize(writer, v, sz_32_64);\n          writer.write_at(header_pos, 32, sz_32_64[0]);\n          writer.write_at(header_pos + 4, 32, 0); // zero\n          writer.write_at(header_pos + 8, 32, sz_32_64[1]);\n        } else {\n          writer.write (8, 0x19 /*cst.CODE_CUSTOM_FIXED*/);\n          for (var i = 0; i < name.length; i++)\n            writer.write (8, name.charCodeAt(i));\n          writer.write(8, 0);\n          var old_pos = writer.pos();\n          ops.serialize(writer, v, sz_32_64);\n          if (ops.fixed_length != writer.pos() - old_pos)\n            caml_failwith(\"output_value: incorrect fixed sizes specified by \" + name);\n        }\n        writer.size_32 += 2 + ((sz_32_64[0] + 3) >> 2);\n        writer.size_64 += 2 + ((sz_32_64[1] + 7) >> 3);\n      }\n      else if (v instanceof Array && v[0] === (v[0]|0)) {\n        if (v[0] == 251) {\n          caml_failwith(\"output_value: abstract value (Abstract)\");\n        }\n        if (v.length > 1 && memo(v)) return;\n        if (v[0] < 16 && v.length - 1 < 8)\n          writer.write (8, 0x80 /*cst.PREFIX_SMALL_BLOCK*/ + v[0] + ((v.length - 1)<<4));\n        else\n          writer.write_code(32, 0x08 /*cst.CODE_BLOCK32*/, ((v.length-1) << 10) | v[0]);\n        writer.size_32 += v.length;\n        writer.size_64 += v.length;\n        if (v.length > 1) stack.push (v, 1);\n      } else if (caml_is_ml_bytes(v)) {\n        if(!(caml_is_ml_bytes(caml_string_of_jsbytes(\"\")))) {\n          caml_failwith(\"output_value: [Bytes.t] cannot safely be marshaled with [--enable use-js-string]\");\n        }\n        if (memo(v)) return;\n        var len = caml_ml_bytes_length(v);\n        if (len < 0x20)\n          writer.write (8, 0x20 /*cst.PREFIX_SMALL_STRING*/ + len);\n        else if (len < 0x100)\n          writer.write_code (8, 0x09/*cst.CODE_STRING8*/, len);\n        else\n          writer.write_code (32, 0x0A /*cst.CODE_STRING32*/, len);\n        for (var i = 0;i < len;i++)\n          writer.write (8, caml_bytes_unsafe_get(v,i));\n        writer.size_32 += 1 + (((len + 4) / 4)|0);\n        writer.size_64 += 1 + (((len + 8) / 8)|0);\n      } else if (caml_is_ml_string(v)) {\n        var len = caml_ml_string_length(v);\n        if (len < 0x20)\n          writer.write (8, 0x20 /*cst.PREFIX_SMALL_STRING*/ + len);\n        else if (len < 0x100)\n          writer.write_code (8, 0x09/*cst.CODE_STRING8*/, len);\n        else\n          writer.write_code (32, 0x0A /*cst.CODE_STRING32*/, len);\n        for (var i = 0;i < len;i++)\n          writer.write (8, caml_string_unsafe_get(v,i));\n        writer.size_32 += 1 + (((len + 4) / 4)|0);\n        writer.size_64 += 1 + (((len + 8) / 8)|0);\n      } else {\n        if (v != (v|0)){\n          var type_of_v = typeof v;\n          //\n          // If a float happens to be an integer it is serialized as an integer\n          // (Js_of_ocaml cannot tell whether the type of an integer number is\n          // float or integer.) This can result in unexpected crashes when\n          // unmarshalling using the standard runtime. It seems better to\n          // systematically fail on marshalling.\n          //\n          //          if(type_of_v != \"number\")\n          caml_failwith(\"output_value: abstract value (\"+type_of_v+\")\");\n          //          var t = caml_int64_to_bytes(caml_int64_bits_of_float(v));\n          //          writer.write (8, 0x0B /*cst.CODE_DOUBLE_BIG*/);\n          //          for(var i = 0; i<8; i++){writer.write(8,t[i])}\n        }\n        else if (v >= 0 && v < 0x40) {\n          writer.write (8, 0X40 /*cst.PREFIX_SMALL_INT*/ + v);\n        } else {\n          if (v >= -(1 << 7) && v < (1 << 7))\n            writer.write_code(8, 0x00 /*cst.CODE_INT8*/, v);\n          else if (v >= -(1 << 15) && v < (1 << 15))\n            writer.write_code(16, 0x01 /*cst.CODE_INT16*/, v);\n          else\n            writer.write_code(32, 0x02 /*cst.CODE_INT32*/, v);\n        }\n      }\n    }\n    extern_rec (v);\n    while (stack.length > 0) {\n      var i = stack.pop ();\n      var v = stack.pop ();\n      if (i + 1 < v.length) stack.push (v, i + 1);\n      extern_rec (v[i]);\n    }\n    if (intern_obj_table) writer.obj_counter = intern_obj_table.objs.length;\n    writer.finalize();\n    return writer.chunk;\n  }\n} ();\n\n//Provides: caml_output_value_to_string mutable\n//Requires: caml_output_val, caml_string_of_array\nfunction caml_output_value_to_string (v, flags) {\n  return caml_string_of_array (caml_output_val (v, flags));\n}\n\n//Provides: caml_output_value_to_bytes mutable\n//Requires: caml_output_val, caml_bytes_of_array\nfunction caml_output_value_to_bytes (v, flags) {\n  return caml_bytes_of_array (caml_output_val (v, flags));\n}\n\n//Provides: caml_output_value_to_buffer\n//Requires: caml_output_val, caml_failwith, caml_blit_bytes\nfunction caml_output_value_to_buffer (s, ofs, len, v, flags) {\n  var t = caml_output_val (v, flags);\n  if (t.length > len) caml_failwith (\"Marshal.to_buffer: buffer overflow\");\n  caml_blit_bytes(t, 0, s, ofs, t.length);\n  return 0;\n}\n"
let md5 = Js_of_ocaml_compiler.Builtins.register ~name:"md5.js" ~content:"// Js_of_ocaml runtime support\n// http://www.ocsigen.org/js_of_ocaml/\n// Copyright (C) 2010 J\195\169r\195\180me Vouillon\n// Laboratoire PPS - CNRS Universit\195\169 Paris Diderot\n//\n// This program is free software; you can redistribute it and/or modify\n// it under the terms of the GNU Lesser General Public License as published by\n// the Free Software Foundation, with linking exception;\n// either version 2.1 of the License, or (at your option) any later version.\n//\n// This program is distributed in the hope that it will be useful,\n// but WITHOUT ANY WARRANTY; without even the implied warranty of\n// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n// GNU Lesser General Public License for more details.\n//\n// You should have received a copy of the GNU Lesser General Public License\n// along with this program; if not, write to the Free Software\n// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.\n\n\n//Provides: caml_md5_chan\n//Requires: caml_md5_string, caml_string_of_array,caml_ml_channels\n//Requires: caml_raise_end_of_file, caml_create_bytes, caml_string_of_bytes\nfunction caml_md5_chan(chanid,len){\n  var chan = caml_ml_channels[chanid];\n  var chan_len = chan.file.length();\n  if(len<0) len = chan_len - chan.offset;\n  if(chan.offset + len > chan_len) caml_raise_end_of_file();\n  var buf = caml_create_bytes(len);\n  chan.file.read(chan.offset,buf,0,len);\n  return caml_md5_string(caml_string_of_bytes(buf),0,len);\n}\n\n//Provides: caml_md5_string\n//Requires: caml_bytes_of_string, caml_md5_bytes\nfunction caml_md5_string(s, ofs, len) {\n  return caml_md5_bytes(caml_bytes_of_string(s),ofs,len);\n}\n\n//Provides: caml_md5_bytes\n//Requires: caml_string_of_array, caml_ml_bytes_content\nvar caml_md5_bytes = function () {\n  function add (x, y) { return (x + y) | 0; }\n  function xx(q,a,b,x,s,t) {\n    a = add(add(a, q), add(x, t));\n    return add((a << s) | (a >>> (32 - s)), b);\n  }\n  function ff(a,b,c,d,x,s,t) {\n    return xx((b & c) | ((~b) & d), a, b, x, s, t);\n  }\n  function gg(a,b,c,d,x,s,t) {\n    return xx((b & d) | (c & (~d)), a, b, x, s, t);\n  }\n  function hh(a,b,c,d,x,s,t) { return xx(b ^ c ^ d, a, b, x, s, t); }\n  function ii(a,b,c,d,x,s,t) { return xx(c ^ (b | (~d)), a, b, x, s, t); }\n\n  function md5(buffer, length) {\n    var i = length;\n    buffer[i >> 2] |= 0x80 << (8 * (i & 3));\n    for (i = (i & ~0x3) + 8;(i & 0x3F) < 60 ;i += 4)\n      buffer[(i >> 2) - 1] = 0;\n    buffer[(i >> 2) -1] = length << 3;\n    buffer[i >> 2] = (length >> 29) & 0x1FFFFFFF;\n\n    var w = [0x67452301, 0xEFCDAB89, 0x98BADCFE, 0x10325476];\n\n    for(i = 0; i < buffer.length; i += 16) {\n      var a = w[0], b = w[1], c = w[2], d = w[3];\n\n      a = ff(a, b, c, d, buffer[i+ 0], 7, 0xD76AA478);\n      d = ff(d, a, b, c, buffer[i+ 1], 12, 0xE8C7B756);\n      c = ff(c, d, a, b, buffer[i+ 2], 17, 0x242070DB);\n      b = ff(b, c, d, a, buffer[i+ 3], 22, 0xC1BDCEEE);\n      a = ff(a, b, c, d, buffer[i+ 4], 7, 0xF57C0FAF);\n      d = ff(d, a, b, c, buffer[i+ 5], 12, 0x4787C62A);\n      c = ff(c, d, a, b, buffer[i+ 6], 17, 0xA8304613);\n      b = ff(b, c, d, a, buffer[i+ 7], 22, 0xFD469501);\n      a = ff(a, b, c, d, buffer[i+ 8], 7, 0x698098D8);\n      d = ff(d, a, b, c, buffer[i+ 9], 12, 0x8B44F7AF);\n      c = ff(c, d, a, b, buffer[i+10], 17, 0xFFFF5BB1);\n      b = ff(b, c, d, a, buffer[i+11], 22, 0x895CD7BE);\n      a = ff(a, b, c, d, buffer[i+12], 7, 0x6B901122);\n      d = ff(d, a, b, c, buffer[i+13], 12, 0xFD987193);\n      c = ff(c, d, a, b, buffer[i+14], 17, 0xA679438E);\n      b = ff(b, c, d, a, buffer[i+15], 22, 0x49B40821);\n\n      a = gg(a, b, c, d, buffer[i+ 1], 5, 0xF61E2562);\n      d = gg(d, a, b, c, buffer[i+ 6], 9, 0xC040B340);\n      c = gg(c, d, a, b, buffer[i+11], 14, 0x265E5A51);\n      b = gg(b, c, d, a, buffer[i+ 0], 20, 0xE9B6C7AA);\n      a = gg(a, b, c, d, buffer[i+ 5], 5, 0xD62F105D);\n      d = gg(d, a, b, c, buffer[i+10], 9, 0x02441453);\n      c = gg(c, d, a, b, buffer[i+15], 14, 0xD8A1E681);\n      b = gg(b, c, d, a, buffer[i+ 4], 20, 0xE7D3FBC8);\n      a = gg(a, b, c, d, buffer[i+ 9], 5, 0x21E1CDE6);\n      d = gg(d, a, b, c, buffer[i+14], 9, 0xC33707D6);\n      c = gg(c, d, a, b, buffer[i+ 3], 14, 0xF4D50D87);\n      b = gg(b, c, d, a, buffer[i+ 8], 20, 0x455A14ED);\n      a = gg(a, b, c, d, buffer[i+13], 5, 0xA9E3E905);\n      d = gg(d, a, b, c, buffer[i+ 2], 9, 0xFCEFA3F8);\n      c = gg(c, d, a, b, buffer[i+ 7], 14, 0x676F02D9);\n      b = gg(b, c, d, a, buffer[i+12], 20, 0x8D2A4C8A);\n\n      a = hh(a, b, c, d, buffer[i+ 5], 4, 0xFFFA3942);\n      d = hh(d, a, b, c, buffer[i+ 8], 11, 0x8771F681);\n      c = hh(c, d, a, b, buffer[i+11], 16, 0x6D9D6122);\n      b = hh(b, c, d, a, buffer[i+14], 23, 0xFDE5380C);\n      a = hh(a, b, c, d, buffer[i+ 1], 4, 0xA4BEEA44);\n      d = hh(d, a, b, c, buffer[i+ 4], 11, 0x4BDECFA9);\n      c = hh(c, d, a, b, buffer[i+ 7], 16, 0xF6BB4B60);\n      b = hh(b, c, d, a, buffer[i+10], 23, 0xBEBFBC70);\n      a = hh(a, b, c, d, buffer[i+13], 4, 0x289B7EC6);\n      d = hh(d, a, b, c, buffer[i+ 0], 11, 0xEAA127FA);\n      c = hh(c, d, a, b, buffer[i+ 3], 16, 0xD4EF3085);\n      b = hh(b, c, d, a, buffer[i+ 6], 23, 0x04881D05);\n      a = hh(a, b, c, d, buffer[i+ 9], 4, 0xD9D4D039);\n      d = hh(d, a, b, c, buffer[i+12], 11, 0xE6DB99E5);\n      c = hh(c, d, a, b, buffer[i+15], 16, 0x1FA27CF8);\n      b = hh(b, c, d, a, buffer[i+ 2], 23, 0xC4AC5665);\n\n      a = ii(a, b, c, d, buffer[i+ 0], 6, 0xF4292244);\n      d = ii(d, a, b, c, buffer[i+ 7], 10, 0x432AFF97);\n      c = ii(c, d, a, b, buffer[i+14], 15, 0xAB9423A7);\n      b = ii(b, c, d, a, buffer[i+ 5], 21, 0xFC93A039);\n      a = ii(a, b, c, d, buffer[i+12], 6, 0x655B59C3);\n      d = ii(d, a, b, c, buffer[i+ 3], 10, 0x8F0CCC92);\n      c = ii(c, d, a, b, buffer[i+10], 15, 0xFFEFF47D);\n      b = ii(b, c, d, a, buffer[i+ 1], 21, 0x85845DD1);\n      a = ii(a, b, c, d, buffer[i+ 8], 6, 0x6FA87E4F);\n      d = ii(d, a, b, c, buffer[i+15], 10, 0xFE2CE6E0);\n      c = ii(c, d, a, b, buffer[i+ 6], 15, 0xA3014314);\n      b = ii(b, c, d, a, buffer[i+13], 21, 0x4E0811A1);\n      a = ii(a, b, c, d, buffer[i+ 4], 6, 0xF7537E82);\n      d = ii(d, a, b, c, buffer[i+11], 10, 0xBD3AF235);\n      c = ii(c, d, a, b, buffer[i+ 2], 15, 0x2AD7D2BB);\n      b = ii(b, c, d, a, buffer[i+ 9], 21, 0xEB86D391);\n\n      w[0] = add(a, w[0]);\n      w[1] = add(b, w[1]);\n      w[2] = add(c, w[2]);\n      w[3] = add(d, w[3]);\n    }\n\n    var t = new Array(16);\n    for (var i = 0; i < 4; i++)\n      for (var j = 0; j < 4; j++)\n        t[i * 4 + j] = (w[i] >> (8 * j)) & 0xFF;\n    return t;\n  }\n\n  return function (s, ofs, len) {\n    // FIX: maybe we should perform the computation by chunk of 64 bytes\n    // as in http://www.myersdaily.org/joseph/javascript/md5.js\n    var buf = [];\n    var content = caml_ml_bytes_content(s);\n    if(typeof content === \"string\"){\n      var b = content;\n      for (var i = 0; i < len; i+=4) {\n        var j = i + ofs;\n        buf[i>>2] =\n          b.charCodeAt(j) | (b.charCodeAt(j+1) << 8) |\n          (b.charCodeAt(j+2) << 16) | (b.charCodeAt(j+3) << 24);\n      }\n      for (; i < len; i++) buf[i>>2] |= b.charCodeAt(i + ofs) << (8 * (i & 3));\n    } else { /* ARRAY */\n      var a = content;\n      for (var i = 0; i < len; i+=4) {\n        var j = i + ofs;\n        buf[i>>2] = a[j] | (a[j+1] << 8) | (a[j+2] << 16) | (a[j+3] << 24);\n      }\n      for (; i < len; i++) buf[i>>2] |= a[i + ofs] << (8 * (i & 3));\n    }\n    return caml_string_of_array(md5(buf, len));\n  }\n} ();\n"
let mlBytes = Js_of_ocaml_compiler.Builtins.register ~name:"mlBytes.js" ~content:"// Js_of_ocaml runtime support\n// http://www.ocsigen.org/js_of_ocaml/\n// Copyright (C) 2010-2014 J\195\169r\195\180me Vouillon\n// Laboratoire PPS - CNRS Universit\195\169 Paris Diderot\n//\n// This program is free software; you can redistribute it and/or modify\n// it under the terms of the GNU Lesser General Public License as published by\n// the Free Software Foundation, with linking exception;\n// either version 2.1 of the License, or (at your option) any later version.\n//\n// This program is distributed in the hope that it will be useful,\n// but WITHOUT ANY WARRANTY; without even the implied warranty of\n// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n// GNU Lesser General Public License for more details.\n//\n// You should have received a copy of the GNU Lesser General Public License\n// along with this program; if not, write to the Free Software\n// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.\n\n// An OCaml string is an object with three fields:\n// - tag 't'\n// - length 'l'\n// - contents 'c'\n//\n// The contents of the string can be either a JavaScript array or\n// a JavaScript string. The length of this string can be less than the\n// length of the OCaml string. In this case, remaining bytes are\n// assumed to be zeroes. Arrays are mutable but consumes more memory\n// than strings. A common pattern is to start from an empty string and\n// progressively fill it from the start. Partial strings makes it\n// possible to implement this efficiently.\n//\n// When converting to and from UTF-16, we keep track of whether the\n// string is composed only of ASCII characters (in which case, no\n// conversion needs to be performed) or not.\n//\n// The string tag can thus take the following values:\n//   full string     BYTE | UNKNOWN:      0\n//                   BYTE | ASCII:        9\n//                   BYTE | NOT_ASCII:    8\n//   string prefix   PARTIAL:             2\n//   array           ARRAY:               4\n//\n// One can use bit masking to discriminate these different cases:\n//   known_encoding(x) = x&8\n//   is_ascii(x) =       x&1\n//   kind(x) =           x&6\n\n//Provides: caml_str_repeat\nfunction caml_str_repeat(n, s) {\n  if(n == 0) return \"\";\n  if (s.repeat) {return s.repeat(n);} // ECMAscript 6 and Firefox 24+\n  var r = \"\", l = 0;\n  for(;;) {\n    if (n & 1) r += s;\n    n >>= 1;\n    if (n == 0) return r;\n    s += s;\n    l++;\n    if (l == 9) {\n      s.slice(0,1); // flatten the string\n      // then, the flattening of the whole string will be faster,\n      // as it will be composed of larger pieces\n    }\n  }\n}\n\n//Provides: caml_subarray_to_jsbytes\n//Weakdef\n// Pre ECMAScript 5, [apply] would not support array-like object.\n// In such setup, Typed_array would be implemented as polyfill, and [f.apply] would\n// fail here. Mark the primitive as Weakdef, so that people can override it easily.\nfunction caml_subarray_to_jsbytes (a, i, len) {\n  var f = String.fromCharCode;\n  if (i == 0 && len <= 4096 && len == a.length) return f.apply (null, a);\n  var s = \"\";\n  for (; 0 < len; i += 1024,len-=1024)\n    s += f.apply (null, a.slice(i,i + Math.min(len, 1024)));\n  return s;\n}\n\n//Provides: caml_utf8_of_utf16\nfunction caml_utf8_of_utf16(s) {\n  for (var b = \"\", t = b, c, d, i = 0, l = s.length; i < l; i++) {\n    c = s.charCodeAt(i);\n    if (c < 0x80) {\n      for (var j = i + 1; (j < l) && (c = s.charCodeAt(j)) < 0x80; j++);\n      if (j - i > 512) { t.substr(0, 1); b += t; t = \"\"; b += s.slice(i, j) }\n      else t += s.slice(i, j);\n      if (j == l) break;\n      i = j;\n    }\n    if (c < 0x800) {\n      t += String.fromCharCode(0xc0 | (c >> 6));\n      t += String.fromCharCode(0x80 | (c & 0x3f));\n    } else if (c < 0xd800 || c >= 0xdfff) {\n      t += String.fromCharCode(0xe0 | (c >> 12),\n                               0x80 | ((c >> 6) & 0x3f),\n                               0x80 | (c & 0x3f));\n    } else if (c >= 0xdbff || i + 1 == l ||\n               (d = s.charCodeAt(i + 1)) < 0xdc00 || d > 0xdfff) {\n      // Unmatched surrogate pair, replaced by \\ufffd (replacement character)\n      t += \"\\xef\\xbf\\xbd\";\n    } else {\n      i++;\n      c = (c << 10) + d - 0x35fdc00;\n      t += String.fromCharCode(0xf0 | (c >> 18),\n                               0x80 | ((c >> 12) & 0x3f),\n                               0x80 | ((c >> 6) & 0x3f),\n                               0x80 | (c & 0x3f));\n    }\n    if (t.length > 1024) {t.substr(0, 1); b += t; t = \"\";}\n  }\n  return b+t;\n}\n\n//Provides: caml_utf16_of_utf8\nfunction caml_utf16_of_utf8(s) {\n  for (var b = \"\", t = \"\", c, c1, c2, v, i = 0, l = s.length; i < l; i++) {\n    c1 = s.charCodeAt(i);\n    if (c1 < 0x80) {\n      for (var j = i + 1; (j < l) && (c1 = s.charCodeAt(j)) < 0x80; j++);\n      if (j - i > 512) { t.substr(0, 1); b += t; t = \"\"; b += s.slice(i, j) }\n      else t += s.slice(i, j);\n      if (j == l) break;\n      i = j;\n    }\n    v = 1;\n    if ((++i < l) && (((c2 = s.charCodeAt(i)) & -64) == 128)) {\n      c = c2 + (c1 << 6);\n      if (c1 < 0xe0) {\n        v = c - 0x3080;\n        if (v < 0x80) v = 1;\n      } else {\n        v = 2;\n        if ((++i < l) && (((c2 = s.charCodeAt(i)) & -64) == 128)) {\n          c = c2 + (c << 6);\n          if (c1 < 0xf0) {\n            v = c - 0xe2080;\n            if ((v < 0x800) || ((v >= 0xd7ff) && (v < 0xe000))) v = 2;\n          } else {\n            v = 3;\n            if ((++i < l) && (((c2 = s.charCodeAt(i)) & -64) == 128) &&\n                (c1 < 0xf5)) {\n              v = c2 - 0x3c82080 + (c << 6);\n              if (v < 0x10000 || v > 0x10ffff) v = 3;\n            }\n          }\n        }\n      }\n    }\n    if (v < 4) { // Invalid sequence\n      i -= v;\n      t += \"\\ufffd\";\n    } else if (v > 0xffff)\n      t += String.fromCharCode(0xd7c0 + (v >> 10), 0xdc00 + (v & 0x3FF))\n    else\n      t += String.fromCharCode(v);\n    if (t.length > 1024) {t.substr(0, 1); b += t; t = \"\";}\n  }\n  return b+t;\n}\n\n//Provides: jsoo_is_ascii\nfunction jsoo_is_ascii (s) {\n  // The regular expression gets better at around this point for all browsers\n  if (s.length < 24) {\n    // Spidermonkey gets much slower when s.length >= 24 (on 64 bit archs)\n    for (var i = 0; i < s.length; i++) if (s.charCodeAt(i) > 127) return false;\n    return true;\n  } else\n    return !/[^\\x00-\\x7f]/.test(s);\n}\n\n//Provides: caml_bytes_unsafe_get mutable\nfunction caml_bytes_unsafe_get (s, i) {\n  switch (s.t & 6) {\n  default: /* PARTIAL */\n    if (i >= s.c.length) return 0;\n  case 0: /* BYTES */\n    return s.c.charCodeAt(i);\n  case 4: /* ARRAY */\n    return s.c[i]\n  }\n}\n\n//Provides: caml_bytes_unsafe_set\n//Requires: caml_convert_bytes_to_array\nfunction caml_bytes_unsafe_set (s, i, c) {\n  // The OCaml compiler uses Char.unsafe_chr on integers larger than 255!\n  c &= 0xff;\n  if (s.t != 4 /* ARRAY */) {\n    if (i == s.c.length) {\n      s.c += String.fromCharCode (c);\n      if (i + 1 == s.l) s.t = 0; /*BYTES | UNKOWN*/\n      return 0;\n    }\n    caml_convert_bytes_to_array (s);\n  }\n  s.c[i] = c;\n  return 0;\n}\n\n//Provides: caml_string_bound_error\n//Requires: caml_invalid_argument\nfunction caml_string_bound_error () {\n  caml_invalid_argument (\"index out of bounds\");\n}\n\n//Provides: caml_bytes_bound_error\n//Requires: caml_invalid_argument\nfunction caml_bytes_bound_error () {\n  caml_invalid_argument (\"index out of bounds\");\n}\n\n//Provides: caml_string_get\n//Requires: caml_string_bound_error, caml_string_unsafe_get\n//Requires: caml_ml_string_length\nfunction caml_string_get (s, i) {\n  if (i >>> 0 >= caml_ml_string_length(s)) caml_string_bound_error();\n  return caml_string_unsafe_get (s, i);\n}\n\n//Provides: caml_string_get16\n//Requires: caml_string_unsafe_get, caml_string_bound_error\n//Requires: caml_ml_string_length\nfunction caml_string_get16(s,i) {\n  if (i >>> 0 >= caml_ml_string_length(s) - 1) caml_string_bound_error();\n  var b1 = caml_string_unsafe_get (s, i),\n      b2 = caml_string_unsafe_get (s, i + 1);\n  return (b2 << 8 | b1);\n}\n\n//Provides: caml_bytes_get16\n//Requires: caml_bytes_unsafe_get, caml_bytes_bound_error\nfunction caml_bytes_get16(s,i) {\n  if (i >>> 0 >= s.l - 1) caml_bytes_bound_error();\n  var b1 = caml_bytes_unsafe_get (s, i),\n      b2 = caml_bytes_unsafe_get (s, i + 1);\n  return (b2 << 8 | b1);\n}\n\n//Provides: caml_string_get32\n//Requires: caml_string_unsafe_get, caml_string_bound_error\n//Requires: caml_ml_string_length\nfunction caml_string_get32(s,i) {\n  if (i >>> 0 >= caml_ml_string_length(s) - 3) caml_string_bound_error();\n  var b1 = caml_string_unsafe_get (s, i),\n      b2 = caml_string_unsafe_get (s, i + 1),\n      b3 = caml_string_unsafe_get (s, i + 2),\n      b4 = caml_string_unsafe_get (s, i + 3);\n  return (b4 << 24 | b3 << 16 | b2 << 8 | b1);\n}\n\n//Provides: caml_bytes_get32\n//Requires: caml_bytes_unsafe_get, caml_bytes_bound_error\nfunction caml_bytes_get32(s,i) {\n  if (i >>> 0 >= s.l - 3) caml_bytes_bound_error();\n  var b1 = caml_bytes_unsafe_get (s, i),\n      b2 = caml_bytes_unsafe_get (s, i + 1),\n      b3 = caml_bytes_unsafe_get (s, i + 2),\n      b4 = caml_bytes_unsafe_get (s, i + 3);\n  return (b4 << 24 | b3 << 16 | b2 << 8 | b1);\n}\n\n//Provides: caml_string_get64\n//Requires: caml_string_unsafe_get, caml_string_bound_error\n//Requires: caml_int64_of_bytes\n//Requires: caml_ml_string_length\nfunction caml_string_get64(s,i) {\n  if (i >>> 0 >= caml_ml_string_length(s) - 7) caml_string_bound_error();\n  var a = new Array(8);\n  for(var j = 0; j < 8; j++){\n    a[7 - j] = caml_string_unsafe_get (s, i + j);\n  }\n  return caml_int64_of_bytes(a);\n}\n\n//Provides: caml_bytes_get64\n//Requires: caml_bytes_unsafe_get, caml_bytes_bound_error\n//Requires: caml_int64_of_bytes\nfunction caml_bytes_get64(s,i) {\n  if (i >>> 0 >= s.l - 7) caml_bytes_bound_error();\n  var a = new Array(8);\n  for(var j = 0; j < 8; j++){\n    a[7 - j] = caml_bytes_unsafe_get (s, i + j);\n  }\n  return caml_int64_of_bytes(a);\n}\n\n//Provides: caml_bytes_get\n//Requires: caml_bytes_bound_error, caml_bytes_unsafe_get\nfunction caml_bytes_get (s, i) {\n  if (i >>> 0 >= s.l) caml_bytes_bound_error();\n  return caml_bytes_unsafe_get (s, i);\n}\n\n//Provides: caml_string_set\n//Requires: caml_failwith\n//If: js-string\nfunction caml_string_set (s, i, c) {\n  caml_failwith(\"caml_string_set\");\n}\n\n//Provides: caml_string_set\n//Requires: caml_string_unsafe_set, caml_string_bound_error\n//If: !js-string\nfunction caml_string_set (s, i, c) {\n  if (i >>> 0 >= s.l) caml_string_bound_error();\n  return caml_string_unsafe_set (s, i, c);\n}\n\n//Provides: caml_bytes_set16\n//Requires: caml_bytes_bound_error, caml_bytes_unsafe_set\nfunction caml_bytes_set16(s,i,i16){\n  if (i >>> 0 >= s.l - 1) caml_bytes_bound_error();\n  var b2 = 0xFF & i16 >> 8,\n      b1 = 0xFF & i16;\n  caml_bytes_unsafe_set (s, i + 0, b1);\n  caml_bytes_unsafe_set (s, i + 1, b2);\n  return 0\n}\n\n//Provides: caml_string_set16\n//Requires: caml_failwith\n//If: js-string\nfunction caml_string_set16(s,i,i16){\n  caml_failwith(\"caml_string_set16\");\n}\n\n//Provides: caml_string_set16\n//Requires: caml_bytes_set16\n//If: !js-string\nfunction caml_string_set16(s,i,i16){\n  return caml_bytes_set16(s,i,i16);\n}\n\n//Provides: caml_bytes_set32\n//Requires: caml_bytes_bound_error, caml_bytes_unsafe_set\nfunction caml_bytes_set32(s,i,i32){\n  if (i >>> 0 >= s.l - 3) caml_bytes_bound_error();\n  var b4 = 0xFF & i32 >> 24,\n      b3 = 0xFF & i32 >> 16,\n      b2 = 0xFF & i32 >> 8,\n      b1 = 0xFF & i32;\n  caml_bytes_unsafe_set (s, i + 0, b1);\n  caml_bytes_unsafe_set (s, i + 1, b2);\n  caml_bytes_unsafe_set (s, i + 2, b3);\n  caml_bytes_unsafe_set (s, i + 3, b4);\n  return 0\n}\n\n//Provides: caml_string_set32\n//Requires: caml_failwith\n//If: js-string\nfunction caml_string_set32(s,i,i32){\n  caml_failwith(\"caml_string_set32\");\n}\n\n//Provides: caml_string_set32\n//Requires: caml_bytes_set32\n//If: !js-string\nfunction caml_string_set32(s,i,i32){\n  return caml_bytes_set32(s,i,i32);\n}\n\n//Provides: caml_bytes_set64\n//Requires: caml_bytes_bound_error, caml_bytes_unsafe_set\n//Requires: caml_int64_to_bytes\nfunction caml_bytes_set64(s,i,i64){\n  if (i >>> 0 >= s.l - 7) caml_bytes_bound_error();\n  var a = caml_int64_to_bytes(i64);\n  for(var j = 0; j < 8; j++) {\n    caml_bytes_unsafe_set (s, i + 7 - j, a[j]);\n  }\n  return 0\n}\n\n//Provides: caml_string_set64\n//Requires: caml_failwith\n//If: js-string\nfunction caml_string_set64(s,i,i64){\n  caml_failwith(\"caml_string_set64\");\n}\n\n//Provides: caml_string_set64\n//Requires: caml_bytes_set64\n//If: !js-string\nfunction caml_string_set64(s,i,i64){\n  return caml_bytes_set64(s,i,i64);\n}\n\n//Provides: caml_bytes_set\n//Requires: caml_bytes_bound_error, caml_bytes_unsafe_set\nfunction caml_bytes_set (s, i, c) {\n  if (i >>> 0 >= s.l) caml_bytes_bound_error();\n  return caml_bytes_unsafe_set (s, i, c);\n}\n\n//Provides: caml_bytes_of_utf16_jsstring\n//Requires: jsoo_is_ascii, caml_utf8_of_utf16, MlBytes\nfunction caml_bytes_of_utf16_jsstring (s) {\n  var tag = 9 /* BYTES | ASCII */;\n  if (!jsoo_is_ascii(s))\n    tag = 8 /* BYTES | NOT_ASCII */, s = caml_utf8_of_utf16(s);\n  return new MlBytes(tag, s, s.length);\n}\n\n\n//Provides: MlBytes\n//Requires: caml_convert_string_to_bytes, jsoo_is_ascii, caml_utf16_of_utf8\nfunction MlBytes (tag, contents, length) {\n  this.t=tag; this.c=contents; this.l=length;\n}\nMlBytes.prototype.toString = function(){\n  switch (this.t) {\n  case 9: /*BYTES | ASCII*/\n    return this.c;\n  default:\n    caml_convert_string_to_bytes(this);\n  case 0: /*BYTES | UNKOWN*/\n    if (jsoo_is_ascii(this.c)) {\n      this.t = 9; /*BYTES | ASCII*/\n      return this.c;\n    }\n    this.t = 8; /*BYTES | NOT_ASCII*/\n  case 8: /*BYTES | NOT_ASCII*/\n    return this.c;\n  }\n};\nMlBytes.prototype.toUtf16 = function (){\n  var r = this.toString();\n  if(this.t == 9) return r\n  return caml_utf16_of_utf8(r);\n}\nMlBytes.prototype.slice = function (){\n  var content = this.t == 4 ? this.c.slice() : this.c;\n  return new MlBytes(this.t,content,this.l);\n}\n\n//Provides: caml_convert_string_to_bytes\n//Requires: caml_str_repeat, caml_subarray_to_jsbytes\nfunction caml_convert_string_to_bytes (s) {\n  /* Assumes not BYTES */\n  if (s.t == 2 /* PARTIAL */)\n    s.c += caml_str_repeat(s.l - s.c.length, '\\0')\n  else\n    s.c = caml_subarray_to_jsbytes (s.c, 0, s.c.length);\n  s.t = 0; /*BYTES | UNKOWN*/\n}\n\n//Provides: caml_convert_bytes_to_array\nfunction caml_convert_bytes_to_array (s) {\n  /* Assumes not ARRAY */\n  if(globalThis.Uint8Array) {\n    var a = new globalThis.Uint8Array(s.l);\n  } else {\n    var a = new Array(s.l);\n  }\n  var b = s.c, l = b.length, i = 0;\n  for (; i < l; i++) a[i] = b.charCodeAt(i);\n  for (l = s.l; i < l; i++) a[i] = 0;\n  s.c = a;\n  s.t = 4; /* ARRAY */\n  return a;\n}\n\n//Provides: caml_array_of_bytes mutable\n//Requires: caml_convert_bytes_to_array\nfunction caml_array_of_bytes (s) {\n  if (s.t != 4 /* ARRAY */) caml_convert_bytes_to_array(s);\n  return s.c;\n}\n\n//Provides: caml_array_of_string mutable\n//Requires: caml_convert_bytes_to_array\n//Requires: caml_ml_string_length, caml_string_unsafe_get\nfunction caml_array_of_string (s) {\n  var l = caml_ml_string_length(s);\n  var a = new Array(l);\n  var i = 0;\n  for (; i < l; i++) a[i] = caml_string_unsafe_get(s,i);\n  return a;\n}\n\n//Provides: caml_create_string const\n//Requires: MlBytes, caml_invalid_argument\n//If: !js-string\nfunction caml_create_string(len) {\n  if(len < 0) caml_invalid_argument(\"String.create\");\n  return new MlBytes(len?2:9,\"\",len);\n}\n\n//Provides: caml_create_string const\n//Requires: caml_invalid_argument\n//If: js-string\nfunction caml_create_string(len) {\n  caml_invalid_argument(\"String.create\");\n}\n\n//Provides: caml_create_bytes const\n//Requires: MlBytes,caml_invalid_argument\nfunction caml_create_bytes(len) {\n  if (len < 0) caml_invalid_argument(\"Bytes.create\");\n  return new MlBytes(len?2:9,\"\",len);\n}\n\n//Provides: caml_string_of_array\n//Requires: caml_subarray_to_jsbytes, caml_string_of_jsbytes\nfunction caml_string_of_array (a) {\n  return caml_string_of_jsbytes(caml_subarray_to_jsbytes(a,0,a.length));\n}\n\n//Provides: caml_bytes_of_array\n//Requires: MlBytes\nfunction caml_bytes_of_array (a) {\n  return new MlBytes(4,a,a.length);\n}\n\n//Provides: caml_bytes_compare mutable\n//Requires: caml_convert_string_to_bytes\nfunction caml_bytes_compare(s1, s2) {\n  (s1.t & 6) && caml_convert_string_to_bytes(s1);\n  (s2.t & 6) && caml_convert_string_to_bytes(s2);\n  return (s1.c < s2.c)?-1:(s1.c > s2.c)?1:0;\n}\n\n\n//Provides: caml_bytes_equal mutable (const, const)\n//Requires: caml_convert_string_to_bytes\nfunction caml_bytes_equal(s1, s2) {\n  if(s1 === s2) return 1;\n  (s1.t & 6) && caml_convert_string_to_bytes(s1);\n  (s2.t & 6) && caml_convert_string_to_bytes(s2);\n  return (s1.c == s2.c)?1:0;\n}\n\n//Provides: caml_string_notequal mutable (const, const)\n//Requires: caml_string_equal\nfunction caml_string_notequal(s1, s2) { return 1-caml_string_equal(s1, s2); }\n\n//Provides: caml_bytes_notequal mutable (const, const)\n//Requires: caml_bytes_equal\nfunction caml_bytes_notequal(s1, s2) { return 1-caml_bytes_equal(s1, s2); }\n\n//Provides: caml_bytes_lessequal mutable\n//Requires: caml_convert_string_to_bytes\nfunction caml_bytes_lessequal(s1, s2) {\n  (s1.t & 6) && caml_convert_string_to_bytes(s1);\n  (s2.t & 6) && caml_convert_string_to_bytes(s2);\n  return (s1.c <= s2.c)?1:0;\n}\n\n//Provides: caml_bytes_lessthan mutable\n//Requires: caml_convert_string_to_bytes\nfunction caml_bytes_lessthan(s1, s2) {\n  (s1.t & 6) && caml_convert_string_to_bytes(s1);\n  (s2.t & 6) && caml_convert_string_to_bytes(s2);\n  return (s1.c < s2.c)?1:0;\n}\n\n//Provides: caml_string_greaterequal\n//Requires: caml_string_lessequal\nfunction caml_string_greaterequal(s1, s2) {\n  return caml_string_lessequal(s2,s1);\n}\n//Provides: caml_bytes_greaterequal\n//Requires: caml_bytes_lessequal\nfunction caml_bytes_greaterequal(s1, s2) {\n  return caml_bytes_lessequal(s2,s1);\n}\n\n//Provides: caml_string_greaterthan\n//Requires: caml_string_lessthan\nfunction caml_string_greaterthan(s1, s2) {\n  return caml_string_lessthan(s2, s1);\n}\n\n//Provides: caml_bytes_greaterthan\n//Requires: caml_bytes_lessthan\nfunction caml_bytes_greaterthan(s1, s2) {\n  return caml_bytes_lessthan(s2, s1);\n}\n\n//Provides: caml_fill_bytes\n//Requires: caml_str_repeat, caml_convert_bytes_to_array\nfunction caml_fill_bytes(s, i, l, c) {\n  if (l > 0) {\n    if (i == 0 && (l >= s.l || (s.t == 2 /* PARTIAL */ && l >= s.c.length))) {\n      if (c == 0) {\n        s.c = \"\";\n        s.t = 2; /* PARTIAL */\n      } else {\n        s.c = caml_str_repeat (l, String.fromCharCode(c));\n        s.t = (l == s.l)?0 /* BYTES | UNKOWN */ :2; /* PARTIAL */\n      }\n    } else {\n      if (s.t != 4 /* ARRAY */) caml_convert_bytes_to_array(s);\n      for (l += i; i < l; i++) s.c[i] = c;\n    }\n  }\n  return 0;\n}\n\n//Provides: caml_fill_string\n//Requires: caml_fill_bytes\nvar caml_fill_string = caml_fill_bytes\n\n//Provides: caml_blit_bytes\n//Requires: caml_subarray_to_jsbytes, caml_convert_bytes_to_array\nfunction caml_blit_bytes(s1, i1, s2, i2, len) {\n  if (len == 0) return 0;\n  if ((i2 == 0) &&\n      (len >= s2.l || (s2.t == 2 /* PARTIAL */ && len >= s2.c.length))) {\n    s2.c = (s1.t == 4 /* ARRAY */)?\n      caml_subarray_to_jsbytes(s1.c, i1, len):\n      (i1 == 0 && s1.c.length == len)?s1.c:s1.c.substr(i1, len);\n    s2.t = (s2.c.length == s2.l)?0 /* BYTES | UNKOWN */ :2; /* PARTIAL */\n  } else if (s2.t == 2 /* PARTIAL */ && i2 == s2.c.length) {\n    s2.c += (s1.t == 4 /* ARRAY */)?\n      caml_subarray_to_jsbytes(s1.c, i1, len):\n      (i1 == 0 && s1.c.length == len)?s1.c:s1.c.substr(i1, len);\n    s2.t = (s2.c.length == s2.l)?0 /* BYTES | UNKOWN */ :2; /* PARTIAL */\n  } else {\n    if (s2.t != 4 /* ARRAY */) caml_convert_bytes_to_array(s2);\n    var c1 = s1.c, c2 = s2.c;\n    if (s1.t == 4 /* ARRAY */) {\n      if (i2 <= i1) {\n        for (var i = 0; i < len; i++) c2 [i2 + i] = c1 [i1 + i];\n      } else {\n        for (var i = len - 1; i >= 0; i--) c2 [i2 + i] = c1 [i1 + i];\n      }\n    } else {\n      var l = Math.min (len, c1.length - i1);\n      for (var i = 0; i < l; i++) c2 [i2 + i] = c1.charCodeAt(i1 + i);\n      for (; i < len; i++) c2 [i2 + i] = 0;\n    }\n  }\n  return 0;\n}\n\n//Provides: caml_blit_string\n//Requires: caml_blit_bytes, caml_bytes_of_string\nfunction caml_blit_string(a,b,c,d,e) {\n  caml_blit_bytes(caml_bytes_of_string(a),b,c,d,e);\n  return 0\n}\n\n//Provides: caml_ml_bytes_length const\nfunction caml_ml_bytes_length(s) { return s.l }\n\n//Provides: caml_string_unsafe_get const\n//If: js-string\nfunction caml_string_unsafe_get (s, i) {\n  return s.charCodeAt(i);\n}\n\n//Provides: caml_string_unsafe_set\n//Requires: caml_failwith\n//If: js-string\nfunction caml_string_unsafe_set (s, i, c) {\n  caml_failwith(\"caml_string_unsafe_set\");\n}\n\n//Provides: caml_ml_string_length const\n//If: js-string\nfunction caml_ml_string_length(s) {\n  return s.length\n}\n\n//Provides: caml_string_compare const\n//If: js-string\nfunction caml_string_compare(s1, s2) {\n  return (s1 < s2)?-1:(s1 > s2)?1:0;\n}\n\n//Provides: caml_string_equal const\n//If: js-string\nfunction caml_string_equal(s1, s2) {\n  if(s1 === s2) return 1;\n  return 0;\n}\n\n//Provides: caml_string_lessequal const\n//If: js-string\nfunction caml_string_lessequal(s1, s2) {\n  return (s1 <= s2)?1:0;\n}\n\n//Provides: caml_string_lessthan const\n//If: js-string\nfunction caml_string_lessthan(s1, s2) {\n  return (s1 < s2)?1:0;\n}\n\n//Provides: caml_string_of_bytes\n//Requires: caml_convert_string_to_bytes, caml_string_of_jsbytes\n//If: js-string\nfunction caml_string_of_bytes(s) {\n  (s.t & 6) && caml_convert_string_to_bytes(s);\n  return caml_string_of_jsbytes(s.c);\n}\n\n//Provides: caml_bytes_of_string const\n//Requires: caml_bytes_of_jsbytes, caml_jsbytes_of_string\n//If: js-string\nfunction caml_bytes_of_string(s) {\n  return caml_bytes_of_jsbytes(caml_jsbytes_of_string(s));\n}\n\n//Provides: caml_string_of_jsbytes const\n//If: js-string\nfunction caml_string_of_jsbytes(x) { return x }\n\n//Provides: caml_jsbytes_of_string const\n//If: js-string\nfunction caml_jsbytes_of_string(x) { return x }\n\n//Provides: caml_jsstring_of_string const\n//Requires: jsoo_is_ascii, caml_utf16_of_utf8\n//If: js-string\nfunction caml_jsstring_of_string(s) {\n  if(jsoo_is_ascii(s))\n    return s;\n  return caml_utf16_of_utf8(s); }\n\n//Provides: caml_string_of_jsstring const\n//Requires: jsoo_is_ascii, caml_utf8_of_utf16, caml_string_of_jsbytes\n//If: js-string\nfunction caml_string_of_jsstring (s) {\n  if (jsoo_is_ascii(s))\n    return caml_string_of_jsbytes(s)\n  else return caml_string_of_jsbytes(caml_utf8_of_utf16(s));\n}\n\n//Provides: caml_bytes_of_jsbytes const\n//Requires: MlBytes\nfunction caml_bytes_of_jsbytes(s) { return new MlBytes(0,s,s.length); }\n\n\n// The section below should be used when use-js-string=false\n\n//Provides: caml_string_unsafe_get const\n//Requires: caml_bytes_unsafe_get\n//If: !js-string\nfunction caml_string_unsafe_get (s, i) {\n  return caml_bytes_unsafe_get(s,i);\n}\n\n//Provides: caml_string_unsafe_set\n//Requires: caml_bytes_unsafe_set\n//If: !js-string\nfunction caml_string_unsafe_set (s, i, c) {\n  return caml_bytes_unsafe_set(s,i,c);\n}\n\n//Provides: caml_ml_string_length const\n//Requires: caml_ml_bytes_length\n//If: !js-string\nfunction caml_ml_string_length(s) {\n  return caml_ml_bytes_length(s)\n}\n\n//Provides: caml_string_compare\n//Requires: caml_bytes_compare\n//If: !js-string\nfunction caml_string_compare(s1, s2) {\n  return caml_bytes_compare(s1,s2)\n}\n\n//Provides: caml_string_equal\n//Requires: caml_bytes_equal\n//If: !js-string\nfunction caml_string_equal(s1, s2) {\n  return caml_bytes_equal(s1,s2)\n}\n\n//Provides: caml_string_lessequal\n//Requires: caml_bytes_lessequal\n//If: !js-string\nfunction caml_string_lessequal(s1, s2) {\n  return caml_bytes_lessequal(s1,s2)\n}\n\n//Provides: caml_string_lessthan\n//Requires: caml_bytes_lessthan\n//If: !js-string\nfunction caml_string_lessthan(s1, s2) {\n  return caml_bytes_lessthan(s1,s2)\n}\n\n//Provides: caml_string_of_bytes\n//If: !js-string\nfunction caml_string_of_bytes(s) { return s }\n\n//Provides: caml_bytes_of_string const\n//If: !js-string\nfunction caml_bytes_of_string(s) { return s }\n\n//Provides: caml_string_of_jsbytes const\n//Requires: caml_bytes_of_jsbytes\n//If: !js-string\nfunction caml_string_of_jsbytes(s) { return caml_bytes_of_jsbytes(s); }\n\n//Provides: caml_jsbytes_of_string const\n//Requires: caml_convert_string_to_bytes\n//If: !js-string\nfunction caml_jsbytes_of_string(s) {\n  (s.t & 6) && caml_convert_string_to_bytes(s);\n  return s.c }\n\n//Provides: caml_jsstring_of_string mutable (const)\n//If: !js-string\nfunction caml_jsstring_of_string(s){\n  return s.toUtf16()\n}\n\n//Provides: caml_string_of_jsstring\n//Requires: caml_bytes_of_utf16_jsstring\n//If: !js-string\nfunction caml_string_of_jsstring (s) {\n  return caml_bytes_of_utf16_jsstring(s);\n}\n\n//Provides: caml_is_ml_bytes\n//Requires: MlBytes\nfunction caml_is_ml_bytes(s) {\n  return (s instanceof MlBytes);\n}\n\n//Provides: caml_ml_bytes_content\n//Requires: MlBytes, caml_convert_string_to_bytes\nfunction caml_ml_bytes_content(s) {\n  switch (s.t & 6) {\n  default: /* PARTIAL */\n    caml_convert_string_to_bytes(s);\n  case 0: /* BYTES */\n    return s.c;\n  case 4:\n    return s.c\n  }\n}\n\n//Provides: caml_is_ml_string\n//Requires: jsoo_is_ascii\n//If: js-string\nfunction caml_is_ml_string(s) {\n  return (typeof s === \"string\" && !/[^\\x00-\\xff]/.test(s));\n}\n\n//Provides: caml_is_ml_string\n//Requires: caml_is_ml_bytes\n//If: !js-string\nfunction caml_is_ml_string(s) {\n  return caml_is_ml_bytes(s);\n}\n\n// The functions below are deprecated\n\n//Provides: caml_js_to_byte_string const\n//Requires: caml_string_of_jsbytes\nfunction caml_js_to_byte_string(s) { return caml_string_of_jsbytes(s) }\n\n//Provides: caml_new_string\n//Requires: caml_string_of_jsbytes\nfunction caml_new_string (s) { return caml_string_of_jsbytes(s) }\n\n//Provides: caml_js_from_string mutable (const)\n//Requires: caml_jsstring_of_string\nfunction caml_js_from_string(s) {\n  return caml_jsstring_of_string(s)\n}\n\n//Provides: caml_to_js_string mutable (const)\n//Requires: caml_jsstring_of_string\nfunction caml_to_js_string(s) {\n  return caml_jsstring_of_string(s)\n}\n\n//Provides: caml_js_to_string const\n//Requires: caml_string_of_jsstring\nfunction caml_js_to_string (s) {\n  return caml_string_of_jsstring(s);\n}\n"
let nat = Js_of_ocaml_compiler.Builtins.register ~name:"nat.js" ~content:"//Provides: initialize_nat\n//Requires: caml_custom_ops\n//Requires: serialize_nat, deserialize_nat, caml_hash_nat\nfunction initialize_nat() {\n  caml_custom_ops[\"_nat\"] =\n    { deserialize : deserialize_nat,\n      serialize : serialize_nat,\n      hash : caml_hash_nat\n    }\n}\n\n//Provides: MlNat\nfunction MlNat(x){\n  this.data = new globalThis.Int32Array(x);\n  // length_nat isn't external, so we have to make the Obj.size\n  // work out right. The +2 to array length seems to work.\n  this.length = this.data.length + 2\n}\n\nMlNat.prototype.caml_custom = \"_nat\";\n\n//Provides: caml_hash_nat\n//Requires: caml_hash_mix_int, num_digits_nat\nfunction caml_hash_nat(x) {\n  var len = num_digits_nat(x, 0, x.data.length);\n  var h = 0;\n  for (var i = 0; i < len; i++) {\n    h = caml_hash_mix_int(h, x.data[i]);\n  }\n  return h;\n}\n\n\n//Provides: nat_of_array\n//Requires: MlNat\nfunction nat_of_array(l){\n  return new MlNat(l);\n}\n\n//Provides: create_nat\n//Requires: MlNat\nfunction create_nat(size) {\n  var arr = new MlNat(size);\n  for(var i = 0; i < size; i++) {\n    arr.data[i] = -1;\n  }\n  return arr;\n}\n\n//Provides: set_to_zero_nat\nfunction set_to_zero_nat(nat, ofs, len) {\n  for(var i = 0; i < len; i++) {\n    nat.data[ofs+i] = 0;\n  }\n  return 0;\n}\n\n//Provides: blit_nat\nfunction blit_nat(nat1, ofs1, nat2, ofs2, len) {\n  for(var i = 0; i < len; i++) {\n    nat1.data[ofs1+i] = nat2.data[ofs2+i];\n  }\n  return 0;\n}\n\n//Provides: set_digit_nat\nfunction set_digit_nat(nat, ofs, digit) {\n  nat.data[ofs] = digit;\n  return 0;\n}\n\n//Provides: nth_digit_nat\nfunction nth_digit_nat(nat, ofs) {\n  return nat.data[ofs];\n}\n\n//Provides: set_digit_nat_native\nfunction set_digit_nat_native(nat, ofs, digit) {\n  nat.data[ofs] = digit;\n  return 0;\n}\n\n//Provides: nth_digit_nat_native\nfunction nth_digit_nat_native(nat, ofs) {\n  return nat.data[ofs];\n}\n\n//Provides: num_digits_nat\nfunction num_digits_nat(nat, ofs, len) {\n  for(var i = len - 1; i >= 0; i--) {\n    if(nat.data[ofs+i] != 0) return i+1;\n  }\n  return 1; // 0 counts as 1 digit\n}\n\n//Provides: num_leading_zero_bits_in_digit\nfunction num_leading_zero_bits_in_digit(nat, ofs) {\n  var a = nat.data[ofs];\n  var b = 0;\n  if(a & 0xFFFF0000) { b +=16; a >>>=16; }\n  if(a & 0xFF00)     { b += 8; a >>>= 8; }\n  if(a & 0xF0)       { b += 4; a >>>= 4; }\n  if(a & 12)         { b += 2; a >>>= 2; }\n  if(a & 2)          { b += 1; a >>>= 1; }\n  if(a & 1)          { b += 1; }\n  return 32 - b;\n}\n\n//Provides: is_digit_int\nfunction is_digit_int(nat, ofs) {\n  if (nat.data[ofs] >= 0) return 1\n  return 0;\n}\n\n//Provides: is_digit_zero\nfunction is_digit_zero(nat, ofs) {\n  if(nat.data[ofs] == 0) return 1;\n  return 0;\n}\n\n//Provides: is_digit_odd\nfunction is_digit_odd(nat, ofs) {\n  if(nat.data[ofs] & 1) return 1;\n  return 0;\n}\n\n//Provides: incr_nat\nfunction incr_nat(nat, ofs, len, carry_in) {\n  var carry = carry_in;\n  for(var i = 0; i < len; i++) {\n    var x = (nat.data[ofs+i] >>> 0) + carry;\n    nat.data[ofs+i] = (x | 0);\n    if(x == (x >>> 0)) {\n      carry = 0;\n      break;\n    } else {\n      carry = 1;\n    }\n  }\n  return carry;\n}\n\n// len1 >= len2\n//Provides: add_nat\n//Requires: incr_nat\nfunction add_nat(nat1, ofs1, len1, nat2, ofs2, len2, carry_in) {\n  var carry = carry_in;\n  for(var i = 0; i < len2; i++) {\n    var x = (nat1.data[ofs1+i] >>> 0) + (nat2.data[ofs2+i] >>> 0) + carry;\n    nat1.data[ofs1+i] = x\n    if(x == (x >>> 0)) {\n      carry = 0;\n    } else {\n      carry = 1;\n    }\n  }\n  return incr_nat(nat1, ofs1+len2, len1-len2, carry);\n}\n\n//Provides: complement_nat\nfunction complement_nat(nat, ofs, len) {\n  for(var i = 0; i < len; i++) {\n    nat.data[ofs+i] = (-1 >>> 0) - (nat.data[ofs+i] >>> 0);\n  }\n}\n\n// ocaml flips carry_in\n//Provides: decr_nat\nfunction decr_nat(nat, ofs, len, carry_in) {\n  var borrow = (carry_in == 1) ? 0 : 1;\n  for(var i = 0; i < len; i++) {\n    var x = (nat.data[ofs+i] >>>0) - borrow;\n    nat.data[ofs+i] = x;\n    if (x >= 0) {\n      borrow = 0;\n      break;\n    } else {\n      borrow = 1;\n    }\n  }\n  return (borrow == 1) ? 0 : 1;\n}\n\n// ocaml flips carry_in\n// len1 >= len2\n//Provides: sub_nat\n//Requires: decr_nat\nfunction sub_nat(nat1, ofs1, len1, nat2, ofs2, len2, carry_in) {\n  var borrow = (carry_in == 1) ? 0 : 1;\n  for(var i = 0; i < len2; i++) {\n    var x = (nat1.data[ofs1+i] >>> 0) - (nat2.data[ofs2+i] >>> 0) - borrow;\n    nat1.data[ofs1+i] = x;\n    if (x >= 0) {\n      borrow = 0;\n    } else {\n      borrow = 1;\n    }\n  }\n  return decr_nat(nat1, ofs1+len2, len1-len2, (borrow==1)?0:1);\n}\n\n// nat1 += nat2 * nat3[ofs3]\n// len1 >= len2\n//Provides: mult_digit_nat\n//Requires: add_nat, nat_of_array\nfunction mult_digit_nat(nat1, ofs1, len1, nat2, ofs2, len2, nat3, ofs3) {\n  var carry = 0;\n  var a = (nat3.data[ofs3] >>> 0);\n  for(var i = 0; i < len2; i++) {\n    var x1 = (nat1.data[ofs1+i] >>> 0) + (nat2.data[ofs2+i] >>> 0) * (a & 0x0000FFFF) + carry;\n    var x2 = (nat2.data[ofs2+i] >>> 0) * (a >>> 16);\n    carry = Math.floor(x2/65536);\n    var x3 = x1 + (x2 % 65536) * 65536;\n    nat1.data[ofs1+i] = x3;\n    carry += Math.floor(x3/4294967296);\n  }\n\n  if(len2 < len1 && carry) {\n    return add_nat(nat1, ofs1+len2, len1-len2, nat_of_array([carry]), 0, 1, 0);\n  } else {\n    return carry;\n  }\n}\n\n// nat1 += nat2 * nat3\n// len1 >= len2 + len3.\n//Provides: mult_nat\n//Requires: mult_digit_nat\nfunction mult_nat(nat1, ofs1, len1, nat2, ofs2, len2, nat3, ofs3, len3) {\n  var carry = 0;\n  for(var i = 0; i < len3; i++) {\n    carry += mult_digit_nat(nat1, ofs1+i, len1-i, nat2, ofs2, len2, nat3, ofs3+i);\n  }\n  return carry;\n}\n\n// nat1 = 2 * nat1 + nat2 * nat2\n// len1 >= 2 * len2\n//Provides: square_nat\n//Requires: mult_nat, add_nat\nfunction square_nat(nat1, ofs1, len1, nat2, ofs2, len2) {\n  var carry = 0;\n  carry += add_nat(nat1, ofs1, len1, nat1, ofs1, len1, 0);\n  carry += mult_nat(nat1, ofs1, len1, nat2, ofs2, len2, nat2, ofs2, len2);\n  return carry;\n}\n\n\n// 0 <= shift < 32\n//Provides: shift_left_nat\nfunction shift_left_nat(nat1, ofs1, len1, nat2, ofs2, nbits) {\n  if(nbits == 0) {\n    nat2.data[ofs2] = 0;\n    return 0;\n  }\n  var wrap = 0;\n  for(var i = 0; i < len1; i++) {\n    var a = (nat1.data[ofs1+i] >>> 0);\n    nat1.data[ofs1+i] = (a << nbits) | wrap;\n    wrap = a >>> (32 - nbits);\n  }\n  nat2.data[ofs2] = wrap;\n  return 0;\n}\n\n// Assuming c > a, returns [quotient, remainder] of (a<<32 + b)/c\n//Provides: div_helper\nfunction div_helper(a, b, c) {\n  var x = a * 65536 + (b>>>16);\n  var y = Math.floor(x/c) * 65536;\n  var z = (x % c) * 65536;\n  var w = z + (b & 0x0000FFFF);\n  return [y + Math.floor(w/c), w % c];\n}\n\n// nat1[ofs1+len] < nat2[ofs2]\n//Provides: div_digit_nat\n//Requires: div_helper\nfunction div_digit_nat(natq, ofsq, natr, ofsr, nat1, ofs1, len, nat2, ofs2) {\n  var rem = (nat1.data[ofs1+len-1] >>>0);\n  // natq[ofsq+len-1] is guaranteed to be zero (due to the MSD requirement),\n  // and should not be written to.\n  for(var i = len-2; i >= 0; i--) {\n    var x = div_helper(rem, (nat1.data[ofs1+i] >>> 0), (nat2.data[ofs2] >>> 0));\n    natq.data[ofsq+i] = x[0];\n    rem = x[1];\n  }\n  natr.data[ofsr] = rem;\n  return 0;\n}\n\n// nat1[nat2:] := nat1 / nat2\n// nat1[:nat2] := nat1 % nat2\n// len1 > len2, nat2[ofs2+len2-1] > nat1[ofs1+len1-1]\n//Provides: div_nat\n//Requires: div_digit_nat, div_helper, num_leading_zero_bits_in_digit, shift_left_nat, shift_right_nat, create_nat, set_to_zero_nat, mult_digit_nat, sub_nat, compare_nat, nat_of_array\nfunction div_nat(nat1, ofs1, len1, nat2, ofs2, len2) {\n  if(len2 == 1) {\n    div_digit_nat(nat1, ofs1+1, nat1, ofs1, nat1, ofs1, len1, nat2, ofs2);\n    return 0;\n  }\n\n  var s = num_leading_zero_bits_in_digit(nat2, ofs2+len2-1);\n  shift_left_nat(nat2, ofs2, len2, nat_of_array([0]), 0, s);\n  shift_left_nat(nat1, ofs1, len1, nat_of_array([0]), 0, s);\n\n  var d = (nat2.data[ofs2+len2-1] >>> 0) + 1;\n  var a = create_nat(len2+1);\n  for (var i = len1 - 1; i >= len2; i--) {\n    // Decent lower bound on quo\n    var quo = d == 4294967296 ? (nat1.data[ofs1+i] >>> 0) : div_helper((nat1.data[ofs1+i] >>> 0), (nat1.data[ofs1+i-1] >>>0), d)[0];\n    set_to_zero_nat(a, 0, len2+1);\n    mult_digit_nat(a, 0, len2+1, nat2, ofs2, len2, nat_of_array([quo]), 0);\n    sub_nat(nat1, ofs1+i-len2, len2+1, a, 0, len2+1, 1);\n\n    while (nat1.data[ofs1+i] != 0 || compare_nat(nat1, ofs1+i-len2, len2, nat2, ofs2, len2) >= 0) {\n      quo = quo + 1;\n      sub_nat(nat1, ofs1+i-len2, len2+1, nat2, ofs2, len2, 1);\n    }\n\n    nat1.data[ofs1+i] = quo;\n  }\n\n  shift_right_nat(nat1, ofs1, len2, nat_of_array([0]), 0, s); // shift remainder\n  shift_right_nat(nat2, ofs2, len2, nat_of_array([0]), 0, s); // restore\n  return 0;\n}\n\n\n// 0 <= shift < 32\n//Provides: shift_right_nat\nfunction shift_right_nat(nat1, ofs1, len1, nat2, ofs2, nbits) {\n  if(nbits == 0) {\n    nat2.data[ofs2] = 0;\n    return 0;\n  }\n  var wrap = 0;\n  for(var i = len1-1; i >= 0; i--) {\n    var a = nat1.data[ofs1+i] >>> 0;\n    nat1.data[ofs1+i] = (a >>> nbits) | wrap;\n    wrap = a << (32 - nbits);\n  }\n  nat2.data[ofs2] = wrap;\n  return 0;\n}\n\n//Provides: compare_digits_nat\nfunction compare_digits_nat(nat1, ofs1, nat2, ofs2) {\n  if(nat1.data[ofs1] > nat2.data[ofs2]) return 1;\n  if(nat1.data[ofs1] < nat2.data[ofs2]) return -1;\n  return 0;\n}\n\n//Provides: compare_nat\n//Requires: num_digits_nat\nfunction compare_nat(nat1, ofs1, len1, nat2, ofs2, len2) {\n  var a = num_digits_nat(nat1, ofs1, len1);\n  var b = num_digits_nat(nat2, ofs2, len2);\n  if(a > b) return 1;\n  if(a < b) return -1;\n  for(var i = len1 - 1; i >= 0; i--) {\n    if ((nat1.data[ofs1+i] >>> 0) > (nat2.data[ofs2+i] >>> 0)) return 1;\n    if ((nat1.data[ofs1+i] >>> 0) < (nat2.data[ofs2+i] >>> 0)) return -1;\n  }\n  return 0;\n}\n\n//Provides: compare_nat_real\n//Requires: compare_nat\nfunction compare_nat_real(nat1,nat2){\n  return compare_nat(nat1,0,nat1.data.length,nat2,0,nat2.data.length);\n}\n\n//Provides: land_digit_nat\nfunction land_digit_nat(nat1, ofs1, nat2, ofs2) {\n  nat1.data[ofs1] &= nat2.data[ofs2];\n  return 0;\n}\n\n//Provides: lor_digit_nat\nfunction lor_digit_nat(nat1, ofs1, nat2, ofs2) {\n  nat1.data[ofs1] |= nat2.data[ofs2];\n  return 0;\n}\n\n//Provides: lxor_digit_nat\nfunction lxor_digit_nat(nat1, ofs1, nat2, ofs2) {\n  nat1.data[ofs1] ^= nat2.data[ofs2];\n  return 0;\n}\n\n\n//Provides: serialize_nat\nfunction serialize_nat(writer, nat, sz){\n  var len = nat.data.length;\n  writer.write(32, len);\n  for(var i = 0; i < len; i++){\n    writer.write(32, nat.data[i]);\n  }\n  sz[0] = len * 4;\n  sz[1] = len * 8;\n}\n\n//Provides: deserialize_nat\n//Requires: MlNat\nfunction deserialize_nat(reader, sz){\n  var len = reader.read32s();\n  var nat = new MlNat(len);\n  for(var i = 0; i < len; i++){\n    nat.data[i] = reader.read32s();\n  }\n  sz[0] = len * 4;\n  return nat;\n}\n"
let obj = Js_of_ocaml_compiler.Builtins.register ~name:"obj.js" ~content:"// Js_of_ocaml runtime support\n// http://www.ocsigen.org/js_of_ocaml/\n//\n// This program is free software; you can redistribute it and/or modify\n// it under the terms of the GNU Lesser General Public License as published by\n// the Free Software Foundation, with linking exception;\n// either version 2.1 of the License, or (at your option) any later version.\n//\n// This program is distributed in the hope that it will be useful,\n// but WITHOUT ANY WARRANTY; without even the implied warranty of\n// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n// GNU Lesser General Public License for more details.\n//\n// You should have received a copy of the GNU Lesser General Public License\n// along with this program; if not, write to the Free Software\n// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.\n\n//Provides: caml_update_dummy\nfunction caml_update_dummy (x, y) {\n  if( typeof y===\"function\" ) { x.fun = y; return 0; }\n  if( y.fun ) { x.fun = y.fun; return 0; }\n  var i = y.length; while (i--) x[i] = y[i]; return 0;\n}\n\n//Provides: caml_obj_is_block const (const)\nfunction caml_obj_is_block (x) { return +(x instanceof Array); }\n\n\n//Provides: caml_obj_tag\n//Requires: caml_is_ml_bytes, caml_is_ml_string\nfunction caml_obj_tag (x) {\n  if ((x instanceof Array) && x[0] == (x[0] >>> 0))\n    return x[0]\n  else if (caml_is_ml_bytes(x))\n    return 252\n  else if (caml_is_ml_string(x))\n    return 252\n  else if ((x instanceof Function) || typeof x == \"function\")\n    return 247\n  else if (x && x.caml_custom)\n    return 255\n  else\n    return 1000\n}\n\n//Provides: caml_obj_set_tag (mutable, const)\nfunction caml_obj_set_tag (x, tag) { x[0] = tag; return 0; }\n//Provides: caml_obj_block const (const,const)\nfunction caml_obj_block (tag, size) {\n  var o = new Array(size+1);\n  o[0]=tag;\n  for (var i = 1; i <= size; i++) o[i] = 0;\n  return o;\n}\n\n//Provides: caml_obj_with_tag\nfunction caml_obj_with_tag(tag,x) {\n  var l = x.length;\n  var a = new Array(l);\n  a[0] = tag;\n  for(var i = 1; i < l; i++ ) a[i] = x[i];\n  return a;\n}\n\n//Provides: caml_obj_dup mutable (const)\nfunction caml_obj_dup (x) {\n  var l = x.length;\n  var a = new Array(l);\n  for(var i = 0; i < l; i++ ) a[i] = x[i];\n  return a;\n}\n\n//Provides: caml_obj_truncate (mutable, const)\n//Requires: caml_invalid_argument\nfunction caml_obj_truncate (x, s) {\n  if (s<=0 || s + 1 > x.length)\n    caml_invalid_argument (\"Obj.truncate\");\n  if (x.length != s + 1) x.length = s + 1;\n  return 0;\n}\n\n//Provides: caml_obj_make_forward\nfunction caml_obj_make_forward (b,v) {\n  b[0]=250;\n  b[1]=v;\n  return 0\n}\n\n//Provides: caml_lazy_make_forward const (const)\nfunction caml_lazy_make_forward (v) { return [250, v]; }\n\n///////////// CamlinternalOO\n//Provides: caml_get_public_method const\nvar caml_method_cache = [];\nfunction caml_get_public_method (obj, tag, cacheid) {\n  var meths = obj[1];\n  var ofs = caml_method_cache[cacheid];\n  if (ofs === undefined) {\n    // Make sure the array is not sparse\n    for (var i = caml_method_cache.length; i < cacheid; i++)\n      caml_method_cache[i] = 0;\n  } else if (meths[ofs] === tag) {\n    return meths[ofs - 1];\n  }\n  var li = 3, hi = meths[1] * 2 + 1, mi;\n  while (li < hi) {\n    mi = ((li+hi) >> 1) | 1;\n    if (tag < meths[mi+1]) hi = mi-2;\n    else li = mi;\n  }\n  caml_method_cache[cacheid] = li + 1;\n  /* return 0 if tag is not there */\n  return (tag == meths[li+1] ? meths[li] : 0);\n}\n\n//Provides: caml_oo_last_id\nvar caml_oo_last_id = 0;\n\n//Provides: caml_set_oo_id\n//Requires: caml_oo_last_id\nfunction caml_set_oo_id (b) {\n  b[2]=caml_oo_last_id++;\n  return b;\n}\n\n//Provides: caml_fresh_oo_id const\n//Requires: caml_oo_last_id\nfunction caml_fresh_oo_id() {\n  return caml_oo_last_id++;\n}\n\n//Provides: caml_obj_raw_field\nfunction caml_obj_raw_field(o,i) { return o[i+1] }\n\n//Provides: caml_obj_set_raw_field\nfunction caml_obj_set_raw_field(o,i,v) { return o[i+1] = v }\n\n//Provides: caml_obj_reachable_words\nfunction caml_obj_reachable_words(o) { return 0; }\n\n//Provides: caml_obj_add_offset\n//Requires: caml_failwith\nfunction caml_obj_add_offset(v,offset) {\n  caml_failwith(\"Obj.add_offset is not supported\");\n}\n"
let parsing = Js_of_ocaml_compiler.Builtins.register ~name:"parsing.js" ~content:"/***********************************************************************/\n/*                                                                     */\n/*                           Objective Caml                            */\n/*                                                                     */\n/*            Xavier Leroy, projet Cristal, INRIA Rocquencourt         */\n/*                                                                     */\n/*  Copyright 1996 Institut National de Recherche en Informatique et   */\n/*  en Automatique.  All rights reserved.  This file is distributed    */\n/*  under the terms of the GNU Lesser General Public License, with     */\n/*  the special exception on linking described in file ../LICENSE.     */\n/*                                                                     */\n/***********************************************************************/\n\n/* $Id: parsing.c 8983 2008-08-06 09:38:25Z xleroy $ */\n\n/* The PDA automaton for parsers generated by camlyacc */\n\n/* The pushdown automata */\n\n//Provides: caml_parse_engine\n//Requires: caml_lex_array\nfunction caml_parse_engine(tables, env, cmd, arg)\n{\n  var ERRCODE = 256;\n\n  //var START = 0;\n  //var TOKEN_READ = 1;\n  //var STACKS_GROWN_1 = 2;\n  //var STACKS_GROWN_2 = 3;\n  //var SEMANTIC_ACTION_COMPUTED = 4;\n  //var ERROR_DETECTED = 5;\n  var loop = 6;\n  var testshift = 7;\n  var shift = 8;\n  var shift_recover = 9;\n  var reduce = 10;\n\n  var READ_TOKEN = 0;\n  var RAISE_PARSE_ERROR = 1;\n  var GROW_STACKS_1 = 2;\n  var GROW_STACKS_2 = 3;\n  var COMPUTE_SEMANTIC_ACTION = 4;\n  var CALL_ERROR_FUNCTION = 5;\n\n  var env_s_stack = 1;\n  var env_v_stack = 2;\n  var env_symb_start_stack = 3;\n  var env_symb_end_stack = 4;\n  var env_stacksize = 5;\n  var env_stackbase = 6;\n  var env_curr_char = 7;\n  var env_lval = 8;\n  var env_symb_start = 9;\n  var env_symb_end = 10;\n  var env_asp = 11;\n  var env_rule_len = 12;\n  var env_rule_number = 13;\n  var env_sp = 14;\n  var env_state = 15;\n  var env_errflag = 16;\n\n  // var _tbl_actions = 1;\n  var tbl_transl_const = 2;\n  var tbl_transl_block = 3;\n  var tbl_lhs = 4;\n  var tbl_len = 5;\n  var tbl_defred = 6;\n  var tbl_dgoto = 7;\n  var tbl_sindex = 8;\n  var tbl_rindex = 9;\n  var tbl_gindex = 10;\n  var tbl_tablesize = 11;\n  var tbl_table = 12;\n  var tbl_check = 13;\n  // var _tbl_error_function = 14;\n  // var _tbl_names_const = 15;\n  // var _tbl_names_block = 16;\n\n  if (!tables.dgoto) {\n    tables.defred = caml_lex_array (tables[tbl_defred]);\n    tables.sindex = caml_lex_array (tables[tbl_sindex]);\n    tables.check  = caml_lex_array (tables[tbl_check]);\n    tables.rindex = caml_lex_array (tables[tbl_rindex]);\n    tables.table  = caml_lex_array (tables[tbl_table]);\n    tables.len    = caml_lex_array (tables[tbl_len]);\n    tables.lhs    = caml_lex_array (tables[tbl_lhs]);\n    tables.gindex = caml_lex_array (tables[tbl_gindex]);\n    tables.dgoto  = caml_lex_array (tables[tbl_dgoto]);\n  }\n\n  var res = 0, n, n1, n2, state1;\n\n  // RESTORE\n  var sp = env[env_sp];\n  var state = env[env_state];\n  var errflag = env[env_errflag];\n\n  exit:for (;;) {\n    switch(cmd) {\n    case 0://START:\n      state = 0;\n      errflag = 0;\n      // Fall through\n\n    case 6://loop:\n      n = tables.defred[state];\n      if (n != 0) { cmd = reduce; break; }\n      if (env[env_curr_char] >= 0) { cmd = testshift; break; }\n      res = READ_TOKEN;\n      break exit;\n      /* The ML code calls the lexer and updates */\n      /* symb_start and symb_end */\n    case 1://TOKEN_READ:\n      if (arg instanceof Array) {\n        env[env_curr_char] = tables[tbl_transl_block][arg[0] + 1];\n        env[env_lval] = arg[1];\n      } else {\n        env[env_curr_char] = tables[tbl_transl_const][arg + 1];\n        env[env_lval] = 0;\n      }\n      // Fall through\n\n    case 7://testshift:\n      n1 = tables.sindex[state];\n      n2 = n1 + env[env_curr_char];\n      if (n1 != 0 && n2 >= 0 && n2 <= tables[tbl_tablesize] &&\n          tables.check[n2] == env[env_curr_char]) {\n        cmd = shift; break;\n      }\n      n1 = tables.rindex[state];\n      n2 = n1 + env[env_curr_char];\n      if (n1 != 0 && n2 >= 0 && n2 <= tables[tbl_tablesize] &&\n          tables.check[n2] == env[env_curr_char]) {\n        n = tables.table[n2];\n        cmd = reduce; break;\n      }\n      if (errflag <= 0) {\n        res = CALL_ERROR_FUNCTION;\n        break exit;\n      }\n      // Fall through\n      /* The ML code calls the error function */\n    case 5://ERROR_DETECTED:\n      if (errflag < 3) {\n        errflag = 3;\n        for (;;) {\n          state1 = env[env_s_stack][sp + 1];\n          n1 = tables.sindex[state1];\n          n2 = n1 + ERRCODE;\n          if (n1 != 0 && n2 >= 0 && n2 <= tables[tbl_tablesize] &&\n              tables.check[n2] == ERRCODE) {\n            cmd = shift_recover; break;\n          } else {\n            if (sp <= env[env_stackbase]) return RAISE_PARSE_ERROR;\n            /* The ML code raises Parse_error */\n            sp--;\n          }\n        }\n      } else {\n        if (env[env_curr_char] == 0) return RAISE_PARSE_ERROR;\n        /* The ML code raises Parse_error */\n        env[env_curr_char] = -1;\n        cmd = loop; break;\n      }\n      // Fall through\n    case 8://shift:\n      env[env_curr_char] = -1;\n      if (errflag > 0) errflag--;\n      // Fall through\n    case 9://shift_recover:\n      state = tables.table[n2];\n      sp++;\n      if (sp >= env[env_stacksize]) {\n        res = GROW_STACKS_1;\n        break exit;\n      }\n      // Fall through\n      /* The ML code resizes the stacks */\n    case 2://STACKS_GROWN_1:\n      env[env_s_stack][sp + 1] = state;\n      env[env_v_stack][sp + 1] = env[env_lval];\n      env[env_symb_start_stack][sp + 1] = env[env_symb_start];\n      env[env_symb_end_stack][sp + 1] = env[env_symb_end];\n      cmd = loop;\n      break;\n\n    case 10://reduce:\n      var m = tables.len[n];\n      env[env_asp] = sp;\n      env[env_rule_number] = n;\n      env[env_rule_len] = m;\n      sp = sp - m + 1;\n      m = tables.lhs[n];\n      state1 = env[env_s_stack][sp];\n      n1 = tables.gindex[m];\n      n2 = n1 + state1;\n      if (n1 != 0 && n2 >= 0 && n2 <= tables[tbl_tablesize] &&\n          tables.check[n2] == state1)\n        state = tables.table[n2];\n      else\n        state = tables.dgoto[m];\n      if (sp >= env[env_stacksize]) {\n        res = GROW_STACKS_2;\n        break exit;\n      }\n      // Fall through\n      /* The ML code resizes the stacks */\n    case 3://STACKS_GROWN_2:\n      res = COMPUTE_SEMANTIC_ACTION;\n      break exit;\n      /* The ML code calls the semantic action */\n    case 4://SEMANTIC_ACTION_COMPUTED:\n      env[env_s_stack][sp + 1] = state;\n      env[env_v_stack][sp + 1] = arg;\n      var asp = env[env_asp];\n      env[env_symb_end_stack][sp + 1] = env[env_symb_end_stack][asp + 1];\n      if (sp > asp) {\n        /* This is an epsilon production. Take symb_start equal to symb_end. */\n        env[env_symb_start_stack][sp + 1] = env[env_symb_end_stack][asp + 1];\n      }\n      cmd = loop; break;\n      /* Should not happen */\n    default:\n      return RAISE_PARSE_ERROR;\n    }\n  }\n  // SAVE\n  env[env_sp] = sp;\n  env[env_state] = state;\n  env[env_errflag] = errflag;\n  return res;\n}\n\n//Provides: caml_set_parser_trace const\n//Dummy function!\nfunction caml_set_parser_trace() { return 0; }\n"
let stdlib = Js_of_ocaml_compiler.Builtins.register ~name:"stdlib.js" ~content:"// Js_of_ocaml runtime support\n// http://www.ocsigen.org/js_of_ocaml/\n// Copyright (C) 2010 J\195\169r\195\180me Vouillon\n// Laboratoire PPS - CNRS Universit\195\169 Paris Diderot\n//\n// This program is free software; you can redistribute it and/or modify\n// it under the terms of the GNU Lesser General Public License as published by\n// the Free Software Foundation, with linking exception;\n// either version 2.1 of the License, or (at your option) any later version.\n//\n// This program is distributed in the hope that it will be useful,\n// but WITHOUT ANY WARRANTY; without even the implied warranty of\n// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n// GNU Lesser General Public License for more details.\n//\n// You should have received a copy of the GNU Lesser General Public License\n// along with this program; if not, write to the Free Software\n// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.\n\n//Provides: caml_call_gen (const, shallow)\n//Weakdef\nfunction caml_call_gen(f, args) {\n  if(f.fun)\n    return caml_call_gen(f.fun, args);\n  //FIXME, can happen with too many arguments\n  if(typeof f !== \"function\") return f;\n  var n = f.length | 0;\n  if(n === 0) return f.apply(null,args);\n  var argsLen = args.length | 0;\n  var d = n - argsLen | 0;\n  if (d == 0)\n    return f.apply(null, args);\n  else if (d < 0) {\n    return caml_call_gen(f.apply(null,args.slice(0,n)),args.slice(n));\n  }\n  else {\n    return function (){\n      var extra_args = (arguments.length == 0)?1:arguments.length;\n      var nargs = new Array(args.length+extra_args);\n      for(var i = 0; i < args.length; i++ ) nargs[i] = args[i];\n      for(var i = 0; i < arguments.length; i++ ) nargs[args.length+i] = arguments[i];\n      return caml_call_gen(f, nargs)\n    }\n  }\n}\n\n//Provides: caml_named_values\nvar caml_named_values = {};\n\n//Provides: caml_register_named_value (const,const)\n//Requires: caml_named_values, caml_jsbytes_of_string\nfunction caml_register_named_value(nm,v) {\n  caml_named_values[caml_jsbytes_of_string(nm)] = v;\n  return 0;\n}\n\n//Provides: caml_named_value\n//Requires: caml_named_values\nfunction caml_named_value(nm) {\n  return caml_named_values[nm]\n}\n\n//Provides: caml_global_data\nvar caml_global_data = [0];\n\n//Provides: caml_register_global (const, shallow, const)\n//Requires: caml_global_data\nfunction caml_register_global (n, v, name_opt) {\n  if(name_opt && globalThis.toplevelReloc)\n    n = globalThis.toplevelReloc(name_opt);\n  caml_global_data[n + 1] = v;\n  if(name_opt) caml_global_data[name_opt] = v;\n}\n\n//Provides: caml_get_global_data mutable\n//Requires: caml_global_data\nfunction caml_get_global_data () { return caml_global_data; }\n\n//Provides: caml_is_printable const (const)\nfunction caml_is_printable(c) { return +(c > 31 && c < 127); }\n"
let stdlib_modern = Js_of_ocaml_compiler.Builtins.register ~name:"stdlib_modern.js" ~content:"// Js_of_ocaml runtime support\n// http://www.ocsigen.org/js_of_ocaml/\n// Laboratoire PPS - CNRS Universit\195\169 Paris Diderot\n//\n// This program is free software; you can redistribute it and/or modify\n// it under the terms of the GNU Lesser General Public License as published by\n// the Free Software Foundation, with linking exception;\n// either version 2.1 of the License, or (at your option) any later version.\n//\n// This program is distributed in the hope that it will be useful,\n// but WITHOUT ANY WARRANTY; without even the implied warranty of\n// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n// GNU Lesser General Public License for more details.\n//\n// You should have received a copy of the GNU Lesser General Public License\n// along with this program; if not, write to the Free Software\n// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.\n\n//Provides: caml_call_gen (const, shallow)\nfunction caml_call_gen(f, args) {\n  if(f.fun)\n    return caml_call_gen(f.fun, args);\n  //FIXME, can happen with too many arguments\n  if(typeof f !== \"function\") return f;\n  var n = f.length | 0;\n  if(n === 0) return f(...args);\n  var argsLen = args.length | 0;\n  var d = n - argsLen | 0;\n  if (d == 0)\n    return f(...args);\n  else if (d < 0) {\n    return caml_call_gen(f(...args.slice(0,n)),args.slice(n));\n  }\n  else {\n    return function (){\n      var extra_args = (arguments.length == 0)?1:arguments.length;\n      var nargs = new Array(args.length+extra_args);\n      for(var i = 0; i < args.length; i++ ) nargs[i] = args[i];\n      for(var i = 0; i < arguments.length; i++ ) nargs[args.length+i] = arguments[i];\n      return caml_call_gen(f, nargs)\n    }\n  }\n}\n"
let str = Js_of_ocaml_compiler.Builtins.register ~name:"str.js" ~content:"// Js_of_ocaml runtime support\n// http://www.ocsigen.org/js_of_ocaml/\n// Copyright (C) 2020 - Hugo Heuzard\n// Copyright (C) 2020 - Shachar Itzhaky\n//\n// This program is free software; you can redistribute it and/or modify\n// it under the terms of the GNU Lesser General Public License as published by\n// the Free Software Foundation, with linking exception;\n// either version 2.1 of the License, or (at your option) any later version.\n//\n// This program is distributed in the hope that it will be useful,\n// but WITHOUT ANY WARRANTY; without even the implied warranty of\n// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n// GNU Lesser General Public License for more details.\n//\n// You should have received a copy of the GNU Lesser General Public License\n// along with this program; if not, write to the Free Software\n// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.\n\n// Based on https://github.com/ocaml/ocaml/blob/4.07/otherlibs/str/strstubs.c\n// Copied from https://github.com/jscoq/jscoq/blob/v8.11/coq-js/js_stub/str.js\n\n//Provides: re_match\n//Requires: caml_jsbytes_of_string, caml_js_from_array, caml_array_of_string\n//Requires: caml_string_get\n\nvar re_match = function(){\n  var re_word_letters = [\n    0x00, 0x00, 0x00, 0x00,       /* 0x00-0x1F: none */\n    0x00, 0x00, 0xFF, 0x03,       /* 0x20-0x3F: digits 0-9 */\n    0xFE, 0xFF, 0xFF, 0x87,       /* 0x40-0x5F: A to Z, _ */\n    0xFE, 0xFF, 0xFF, 0x07,       /* 0x60-0x7F: a to z */\n    0x00, 0x00, 0x00, 0x00,       /* 0x80-0x9F: none */\n    0x00, 0x00, 0x00, 0x00,       /* 0xA0-0xBF: none */\n    0xFF, 0xFF, 0x7F, 0xFF,       /* 0xC0-0xDF: Latin-1 accented uppercase */\n    0xFF, 0xFF, 0x7F, 0xFF        /* 0xE0-0xFF: Latin-1 accented lowercase */\n  ];\n\n  var opcodes = {\n    CHAR: 0, CHARNORM: 1, STRING: 2, STRINGNORM: 3, CHARCLASS: 4,\n    BOL: 5, EOL: 6, WORDBOUNDARY: 7,\n    BEGGROUP: 8, ENDGROUP: 9, REFGROUP: 10,\n    ACCEPT: 11,\n    SIMPLEOPT: 12, SIMPLESTAR: 13, SIMPLEPLUS: 14,\n    GOTO: 15, PUSHBACK: 16, SETMARK: 17,\n    CHECKPROGRESS: 18\n  };\n\n  function is_word_letter(c) {\n    return (re_word_letters[  (c >> 3)] >> (c & 7)) & 1;\n  }\n\n  function in_bitset(s,i) {\n    return (caml_string_get(s,(i >> 3)) >> (i & 7)) & 1;\n  }\n\n  function re_match_impl(re, s, pos, partial) {\n\n    var prog          = caml_js_from_array(re[1]),\n        cpool         = caml_js_from_array(re[2]),\n        normtable     = caml_jsbytes_of_string(re[3]),\n        numgroups     = re[4] | 0,\n        numregisters  = re[5] | 0,\n        startchars    = re[6] | 0;\n\n    var s = caml_array_of_string(s);\n\n    var pc = 0,\n        quit = false,\n        stack = [],\n        groups = new Array(numgroups),\n        re_register = new Array(numregisters);\n\n    for(var i = 0; i < groups.length; i++){\n      groups[i] = {start: -1, end:-1}\n    }\n    groups[0].start = pos;\n\n    var backtrack = function () {\n      while (stack.length) {\n        var item = stack.pop();\n        if (item.undo) {\n          item.undo.obj[item.undo.prop] = item.undo.value;\n        }\n        else if(item.pos) {\n          pc = item.pos.pc;\n          pos = item.pos.txt;\n          return;\n        }\n      }\n      quit = true;\n    };\n\n    var push = function(item) { stack.push(item); };\n\n    var accept = function () {\n      groups[0].end = pos;\n      var result = new Array(1 + groups.length*2);\n      result[0] = 0; // tag\n      for(var i = 0; i < groups.length; i++){\n        var g = groups[i];\n        if(g.start < 0 || g.end < 0) {\n          g.start = g.end = -1;\n        }\n        result[2*i + 1 ] = g.start;\n        result[2*i + 1 + 1 ] = g.end;\n      };\n      return result\n    };\n\n    var prefix_match = function () {\n      if(partial) return accept ();\n      else backtrack ();\n    }\n\n    /* Main DFA interpreter loop */\n    while (!quit) {\n      var op = prog[pc] & 0xff,\n          sarg = prog[pc] >> 8,\n          uarg = sarg & 0xff,\n          c = s[pos],\n          group;\n\n      pc++;\n\n      switch (op) {\n      case opcodes.CHAR:\n        if(pos === s.length) {prefix_match (); break};\n        if (c === uarg) pos++;\n        else backtrack();\n        break;\n      case opcodes.CHARNORM:\n        if(pos === s.length) {prefix_match (); break};\n        if (normtable.charCodeAt(c) === uarg) pos++;\n        else backtrack();\n        break;\n      case opcodes.STRING:\n        for (var arg = caml_jsbytes_of_string(cpool[uarg]), i = 0; i < arg.length; i++) {\n          if(pos === s.length) {prefix_match (); break};\n          if (c === arg.charCodeAt(i))\n            c = s[++pos];\n          else { backtrack(); break; }\n        }\n        break;\n      case opcodes.STRINGNORM:\n        for (var arg = caml_jsbytes_of_string(cpool[uarg]), i = 0; i < arg.length; i++) {\n          if(pos === s.length) {prefix_match (); break};\n          if (normtable.charCodeAt(c) === arg.charCodeAt(i))\n            c = s[++pos];\n          else { backtrack(); break; }\n        }\n        break;\n      case opcodes.CHARCLASS:\n        if(pos === s.length) {prefix_match (); break};\n        if (in_bitset(cpool[uarg], c)) pos++;\n        else backtrack();\n        break;\n      case opcodes.BOL:\n        if(pos > 0 && s[pos - 1] != 10 /* \\n */) {backtrack()}\n        break;\n      case opcodes.EOL:\n        if(pos < s.length && s[pos] != 10 /* \\n */) {backtrack()}\n        break;\n      case opcodes.WORDBOUNDARY:\n        if(pos == 0) {\n          if(pos === s.length) {prefix_match (); break};\n          if(is_word_letter(s[0])) break;\n          backtrack();\n        }\n        else if (pos === s.length) {\n          if(is_word_letter(s[pos - 1])) break;\n          backtrack ();\n        }\n        else {\n          if(is_word_letter(s[pos - 1]) != is_word_letter(s[pos])) break;\n          backtrack ();\n        }\n        break;\n      case opcodes.BEGGROUP:\n        group = groups[uarg];\n        push({undo: {obj:group,\n                     prop:'start',\n                     value: group.start}});\n        group.start = pos;\n        break;\n      case opcodes.ENDGROUP:\n        group = groups[uarg];\n        push({undo: {obj: group,\n                     prop:'end',\n                     value: group.end}});\n        group.end = pos;\n        break;\n      case opcodes.REFGROUP:\n        group = groups[uarg];\n        if(group.start < 0 || group.end < 0) {backtrack (); break}\n        for (var i = group.start; i < group.end; i++){\n          if(pos === s.length) {prefix_match (); break};\n          if(s[i] != s[pos]) {backtrack (); break}\n          pos++;\n        }\n        break;\n      case opcodes.SIMPLEOPT:\n        if (in_bitset(cpool[uarg], c)) pos++;\n        break;\n      case opcodes.SIMPLESTAR:\n        while (in_bitset(cpool[uarg], c))\n          c = s[++pos];\n        break;\n      case opcodes.SIMPLEPLUS:\n        if(pos === s.length) {prefix_match (); break};\n        if (in_bitset(cpool[uarg], c)) {\n          do {\n            c = s[++pos];\n          } while (in_bitset(cpool[uarg], c));\n        }\n        else backtrack();\n        break;\n      case opcodes.ACCEPT:\n        return accept();\n      case opcodes.GOTO:\n        pc = pc + sarg;\n        break;\n      case opcodes.PUSHBACK:\n        push({pos: {pc: pc + sarg, txt: pos}});\n        break;\n      case opcodes.SETMARK:\n        push({undo: {obj:re_register,\n                     prop: uarg,\n                     value: re_register[uarg]}});\n        re_register[uarg] = pos;\n        break;\n      case opcodes.CHECKPROGRESS:\n        if (re_register[uarg] === pos) backtrack();\n        break;\n      default: throw new Error(\"Invalid bytecode\");\n      }\n    }\n    return 0;\n  }\n\n  return re_match_impl;\n}();\n\n\n//Provides: re_search_forward\n//Requires: re_match, caml_ml_string_length, caml_invalid_argument\nfunction re_search_forward(re, s, pos) {\n  if(pos < 0 || pos > caml_ml_string_length(s))\n    caml_invalid_argument(\"Str.search_forward\")\n  while (pos <= caml_ml_string_length(s)) {\n    var res = re_match(re, s, pos, 0);\n    if (res) return res;\n    pos++;\n  }\n\n  return [0];  /* [||] : int array */\n}\n\n//Provides: re_search_backward\n//Requires: re_match, caml_ml_string_length, caml_invalid_argument\nfunction re_search_backward(re, s, pos) {\n  if(pos < 0 || pos > caml_ml_string_length(s))\n    caml_invalid_argument(\"Str.search_backward\")\n  while (pos >= 0) {\n    var res = re_match(re, s, pos, 0);\n    if (res) return res;\n    pos--;\n  }\n\n  return [0];  /* [||] : int array */\n}\n\n\n//Provides: re_string_match\n//Requires: re_match, caml_ml_string_length, caml_invalid_argument\nfunction re_string_match(re,s,pos){\n  if(pos < 0 || pos > caml_ml_string_length(s))\n    caml_invalid_argument(\"Str.string_match\")\n  var res = re_match(re, s, pos, 0);\n  if (res) return res;\n  else return [0];\n}\n\n//Provides: re_partial_match\n//Requires: re_match, caml_ml_string_length, caml_invalid_argument\nfunction re_partial_match(re,s,pos){\n  if(pos < 0 || pos > caml_ml_string_length(s))\n    caml_invalid_argument(\"Str.partial_match\")\n  var res = re_match(re, s, pos, 1);\n  if (res) return res;\n  else return [0];\n}\n\n//Provides: re_replacement_text\n//Requires: caml_jsbytes_of_string, caml_string_of_jsbytes\n//Requires: caml_array_get\n//Requires: caml_failwith\n// external re_replacement_text: string -> int array -> string -> string\nfunction re_replacement_text(repl,groups,orig) {\n  var repl = caml_jsbytes_of_string(repl);\n  var len = repl.length;\n  var orig = caml_jsbytes_of_string(orig);\n  var res = \"\"; //result\n  var n = 0; // current position\n  var cur; //current char\n  var start, end, c;\n  while(n < len){\n    cur = repl.charAt(n++);\n    if(cur != '\\\\'){\n      res += cur;\n    }\n    else {\n      if(n == len) caml_failwith(\"Str.replace: illegal backslash sequence\");\n      cur = repl.charAt(n++);\n      switch(cur){\n      case '\\\\':\n        res += cur;\n        break;\n      case '0': case '1': case '2': case '3': case '4':\n      case '5': case '6': case '7': case '8': case '9':\n        c = +cur;\n        if (c*2 >= groups.length - 1 )\n          caml_failwith(\"Str.replace: reference to unmatched group\" );\n        start = caml_array_get(groups,c*2);\n        end = caml_array_get(groups, c*2 +1);\n        if (start == -1)\n          caml_failwith(\"Str.replace: reference to unmatched group\");\n        res+=orig.slice(start,end);\n        break;\n      default:\n        res += ('\\\\'  + cur);\n      }\n    }\n  }\n  return caml_string_of_jsbytes(res); }\n"
let sys = Js_of_ocaml_compiler.Builtins.register ~name:"sys.js" ~content:"// Js_of_ocaml runtime support\n// http://www.ocsigen.org/js_of_ocaml/\n//\n// This program is free software; you can redistribute it and/or modify\n// it under the terms of the GNU Lesser General Public License as published by\n// the Free Software Foundation, with linking exception;\n// either version 2.1 of the License, or (at your option) any later version.\n//\n// This program is distributed in the hope that it will be useful,\n// but WITHOUT ANY WARRANTY; without even the implied warranty of\n// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n// GNU Lesser General Public License for more details.\n//\n// You should have received a copy of the GNU Lesser General Public License\n// along with this program; if not, write to the Free Software\n// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.\n\n///////////// Sys\n\n//Provides: caml_raise_sys_error (const)\n//Requires: caml_raise_with_string, caml_global_data\nfunction caml_raise_sys_error (msg) {\n  caml_raise_with_string(caml_global_data.Sys_error, msg);\n}\n\n//Provides: caml_sys_exit\n//Requires: caml_invalid_argument\nfunction caml_sys_exit (code) {\n  var g = globalThis;\n  if(g.quit) g.quit(code);\n  //nodejs\n  if(g.process && g.process.exit)\n    g.process.exit(code);\n  caml_invalid_argument(\"Function 'exit' not implemented\");\n}\n\n//Provides: caml_is_special_exception\nfunction caml_is_special_exception(exn){\n  switch(exn[2]) {\n  case -8: // Match_failure\n  case -11: // Assert_failure\n  case -12: // Undefined_recursive_module\n    return 1;\n  default:\n    return 0;\n  }\n}\n\n//Provides: caml_format_exception\n//Requires: MlBytes, caml_is_special_exception\nfunction caml_format_exception(exn){\n  var r = \"\";\n  if(exn[0] == 0) {\n    r += exn[1][1];\n    if(exn.length == 3 && exn[2][0] == 0 && caml_is_special_exception(exn[1])) {\n\n      var bucket = exn[2];\n      var start = 1;\n    } else {\n      var start = 2\n      var bucket = exn;\n    }\n    r += \"(\";\n    for(var i = start; i < bucket.length; i ++){\n      if(i > start) r+=\", \";\n      var v = bucket[i]\n      if(typeof v == \"number\")\n        r+= v.toString();\n      else if(v instanceof MlBytes){\n        r+= '\"' + v.toString() + '\"';\n      }\n      else if(typeof v == \"string\"){\n        r+= '\"' + v.toString() + '\"';\n      }\n      else r += \"_\";\n    }\n    r += \")\"\n  } else if (exn[0] == 248){\n    r += exn[1]\n  }\n  return r\n}\n\n//Provides: caml_fatal_uncaught_exception\n//Requires: caml_named_value, caml_format_exception\nfunction caml_fatal_uncaught_exception(err){\n  if(err instanceof Array && (err[0] == 0 || err[0] == 248)) {\n    var handler = caml_named_value(\"Printexc.handle_uncaught_exception\");\n    if(handler) handler(err,false);\n    else {\n      var msg = caml_format_exception(err);\n      var at_exit = caml_named_value(\"Pervasives.do_at_exit\");\n      if(at_exit) { at_exit(0) }\n      globalThis.console.error(\"Fatal error: exception \" + msg + \"\\n\");\n    }\n  }\n  else {\n    throw err\n  }\n}\n\n\n//Provides: caml_set_static_env\nfunction caml_set_static_env(k,v){\n  if(!globalThis.jsoo_static_env)\n    globalThis.jsoo_static_env = {}\n  globalThis.jsoo_static_env[k] = v;\n  return 0;\n}\n//Provides: caml_sys_getenv (const)\n//Requires: caml_raise_not_found\n//Requires: caml_string_of_jsstring\n//Requires: caml_jsstring_of_string\nfunction caml_sys_getenv (name) {\n  var g = globalThis;\n  var n = caml_jsstring_of_string(name);\n  //nodejs env\n  if(g.process\n     && g.process.env\n     && g.process.env[n] != undefined)\n    return caml_string_of_jsstring(g.process.env[n]);\n  if(globalThis.jsoo_static_env\n     && globalThis.jsoo_static_env[n])\n    return caml_string_of_jsstring(globalThis.jsoo_static_env[n])\n  caml_raise_not_found ();\n}\n\n//Provides: caml_sys_unsafe_getenv\n//Requires: caml_sys_getenv\nfunction caml_sys_unsafe_getenv(name){\n  return caml_sys_getenv (name);\n}\n\n//Provides: caml_argv\n//Requires: caml_string_of_jsstring\nvar caml_argv = ((function () {\n  var g = globalThis;\n  var main = \"a.out\";\n  var args = []\n\n  if(g.process\n     && g.process.argv\n     && g.process.argv.length > 1) {\n    var argv = g.process.argv\n    //nodejs\n    main = argv[1];\n    args = argv.slice(2);\n  }\n\n  var p = caml_string_of_jsstring(main);\n  var args2 = [0, p];\n  for(var i = 0; i < args.length; i++)\n    args2.push(caml_string_of_jsstring(args[i]));\n  return args2;\n})())\n\n//Provides: caml_executable_name\n//Requires: caml_argv\nvar caml_executable_name = caml_argv[1]\n\n//Provides: caml_sys_get_argv\n//Requires: caml_argv\nfunction caml_sys_get_argv (a) {\n  return [0, caml_argv[1], caml_argv];\n}\n\n//Provides: caml_sys_argv\n//Requires: caml_argv\nfunction caml_sys_argv (a) {\n  return caml_argv;\n}\n\n//Provides: caml_sys_modify_argv\n//Requires: caml_argv\nfunction caml_sys_modify_argv(arg){\n  caml_argv = arg;\n  return 0;\n}\n\n//Provides: caml_sys_executable_name const\n//Requires: caml_executable_name\nfunction caml_sys_executable_name(a){\n  return caml_executable_name\n}\n\n//Provides: caml_sys_system_command\n//Requires: caml_jsstring_of_string\nfunction caml_sys_system_command(cmd){\n  var cmd = caml_jsstring_of_string(cmd);\n  if (typeof require != \"undefined\"\n      && require('child_process')\n      && require('child_process').execSync) {\n    try {require('child_process').execSync(cmd,{stdio: 'inherit'}); return 0}\n    catch (e) {return 1}\n  }\n  else return 127;\n}\n\n//Provides: caml_sys_time mutable\nvar caml_initial_time = (new Date()).getTime() * 0.001;\nfunction caml_sys_time () {\n  var now = (new Date()).getTime();\n  return now * 0.001 - caml_initial_time;\n}\n\n//Provides: caml_sys_time_include_children\n//Requires: caml_sys_time\nfunction caml_sys_time_include_children(b) {\n  return caml_sys_time();\n}\n\n//Provides: caml_sys_random_seed mutable\n//The function needs to return an array since OCaml 4.0...\nfunction caml_sys_random_seed () {\n  if(globalThis.crypto) {\n    if(typeof globalThis.crypto.getRandomValues === 'function'){\n      // Webbrowsers\n      var a = new globalThis.Uint32Array(1);\n      globalThis.crypto.getRandomValues(a);\n      return [0,a[0]];\n    } else if(globalThis.crypto.randomBytes === 'function'){\n      // Nodejs\n      var buff = globalThis.crypto.randomBytes(4);\n      var a = new globalThis.Uint32Array(buff);\n      return [0,a[0]];\n    }\n  }\n  var now = (new Date()).getTime();\n  var x = now^0xffffffff*Math.random();\n  return [0,x];\n}\n\n//Provides: caml_sys_const_big_endian const\nfunction caml_sys_const_big_endian () { return 0; }\n\n//Provides: caml_sys_const_word_size const\nfunction caml_sys_const_word_size () { return 32; }\n\n//Provides: caml_sys_const_int_size const\nfunction caml_sys_const_int_size () { return 32; }\n\n//Provides: caml_sys_const_max_wosize const\n// max_int / 4 so that the following does not overflow\n//let max_string_length = word_size / 8 * max_array_length - 1;;\nfunction caml_sys_const_max_wosize () { return (0x7FFFFFFF/4) | 0;}\n\n//Provides: caml_sys_const_ostype_unix const\n//Requires: os_type\nfunction caml_sys_const_ostype_unix () { return os_type == \"Unix\" ? 1 : 0; }\n//Provides: caml_sys_const_ostype_win32 const\n//Requires: os_type\nfunction caml_sys_const_ostype_win32 () { return os_type == \"Win32\" ? 1 : 0; }\n//Provides: caml_sys_const_ostype_cygwin const\n//Requires: os_type\nfunction caml_sys_const_ostype_cygwin () { return os_type == \"Cygwin\" ? 1 : 0; }\n\n//Provides: caml_sys_const_backend_type const\n//Requires: caml_string_of_jsbytes\nfunction caml_sys_const_backend_type () {\n  return [0, caml_string_of_jsbytes(\"js_of_ocaml\")];\n}\n\n//Provides: os_type\nvar os_type = (globalThis.process &&\n               globalThis.process.platform &&\n               globalThis.process.platform == \"win32\") ? \"Cygwin\" : \"Unix\";\n\n\n//Provides: caml_sys_get_config const\n//Requires: caml_string_of_jsbytes, os_type\nfunction caml_sys_get_config () {\n  return [0, caml_string_of_jsbytes(os_type), 32, 0];\n}\n\n//Provides: caml_sys_isatty\nfunction caml_sys_isatty(_chan) {\n  return 0;\n}\n\n//Provides: caml_runtime_variant\n//Requires: caml_string_of_jsbytes\nfunction caml_runtime_variant(_unit) {\n  return caml_string_of_jsbytes(\"\");\n}\n//Provides: caml_runtime_parameters\n//Requires: caml_string_of_jsbytes\nfunction caml_runtime_parameters(_unit) {\n  return caml_string_of_jsbytes(\"\");\n}\n\n//Provides: caml_install_signal_handler const\nfunction caml_install_signal_handler(){return 0}\n\n//Provides: unix_inet_addr_of_string\nfunction unix_inet_addr_of_string () {return 0;}\n\n\n\n//Provides: caml_runtime_warnings\nvar caml_runtime_warnings = 0;\n\n//Provides: caml_ml_enable_runtime_warnings\n//Requires: caml_runtime_warnings\nfunction caml_ml_enable_runtime_warnings (bool) {\n  caml_runtime_warnings = bool;\n  return 0;\n}\n\n//Provides: caml_ml_runtime_warnings_enabled\n//Requires: caml_runtime_warnings\nfunction caml_ml_runtime_warnings_enabled (_unit) {\n  return caml_runtime_warnings;\n}\n\n\n//Provides: caml_spacetime_enabled const (const)\nfunction caml_spacetime_enabled(_unit) {\n  return 0;\n}\n\n//Provides: caml_sys_const_naked_pointers_checked const (const)\nfunction caml_sys_const_naked_pointers_checked(_unit) {\n  return 0;\n}\n\n//Provides: caml_register_channel_for_spacetime const (const)\nfunction caml_register_channel_for_spacetime(_channel) {\n  return 0;\n}\n\n//Provides: caml_spacetime_only_works_for_native_code\n//Requires: caml_failwith\nfunction caml_spacetime_only_works_for_native_code() {\n  caml_failwith(\"Spacetime profiling only works for native code\");\n}\n\n//Always\n//Requires: caml_fatal_uncaught_exception\nfunction caml_setup_uncaught_exception_handler() {\n  var g = globalThis;\n  if(g.process && g.process.on) {\n    g.process.on('uncaughtException', function (err, origin) {\n      caml_fatal_uncaught_exception(err);\n      g.process.exit (2);\n    })\n  }\n  else if(g.addEventListener){\n    g.addEventListener('error', function(event){\n      if(event.error){\n        caml_fatal_uncaught_exception(event.error);\n      }\n    });\n  }\n}\ncaml_setup_uncaught_exception_handler();\n"
let toplevel = Js_of_ocaml_compiler.Builtins.register ~name:"toplevel.js" ~content:"// Js_of_ocaml toplevel runtime support\n// http://www.ocsigen.org/js_of_ocaml/\n// Copyright (C) 2011 J\195\169r\195\180me Vouillon\n// Laboratoire PPS - CNRS Universit\195\169 Paris Diderot\n//\n// This program is free software; you can redistribute it and/or modify\n// it under the terms of the GNU Lesser General Public License as published by\n// the Free Software Foundation, with linking exception;\n// either version 2.1 of the License, or (at your option) any later version.\n//\n// This program is distributed in the hope that it will be useful,\n// but WITHOUT ANY WARRANTY; without even the implied warranty of\n// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n// GNU Lesser General Public License for more details.\n//\n// You should have received a copy of the GNU Lesser General Public License\n// along with this program; if not, write to the Free Software\n// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.\n\n//Provides: caml_terminfo_setup\nfunction caml_terminfo_setup () { return 1; } // Bad_term\n//Provides: caml_terminfo_backup\nfunction caml_terminfo_backup () { return 0; }\n//Provides: caml_terminfo_standout\nfunction caml_terminfo_standout () { return 0; }\n//Provides: caml_terminfo_resume\nfunction caml_terminfo_resume () { return 0; }\n//Provides: caml_terminfo_rows\nfunction caml_terminfo_rows () { return 0; }\n//Provides: caml_invoke_traced_function\n//Requires: caml_invalid_argument\nfunction caml_invoke_traced_function() {\n  caml_invalid_argument(\"Meta.invoke_traced_function\");\n}\n//Provides: caml_get_current_environment\n//Requires: caml_failwith\nfunction caml_get_current_environment() {\n  caml_failwith(\"caml_get_current_environment not Implemented\");\n}\n//////////////////////////////////////////////////////////////////////\n\n//Provides: caml_get_section_table\n//Requires: caml_global_data, caml_failwith\nfunction caml_get_section_table () {\n  if(!caml_global_data.toc)\n    caml_failwith(\"Program not compiled with --toplevel\");\n  return caml_global_data.toc;\n}\n\n\n//Provides: caml_reify_bytecode\n//Requires: caml_failwith\n//Version: < 4.08\nfunction caml_reify_bytecode (code, _sz) {\n  if(globalThis.toplevelCompile)\n    return globalThis.toplevelCompile([0,code]);\n  else caml_failwith(\"Toplevel not initialized (toplevelCompile)\")\n}\n\n//Provides: caml_reify_bytecode\n//Requires: caml_failwith\n//Version: >= 4.08\nfunction caml_reify_bytecode (code, _sz,_) {\n  if(globalThis.toplevelCompile)\n    return [0, 0, globalThis.toplevelCompile(code)];\n  else caml_failwith(\"Toplevel not initialized (toplevelCompile)\")\n}\n\n//Provides: caml_static_release_bytecode\nfunction caml_static_release_bytecode () { return 0; }\n\n//Provides: caml_static_alloc\n//Requires: caml_create_bytes\nfunction caml_static_alloc (len) { return caml_create_bytes (len); }\n\n//Provides: caml_static_free\nfunction caml_static_free () { return 0; }\n\n//Provides: caml_realloc_global\n//Requires: caml_global_data\nfunction caml_realloc_global (len) {\n  if (len + 1 > caml_global_data.length) caml_global_data.length = len + 1;\n  return 0;\n}\n"
let unix = Js_of_ocaml_compiler.Builtins.register ~name:"unix.js" ~content:"//Provides: unix_gettimeofday\nfunction unix_gettimeofday () {\n  return (new Date()).getTime() / 1000;\n}\n\n//Provides: unix_time\n//Requires: unix_gettimeofday\nfunction unix_time () {\n  return Math.floor(unix_gettimeofday ());\n}\n\n//Provides: unix_gmtime\nfunction unix_gmtime (t) {\n  var d = new Date (t * 1000);\n  var d_num = d.getTime();\n  var januaryfirst = (new Date(Date.UTC(d.getUTCFullYear(), 0, 1))).getTime();\n  var doy = Math.floor((d_num - januaryfirst) / 86400000);\n  return BLOCK(0, d.getUTCSeconds(), d.getUTCMinutes(), d.getUTCHours(),\n               d.getUTCDate(), d.getUTCMonth(), d.getUTCFullYear() - 1900,\n               d.getUTCDay(), doy,\n               false | 0 /* for UTC daylight savings time is false */)\n}\n\n//Provides: unix_localtime\nfunction unix_localtime (t) {\n  var d = new Date (t * 1000);\n  var d_num = d.getTime();\n  var januaryfirst = (new Date(d.getFullYear(), 0, 1)).getTime();\n  var doy = Math.floor((d_num - januaryfirst) / 86400000);\n  var jan = new Date(d.getFullYear(), 0, 1);\n  var jul = new Date(d.getFullYear(), 6, 1);\n  var stdTimezoneOffset = Math.max(jan.getTimezoneOffset(), jul.getTimezoneOffset());\n  return BLOCK(0, d.getSeconds(), d.getMinutes(), d.getHours(),\n               d.getDate(), d.getMonth(), d.getFullYear() - 1900,\n               d.getDay(), doy,\n               (d.getTimezoneOffset() < stdTimezoneOffset) | 0 /* daylight savings time  field. */)\n}\n\n//Provides: unix_mktime\n//Requires: unix_localtime\nfunction unix_mktime(tm){\n  var d = (new Date(tm[6]+1900,tm[5],tm[4],tm[3],tm[2],tm[1])).getTime();\n  var t = Math.floor(d / 1000);\n  var tm2 = unix_localtime(t);\n  return BLOCK(0,t,tm2);\n}\n\n//Provides: win_startup const\nfunction win_startup() {}\n\n//Provides: win_cleanup const\nfunction win_cleanup() {}\n\n//Provides: win_handle_fd const\nfunction win_handle_fd(x) {return x;}\n\n//Provides: unix_isatty\n//Requires: fs_node_supported\nfunction unix_isatty(fileDescriptor) {\n  if(fs_node_supported()) {\n    var tty = require('tty');\n    return tty.isatty(fileDescriptor)?1:0;\n  } else {\n    return 0;\n  }\n}\n\n//Provides: make_unix_err_args\n//Requires: caml_string_of_jsstring\nvar unix_error = [\n  /* ===Unix.error===\n   *\n   * This array is in order of the variant in OCaml\n   */\n  \"E2BIG\", \"EACCES\", \"EAGAIN\", \"EBADF\", \"EBUSY\", \"ECHILD\", \"EDEADLK\", \"EDOM\",\n  \"EEXIST\", \"EFAULT\", \"EFBIG\", \"EINTR\", \"EINVAL\", \"EIO\", \"EISDIR\", \"EMFILE\",\n  \"EMLINK\", \"ENAMETOOLONG\", \"ENFILE\", \"ENODEV\", \"ENOENT\", \"ENOEXEC\", \"ENOLCK\",\n  \"ENOMEM\", \"ENOSPC\", \"ENOSYS\", \"ENOTDIR\", \"ENOTEMPTY\", \"ENOTTY\", \"ENXIO\",\n  \"EPERM\", \"EPIPE\", \"ERANGE\", \"EROFS\", \"ESPIPE\", \"ESRCH\", \"EXDEV\", \"EWOULDBLOCK\",\n  \"EINPROGRESS\", \"EALREADY\", \"ENOTSOCK\", \"EDESTADDRREQ\", \"EMSGSIZE\",\n  \"EPROTOTYPE\", \"ENOPROTOOPT\", \"EPROTONOSUPPORT\", \"ESOCKTNOSUPPORT\",\n  \"EOPNOTSUPP\", \"EPFNOSUPPORT\", \"EAFNOSUPPORT\", \"EADDRINUSE\", \"EADDRNOTAVAIL\",\n  \"ENETDOWN\", \"ENETUNREACH\", \"ENETRESET\", \"ECONNABORTED\", \"ECONNRESET\", \"ENOBUFS\",\n  \"EISCONN\", \"ENOTCONN\", \"ESHUTDOWN\", \"ETOOMANYREFS\", \"ETIMEDOUT\", \"ECONNREFUSED\",\n  \"EHOSTDOWN\", \"EHOSTUNREACH\", \"ELOOP\", \"EOVERFLOW\"\n];\nfunction make_unix_err_args(code, syscall, path, errno) {\n  var variant = unix_error.indexOf(code);\n  if (variant < 0) {\n    // Default if undefined\n    if (errno == null) {\n      errno = -9999\n    }\n    // If none of the above variants, fallback to EUNKNOWNERR(int)\n    variant = BLOCK(0, errno);\n  }\n  var args = [\n    variant,\n    caml_string_of_jsstring(syscall || \"\"),\n    caml_string_of_jsstring(path || \"\")\n  ];\n  return args;\n}\n\n//Provides: unix_stat\n//Requires: resolve_fs_device, caml_failwith\nfunction unix_stat(name) {\n  var root = resolve_fs_device(name);\n  if (!root.device.stat) {\n    caml_failwith(\"unix_stat: not implemented\");\n  }\n  return root.device.stat(root.rest, /* raise Unix_error */ true);\n}\n\n//Provides: unix_stat_64\n//Requires: unix_stat\nvar unix_stat_64 = unix_stat;\n\n//Provides: unix_lstat\n//Requires: resolve_fs_device, caml_failwith\nfunction unix_lstat(name) {\n  var root = resolve_fs_device(name);\n  if (!root.device.lstat) {\n    caml_failwith(\"unix_lstat: not implemented\");\n  }\n  return root.device.lstat(root.rest, /* raise Unix_error */ true);\n}\n\n//Provides: unix_lstat_64\n//Requires: unix_lstat\nvar unix_lstat_64 = unix_lstat;\n\n//Provides: unix_mkdir\n//Requires: resolve_fs_device, caml_failwith\nfunction unix_mkdir(name, perm) {\n  var root = resolve_fs_device(name);\n  if (!root.device.mkdir) {\n    caml_failwith(\"unix_mkdir: not implemented\");\n  }\n  return root.device.mkdir(root.rest, perm, /* raise Unix_error */ true);\n}\n\n//Provides: unix_rmdir\n//Requires: resolve_fs_device, caml_failwith\nfunction unix_rmdir(name) {\n  var root = resolve_fs_device(name);\n  if (!root.device.rmdir) {\n    caml_failwith(\"unix_rmdir: not implemented\");\n  }\n  return root.device.rmdir(root.rest, /* raise Unix_error */ true);\n}\n\n//Provides: unix_symlink\n//Requires: resolve_fs_device, caml_failwith\nfunction unix_symlink(to_dir, src, dst) {\n  var src_root = resolve_fs_device(src);\n  var dst_root = resolve_fs_device(dst);\n  if(src_root.device != dst_root.device)\n    caml_failwith(\"unix_symlink: cannot symlink between two filesystems\");\n  if (!src_root.device.symlink) {\n    caml_failwith(\"unix_symlink: not implemented\");\n  }\n  return src_root.device.symlink(to_dir, src_root.rest, dst_root.rest, /* raise Unix_error */ true);\n}\n\n//Provides: unix_readlink\n//Requires: resolve_fs_device, caml_failwith\nfunction unix_readlink(name) {\n  var root = resolve_fs_device(name);\n  if (!root.device.readlink) {\n    caml_failwith(\"unix_readlink: not implemented\");\n  }\n  return root.device.readlink(root.rest, /* raise Unix_error */ true);\n}\n\n//Provides: unix_unlink\n//Requires: resolve_fs_device, caml_failwith\nfunction unix_unlink(name) {\n  var root = resolve_fs_device(name);\n  if (!root.device.unlink) {\n    caml_failwith(\"unix_unlink: not implemented\");\n  }\n  return root.device.unlink(root.rest, /* raise Unix_error */ true);\n}\n\n//Provides: unix_getuid\n//Requires: caml_raise_not_found\nfunction unix_getuid(unit) {\n  if(globalThis.process && globalThis.process.getuid){\n    return globalThis.process.getuid();\n  }\n  caml_raise_not_found();\n}\n\n//Provides: unix_getpwuid\n//Requires: caml_raise_not_found\nfunction unix_getpwuid(unit) {\n  caml_raise_not_found()\n}\n\n//Provides: unix_has_symlink\n//Requires: fs_node_supported\nfunction unix_has_symlink(unit) {\n  return fs_node_supported()?1:0\n}\n"
let weak = Js_of_ocaml_compiler.Builtins.register ~name:"weak.js" ~content:"// Js_of_ocaml runtime support\n// http://www.ocsigen.org/js_of_ocaml/\n// Copyright (C) 2010 J\195\169r\195\180me Vouillon\n// Laboratoire PPS - CNRS Universit\195\169 Paris Diderot\n//\n// This program is free software; you can redistribute it and/or modify\n// it under the terms of the GNU Lesser General Public License as published by\n// the Free Software Foundation, with linking exception;\n// either version 2.1 of the License, or (at your option) any later version.\n//\n// This program is distributed in the hope that it will be useful,\n// but WITHOUT ANY WARRANTY; without even the implied warranty of\n// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n// GNU Lesser General Public License for more details.\n//\n// You should have received a copy of the GNU Lesser General Public License\n// along with this program; if not, write to the Free Software\n// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.\n\n// Weak API, but without the weak semantics\n\n//Provides: caml_ephe_key_offset\nvar caml_ephe_key_offset = 3\n\n//Provides: caml_ephe_data_offset\nvar caml_ephe_data_offset = 2\n\n//Provides: caml_weak_create\n//Requires: caml_ephe_key_offset, caml_invalid_argument\nfunction caml_weak_create (n) {\n  if (n < 0) caml_invalid_argument (\"Weak.create\");\n  var x = [251,\"caml_ephe_list_head\"];\n  x.length = caml_ephe_key_offset + n;\n  return x;\n}\n\n//Provides: caml_weak_set\n//Requires: caml_ephe_key_offset, caml_invalid_argument\nfunction caml_weak_set(x, i, v) {\n  if(i < 0 || caml_ephe_key_offset + i >= x.length)\n    caml_invalid_argument (\"Weak.set\");\n  x[caml_ephe_key_offset + i] = v;\n  return 0;\n}\n//Provides: caml_weak_get\n//Requires: caml_ephe_key_offset, caml_invalid_argument\nfunction caml_weak_get(x, i) {\n  if(i < 0 || caml_ephe_key_offset + i >= x.length)\n    caml_invalid_argument (\"Weak.get_key\");\n  return (x[caml_ephe_key_offset + i ]===undefined)?0:x[caml_ephe_key_offset + i];\n}\n//Provides: caml_weak_get_copy\n//Requires: caml_weak_get,caml_ephe_key_offset\n//Requires: caml_obj_dup, caml_invalid_argument\nfunction caml_weak_get_copy(x, i) {\n  if(i < 0 || caml_ephe_key_offset + i >= x.length)\n    caml_invalid_argument (\"Weak.get_copy\");\n  var y = caml_weak_get(x, i);\n  if (y === 0) return y;\n  var z = y[1];\n  if (z instanceof Array) return [0, caml_obj_dup(z)];\n  return y;\n}\n\n//Provides: caml_weak_check mutable\n//Requires: caml_ephe_key_offset\nfunction caml_weak_check(x, i) {\n  if(x[caml_ephe_key_offset + i]!==undefined && x[caml_ephe_key_offset + i] !==0)\n    return 1;\n  else\n    return 0;\n}\n\n//Provides: caml_weak_blit\n//Requires: caml_array_blit\n//Requires: caml_ephe_key_offset\nfunction caml_weak_blit(a1, i1, a2, i2, len) {\n  // minus one because caml_array_blit works on ocaml array\n  caml_array_blit(a1, caml_ephe_key_offset + i1 - 1,\n                  a2, caml_ephe_key_offset + i2 - 1,\n                  len);\n  return 0;\n}\n\n//Provides: caml_ephe_create\n//Requires: caml_weak_create\nvar caml_ephe_create = caml_weak_create\n\n//Provides: caml_ephe_blit_key\n//Requires: caml_weak_blit\nvar caml_ephe_blit_key = caml_weak_blit\n\n//Provides: caml_ephe_get_key\n//Requires: caml_weak_get\nvar caml_ephe_get_key = caml_weak_get\n\n//Provides: caml_ephe_get_key_copy\n//Requires: caml_weak_get_copy\nvar caml_ephe_get_key_copy = caml_weak_get_copy\n\n//Provides: caml_ephe_check_key\n//Requires: caml_weak_check\nvar caml_ephe_check_key = caml_weak_check\n\n//Provides: caml_ephe_set_key\n//Requires: caml_weak_set\nfunction caml_ephe_set_key(x, i, v) {\n  return caml_weak_set(x, i, [0, v])\n}\n\n//Provides: caml_ephe_unset_key\n//Requires: caml_weak_set\nfunction caml_ephe_unset_key(x, i) {\n  return caml_weak_set(x, i, 0)\n}\n\n//Provides: caml_ephe_blit_data\n//Requires: caml_ephe_data_offset\nfunction caml_ephe_blit_data(src, dst){\n  dst[caml_ephe_data_offset] = src[caml_ephe_data_offset];\n  return 0;\n}\n\n//Provides: caml_ephe_get_data\n//Requires: caml_ephe_data_offset\nfunction caml_ephe_get_data(x){\n  if(x[caml_ephe_data_offset] === undefined)\n    return 0;\n  else\n    return [0, x[caml_ephe_data_offset]];\n}\n\n//Provides: caml_ephe_get_data_copy\n//Requires: caml_ephe_data_offset\n//Requires: caml_obj_dup\nfunction caml_ephe_get_data_copy(x){\n  if(x[caml_ephe_data_offset] === undefined)\n    return 0;\n  else\n    return [0, caml_obj_dup(x[caml_ephe_data_offset])];\n}\n\n//Provides: caml_ephe_set_data\n//Requires: caml_ephe_data_offset\nfunction caml_ephe_set_data(x, data){\n  x[caml_ephe_data_offset] = data;\n  return 0;\n}\n\n//Provides: caml_ephe_unset_data\n//Requires: caml_ephe_data_offset\nfunction caml_ephe_unset_data(x, data){\n  x[caml_ephe_data_offset] = undefined;\n  return 0;\n}\n\n//Provides: caml_ephe_check_data\n//Requires: caml_ephe_data_offset\nfunction caml_ephe_check_data(x){\n  if(x[caml_ephe_data_offset] === undefined)\n    return 0;\n  else\n    return 1;\n}\n"
