/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.plaf.LookAndFeelFactory;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ActionMapUIResource;

public class LegacyTristateCheckBox
extends JCheckBox {
    public static final String PROPERTY_STATE = "state";
    public static final State NOT_SELECTED = new State();
    public static final State SELECTED = new State();
    public static final State DONT_CARE = new State();
    private final TristateDecorator model;

    public LegacyTristateCheckBox(String text, Icon icon, State initial) {
        super(text, icon);
        super.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                LegacyTristateCheckBox.this.grabFocus();
                LegacyTristateCheckBox.this.setState(LegacyTristateCheckBox.this.getNextState(LegacyTristateCheckBox.this.getState()));
            }
        });
        ActionMapUIResource map = new ActionMapUIResource();
        map.put("pressed", new AbstractAction(){
            private static final long serialVersionUID = 7121802319351334948L;

            public void actionPerformed(ActionEvent e) {
                LegacyTristateCheckBox.this.grabFocus();
                LegacyTristateCheckBox.this.setState(LegacyTristateCheckBox.this.getNextState(LegacyTristateCheckBox.this.getState()));
            }
        });
        map.put("released", null);
        SwingUtilities.replaceUIActionMap(this, map);
        this.model = new TristateDecorator(this.getModel());
        this.setModel(this.model);
        this.setState(initial);
    }

    public LegacyTristateCheckBox(String text, State initial) {
        this(text, null, initial);
    }

    public LegacyTristateCheckBox(String text) {
        this(text, DONT_CARE);
    }

    public LegacyTristateCheckBox() {
        this((String)null);
    }

    public void addMouseListener(MouseListener l) {
    }

    public void setState(State state) {
        State old = this.model.getState();
        this.model.setState(state);
        if (old != state) {
            this.firePropertyChange(PROPERTY_STATE, old, state);
        }
        if (LookAndFeelFactory.isSyntheticaLnfInstalled() && (UIManager.getLookAndFeel().getClass().getName().startsWith("de.javasoft.plaf.synthetica.Synthetica") || LookAndFeelFactory.isLnfInUse("de.javasoft.plaf.synthetica.SyntheticaLookAndFeel"))) {
            if (state == DONT_CARE) {
                this.setName("HalfSelected");
            } else {
                this.setName("");
            }
        }
    }

    public State getState() {
        return this.model.getState();
    }

    public void setSelected(boolean b) {
        if (b) {
            this.setState(SELECTED);
        } else {
            this.setState(NOT_SELECTED);
        }
    }

    protected State getNextState(State current) {
        if (current == NOT_SELECTED) {
            return SELECTED;
        }
        if (current == SELECTED) {
            return DONT_CARE;
        }
        return NOT_SELECTED;
    }

    private class TristateDecorator
    implements ButtonModel {
        private final ButtonModel other;
        private State _state;

        private TristateDecorator(ButtonModel other) {
            this.other = other;
        }

        private void setState(State state) {
            if (state == NOT_SELECTED) {
                this.other.setArmed(false);
                this.setPressed(false);
                this.setSelected(false);
            } else if (state == SELECTED) {
                this.other.setArmed(false);
                this.setPressed(false);
                this.setSelected(true);
            } else {
                this.other.setArmed(true);
                this.setPressed(true);
                this.setSelected(true);
            }
            this._state = state;
        }

        private State getState() {
            return this._state == null ? DONT_CARE : this._state;
        }

        public void setArmed(boolean b) {
        }

        public void setEnabled(boolean b) {
            LegacyTristateCheckBox.this.setFocusable(b);
            this.other.setEnabled(b);
        }

        public boolean isArmed() {
            return this.other.isArmed();
        }

        public boolean isSelected() {
            return this.other.isSelected();
        }

        public boolean isEnabled() {
            return this.other.isEnabled();
        }

        public boolean isPressed() {
            return this.other.isPressed();
        }

        public boolean isRollover() {
            return this.other.isRollover();
        }

        public void setSelected(boolean b) {
            this.other.setSelected(b);
        }

        public void setPressed(boolean b) {
            this.other.setPressed(b);
        }

        public void setRollover(boolean b) {
            this.other.setRollover(b);
        }

        public void setMnemonic(int key) {
            this.other.setMnemonic(key);
        }

        public int getMnemonic() {
            return this.other.getMnemonic();
        }

        public void setActionCommand(String s2) {
            this.other.setActionCommand(s2);
        }

        public String getActionCommand() {
            return this.other.getActionCommand();
        }

        public void setGroup(ButtonGroup group) {
            this.other.setGroup(group);
        }

        public void addActionListener(ActionListener l) {
            this.other.addActionListener(l);
        }

        public void removeActionListener(ActionListener l) {
            this.other.removeActionListener(l);
        }

        public void addItemListener(ItemListener l) {
            this.other.addItemListener(l);
        }

        public void removeItemListener(ItemListener l) {
            this.other.removeItemListener(l);
        }

        public void addChangeListener(ChangeListener l) {
            this.other.addChangeListener(l);
        }

        public void removeChangeListener(ChangeListener l) {
            this.other.removeChangeListener(l);
        }

        public Object[] getSelectedObjects() {
            return this.other.getSelectedObjects();
        }
    }

    public static class State {
        private State() {
        }
    }
}

