/*
 * Decompiled with CFR 0.152.
 */
package org.wiztools.restclient.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.logging.Logger;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartDocument;
import javax.xml.stream.events.XMLEvent;
import nu.xom.Builder;
import nu.xom.Document;
import nu.xom.ParsingException;
import nu.xom.Serializer;
import org.wiztools.restclient.persistence.XMLException;

public final class XMLUtil {
    private static final Logger LOG = Logger.getLogger(XMLUtil.class.getName());
    public static final String XML_MIME = "application/xml";

    private XMLUtil() {
    }

    public static String getDocumentCharset(File f) throws IOException, XMLException {
        XMLEventReader reader = null;
        try {
            XMLInputFactory inputFactory = XMLInputFactory.newInstance();
            reader = inputFactory.createXMLEventReader(new FileInputStream(f));
            XMLEvent event = reader.nextEvent();
            StartDocument document = (StartDocument)event;
            String string = document.getCharacterEncodingScheme();
            return string;
        }
        catch (XMLStreamException ex) {
            throw new XMLException(ex.getMessage(), ex);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (XMLStreamException ex) {
                    LOG.warning(ex.getMessage());
                }
            }
        }
    }

    @Deprecated
    public static String indentXML(String in) throws XMLException, IOException {
        try {
            Builder parser = new Builder();
            Document doc = parser.build(in, null);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            Serializer serializer = new Serializer(baos);
            serializer.setIndent(4);
            serializer.setMaxLength(69);
            serializer.write(doc);
            return new String(baos.toByteArray());
        }
        catch (ParsingException ex) {
            throw new XMLException("XML indentation failed.", ex);
        }
    }
}

