/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.tribble.gff;

import htsjdk.samtools.util.Tuple;
import htsjdk.tribble.TribbleException;
import htsjdk.tribble.annotation.Strand;
import htsjdk.tribble.gff.Gff3BaseData;
import htsjdk.tribble.gff.Gff3Feature;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class Gff3FeatureImpl
implements Gff3Feature {
    private static final String DERIVES_FROM_ATTRIBUTE_KEY = "Derives_from";
    private final Gff3BaseData baseData;
    private final Set<Gff3FeatureImpl> parents = new LinkedHashSet<Gff3FeatureImpl>();
    private final LinkedHashSet<Gff3FeatureImpl> children = new LinkedHashSet();
    private final LinkedHashSet<Gff3FeatureImpl> coFeatures = new LinkedHashSet();
    private final Set<Gff3FeatureImpl> topLevelFeatures = new HashSet<Gff3FeatureImpl>();

    public Gff3FeatureImpl(String contig, String source, String type, int start, int end, Double score, Strand strand, int phase, Map<String, List<String>> attributes) {
        this.baseData = new Gff3BaseData(contig, source, type, start, end, score, strand, phase, attributes);
    }

    public Gff3FeatureImpl(Gff3BaseData baseData) {
        this.baseData = baseData;
    }

    public Set<Gff3FeatureImpl> getTopLevelFeatures() {
        if (this.isTopLevelFeature()) {
            return Collections.singleton(this);
        }
        return this.topLevelFeatures;
    }

    @Override
    public boolean isTopLevelFeature() {
        return this.topLevelFeatures.isEmpty();
    }

    public Set<Gff3FeatureImpl> getParents() {
        return this.parents;
    }

    public Set<Gff3FeatureImpl> getChildren() {
        return this.children;
    }

    @Override
    public Gff3BaseData getBaseData() {
        return this.baseData;
    }

    public Set<Gff3FeatureImpl> getAncestors() {
        ArrayList<Gff3FeatureImpl> ancestors = new ArrayList<Gff3FeatureImpl>(this.parents);
        for (Gff3FeatureImpl parent : this.parents) {
            ancestors.addAll(this.getAttribute(DERIVES_FROM_ATTRIBUTE_KEY).isEmpty() ? parent.getAncestors() : parent.getAncestors(new HashSet<String>((Collection)this.baseData.getAttributes().get(DERIVES_FROM_ATTRIBUTE_KEY))));
        }
        return new LinkedHashSet<Gff3FeatureImpl>(ancestors);
    }

    private Set<Gff3FeatureImpl> getAncestors(Collection<String> derivingFrom) {
        ArrayList<Gff3FeatureImpl> ancestors = new ArrayList<Gff3FeatureImpl>();
        for (Gff3FeatureImpl parent : this.parents) {
            if (!derivingFrom.contains(parent.getID()) && !parent.getAncestors().stream().anyMatch(f -> derivingFrom.contains(f.getID()))) continue;
            ancestors.add(parent);
            ancestors.addAll(parent.getAncestors());
        }
        return new LinkedHashSet<Gff3FeatureImpl>(ancestors);
    }

    public Set<Gff3FeatureImpl> getDescendents() {
        ArrayList<Gff3FeatureImpl> descendants = new ArrayList<Gff3FeatureImpl>(this.children);
        HashSet<String> idsInLineage = new HashSet<String>(Collections.singleton(this.baseData.getId()));
        idsInLineage.addAll(this.children.stream().map(Gff3Feature::getID).collect(Collectors.toSet()));
        for (Gff3FeatureImpl child : this.children) {
            descendants.addAll(child.getDescendents(idsInLineage));
        }
        return new LinkedHashSet<Gff3FeatureImpl>(descendants);
    }

    private Set<Gff3FeatureImpl> getDescendents(Set<String> idsInLineage) {
        List childrenToAdd = this.children.stream().filter(c -> c.getAttribute(DERIVES_FROM_ATTRIBUTE_KEY).isEmpty() || !Collections.disjoint(idsInLineage, c.getAttribute(DERIVES_FROM_ATTRIBUTE_KEY))).collect(Collectors.toList());
        ArrayList descendants = new ArrayList(childrenToAdd);
        HashSet<String> updatedIdsInLineage = new HashSet<String>(idsInLineage);
        updatedIdsInLineage.addAll(childrenToAdd.stream().map(Gff3Feature::getID).collect(Collectors.toSet()));
        for (Gff3FeatureImpl child : childrenToAdd) {
            descendants.addAll(child.getDescendents(updatedIdsInLineage));
        }
        return new LinkedHashSet<Gff3FeatureImpl>(descendants);
    }

    public Set<Gff3FeatureImpl> getCoFeatures() {
        return this.coFeatures;
    }

    @Override
    public boolean hasParents() {
        return !this.parents.isEmpty();
    }

    @Override
    public boolean hasChildren() {
        return !this.children.isEmpty();
    }

    @Override
    public boolean hasCoFeatures() {
        return !this.coFeatures.isEmpty();
    }

    public void addParent(Gff3FeatureImpl parent) {
        HashSet<Gff3FeatureImpl> topLevelFeaturesToAdd = new HashSet<Gff3FeatureImpl>(parent.getTopLevelFeatures());
        if (!this.getAttribute(DERIVES_FROM_ATTRIBUTE_KEY).isEmpty()) {
            topLevelFeaturesToAdd.removeIf(f -> !this.getAttribute(DERIVES_FROM_ATTRIBUTE_KEY).contains(f.getID()) && f.getDescendents().stream().noneMatch(f2 -> f2.getID() != null && this.getAttribute(DERIVES_FROM_ATTRIBUTE_KEY).contains(f2.getID())));
        }
        this.parents.add(parent);
        parent.addChild(this);
        this.addTopLevelFeatures(topLevelFeaturesToAdd);
    }

    private void addChild(Gff3FeatureImpl child) {
        this.children.add(child);
    }

    private void addTopLevelFeatures(Collection<Gff3FeatureImpl> topLevelFeaturesToAdd) {
        this.topLevelFeatures.addAll(topLevelFeaturesToAdd);
        for (Gff3FeatureImpl child : this.children) {
            child.addTopLevelFeatures(topLevelFeaturesToAdd);
            child.removeTopLevelFeature(this);
        }
    }

    private void removeTopLevelFeature(Gff3FeatureImpl topLevelFeatureToRemove) {
        this.topLevelFeatures.remove(topLevelFeatureToRemove);
        for (Gff3FeatureImpl child : this.children) {
            child.removeTopLevelFeature(topLevelFeatureToRemove);
        }
    }

    public void addCoFeature(Gff3FeatureImpl coFeature) {
        if (!this.parents.equals(coFeature.getParents())) {
            throw new TribbleException("Co-features " + this.baseData.getId() + " do not have same parents");
        }
        for (Gff3FeatureImpl feature : this.coFeatures) {
            feature.addCoFeatureShallow(coFeature);
            coFeature.addCoFeatureShallow(feature);
        }
        this.addCoFeatureShallow(coFeature);
        coFeature.addCoFeatureShallow(this);
    }

    private void addCoFeatureShallow(Gff3FeatureImpl coFeature) {
        this.coFeatures.add(coFeature);
        if (!coFeature.getID().equals(this.baseData.getId())) {
            throw new TribbleException("Attempting to add co-feature with id " + coFeature.getID() + " to feature with id " + this.baseData.getId());
        }
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Gff3Feature)) {
            return false;
        }
        return this.baseData.equals(((Gff3Feature)other).getBaseData()) && new Gff3Graph(this).equals(new Gff3Graph((Gff3Feature)other));
    }

    public int hashCode() {
        return this.baseData.hashCode();
    }

    public Set<Gff3FeatureImpl> flatten() {
        LinkedHashSet<Gff3FeatureImpl> features = new LinkedHashSet<Gff3FeatureImpl>(Collections.singleton(this));
        features.addAll(this.getDescendents());
        return features;
    }

    private static class Gff3Graph {
        private final Set<Gff3BaseData> nodes = new HashSet<Gff3BaseData>();
        private final Set<Tuple<Gff3BaseData, Gff3BaseData>> parentEdges = new HashSet<Tuple<Gff3BaseData, Gff3BaseData>>();
        private final Set<Tuple<Gff3BaseData, Gff3BaseData>> childEdges = new HashSet<Tuple<Gff3BaseData, Gff3BaseData>>();
        private final Set<Set<Gff3BaseData>> coFeatureSets = new HashSet<Set<Gff3BaseData>>();

        Gff3Graph(Gff3Feature feature) {
            feature.getTopLevelFeatures().stream().flatMap(f -> f.flatten().stream()).forEach(this::addFeature);
        }

        private void addFeature(Gff3Feature feature) {
            this.addNode(feature);
            this.addParentEdges(feature);
            this.addChildEdges(feature);
            this.addCoFeatureSet(feature);
        }

        private void addNode(Gff3Feature feature) {
            this.nodes.add(feature.getBaseData());
        }

        private void addParentEdges(Gff3Feature feature) {
            for (Gff3Feature gff3Feature : feature.getParents()) {
                this.parentEdges.add(new Tuple<Gff3BaseData, Gff3BaseData>(feature.getBaseData(), gff3Feature.getBaseData()));
            }
        }

        private void addChildEdges(Gff3Feature feature) {
            for (Gff3Feature gff3Feature : feature.getChildren()) {
                this.childEdges.add(new Tuple<Gff3BaseData, Gff3BaseData>(feature.getBaseData(), gff3Feature.getBaseData()));
            }
        }

        private void addCoFeatureSet(Gff3Feature feature) {
            if (feature.hasCoFeatures()) {
                Set coFeaturesBaseData = feature.getCoFeatures().stream().map(Gff3Feature::getBaseData).collect(Collectors.toSet());
                coFeaturesBaseData.add(feature.getBaseData());
                this.coFeatureSets.add(coFeaturesBaseData);
            }
        }

        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (!other.getClass().equals(Gff3Graph.class)) {
                return false;
            }
            return this.nodes.equals(((Gff3Graph)other).nodes) && this.parentEdges.equals(((Gff3Graph)other).parentEdges) && this.childEdges.equals(((Gff3Graph)other).childEdges) && this.coFeatureSets.equals(((Gff3Graph)other).coFeatureSets);
        }

        public int hashCode() {
            int hash = this.nodes.hashCode();
            hash = 31 * hash + this.parentEdges.hashCode();
            hash = 31 * hash + this.childEdges.hashCode();
            hash = 31 * hash + this.coFeatureSets.hashCode();
            return hash;
        }
    }
}

