package TDS::Replacer::Url;
################################################################
# TDS::Replacer::Url : URL Replace List
#
# $Id: Url.pm,v 1.12 2000/12/16 07:17:24 tom Exp $
################################################################

use strict qw(vars);
use vars qw(@ISA);

use TDS::System;
use TDS::Replacer::Base;
use TDS::DirInfo;

@ISA = qw(TDS::Replacer::Base);

attributes qw();

sub initialize($)
{
    my $self = shift;
    $self->datafile(GetDataDir() . "/url.dat")
	unless $self->datafile;

    $self->SUPER::initialize;
}
################################################################
# protected:

sub ReadLine($$)
{
    my ($self, $line) = @_;

#    next if $line =~ /^\!/ || $line =~ /^#/ || $line =~ /^$/;
    return if $line =~ /^\!/;

    my ($term, $replaced) = $self->SUPER::ReadLine($line);
}
sub RealReplace($$)
{
    my ($self, $term, $object) = @_;
    my $replaced = $self->contents->{$term}->{replaced};
    my $template = qq(<a href="$replaced">$object</a>);

#    return $template;
    return $self->ApplyTemplate($template, {});
}


1;
