/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.dom;

import java.util.Collection;
import java.util.Iterator;
import org.w3c.dom.Node;
import org.w3c.dom.xpath.XPathException;
import org.w3c.dom.xpath.XPathResult;

class DomXPathResult
implements XPathResult {
    final Object value;
    final short type;
    Iterator iterator;

    public boolean getBooleanValue() {
        if (this.type == 3) {
            return (Boolean)this.value;
        }
        throw new XPathException(52, this.value.toString());
    }

    public boolean getInvalidIteratorState() {
        boolean bl = false;
        if (this.iterator == null) {
            bl = true;
        }
        return bl;
    }

    public double getNumberValue() {
        if (this.type == 1) {
            return (Double)this.value;
        }
        throw new XPathException(52, this.value.toString());
    }

    public short getResultType() {
        return this.type;
    }

    public Node getSingleNodeValue() {
        switch (this.type) {
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: {
                Collection ns = (Collection)this.value;
                if (ns.isEmpty()) {
                    return null;
                }
                return (Node)ns.iterator().next();
            }
        }
        throw new XPathException(52, this.value.toString());
    }

    public int getSnapshotLength() {
        switch (this.type) {
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: {
                return ((Collection)this.value).size();
            }
        }
        throw new XPathException(52, this.value.toString());
    }

    public String getStringValue() {
        if (this.type == 2) {
            return (String)this.value;
        }
        throw new XPathException(52, this.value.toString());
    }

    public Node iterateNext() {
        if (this.iterator != null) {
            if (this.iterator.hasNext()) {
                return (Node)this.iterator.next();
            }
            this.iterator = null;
            return null;
        }
        throw new XPathException(52, this.value.toString());
    }

    public Node snapshotItem(int index) {
        switch (this.type) {
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: {
                Collection ns = (Collection)this.value;
                Object[] nodes = new Node[ns.size()];
                ns.toArray(nodes);
                return nodes[index];
            }
        }
        throw new XPathException(52, this.value.toString());
    }

    public String toString() {
        return this.getClass().getName() + "[type=" + this.typeName(this.type) + ",value=" + this.value + ']';
    }

    private final String typeName(short type) {
        switch (type) {
            case 3: {
                return "BOOLEAN_TYPE";
            }
            case 1: {
                return "NUMBER_TYPE";
            }
            case 2: {
                return "STRING_TYPE";
            }
            case 9: {
                return "FIRST_ORDERED_NODE_TYPE";
            }
            case 5: {
                return "ORDERED_NODE_ITERATOR_TYPE";
            }
            case 7: {
                return "ORDERED_NODE_SNAPSHOT_TYPE";
            }
            case 4: {
                return "UNORDERED_NODE_ITERATOR_TYPE";
            }
            case 6: {
                return "UNORDERED_NODE_SNAPSHOT_TYPE";
            }
        }
        return "(unknown)";
    }

    DomXPathResult(Object value, short requestedType) {
        this.value = value;
        if (value instanceof Boolean) {
            this.type = (short)3;
        } else if (value instanceof Double) {
            this.type = 1;
        } else if (value instanceof String) {
            this.type = (short)2;
        } else if (value instanceof Collection) {
            Collection ns = (Collection)value;
            switch (requestedType) {
                case 0: 
                case 8: {
                    this.type = (short)(ns.size() == 1 ? 9 : 5);
                    break;
                }
                default: {
                    this.type = requestedType;
                }
            }
            this.iterator = ns.iterator();
        } else {
            throw new IllegalArgumentException();
        }
    }
}

