require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_M68k_INTR_H_)) {
    eval 'sub _M68k_INTR_H_ () {1;}' unless defined(&_M68k_INTR_H_);
    require 'machine/psl.ph';
    if((defined(&_KERNEL)  && !defined(&_LOCORE)) || defined(&_KMEMUSER)) {
    }
    if(defined(&_KERNEL)) {
	eval 'sub IPL_NONE () {0;}' unless defined(&IPL_NONE);
	eval 'sub IPL_SOFTCLOCK () {1;}' unless defined(&IPL_SOFTCLOCK);
	eval 'sub IPL_SOFTBIO () {2;}' unless defined(&IPL_SOFTBIO);
	eval 'sub IPL_SOFTNET () {3;}' unless defined(&IPL_SOFTNET);
	eval 'sub IPL_SOFTSERIAL () {4;}' unless defined(&IPL_SOFTSERIAL);
	eval 'sub IPL_VM () {5;}' unless defined(&IPL_VM);
	eval 'sub IPL_SCHED () {6;}' unless defined(&IPL_SCHED);
	eval 'sub IPL_HIGH () {7;}' unless defined(&IPL_HIGH);
	eval 'sub NIPL () {8;}' unless defined(&NIPL);
	eval 'sub ISRPRI_BIO () {0;}' unless defined(&ISRPRI_BIO);
	eval 'sub ISRPRI_MISC () {0;}' unless defined(&ISRPRI_MISC);
	eval 'sub ISRPRI_NET () {1;}' unless defined(&ISRPRI_NET);
	eval 'sub ISRPRI_TTY () {2;}' unless defined(&ISRPRI_TTY);
	eval 'sub ISRPRI_DISPLAY () {2;}' unless defined(&ISRPRI_DISPLAY);
	eval 'sub ISRPRI_TTYNOBUF () {3;}' unless defined(&ISRPRI_TTYNOBUF);
	eval 'sub ISRPRI_AUDIO () {4;}' unless defined(&ISRPRI_AUDIO);
	unless(defined(&_LOCORE)) {
	    eval 'sub cpu_intr_p {
	        my($void) = @_;
    		eval q({  &intr_depth != 0; });
	    }' unless defined(&cpu_intr_p);
	    eval 'sub makeiplcookie {
	        my($ipl) = @_;
    		eval q({ ( &ipl_cookie_t){. &_psl =  $ipl2psl_table[$ipl]}; });
	    }' unless defined(&makeiplcookie);
	    eval 'sub splraiseipl {
	        my($icookie) = @_;
    		eval q({  &_splraise( ($icookie->{_psl})); });
	    }' unless defined(&splraiseipl);
	    eval 'sub splsoftclock () {
	        eval q( &_splraise( &PSL_S |  &MACHINE_PSL_IPL_SOFTCLOCK));
	    }' unless defined(&splsoftclock);
	    eval 'sub splsoftbio () {
	        eval q( &_splraise( &PSL_S |  &MACHINE_PSL_IPL_SOFTBIO));
	    }' unless defined(&splsoftbio);
	    eval 'sub splsoftnet () {
	        eval q( &_splraise( &PSL_S |  &MACHINE_PSL_IPL_SOFTNET));
	    }' unless defined(&splsoftnet);
	    eval 'sub splsoftserial () {
	        eval q( &_splraise( &PSL_S |  &MACHINE_PSL_IPL_SOFTSERIAL));
	    }' unless defined(&splsoftserial);
	    eval 'sub splvm () {
	        eval q( &_splraise( &PSL_S |  &MACHINE_PSL_IPL_VM));
	    }' unless defined(&splvm);
	    eval 'sub splsched () {
	        eval q( &_splraise( &PSL_S |  &MACHINE_PSL_IPL_SCHED));
	    }' unless defined(&splsched);
	    eval 'sub splhigh () {
	        eval q( &spl7());
	    }' unless defined(&splhigh);
	    eval 'sub spl0 () {
	        eval q( &_spl0());
	    }' unless defined(&spl0);
	    eval 'sub splx {
	        my($s) = @_;
    		eval q( &_splx($s));
	    }' unless defined(&splx);
	    if(defined(&_M68K_INTR_PRIVATE)) {
		require 'sys/queue.ph';
	    } else {
	    }
	    require 'sys/evcnt.ph';
	    if(defined(&__HAVE_LEGACY_INTRCNT)) {
		eval 'sub m68k_count_intr {
		    my($x) = @_;
    		    eval q( &do {  &extern \'u_int\'  $intrcnt[];  $intrcnt[($x)]++;  &curcpu()-> ($ci_data->{cpu_nintr})++; }  &while ( 0));
		}' unless defined(&m68k_count_intr);
	    } else {
		eval 'sub m68k_count_intr {
		    my($x) = @_;
    		    eval q( &do {  ($m68k_intr_evcnt[&(x)]->{ev_count32})++;  &curcpu()-> ($ci_data->{cpu_nintr})++; }  &while ( 0));
		}' unless defined(&m68k_count_intr);
	    }
	    if(defined(&__HAVE_M68K_INTR_VECTORED)) {
	    }
	}
    }
}
1;
