/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.figures;

import CH.ifa.draw.standard.AbstractFigure;
import CH.ifa.draw.standard.FigureAttributes;
import CH.ifa.draw.util.ColorMap;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;

public abstract class AttributeFigure
extends AbstractFigure {
    private static FigureAttributes fgDefaultAttributes = null;
    private static final long serialVersionUID = -10857585979273442L;
    private int attributeFigureSerializedDataVersion = 1;

    protected AttributeFigure() {
    }

    public void draw(Graphics graphics, boolean bl) {
        Color color = this.getFillColor();
        if (!ColorMap.getColorMap().isTransparent(color)) {
            graphics.setColor(color);
            this.drawBackground(graphics);
        }
        Color color2 = this.getFrameColor();
        if (!ColorMap.getColorMap().isTransparent(color2)) {
            graphics.setColor(color2);
            this.drawFrame(graphics);
        }
        if (bl) {
            this.drawURL(graphics);
        }
    }

    protected void drawBackground(Graphics graphics) {
    }

    protected void drawFrame(Graphics graphics) {
    }

    private void drawURL(Graphics graphics) {
        String string = (String)this.getAttribute("Sensitive");
        if (string != null && string.length() > 0) {
            Rectangle rectangle = this.displayBox();
            graphics.setColor(Color.red);
            graphics.setFont(AbstractFigure.dialogFont);
            graphics.drawString("url=" + string, rectangle.x, rectangle.y + rectangle.height);
        }
    }

    public Color getFillColor() {
        return (Color)this.getAttribute("FillColor");
    }

    public Color getFrameColor() {
        return (Color)this.getAttribute("FrameColor");
    }

    private static void initializeAttributes() {
        fgDefaultAttributes = new FigureAttributes();
        fgDefaultAttributes.set("FrameColor", Color.black);
        fgDefaultAttributes.set("FillColor", new Color(7396243));
        fgDefaultAttributes.set("TextColor", Color.black);
        fgDefaultAttributes.set("ArrowMode", new Integer(0));
        fgDefaultAttributes.set("FontName", "Helvetica");
        fgDefaultAttributes.set("FontSize", new Integer(12));
        fgDefaultAttributes.set("FontStyle", new Integer(0));
        fgDefaultAttributes.set("TextAlign", "Left");
        fgDefaultAttributes.set("Sensitive", "");
    }

    public static Object getDefaultAttribute(String string) {
        if (fgDefaultAttributes == null) {
            AttributeFigure.initializeAttributes();
        }
        return fgDefaultAttributes.get(string);
    }

    public Object defaultAttribute(String string) {
        return AttributeFigure.getDefaultAttribute(string);
    }

    public String getMap() {
        return "";
    }
}

