#!/usr/bin/env python
# -*- coding: utf-8 -*-

#
# Generated Fri Apr  8 12:08:30 2016 by generateDS.py version 2.21a.
#
# Command line options:
#   ('-f', '')
#   ('-o', 'generateds_gui_session.py')
#   ('--member-specs', 'list')
#
# Command line arguments:
#   generateds_gui_session.xsd
#
# Command line:
#   ../generateDS.py -f -o "generateds_gui_session.py" --member-specs="list" generateds_gui_session.xsd
#
# Current working directory (os.getcwd()):
#   gui
#

import sys
import re as re_
import base64
import datetime as datetime_
import warnings as warnings_
from lxml import etree as etree_


Validate_simpletypes_ = True
if sys.version_info.major == 2:
    BaseStrType_ = basestring
else:
    BaseStrType_ = str


def parsexml_(infile, parser=None, **kwargs):
    if parser is None:
        # Use the lxml ElementTree compatible parser so that, e.g.,
        #   we ignore comments.
        parser = etree_.ETCompatXMLParser()
    doc = etree_.parse(infile, parser=parser, **kwargs)
    return doc

#
# User methods
#
# Calls to the methods in these classes are generated by generateDS.py.
# You can replace these methods by re-implementing the following class
#   in a module named generatedssuper.py.

try:
    from generatedssuper import GeneratedsSuper
except ImportError as exp:

    class GeneratedsSuper(object):
        tzoff_pattern = re_.compile(r'(\+|-)((0\d|1[0-3]):[0-5]\d|14:00)$')
        class _FixedOffsetTZ(datetime_.tzinfo):
            def __init__(self, offset, name):
                self.__offset = datetime_.timedelta(minutes=offset)
                self.__name = name
            def utcoffset(self, dt):
                return self.__offset
            def tzname(self, dt):
                return self.__name
            def dst(self, dt):
                return None
        def gds_format_string(self, input_data, input_name=''):
            return input_data
        def gds_validate_string(self, input_data, node=None, input_name=''):
            if not input_data:
                return ''
            else:
                return input_data
        def gds_format_base64(self, input_data, input_name=''):
            return base64.b64encode(input_data)
        def gds_validate_base64(self, input_data, node=None, input_name=''):
            return input_data
        def gds_format_integer(self, input_data, input_name=''):
            return '%d' % input_data
        def gds_validate_integer(self, input_data, node=None, input_name=''):
            return input_data
        def gds_format_integer_list(self, input_data, input_name=''):
            return '%s' % ' '.join(input_data)
        def gds_validate_integer_list(
                self, input_data, node=None, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    int(value)
                except (TypeError, ValueError):
                    raise_parse_error(node, 'Requires sequence of integers')
            return values
        def gds_format_float(self, input_data, input_name=''):
            return ('%.15f' % input_data).rstrip('0')
        def gds_validate_float(self, input_data, node=None, input_name=''):
            return input_data
        def gds_format_float_list(self, input_data, input_name=''):
            return '%s' % ' '.join(input_data)
        def gds_validate_float_list(
                self, input_data, node=None, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    float(value)
                except (TypeError, ValueError):
                    raise_parse_error(node, 'Requires sequence of floats')
            return values
        def gds_format_double(self, input_data, input_name=''):
            return '%e' % input_data
        def gds_validate_double(self, input_data, node=None, input_name=''):
            return input_data
        def gds_format_double_list(self, input_data, input_name=''):
            return '%s' % ' '.join(input_data)
        def gds_validate_double_list(
                self, input_data, node=None, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    float(value)
                except (TypeError, ValueError):
                    raise_parse_error(node, 'Requires sequence of doubles')
            return values
        def gds_format_boolean(self, input_data, input_name=''):
            return ('%s' % input_data).lower()
        def gds_validate_boolean(self, input_data, node=None, input_name=''):
            return input_data
        def gds_format_boolean_list(self, input_data, input_name=''):
            return '%s' % ' '.join(input_data)
        def gds_validate_boolean_list(
                self, input_data, node=None, input_name=''):
            values = input_data.split()
            for value in values:
                if value not in ('true', '1', 'false', '0', ):
                    raise_parse_error(
                        node,
                        'Requires sequence of booleans '
                        '("true", "1", "false", "0")')
            return values
        def gds_validate_datetime(self, input_data, node=None, input_name=''):
            return input_data
        def gds_format_datetime(self, input_data, input_name=''):
            if input_data.microsecond == 0:
                _svalue = '%04d-%02d-%02dT%02d:%02d:%02d' % (
                    input_data.year,
                    input_data.month,
                    input_data.day,
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                )
            else:
                _svalue = '%04d-%02d-%02dT%02d:%02d:%02d.%s' % (
                    input_data.year,
                    input_data.month,
                    input_data.day,
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                    ('%f' % (float(input_data.microsecond) / 1000000))[2:],
                )
            if input_data.tzinfo is not None:
                tzoff = input_data.tzinfo.utcoffset(input_data)
                if tzoff is not None:
                    total_seconds = tzoff.seconds + (86400 * tzoff.days)
                    if total_seconds == 0:
                        _svalue += 'Z'
                    else:
                        if total_seconds < 0:
                            _svalue += '-'
                            total_seconds *= -1
                        else:
                            _svalue += '+'
                        hours = total_seconds // 3600
                        minutes = (total_seconds - (hours * 3600)) // 60
                        _svalue += '{0:02d}:{1:02d}'.format(hours, minutes)
            return _svalue
        @classmethod
        def gds_parse_datetime(cls, input_data):
            tz = None
            if input_data[-1] == 'Z':
                tz = GeneratedsSuper._FixedOffsetTZ(0, 'UTC')
                input_data = input_data[:-1]
            else:
                results = GeneratedsSuper.tzoff_pattern.search(input_data)
                if results is not None:
                    tzoff_parts = results.group(2).split(':')
                    tzoff = int(tzoff_parts[0]) * 60 + int(tzoff_parts[1])
                    if results.group(1) == '-':
                        tzoff *= -1
                    tz = GeneratedsSuper._FixedOffsetTZ(
                        tzoff, results.group(0))
                    input_data = input_data[:-6]
            time_parts = input_data.split('.')
            if len(time_parts) > 1:
                micro_seconds = int(float('0.' + time_parts[1]) * 1000000)
                input_data = '%s.%s' % (time_parts[0], micro_seconds, )
                dt = datetime_.datetime.strptime(
                    input_data, '%Y-%m-%dT%H:%M:%S.%f')
            else:
                dt = datetime_.datetime.strptime(
                    input_data, '%Y-%m-%dT%H:%M:%S')
            dt = dt.replace(tzinfo=tz)
            return dt
        def gds_validate_date(self, input_data, node=None, input_name=''):
            return input_data
        def gds_format_date(self, input_data, input_name=''):
            _svalue = '%04d-%02d-%02d' % (
                input_data.year,
                input_data.month,
                input_data.day,
            )
            try:
                if input_data.tzinfo is not None:
                    tzoff = input_data.tzinfo.utcoffset(input_data)
                    if tzoff is not None:
                        total_seconds = tzoff.seconds + (86400 * tzoff.days)
                        if total_seconds == 0:
                            _svalue += 'Z'
                        else:
                            if total_seconds < 0:
                                _svalue += '-'
                                total_seconds *= -1
                            else:
                                _svalue += '+'
                            hours = total_seconds // 3600
                            minutes = (total_seconds - (hours * 3600)) // 60
                            _svalue += '{0:02d}:{1:02d}'.format(
                                hours, minutes)
            except AttributeError:
                pass
            return _svalue
        @classmethod
        def gds_parse_date(cls, input_data):
            tz = None
            if input_data[-1] == 'Z':
                tz = GeneratedsSuper._FixedOffsetTZ(0, 'UTC')
                input_data = input_data[:-1]
            else:
                results = GeneratedsSuper.tzoff_pattern.search(input_data)
                if results is not None:
                    tzoff_parts = results.group(2).split(':')
                    tzoff = int(tzoff_parts[0]) * 60 + int(tzoff_parts[1])
                    if results.group(1) == '-':
                        tzoff *= -1
                    tz = GeneratedsSuper._FixedOffsetTZ(
                        tzoff, results.group(0))
                    input_data = input_data[:-6]
            dt = datetime_.datetime.strptime(input_data, '%Y-%m-%d')
            dt = dt.replace(tzinfo=tz)
            return dt.date()
        def gds_validate_time(self, input_data, node=None, input_name=''):
            return input_data
        def gds_format_time(self, input_data, input_name=''):
            if input_data.microsecond == 0:
                _svalue = '%02d:%02d:%02d' % (
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                )
            else:
                _svalue = '%02d:%02d:%02d.%s' % (
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                    ('%f' % (float(input_data.microsecond) / 1000000))[2:],
                )
            if input_data.tzinfo is not None:
                tzoff = input_data.tzinfo.utcoffset(input_data)
                if tzoff is not None:
                    total_seconds = tzoff.seconds + (86400 * tzoff.days)
                    if total_seconds == 0:
                        _svalue += 'Z'
                    else:
                        if total_seconds < 0:
                            _svalue += '-'
                            total_seconds *= -1
                        else:
                            _svalue += '+'
                        hours = total_seconds // 3600
                        minutes = (total_seconds - (hours * 3600)) // 60
                        _svalue += '{0:02d}:{1:02d}'.format(hours, minutes)
            return _svalue
        def gds_validate_simple_patterns(self, patterns, target):
            # pat is a list of lists of strings/patterns.  We should:
            # - AND the outer elements
            # - OR the inner elements
            found1 = True
            for patterns1 in patterns:
                found2 = False
                for patterns2 in patterns1:
                    if re_.search(patterns2, target) is not None:
                        found2 = True
                        break
                if not found2:
                    found1 = False
                    break
            return found1
        @classmethod
        def gds_parse_time(cls, input_data):
            tz = None
            if input_data[-1] == 'Z':
                tz = GeneratedsSuper._FixedOffsetTZ(0, 'UTC')
                input_data = input_data[:-1]
            else:
                results = GeneratedsSuper.tzoff_pattern.search(input_data)
                if results is not None:
                    tzoff_parts = results.group(2).split(':')
                    tzoff = int(tzoff_parts[0]) * 60 + int(tzoff_parts[1])
                    if results.group(1) == '-':
                        tzoff *= -1
                    tz = GeneratedsSuper._FixedOffsetTZ(
                        tzoff, results.group(0))
                    input_data = input_data[:-6]
            if len(input_data.split('.')) > 1:
                dt = datetime_.datetime.strptime(input_data, '%H:%M:%S.%f')
            else:
                dt = datetime_.datetime.strptime(input_data, '%H:%M:%S')
            dt = dt.replace(tzinfo=tz)
            return dt.time()
        def gds_str_lower(self, instring):
            return instring.lower()
        def get_path_(self, node):
            path_list = []
            self.get_path_list_(node, path_list)
            path_list.reverse()
            path = '/'.join(path_list)
            return path
        Tag_strip_pattern_ = re_.compile(r'\{.*\}')
        def get_path_list_(self, node, path_list):
            if node is None:
                return
            tag = GeneratedsSuper.Tag_strip_pattern_.sub('', node.tag)
            if tag:
                path_list.append(tag)
            self.get_path_list_(node.getparent(), path_list)
        def get_class_obj_(self, node, default_class=None):
            class_obj1 = default_class
            if 'xsi' in node.nsmap:
                classname = node.get('{%s}type' % node.nsmap['xsi'])
                if classname is not None:
                    names = classname.split(':')
                    if len(names) == 2:
                        classname = names[1]
                    class_obj2 = globals().get(classname)
                    if class_obj2 is not None:
                        class_obj1 = class_obj2
            return class_obj1
        def gds_build_any(self, node, type_name=None):
            return None
        @classmethod
        def gds_reverse_node_mapping(cls, mapping):
            return dict(((v, k) for k, v in mapping.iteritems()))
        @staticmethod
        def gds_encode(instring):
            if sys.version_info.major == 2:
                return instring.encode(ExternalEncoding)
            else:
                return instring

    def getSubclassFromModule_(module, class_):
        '''Get the subclass of a class from a specific module.'''
        name = class_.__name__ + 'Sub'
        if hasattr(module, name):
            return getattr(module, name)
        else:
            return None


#
# If you have installed IPython you can uncomment and use the following.
# IPython is available from http://ipython.scipy.org/.
#

## from IPython.Shell import IPShellEmbed
## args = ''
## ipshell = IPShellEmbed(args,
##     banner = 'Dropping into IPython',
##     exit_msg = 'Leaving Interpreter, back to program.')

# Then use the following line where and when you want to drop into the
# IPython shell:
#    ipshell('<some message> -- Entering ipshell.\nHit Ctrl-D to exit')

#
# Globals
#

ExternalEncoding = 'ascii'
Tag_pattern_ = re_.compile(r'({.*})?(.*)')
String_cleanup_pat_ = re_.compile(r"[\n\r\s]+")
Namespace_extract_pat_ = re_.compile(r'{(.*)}(.*)')
CDATA_pattern_ = re_.compile(r"<!\[CDATA\[.*?\]\]>", re_.DOTALL)

# Change this to redirect the generated superclass module to use a
# specific subclass module.
CurrentSubclassModule_ = None

#
# Support/utility functions.
#


def showIndent(outfile, level, pretty_print=True):
    if pretty_print:
        for idx in range(level):
            outfile.write('    ')


def quote_xml(inStr):
    "Escape markup chars, but do not modify CDATA sections."
    if not inStr:
        return ''
    s1 = (isinstance(inStr, BaseStrType_) and inStr or '%s' % inStr)
    s2 = ''
    pos = 0
    matchobjects = CDATA_pattern_.finditer(s1)
    for mo in matchobjects:
        s3 = s1[pos:mo.start()]
        s2 += quote_xml_aux(s3)
        s2 += s1[mo.start():mo.end()]
        pos = mo.end()
    s3 = s1[pos:]
    s2 += quote_xml_aux(s3)
    return s2


def quote_xml_aux(inStr):
    s1 = inStr.replace('&', '&amp;')
    s1 = s1.replace('<', '&lt;')
    s1 = s1.replace('>', '&gt;')
    return s1


def quote_attrib(inStr):
    s1 = (isinstance(inStr, BaseStrType_) and inStr or '%s' % inStr)
    s1 = s1.replace('&', '&amp;')
    s1 = s1.replace('<', '&lt;')
    s1 = s1.replace('>', '&gt;')
    if '"' in s1:
        if "'" in s1:
            s1 = '"%s"' % s1.replace('"', "&quot;")
        else:
            s1 = "'%s'" % s1
    else:
        s1 = '"%s"' % s1
    return s1


def quote_python(inStr):
    s1 = inStr
    if s1.find("'") == -1:
        if s1.find('\n') == -1:
            return "'%s'" % s1
        else:
            return "'''%s'''" % s1
    else:
        if s1.find('"') != -1:
            s1 = s1.replace('"', '\\"')
        if s1.find('\n') == -1:
            return '"%s"' % s1
        else:
            return '"""%s"""' % s1


def get_all_text_(node):
    if node.text is not None:
        text = node.text
    else:
        text = ''
    for child in node:
        if child.tail is not None:
            text += child.tail
    return text


def find_attr_value_(attr_name, node):
    attrs = node.attrib
    attr_parts = attr_name.split(':')
    value = None
    if len(attr_parts) == 1:
        value = attrs.get(attr_name)
    elif len(attr_parts) == 2:
        prefix, name = attr_parts
        namespace = node.nsmap.get(prefix)
        if namespace is not None:
            value = attrs.get('{%s}%s' % (namespace, name, ))
    return value


class GDSParseError(Exception):
    pass


def raise_parse_error(node, msg):
    msg = '%s (element %s/line %d)' % (msg, node.tag, node.sourceline, )
    raise GDSParseError(msg)


class MixedContainer:
    # Constants for category:
    CategoryNone = 0
    CategoryText = 1
    CategorySimple = 2
    CategoryComplex = 3
    # Constants for content_type:
    TypeNone = 0
    TypeText = 1
    TypeString = 2
    TypeInteger = 3
    TypeFloat = 4
    TypeDecimal = 5
    TypeDouble = 6
    TypeBoolean = 7
    TypeBase64 = 8
    def __init__(self, category, content_type, name, value):
        self.category = category
        self.content_type = content_type
        self.name = name
        self.value = value
    def getCategory(self):
        return self.category
    def getContenttype(self, content_type):
        return self.content_type
    def getValue(self):
        return self.value
    def getName(self):
        return self.name
    def export(self, outfile, level, name, namespace, pretty_print=True):
        if self.category == MixedContainer.CategoryText:
            # Prevent exporting empty content as empty lines.
            if self.value.strip():
                outfile.write(self.value)
        elif self.category == MixedContainer.CategorySimple:
            self.exportSimple(outfile, level, name)
        else:    # category == MixedContainer.CategoryComplex
            self.value.export(outfile, level, namespace, name, pretty_print)
    def exportSimple(self, outfile, level, name):
        if self.content_type == MixedContainer.TypeString:
            outfile.write('<%s>%s</%s>' % (
                self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeInteger or \
                self.content_type == MixedContainer.TypeBoolean:
            outfile.write('<%s>%d</%s>' % (
                self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeFloat or \
                self.content_type == MixedContainer.TypeDecimal:
            outfile.write('<%s>%f</%s>' % (
                self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeDouble:
            outfile.write('<%s>%g</%s>' % (
                self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeBase64:
            outfile.write('<%s>%s</%s>' % (
                self.name, base64.b64encode(self.value), self.name))
    def to_etree(self, element):
        if self.category == MixedContainer.CategoryText:
            # Prevent exporting empty content as empty lines.
            if self.value.strip():
                if len(element) > 0:
                    if element[-1].tail is None:
                        element[-1].tail = self.value
                    else:
                        element[-1].tail += self.value
                else:
                    if element.text is None:
                        element.text = self.value
                    else:
                        element.text += self.value
        elif self.category == MixedContainer.CategorySimple:
            subelement = etree_.SubElement(element, '%s' % self.name)
            subelement.text = self.to_etree_simple()
        else:    # category == MixedContainer.CategoryComplex
            self.value.to_etree(element)
    def to_etree_simple(self):
        if self.content_type == MixedContainer.TypeString:
            text = self.value
        elif (self.content_type == MixedContainer.TypeInteger or
                self.content_type == MixedContainer.TypeBoolean):
            text = '%d' % self.value
        elif (self.content_type == MixedContainer.TypeFloat or
                self.content_type == MixedContainer.TypeDecimal):
            text = '%f' % self.value
        elif self.content_type == MixedContainer.TypeDouble:
            text = '%g' % self.value
        elif self.content_type == MixedContainer.TypeBase64:
            text = '%s' % base64.b64encode(self.value)
        return text
    def exportLiteral(self, outfile, level, name):
        if self.category == MixedContainer.CategoryText:
            showIndent(outfile, level)
            outfile.write(
                'model_.MixedContainer(%d, %d, "%s", "%s"),\n' % (
                    self.category, self.content_type, self.name, self.value))
        elif self.category == MixedContainer.CategorySimple:
            showIndent(outfile, level)
            outfile.write(
                'model_.MixedContainer(%d, %d, "%s", "%s"),\n' % (
                    self.category, self.content_type, self.name, self.value))
        else:    # category == MixedContainer.CategoryComplex
            showIndent(outfile, level)
            outfile.write(
                'model_.MixedContainer(%d, %d, "%s",\n' % (
                    self.category, self.content_type, self.name,))
            self.value.exportLiteral(outfile, level + 1)
            showIndent(outfile, level)
            outfile.write(')\n')


class MemberSpec_(object):
    def __init__(self, name='', data_type='', container=0):
        self.name = name
        self.data_type = data_type
        self.container = container
    def set_name(self, name): self.name = name
    def get_name(self): return self.name
    def set_data_type(self, data_type): self.data_type = data_type
    def get_data_type_chain(self): return self.data_type
    def get_data_type(self):
        if isinstance(self.data_type, list):
            if len(self.data_type) > 0:
                return self.data_type[-1]
            else:
                return 'xs:string'
        else:
            return self.data_type
    def set_container(self, container): self.container = container
    def get_container(self): return self.container


def _cast(typ, value):
    if typ is None or value is None:
        return value
    return typ(value)

#
# Mixin class for additional behaviors.
#

class SessionTypeMixin(object):
    def copy(self):
        """Produce a copy of myself.
        """
        new_session = sessionType(
            input_schema=self.input_schema,
            output_superclass=self.output_superclass,
            output_subclass=self.output_subclass,
            force=self.force,
            prefix=self.prefix,
            namespace_prefix=self.namespace_prefix,
            empty_namespace_prefix=self.empty_namespace_prefix,
            behavior_filename=self.behavior_filename,
            properties=self.properties,
            subclass_suffix=self.subclass_suffix,
            root_element=self.root_element,
            superclass_module=self.superclass_module,
            auto_super=self.auto_super,
            old_getters_setters=self.old_getters_setters,
            validator_bodies=self.validator_bodies,
            user_methods=self.user_methods,
            no_dates=self.no_dates,
            no_versions=self.no_versions,
            no_process_includes=self.no_process_includes,
            silence=self.silence,
            namespace_defs=self.namespace_defs,
            external_encoding=self.external_encoding,
            member_specs=self.member_specs,
            export_spec=self.export_spec,
            one_file_per_xsd=self.one_file_per_xsd,
            output_directory=self.output_directory,
            module_suffix=self.module_suffix,
            preserve_cdata_tags=self.preserve_cdata_tags,
            cleanup_name_list=self.cleanup_name_list,
        )
        return new_session

    def __eq__(self, obj):
        """Implement the == operator.
        """
        if (
                obj.input_schema == self.input_schema and
                obj.output_superclass == self.output_superclass and
                obj.output_subclass == self.output_subclass and
                obj.force == self.force and
                obj.prefix == self.prefix and
                obj.namespace_prefix == self.namespace_prefix and
                obj.empty_namespace_prefix == self.empty_namespace_prefix and
                obj.behavior_filename == self.behavior_filename and
                obj.properties == self.properties and
                obj.subclass_suffix == self.subclass_suffix and
                obj.root_element == self.root_element and
                obj.superclass_module == self.superclass_module and
                obj.auto_super == self.auto_super and
                obj.old_getters_setters == self.old_getters_setters and
                obj.validator_bodies == self.validator_bodies and
                obj.user_methods == self.user_methods and
                obj.no_dates == self.no_dates and
                obj.no_versions == self.no_versions and
                obj.no_process_includes == self.no_process_includes and
                obj.silence == self.silence and
                obj.namespace_defs == self.namespace_defs and
                obj.external_encoding == self.external_encoding and
                obj.member_specs == self.member_specs and
                obj.export_spec == self.export_spec and
                obj.one_file_per_xsd == self.one_file_per_xsd and
                obj.output_directory == self.output_directory and
                obj.module_suffix == self.module_suffix and
                obj.preserve_cdata_tags == self.preserve_cdata_tags and
                obj.cleanup_name_list == self.cleanup_name_list):
            return True
        else:
            return False

    def __ne__(self, obj):
        """Implement the != operator.
        """
        return not self.__eq__(obj)


#
# Data representation classes.
#


class sessionType(GeneratedsSuper, SessionTypeMixin):
    member_data_items_ = [
        MemberSpec_('input_schema', 'xs:string', 0),
        MemberSpec_('output_superclass', 'xs:string', 0),
        MemberSpec_('output_subclass', 'xs:string', 0),
        MemberSpec_('force', 'xs:boolean', 0),
        MemberSpec_('prefix', 'xs:string', 0),
        MemberSpec_('namespace_prefix', 'xs:string', 0),
        MemberSpec_('empty_namespace_prefix', 'xs:boolean', 0),
        MemberSpec_('behavior_filename', 'xs:string', 0),
        MemberSpec_('properties', 'xs:boolean', 0),
        MemberSpec_('subclass_suffix', 'xs:string', 0),
        MemberSpec_('root_element', 'xs:string', 0),
        MemberSpec_('superclass_module', 'xs:string', 0),
        MemberSpec_('auto_super', 'xs:boolean', 0),
        MemberSpec_('old_getters_setters', 'xs:boolean', 0),
        MemberSpec_('validator_bodies', 'xs:string', 0),
        MemberSpec_('user_methods', 'xs:string', 0),
        MemberSpec_('no_dates', 'xs:boolean', 0),
        MemberSpec_('no_versions', 'xs:boolean', 0),
        MemberSpec_('no_process_includes', 'xs:boolean', 0),
        MemberSpec_('silence', 'xs:boolean', 0),
        MemberSpec_('namespace_defs', 'xs:string', 0),
        MemberSpec_('external_encoding', 'xs:string', 0),
        MemberSpec_('get_encoded', 'xs:boolean', 0),
        MemberSpec_('member_specs', 'xs:string', 0),
        MemberSpec_('export_spec', 'xs:string', 0),
        MemberSpec_('one_file_per_xsd', 'xs:boolean', 0),
        MemberSpec_('output_directory', 'xs:string', 0),
        MemberSpec_('module_suffix', 'xs:string', 0),
        MemberSpec_('preserve_cdata_tags', 'xs:boolean', 0),
        MemberSpec_('cleanup_name_list', 'xs:string', 0),
    ]
    subclass = None
    superclass = None
    def __init__(self, input_schema=None, output_superclass=None, output_subclass=None, force=None, prefix=None, namespace_prefix=None, empty_namespace_prefix=None, behavior_filename=None, properties=None, subclass_suffix=None, root_element=None, superclass_module=None, auto_super=None, old_getters_setters=None, validator_bodies=None, user_methods=None, no_dates=None, no_versions=None, no_process_includes=None, silence=None, namespace_defs=None, external_encoding=None, get_encoded=None, member_specs=None, export_spec=None, one_file_per_xsd=None, output_directory=None, module_suffix=None, preserve_cdata_tags=None, cleanup_name_list=None):
        self.original_tagname_ = None
        self.input_schema = input_schema
        self.output_superclass = output_superclass
        self.output_subclass = output_subclass
        self.force = force
        self.prefix = prefix
        self.namespace_prefix = namespace_prefix
        self.empty_namespace_prefix = empty_namespace_prefix
        self.behavior_filename = behavior_filename
        self.properties = properties
        self.subclass_suffix = subclass_suffix
        self.root_element = root_element
        self.superclass_module = superclass_module
        self.auto_super = auto_super
        self.old_getters_setters = old_getters_setters
        self.validator_bodies = validator_bodies
        self.user_methods = user_methods
        self.no_dates = no_dates
        self.no_versions = no_versions
        self.no_process_includes = no_process_includes
        self.silence = silence
        self.namespace_defs = namespace_defs
        self.external_encoding = external_encoding
        self.get_encoded = get_encoded
        self.member_specs = member_specs
        self.export_spec = export_spec
        self.one_file_per_xsd = one_file_per_xsd
        self.output_directory = output_directory
        self.module_suffix = module_suffix
        self.preserve_cdata_tags = preserve_cdata_tags
        self.cleanup_name_list = cleanup_name_list
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, sessionType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if sessionType.subclass:
            return sessionType.subclass(*args_, **kwargs_)
        else:
            return sessionType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_input_schema(self): return self.input_schema
    def set_input_schema(self, input_schema): self.input_schema = input_schema
    def get_output_superclass(self): return self.output_superclass
    def set_output_superclass(self, output_superclass): self.output_superclass = output_superclass
    def get_output_subclass(self): return self.output_subclass
    def set_output_subclass(self, output_subclass): self.output_subclass = output_subclass
    def get_force(self): return self.force
    def set_force(self, force): self.force = force
    def get_prefix(self): return self.prefix
    def set_prefix(self, prefix): self.prefix = prefix
    def get_namespace_prefix(self): return self.namespace_prefix
    def set_namespace_prefix(self, namespace_prefix): self.namespace_prefix = namespace_prefix
    def get_empty_namespace_prefix(self): return self.empty_namespace_prefix
    def set_empty_namespace_prefix(self, empty_namespace_prefix): self.empty_namespace_prefix = empty_namespace_prefix
    def get_behavior_filename(self): return self.behavior_filename
    def set_behavior_filename(self, behavior_filename): self.behavior_filename = behavior_filename
    def get_properties(self): return self.properties
    def set_properties(self, properties): self.properties = properties
    def get_subclass_suffix(self): return self.subclass_suffix
    def set_subclass_suffix(self, subclass_suffix): self.subclass_suffix = subclass_suffix
    def get_root_element(self): return self.root_element
    def set_root_element(self, root_element): self.root_element = root_element
    def get_superclass_module(self): return self.superclass_module
    def set_superclass_module(self, superclass_module): self.superclass_module = superclass_module
    def get_auto_super(self): return self.auto_super
    def set_auto_super(self, auto_super): self.auto_super = auto_super
    def get_old_getters_setters(self): return self.old_getters_setters
    def set_old_getters_setters(self, old_getters_setters): self.old_getters_setters = old_getters_setters
    def get_validator_bodies(self): return self.validator_bodies
    def set_validator_bodies(self, validator_bodies): self.validator_bodies = validator_bodies
    def get_user_methods(self): return self.user_methods
    def set_user_methods(self, user_methods): self.user_methods = user_methods
    def get_no_dates(self): return self.no_dates
    def set_no_dates(self, no_dates): self.no_dates = no_dates
    def get_no_versions(self): return self.no_versions
    def set_no_versions(self, no_versions): self.no_versions = no_versions
    def get_no_process_includes(self): return self.no_process_includes
    def set_no_process_includes(self, no_process_includes): self.no_process_includes = no_process_includes
    def get_silence(self): return self.silence
    def set_silence(self, silence): self.silence = silence
    def get_namespace_defs(self): return self.namespace_defs
    def set_namespace_defs(self, namespace_defs): self.namespace_defs = namespace_defs
    def get_external_encoding(self): return self.external_encoding
    def set_external_encoding(self, external_encoding): self.external_encoding = external_encoding
    def get_get_encoded(self): return self.get_encoded
    def set_get_encoded(self, get_encoded): self.get_encoded = get_encoded
    def get_member_specs(self): return self.member_specs
    def set_member_specs(self, member_specs): self.member_specs = member_specs
    def get_export_spec(self): return self.export_spec
    def set_export_spec(self, export_spec): self.export_spec = export_spec
    def get_one_file_per_xsd(self): return self.one_file_per_xsd
    def set_one_file_per_xsd(self, one_file_per_xsd): self.one_file_per_xsd = one_file_per_xsd
    def get_output_directory(self): return self.output_directory
    def set_output_directory(self, output_directory): self.output_directory = output_directory
    def get_module_suffix(self): return self.module_suffix
    def set_module_suffix(self, module_suffix): self.module_suffix = module_suffix
    def get_preserve_cdata_tags(self): return self.preserve_cdata_tags
    def set_preserve_cdata_tags(self, preserve_cdata_tags): self.preserve_cdata_tags = preserve_cdata_tags
    def get_cleanup_name_list(self): return self.cleanup_name_list
    def set_cleanup_name_list(self, cleanup_name_list): self.cleanup_name_list = cleanup_name_list
    def hasContent_(self):
        if (
            self.input_schema is not None or
            self.output_superclass is not None or
            self.output_subclass is not None or
            self.force is not None or
            self.prefix is not None or
            self.namespace_prefix is not None or
            self.empty_namespace_prefix is not None or
            self.behavior_filename is not None or
            self.properties is not None or
            self.subclass_suffix is not None or
            self.root_element is not None or
            self.superclass_module is not None or
            self.auto_super is not None or
            self.old_getters_setters is not None or
            self.validator_bodies is not None or
            self.user_methods is not None or
            self.no_dates is not None or
            self.no_versions is not None or
            self.no_process_includes is not None or
            self.silence is not None or
            self.namespace_defs is not None or
            self.external_encoding is not None or
            self.get_encoded is not None or
            self.member_specs is not None or
            self.export_spec is not None or
            self.one_file_per_xsd is not None or
            self.output_directory is not None or
            self.module_suffix is not None or
            self.preserve_cdata_tags is not None or
            self.cleanup_name_list is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='sessionType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='sessionType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='sessionType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='sessionType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='sessionType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.input_schema is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sinput_schema>%s</%sinput_schema>%s' % (namespace_, self.gds_encode(self.gds_format_string(quote_xml(self.input_schema), input_name='input_schema')), namespace_, eol_))
        if self.output_superclass is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%soutput_superclass>%s</%soutput_superclass>%s' % (namespace_, self.gds_encode(self.gds_format_string(quote_xml(self.output_superclass), input_name='output_superclass')), namespace_, eol_))
        if self.output_subclass is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%soutput_subclass>%s</%soutput_subclass>%s' % (namespace_, self.gds_encode(self.gds_format_string(quote_xml(self.output_subclass), input_name='output_subclass')), namespace_, eol_))
        if self.force is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sforce>%s</%sforce>%s' % (namespace_, self.gds_format_boolean(self.force, input_name='force'), namespace_, eol_))
        if self.prefix is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sprefix>%s</%sprefix>%s' % (namespace_, self.gds_encode(self.gds_format_string(quote_xml(self.prefix), input_name='prefix')), namespace_, eol_))
        if self.namespace_prefix is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%snamespace_prefix>%s</%snamespace_prefix>%s' % (namespace_, self.gds_encode(self.gds_format_string(quote_xml(self.namespace_prefix), input_name='namespace_prefix')), namespace_, eol_))
        if self.empty_namespace_prefix is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sempty_namespace_prefix>%s</%sempty_namespace_prefix>%s' % (namespace_, self.gds_format_boolean(self.empty_namespace_prefix, input_name='empty_namespace_prefix'), namespace_, eol_))
        if self.behavior_filename is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sbehavior_filename>%s</%sbehavior_filename>%s' % (namespace_, self.gds_encode(self.gds_format_string(quote_xml(self.behavior_filename), input_name='behavior_filename')), namespace_, eol_))
        if self.properties is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sproperties>%s</%sproperties>%s' % (namespace_, self.gds_format_boolean(self.properties, input_name='properties'), namespace_, eol_))
        if self.subclass_suffix is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%ssubclass_suffix>%s</%ssubclass_suffix>%s' % (namespace_, self.gds_encode(self.gds_format_string(quote_xml(self.subclass_suffix), input_name='subclass_suffix')), namespace_, eol_))
        if self.root_element is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sroot_element>%s</%sroot_element>%s' % (namespace_, self.gds_encode(self.gds_format_string(quote_xml(self.root_element), input_name='root_element')), namespace_, eol_))
        if self.superclass_module is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%ssuperclass_module>%s</%ssuperclass_module>%s' % (namespace_, self.gds_encode(self.gds_format_string(quote_xml(self.superclass_module), input_name='superclass_module')), namespace_, eol_))
        if self.auto_super is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sauto_super>%s</%sauto_super>%s' % (namespace_, self.gds_format_boolean(self.auto_super, input_name='auto_super'), namespace_, eol_))
        if self.old_getters_setters is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sold_getters_setters>%s</%sold_getters_setters>%s' % (namespace_, self.gds_format_boolean(self.old_getters_setters, input_name='old_getters_setters'), namespace_, eol_))
        if self.validator_bodies is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%svalidator_bodies>%s</%svalidator_bodies>%s' % (namespace_, self.gds_encode(self.gds_format_string(quote_xml(self.validator_bodies), input_name='validator_bodies')), namespace_, eol_))
        if self.user_methods is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%suser_methods>%s</%suser_methods>%s' % (namespace_, self.gds_encode(self.gds_format_string(quote_xml(self.user_methods), input_name='user_methods')), namespace_, eol_))
        if self.no_dates is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sno_dates>%s</%sno_dates>%s' % (namespace_, self.gds_format_boolean(self.no_dates, input_name='no_dates'), namespace_, eol_))
        if self.no_versions is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sno_versions>%s</%sno_versions>%s' % (namespace_, self.gds_format_boolean(self.no_versions, input_name='no_versions'), namespace_, eol_))
        if self.no_process_includes is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sno_process_includes>%s</%sno_process_includes>%s' % (namespace_, self.gds_format_boolean(self.no_process_includes, input_name='no_process_includes'), namespace_, eol_))
        if self.silence is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%ssilence>%s</%ssilence>%s' % (namespace_, self.gds_format_boolean(self.silence, input_name='silence'), namespace_, eol_))
        if self.namespace_defs is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%snamespace_defs>%s</%snamespace_defs>%s' % (namespace_, self.gds_encode(self.gds_format_string(quote_xml(self.namespace_defs), input_name='namespace_defs')), namespace_, eol_))
        if self.external_encoding is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sexternal_encoding>%s</%sexternal_encoding>%s' % (namespace_, self.gds_encode(self.gds_format_string(quote_xml(self.external_encoding), input_name='external_encoding')), namespace_, eol_))
        if self.get_encoded is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sget_encoded>%s</%sget_encoded>%s' % (namespace_, self.gds_format_boolean(self.get_encoded, input_name='get_encoded'), namespace_, eol_))
        if self.member_specs is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%smember_specs>%s</%smember_specs>%s' % (namespace_, self.gds_encode(self.gds_format_string(quote_xml(self.member_specs), input_name='member_specs')), namespace_, eol_))
        if self.export_spec is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sexport_spec>%s</%sexport_spec>%s' % (namespace_, self.gds_encode(self.gds_format_string(quote_xml(self.export_spec), input_name='export_spec')), namespace_, eol_))
        if self.one_file_per_xsd is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sone_file_per_xsd>%s</%sone_file_per_xsd>%s' % (namespace_, self.gds_format_boolean(self.one_file_per_xsd, input_name='one_file_per_xsd'), namespace_, eol_))
        if self.output_directory is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%soutput_directory>%s</%soutput_directory>%s' % (namespace_, self.gds_encode(self.gds_format_string(quote_xml(self.output_directory), input_name='output_directory')), namespace_, eol_))
        if self.module_suffix is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%smodule_suffix>%s</%smodule_suffix>%s' % (namespace_, self.gds_encode(self.gds_format_string(quote_xml(self.module_suffix), input_name='module_suffix')), namespace_, eol_))
        if self.preserve_cdata_tags is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spreserve_cdata_tags>%s</%spreserve_cdata_tags>%s' % (namespace_, self.gds_format_boolean(self.preserve_cdata_tags, input_name='preserve_cdata_tags'), namespace_, eol_))
        if self.cleanup_name_list is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scleanup_name_list>%s</%scleanup_name_list>%s' % (namespace_, self.gds_encode(self.gds_format_string(quote_xml(self.cleanup_name_list), input_name='cleanup_name_list')), namespace_, eol_))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'input_schema':
            input_schema_ = child_.text
            input_schema_ = self.gds_validate_string(input_schema_, node, 'input_schema')
            self.input_schema = input_schema_
        elif nodeName_ == 'output_superclass':
            output_superclass_ = child_.text
            output_superclass_ = self.gds_validate_string(output_superclass_, node, 'output_superclass')
            self.output_superclass = output_superclass_
        elif nodeName_ == 'output_subclass':
            output_subclass_ = child_.text
            output_subclass_ = self.gds_validate_string(output_subclass_, node, 'output_subclass')
            self.output_subclass = output_subclass_
        elif nodeName_ == 'force':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'force')
            self.force = ival_
        elif nodeName_ == 'prefix':
            prefix_ = child_.text
            prefix_ = self.gds_validate_string(prefix_, node, 'prefix')
            self.prefix = prefix_
        elif nodeName_ == 'namespace_prefix':
            namespace_prefix_ = child_.text
            namespace_prefix_ = self.gds_validate_string(namespace_prefix_, node, 'namespace_prefix')
            self.namespace_prefix = namespace_prefix_
        elif nodeName_ == 'empty_namespace_prefix':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'empty_namespace_prefix')
            self.empty_namespace_prefix = ival_
        elif nodeName_ == 'behavior_filename':
            behavior_filename_ = child_.text
            behavior_filename_ = self.gds_validate_string(behavior_filename_, node, 'behavior_filename')
            self.behavior_filename = behavior_filename_
        elif nodeName_ == 'properties':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'properties')
            self.properties = ival_
        elif nodeName_ == 'subclass_suffix':
            subclass_suffix_ = child_.text
            subclass_suffix_ = self.gds_validate_string(subclass_suffix_, node, 'subclass_suffix')
            self.subclass_suffix = subclass_suffix_
        elif nodeName_ == 'root_element':
            root_element_ = child_.text
            root_element_ = self.gds_validate_string(root_element_, node, 'root_element')
            self.root_element = root_element_
        elif nodeName_ == 'superclass_module':
            superclass_module_ = child_.text
            superclass_module_ = self.gds_validate_string(superclass_module_, node, 'superclass_module')
            self.superclass_module = superclass_module_
        elif nodeName_ == 'auto_super':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'auto_super')
            self.auto_super = ival_
        elif nodeName_ == 'old_getters_setters':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'old_getters_setters')
            self.old_getters_setters = ival_
        elif nodeName_ == 'validator_bodies':
            validator_bodies_ = child_.text
            validator_bodies_ = self.gds_validate_string(validator_bodies_, node, 'validator_bodies')
            self.validator_bodies = validator_bodies_
        elif nodeName_ == 'user_methods':
            user_methods_ = child_.text
            user_methods_ = self.gds_validate_string(user_methods_, node, 'user_methods')
            self.user_methods = user_methods_
        elif nodeName_ == 'no_dates':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'no_dates')
            self.no_dates = ival_
        elif nodeName_ == 'no_versions':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'no_versions')
            self.no_versions = ival_
        elif nodeName_ == 'no_process_includes':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'no_process_includes')
            self.no_process_includes = ival_
        elif nodeName_ == 'silence':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'silence')
            self.silence = ival_
        elif nodeName_ == 'namespace_defs':
            namespace_defs_ = child_.text
            namespace_defs_ = self.gds_validate_string(namespace_defs_, node, 'namespace_defs')
            self.namespace_defs = namespace_defs_
        elif nodeName_ == 'external_encoding':
            external_encoding_ = child_.text
            external_encoding_ = self.gds_validate_string(external_encoding_, node, 'external_encoding')
            self.external_encoding = external_encoding_
        elif nodeName_ == 'get_encoded':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'get_encoded')
            self.get_encoded = ival_
        elif nodeName_ == 'member_specs':
            member_specs_ = child_.text
            member_specs_ = self.gds_validate_string(member_specs_, node, 'member_specs')
            self.member_specs = member_specs_
        elif nodeName_ == 'export_spec':
            export_spec_ = child_.text
            export_spec_ = self.gds_validate_string(export_spec_, node, 'export_spec')
            self.export_spec = export_spec_
        elif nodeName_ == 'one_file_per_xsd':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'one_file_per_xsd')
            self.one_file_per_xsd = ival_
        elif nodeName_ == 'output_directory':
            output_directory_ = child_.text
            output_directory_ = self.gds_validate_string(output_directory_, node, 'output_directory')
            self.output_directory = output_directory_
        elif nodeName_ == 'module_suffix':
            module_suffix_ = child_.text
            module_suffix_ = self.gds_validate_string(module_suffix_, node, 'module_suffix')
            self.module_suffix = module_suffix_
        elif nodeName_ == 'preserve_cdata_tags':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'preserve_cdata_tags')
            self.preserve_cdata_tags = ival_
        elif nodeName_ == 'cleanup_name_list':
            cleanup_name_list_ = child_.text
            cleanup_name_list_ = self.gds_validate_string(cleanup_name_list_, node, 'cleanup_name_list')
            self.cleanup_name_list = cleanup_name_list_
# end class sessionType


GDSClassesMapping = {
    'session': sessionType,
}


USAGE_TEXT = """
Usage: python <Parser>.py [ -s ] <in_xml_file>
"""


def usage():
    print(USAGE_TEXT)
    sys.exit(1)


def get_root_tag(node):
    tag = Tag_pattern_.match(node.tag).groups()[-1]
    rootClass = GDSClassesMapping.get(tag)
    if rootClass is None:
        rootClass = globals().get(tag)
    return tag, rootClass


def parse(inFileName, silence=False):
    parser = None
    doc = parsexml_(inFileName, parser)
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'sessionType'
        rootClass = sessionType
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    if not silence:
        sys.stdout.write('<?xml version="1.0" ?>\n')
        rootObj.export(
            sys.stdout, 0, name_=rootTag,
            namespacedef_='',
            pretty_print=True)
    return rootObj


def parseEtree(inFileName, silence=False):
    parser = None
    doc = parsexml_(inFileName, parser)
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'sessionType'
        rootClass = sessionType
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    mapping = {}
    rootElement = rootObj.to_etree(None, name_=rootTag, mapping_=mapping)
    reverse_mapping = rootObj.gds_reverse_node_mapping(mapping)
    if not silence:
        content = etree_.tostring(
            rootElement, pretty_print=True,
            xml_declaration=True, encoding="utf-8")
        sys.stdout.write(content)
        sys.stdout.write('\n')
    return rootObj, rootElement, mapping, reverse_mapping


def parseString(inString, silence=False):
    from StringIO import StringIO
    parser = None
    doc = parsexml_(StringIO(inString), parser)
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'sessionType'
        rootClass = sessionType
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    if not silence:
        sys.stdout.write('<?xml version="1.0" ?>\n')
        rootObj.export(
            sys.stdout, 0, name_=rootTag,
            namespacedef_='')
    return rootObj


def parseLiteral(inFileName, silence=False):
    parser = None
    doc = parsexml_(inFileName, parser)
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'sessionType'
        rootClass = sessionType
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    if not silence:
        sys.stdout.write('#from generateds_gui_session import *\n\n')
        sys.stdout.write('import generateds_gui_session as model_\n\n')
        sys.stdout.write('rootObj = model_.rootClass(\n')
        rootObj.exportLiteral(sys.stdout, 0, name_=rootTag)
        sys.stdout.write(')\n')
    return rootObj


def main():
    args = sys.argv[1:]
    if len(args) == 1:
        parse(args[0])
    else:
        usage()


if __name__ == '__main__':
    #import pdb; pdb.set_trace()
    main()


__all__ = [
    "sessionType"
]
