.TH FBSHARP 1 25-Jun-90
.CM 3
.SH NAME
fbsharp \- edge enhance a grayscale or color image
.SH SYNOPSIS
.nf
fbsharp [ -<type> ] beta < image > image
.fi
.SH DESCRIPTION
.PP
Uses a digital Laplacian filter to enhance the edges.  Typical values
of beta run from 1 to 20.  The default is 2.  This command works for
color images, but values of sharpening higher than 3 or 4 tend to create
lots of noisy artifiacts in the image.
.sp
The
.I fbhalf
command also calls the sharpening code implicitly if the
.I -s
optional is passed to
.I fbhalf.
.SH OPTIONS
.TP
.BR <beta>
specifies the amount of sharpening.  Typical values run from 1 to 10,
higher values can cause snow.
.TP
.BR -B
.I face
format, as used by Bennet Yee's
.I face
program at CMU. 
.TP
.BR -F
.I FBM,
format (by default, the default).  You are guaranteed not
to lose information by specifying FBM as the default.
.TP
.BR -G
.I GIF,
Compuserve GIF format.
.TP
.BR -I
.I IFF
format, interleaved bitmaps (ILBM), used by Amigas.
.TP
.BR -P
.I PBM,
Jef Poskanzer's bitmap format.
.TP
.BR -S
.I sun,
Sun rasterfiles (not run length encoded).
.SH EXAMPLE
.PP
Since the -s option of fbahlf(1) exists, you will probably only run
fbsharp on color images, which tolerate less sharpening.  Here we
sharpen an FBM format color image with beta=3 and quantize it for
display on a Sun:
.sp
    % fbsharp 3.0 < foo.fbm | fbquant -S > foo.clr
.SH SEE ALSO
fbm(1) for general discussion, pbm(1) for PBM routines.
.SH BUGS
None known.
.SH HISTORY
Copyright (C) 1989,1990 by Michael Mauldin.  Permission is granted
to use this file in whole or in part for any purpose, educational,
recreational or commercial, provided that this copyright notice
is retained unchanged.  This software is available to all free of
charge by anonymous FTP and in the UUNET archives.
.TP
25-Jun-90  Michael Mauldin at Carnegie Mellon University
Release 1.0 mlm@cs.cmu.edu
.TP
07-Mar-89  Michael L. Mauldin at Carnegie Mellon University
Beta release (version 0.9) mlm@cs.cmu.edu
