/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.filter;

import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.filter.SamRecordFilter;

public class MappingQualityFilter
implements SamRecordFilter {
    private int minimumMappingQuality = Integer.MIN_VALUE;

    public MappingQualityFilter(int minimumMappingQuality) {
        this.minimumMappingQuality = minimumMappingQuality;
    }

    @Override
    public boolean filterOut(SAMRecord record) {
        return record.getMappingQuality() < this.minimumMappingQuality;
    }

    @Override
    public boolean filterOut(SAMRecord first, SAMRecord second) {
        return this.filterOut(first) || this.filterOut(second);
    }
}

