require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_M68K_MMU_40_H_)) {
    eval 'sub _M68K_MMU_40_H_ () {1;}' unless defined(&_M68K_MMU_40_H_);
    eval 'sub LA40_L1_NBITS () {7;}' unless defined(&LA40_L1_NBITS);
    eval 'sub LA40_L1_SHIFT () {25;}' unless defined(&LA40_L1_SHIFT);
    eval 'sub LA40_L2_NBITS () {7;}' unless defined(&LA40_L2_NBITS);
    eval 'sub LA40_L2_SHIFT () {18;}' unless defined(&LA40_L2_SHIFT);
    eval 'sub LA40_L3_NBITS () {(32 -  &LA40_L1_NBITS -  &LA40_L2_NBITS -  &PGSHIFT);}' unless defined(&LA40_L3_NBITS);
    eval 'sub LA40_L3_SHIFT () { &PGSHIFT;}' unless defined(&LA40_L3_SHIFT);
    eval 'sub LA40_L1_COUNT () { &__BIT( &LA40_L1_NBITS);}' unless defined(&LA40_L1_COUNT);
    eval 'sub LA40_L2_COUNT () { &__BIT( &LA40_L2_NBITS);}' unless defined(&LA40_L2_COUNT);
    eval 'sub LA40_L3_COUNT () { &__BIT( &LA40_L3_NBITS);}' unless defined(&LA40_L3_COUNT);
    eval 'sub LA40_L1_MASK () {( &__BITS(0,( &LA40_L1_NBITS - 1)) <<  &LA40_L1_SHIFT);}' unless defined(&LA40_L1_MASK);
    eval 'sub LA40_L2_MASK () {( &__BITS(0,( &LA40_L2_NBITS - 1)) <<  &LA40_L2_SHIFT);}' unless defined(&LA40_L2_MASK);
    eval 'sub LA40_L3_MASK () {( &__BITS(0,( &LA40_L3_NBITS - 1)) <<  &LA40_L3_SHIFT);}' unless defined(&LA40_L3_MASK);
    eval 'sub TBL40_L1_SIZE () {( &LA40_L1_COUNT * $sizeof{ &uint32_t});}' unless defined(&TBL40_L1_SIZE);
    eval 'sub TBL40_L2_SIZE () {( &LA40_L2_COUNT * $sizeof{ &uint32_t});}' unless defined(&TBL40_L2_SIZE);
    eval 'sub TBL40_L3_SIZE () {( &LA40_L3_COUNT * $sizeof{ &uint32_t});}' unless defined(&TBL40_L3_SIZE);
    eval 'sub LA40_RI {
        my($va) = @_;
	    eval q( &__SHIFTOUT(($va),  &LA40_L1_MASK));
    }' unless defined(&LA40_RI);
    eval 'sub LA40_PI {
        my($va) = @_;
	    eval q( &__SHIFTOUT(($va),  &LA40_L2_MASK));
    }' unless defined(&LA40_PI);
    eval 'sub LA40_PGI {
        my($va) = @_;
	    eval q( &__SHIFTOUT(($va),  &LA40_L3_MASK));
    }' unless defined(&LA40_PGI);
    eval 'sub LA40_TRUNC_L1 {
        my($va) = @_;
	    eval q(((( &vaddr_t)($va)) &  &LA40_L1_MASK));
    }' unless defined(&LA40_TRUNC_L1);
    eval 'sub LA40_TRUNC_L2 {
        my($va) = @_;
	    eval q(((( &vaddr_t)($va)) & ( &LA40_L1_MASK |  &LA40_L2_MASK)));
    }' unless defined(&LA40_TRUNC_L2);
    eval 'sub UTE40_PTA () { &__BITS(9,31);}' unless defined(&UTE40_PTA);
    eval 'sub UTE40_PGTA () { &__BITS(8- (13-  &PGSHIFT),31);}' unless defined(&UTE40_PGTA);
    eval 'sub UTE40_U () { &__BIT(3);}' unless defined(&UTE40_U);
    eval 'sub UTE40_W () { &__BIT(2);}' unless defined(&UTE40_W);
    eval 'sub UTE40_UDT () { &__BITS(0,1);}' unless defined(&UTE40_UDT);
    eval 'sub UTE40_INVALID () { &__SHIFTIN(0,  &UTE_UDT);}' unless defined(&UTE40_INVALID);
    eval 'sub UTE40_RESIDENT () { &__SHIFTIN(2,  &UTE_UDT);}' unless defined(&UTE40_RESIDENT);
    eval 'sub PTE40_PGA () { &__BITS( &PGSHIFT,31);}' unless defined(&PTE40_PGA);
    eval 'sub PTE40_UR_x () { &__BIT(12);}' unless defined(&PTE40_UR_x);
    eval 'sub PTE40_UR () { &__BIT(11);}' unless defined(&PTE40_UR);
    eval 'sub PTE40_G () { &__BIT(10);}' unless defined(&PTE40_G);
    eval 'sub PTE40_U1 () { &__BIT(9);}' unless defined(&PTE40_U1);
    eval 'sub PTE40_U0 () { &__BIT(8);}' unless defined(&PTE40_U0);
    eval 'sub PTE40_S () { &__BIT(7);}' unless defined(&PTE40_S);
    eval 'sub PTE40_CM () { &__BITS(5,6);}' unless defined(&PTE40_CM);
    eval 'sub PTE40_M () { &__BIT(4);}' unless defined(&PTE40_M);
    eval 'sub PTE40_U () { &__BIT(3);}' unless defined(&PTE40_U);
    eval 'sub PTE40_W () { &__BIT(2);}' unless defined(&PTE40_W);
    eval 'sub PTE40_PDT () { &__BITS(0,1);}' unless defined(&PTE40_PDT);
    eval 'sub PTE40_CM_WT () { &__SHIFTIN(0,  &PTE40_CM);}' unless defined(&PTE40_CM_WT);
    eval 'sub PTE40_CM_CB () { &__SHIFTIN(1,  &PTE40_CM);}' unless defined(&PTE40_CM_CB);
    eval 'sub PTE40_CM_NC_SER () { &__SHIFTIN(2,  &PTE40_CM);}' unless defined(&PTE40_CM_NC_SER);
    eval 'sub PTE40_CM_NC () { &__SHIFTIN(3,  &PTE40_CM);}' unless defined(&PTE40_CM_NC);
    eval 'sub PTE40_INVALID () { &__SHIFTIN(0,  &PTE40_PDT);}' unless defined(&PTE40_INVALID);
    eval 'sub PTE40_RESIDENT () { &__SHIFTIN(1,  &PTE40_PDT);}' unless defined(&PTE40_RESIDENT);
    eval 'sub PTE40_INDIRECT () { &__SHIFTIN(2,  &PTE40_PDT);}' unless defined(&PTE40_INDIRECT);
    eval 'sub TCR40_E () { &__BIT(15);}' unless defined(&TCR40_E);
    eval 'sub TCR40_P () { &__BIT(14);}' unless defined(&TCR40_P);
    eval 'sub TTR40_LAB () { &__BITS(24,31);}' unless defined(&TTR40_LAB);
    eval 'sub TTR40_LAM () { &__BITS(16,23);}' unless defined(&TTR40_LAM);
    eval 'sub TTR40_E () { &__BIT(15);}' unless defined(&TTR40_E);
    eval 'sub TTR40_SFIELD () { &__BITS(13,14);}' unless defined(&TTR40_SFIELD);
    eval 'sub TTR40_U1 () { &PTE40_U1;}' unless defined(&TTR40_U1);
    eval 'sub TTR40_U0 () { &PTE40_U0;}' unless defined(&TTR40_U0);
    eval 'sub TTR40_CM () { &PTE40_CM;}' unless defined(&TTR40_CM);
    eval 'sub TTR40_W () { &PTE40_W;}' unless defined(&TTR40_W);
    eval 'sub TTR40_USER () { &__SHIFTIN(0,  &TTR40_SFIELD);}' unless defined(&TTR40_USER);
    eval 'sub TTR40_SUPER () { &__SHIFTIN(1,  &TTR40_SFIELD);}' unless defined(&TTR40_SUPER);
    eval 'sub TTR40_BOTH () { &__SHIFTIN(2,  &TTR40_SFIELD);}' unless defined(&TTR40_BOTH);
    eval 'sub MMUSR40_PA () { &PTE40_PGA;}' unless defined(&MMUSR40_PA);
    eval 'sub MMUSR40_B () { &__BIT(11);}' unless defined(&MMUSR40_B);
    eval 'sub MMUSR40_G () { &PTE40_G;}' unless defined(&MMUSR40_G);
    eval 'sub MMUSR40_U1 () { &PTE40_U1;}' unless defined(&MMUSR40_U1);
    eval 'sub MMUSR40_U0 () { &PTE40_U0;}' unless defined(&MMUSR40_U0);
    eval 'sub MMUSR40_S () { &PTE40_S;}' unless defined(&MMUSR40_S);
    eval 'sub MMUSR40_CM () { &PTE40_CM;}' unless defined(&MMUSR40_CM);
    eval 'sub MMUSR40_M () { &PTE40_M;}' unless defined(&MMUSR40_M);
    eval 'sub MMUSR40_W () { &PTE40_W;}' unless defined(&MMUSR40_W);
    eval 'sub MMUSR40_T () { &__BIT(1);}' unless defined(&MMUSR40_T);
    eval 'sub MMUSR40_R () { &PTE40_RESIDENT;}' unless defined(&MMUSR40_R);
    if(defined(&_KERNEL)) {
	eval 'sub MMU_TTREG_ITT0 () {0;}' unless defined(&MMU_TTREG_ITT0);
	eval 'sub MMU_TTREG_ITT1 () {1;}' unless defined(&MMU_TTREG_ITT1);
	eval 'sub MMU_TTREG_DTT0 () {2;}' unless defined(&MMU_TTREG_DTT0);
	eval 'sub MMU_TTREG_DTT1 () {3;}' unless defined(&MMU_TTREG_DTT1);
	eval 'sub MMU_NTTREGS40 () {1;}' unless defined(&MMU_NTTREGS40);
    }
}
1;
