/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.security.auth.login;

import gnu.javax.security.auth.login.ConfigFileParser;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.Security;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.security.auth.AuthPermission;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;

public final class GnuConfiguration
extends Configuration {
    private static final boolean DEBUG = true;
    private Map loginModulesMap = new HashMap();
    private ConfigFileParser cp = new ConfigFileParser();

    private static final void debug(String string) {
        System.err.println(string);
    }

    public final AppConfigurationEntry[] getAppConfigurationEntry(String string) {
        if (string == null) {
            return null;
        }
        if ((string = string.trim()).length() == 0) {
            return null;
        }
        List list2 = (List)this.loginModulesMap.get(string);
        if (list2 == null || list2.size() == 0) {
            return null;
        }
        GnuConfiguration.debug("DEBUG: " + string + " -> " + list2.size() + " entry(ies)");
        return (AppConfigurationEntry[])list2.toArray(new AppConfigurationEntry[0]);
    }

    public final void refresh() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new AuthPermission("refreshLoginConfiguration"));
        }
        this.loginModulesMap.clear();
        this.init();
    }

    private final void init() {
        if (this.processSecurityProperties()) {
            GnuConfiguration.debug(" INFO: Using login configuration defined by Security property(ies)");
        } else if (this.processSystemProperty()) {
            GnuConfiguration.debug(" INFO: Using login configuration defined by System property");
        } else if (this.processUserHome()) {
            GnuConfiguration.debug(" INFO: Using login configuration defined in ${user.home}");
        } else {
            GnuConfiguration.debug(" WARN: No login configuration file found");
        }
    }

    private final boolean processSecurityProperties() {
        boolean bl = false;
        int n = 0;
        while (true) {
            try {
                String string = Security.getProperty("java.security.auth.login.config.url." + ++n);
                if (string == null) break;
                if ((string = string.trim()).length() == 0) continue;
                GnuConfiguration.debug("DEBUG: java.security.auth.login.config.url." + n + " = " + string);
                this.parseConfig(this.getInputStreamFromURL(string));
                bl = true;
            }
            catch (Throwable throwable) {
                GnuConfiguration.debug(" WARN: Exception while handling Security property at #" + n + ". Continue: " + throwable);
            }
        }
        return bl;
    }

    private final InputStream getInputStreamFromURL(String string) throws IOException {
        InputStream inputStream = null;
        try {
            URL uRL = new URL(string);
            inputStream = uRL.openStream();
        }
        catch (MalformedURLException malformedURLException) {
            GnuConfiguration.debug(" WARN: Failed opening as URL: " + string + ". Will try as File");
            inputStream = new FileInputStream(string);
        }
        return inputStream;
    }

    private final boolean processSystemProperty() {
        boolean bl = false;
        try {
            String string = System.getProperty("java.security.auth.login.config");
            if (string != null && (string = string.trim()).length() != 0) {
                GnuConfiguration.debug("DEBUG: java.security.auth.login.config = " + string);
                this.parseConfig(this.getInputStreamFromURL(string));
                bl = true;
            }
        }
        catch (Throwable throwable) {
            GnuConfiguration.debug(" WARN: Exception while handling System property. Continue: " + throwable);
        }
        return bl;
    }

    private final boolean processUserHome() {
        boolean bl = false;
        try {
            File file = this.getUserHome();
            if (file == null) {
                return bl;
            }
            File file2 = this.getConfigFromUserHome(file, ".java.login.config");
            if (file2 == null) {
                file2 = this.getConfigFromUserHome(file, "java.login.config");
            }
            if (file2 == null) {
                GnuConfiguration.debug(" WARN: Login Configuration file, in " + file + ", does not exist or is inaccessible");
                return bl;
            }
            FileInputStream fileInputStream = new FileInputStream(file2);
            this.parseConfig(fileInputStream);
            bl = true;
        }
        catch (Throwable throwable) {
            GnuConfiguration.debug(" WARN: Exception while handling ${user.home}: " + throwable);
        }
        return bl;
    }

    private final void parseConfig(InputStream inputStream) throws IOException {
        this.cp.parse(new InputStreamReader(inputStream, "UTF-8"));
        Map map = this.cp.getLoginModulesMap();
        this.mergeLoginModules(map);
    }

    private final void mergeLoginModules(Map map) {
        if (map == null || map.size() < 1) {
            return;
        }
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            List list2 = (List)map.get(string);
            if (list2 == null || list2.size() < 1) continue;
            List list3 = (List)this.loginModulesMap.get(string);
            if (list3 == null) {
                this.loginModulesMap.put(string, list2);
                continue;
            }
            list3.addAll(list2);
        }
    }

    private final File getUserHome() {
        String string = System.getProperty("user.home");
        if (string == null || string.trim().length() == 0) {
            GnuConfiguration.debug(" WARN: User home path is not set or is empty");
            return null;
        }
        File file = new File(string = string.trim());
        if (!file.exists()) {
            GnuConfiguration.debug(" WARN: User home '" + string + "' does not exist");
            return null;
        }
        if (!file.isDirectory()) {
            GnuConfiguration.debug(" WARN: User home '" + string + "' is not a directory");
            return null;
        }
        if (!file.canRead()) {
            GnuConfiguration.debug(" WARN: User home '" + string + "' is not readable");
            return null;
        }
        return file;
    }

    private final File getConfigFromUserHome(File file, String string) {
        File file2 = new File(file, string);
        if (!file2.exists()) {
            GnuConfiguration.debug(" WARN: File '" + string + "' does not exist in user's home");
            return null;
        }
        if (!file2.isFile()) {
            GnuConfiguration.debug(" WARN: File '" + string + "' in user's home is not a file");
            return null;
        }
        if (!file2.canRead()) {
            GnuConfiguration.debug(" WARN: File '" + string + "' in user's home is not readable");
            return null;
        }
        return file2;
    }

    public GnuConfiguration() {
        this.init();
    }
}

