/*
 * Decompiled with CFR 0.152.
 */
package net.claribole.zvtm.engine;

import com.xerox.VTM.engine.Camera;
import com.xerox.VTM.engine.View;
import com.xerox.VTM.glyphs.Glyph;
import com.xerox.VTM.glyphs.Translucent;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import net.claribole.zvtm.engine.CameraPortal;
import net.claribole.zvtm.engine.ObservedRegionListener;

public class OverviewPortal
extends CameraPortal {
    Camera observedRegionCamera;
    View observedRegionView;
    long[] observedRegion;
    float orcoef;
    Color observedRegionColor = Color.GREEN;
    AlphaComposite acST;
    float alpha = 0.5f;
    Timer borderTimer;
    ObservedRegionListener observedRegionListener;

    public OverviewPortal(int x, int y, int w, int h, Camera pc, Camera orc) {
        super(x, y, w, h, pc);
        this.observedRegionCamera = orc;
        this.observedRegionView = orc.getOwningView();
        this.observedRegion = new long[4];
        this.borderTimer = new Timer();
        this.borderTimer.scheduleAtFixedRate((TimerTask)new BorderTimer(this), 40L, 40L);
    }

    public boolean coordInsideObservedRegion(int cx, int cy) {
        return cx >= this.x + this.w / 2 + Math.round((float)(this.observedRegion[0] - this.camera.posx) * this.orcoef) && cy >= this.y + this.h / 2 + Math.round((float)(this.camera.posy - this.observedRegion[1]) * this.orcoef) && cx <= this.x + this.w / 2 + Math.round((float)(this.observedRegion[2] - this.camera.posx) * this.orcoef) && cy <= this.y + this.h / 2 + Math.round((float)(this.camera.posy - this.observedRegion[3]) * this.orcoef);
    }

    public void setObservedRegionColor(Color c) {
        this.observedRegionColor = c;
    }

    public Color getObservedRegionColor() {
        return this.observedRegionColor;
    }

    public void setObservedRegionTranslucency(float a) {
        this.acST = a == 1.0f ? null : AlphaComposite.getInstance(3, a);
    }

    public AlphaComposite getObservedRegionTranslucency() {
        return this.acST;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics2D g2d, int viewWidth, int viewHeight) {
        if (!this.visible) {
            return;
        }
        g2d.setClip(this.x, this.y, this.w, this.h);
        if (this.bkgColor != null) {
            g2d.setColor(this.bkgColor);
            g2d.fillRect(this.x, this.y, this.w, this.h);
        }
        this.standardStroke = g2d.getStroke();
        this.standardTransform = g2d.getTransform();
        Vector vector = this.drawnGlyphs = this.cameraSpace.getDrawnGlyphs(this.camIndex);
        synchronized (vector) {
            this.drawnGlyphs.removeAllElements();
            this.uncoef = (this.camera.focal + this.camera.altitude) / this.camera.focal;
            this.viewWC = (long)((float)this.camera.posx - (float)(this.w / 2) * this.uncoef);
            this.viewNC = (long)((float)this.camera.posy + (float)(this.h / 2) * this.uncoef);
            this.viewEC = (long)((float)this.camera.posx + (float)(this.w / 2) * this.uncoef);
            this.viewSC = (long)((float)this.camera.posy - (float)(this.h / 2) * this.uncoef);
            this.gll = this.cameraSpace.getDrawingList();
            for (int i = 0; i < this.gll.length; ++i) {
                if (this.gll[i] == null) continue;
                Glyph glyph = this.gll[i];
                synchronized (glyph) {
                    if (this.gll[i].visibleInRegion(this.viewWC, this.viewNC, this.viewEC, this.viewSC, this.camIndex)) {
                        this.gll[i].project(this.camera, this.size);
                        if (this.gll[i].isVisible()) {
                            this.gll[i].draw(g2d, this.w, this.h, this.camIndex, this.standardStroke, this.standardTransform, this.x, this.y);
                        }
                    }
                    continue;
                }
            }
        }
        this.observedRegion = this.observedRegionView.getVisibleRegion(this.observedRegionCamera, this.observedRegion);
        g2d.setColor(this.observedRegionColor);
        this.orcoef = this.camera.focal / (this.camera.focal + this.camera.altitude);
        if (this.acST != null) {
            g2d.setComposite(this.acST);
            g2d.fillRect(this.x + this.w / 2 + Math.round((float)(this.observedRegion[0] - this.camera.posx) * this.orcoef), this.y + this.h / 2 - Math.round((float)(this.observedRegion[1] - this.camera.posy) * this.orcoef), Math.round((float)(this.observedRegion[2] - this.observedRegion[0]) * this.orcoef), Math.round((float)(this.observedRegion[1] - this.observedRegion[3]) * this.orcoef));
            g2d.setComposite(Translucent.acO);
        }
        g2d.drawRect(this.x + this.w / 2 + Math.round((float)(this.observedRegion[0] - this.camera.posx) * this.orcoef), this.y + this.h / 2 - Math.round((float)(this.observedRegion[1] - this.camera.posy) * this.orcoef), Math.round((float)(this.observedRegion[2] - this.observedRegion[0]) * this.orcoef), Math.round((float)(this.observedRegion[1] - this.observedRegion[3]) * this.orcoef));
        g2d.setClip(0, 0, viewWidth, viewHeight);
        if (this.borderColor != null) {
            g2d.setColor(this.borderColor);
            g2d.drawRect(this.x, this.y, this.w, this.h);
        }
    }

    public void dispose() {
        this.borderTimer.cancel();
    }

    public void setObservedRegionListener(ObservedRegionListener orl) {
        this.observedRegionListener = orl;
    }

    void observedRegionIntersects(long[] wnes) {
        if (this.observedRegionListener != null) {
            this.observedRegionListener.intersectsParentRegion(wnes);
        }
    }

    private class BorderTimer
    extends TimerTask {
        OverviewPortal portal;
        long[] portalRegion = new long[4];
        long[] intersection = new long[4];

        BorderTimer(OverviewPortal p) {
            this.portal = p;
        }

        public void run() {
            this.portal.getVisibleRegion(this.portalRegion);
            this.intersection[0] = this.portal.observedRegion[0] - this.portalRegion[0];
            this.intersection[1] = this.portal.observedRegion[1] - this.portalRegion[1];
            this.intersection[2] = this.portal.observedRegion[2] - this.portalRegion[2];
            this.intersection[3] = this.portal.observedRegion[3] - this.portalRegion[3];
            this.portal.observedRegionIntersects(this.intersection);
        }
    }
}

