#
# Gramps - a GTK+/GNOME based genealogy program
#
# Copyright (C) 2001-2007  Donald N. Allingham, Martin Hawlisch
# Copyright (C) 2009 Douglas S. Blank
# Copyright (C) 2012 Benny Malengier
# Copyright (C) 2013 Vassilii Khachaturov
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
#

#-------------------------------------------------------------------------
#
# Python modules
#
#-------------------------------------------------------------------------
#from gi.repository import Pango
#from gi.repository import GObject
#from gi.repository import Gdk
#from gi.repository import Gtk
#from gi.repository import PangoCairo
import cairo
#import math
#import colorsys
#import pickle

#-------------------------------------------------------------------------
#
# Functions
#
#-------------------------------------------------------------------------
def warpPath(ctx, function):
    """Transform a path given a 2D transformation function.

    ctx -- a cairo.Context, on which the path is set
    function -- a 2D transform (x,y) |-> (x_new,y_new)

    The transformed path replaces the original one on the context.

    Taken from /usr/share/doc/python-cairo/examples/warpedtext.py
    According to /usr/share/doc/python-cairo/copyright, licensed
    under MOZILLA PUBLIC LICENSE 1.1, see that file for more detail.
    """

    first = True

    for type, points in ctx.copy_path():
        if type == cairo.PATH_MOVE_TO:
            if first:
                ctx.new_path()
                first = False
            x, y = function(*points)
            ctx.move_to(x, y)

        elif type == cairo.PATH_LINE_TO:
            x, y = function(*points)
            ctx.line_to(x, y)

        elif type == cairo.PATH_CURVE_TO:
            x1, y1, x2, y2, x3, y3 = points
            x1, y1 = function(x1, y1)
            x2, y2 = function(x2, y2)
            x3, y3 = function(x3, y3)
            ctx.curve_to(x1, y1, x2, y2, x3, y3)

        elif type == cairo.PATH_CLOSE_PATH:
            ctx.close_path()
