/*
 * Decompiled with CFR 0.152.
 */
package javax.sound.sampled;

import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.Line;

public interface DataLine
extends Line {
    public int available();

    public void drain();

    public void flush();

    public int getBufferSize();

    public AudioFormat getFormat();

    public int getFramePosition();

    public float getLevel();

    public long getLongFramePosition();

    public long getMicrosecondPosition();

    public boolean isActive();

    public boolean isRunning();

    public void start();

    public void stop();

    public static class Info
    extends Line.Info {
        private int minBufferSize;
        private int maxBufferSize;
        private AudioFormat[] formats;

        public AudioFormat[] getFormats() {
            return this.formats;
        }

        public int getMaxBufferSize() {
            return this.maxBufferSize;
        }

        public int getMinBufferSize() {
            return this.minBufferSize;
        }

        public boolean isFormatSupported(AudioFormat audioFormat) {
            int n = 0;
            while (n < this.formats.length) {
                if (audioFormat.matches(this.formats[n])) {
                    return true;
                }
                ++n;
            }
            return false;
        }

        public boolean matches(Line.Info info) {
            if (!super.matches(info) || !(info instanceof Info)) {
                return false;
            }
            Info info2 = (Info)info;
            if (this.minBufferSize < info2.minBufferSize || this.maxBufferSize > info2.maxBufferSize) {
                return false;
            }
            int n = 0;
            while (n < this.formats.length) {
                boolean bl = false;
                int n2 = 0;
                while (n2 < info2.formats.length) {
                    if (this.formats[n].matches(info2.formats[n2])) {
                        bl = true;
                        break;
                    }
                    ++n2;
                }
                if (!bl) {
                    return false;
                }
                ++n;
            }
            return true;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("formats: [");
            int n = 0;
            while (n < this.formats.length) {
                if (n > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(this.formats[n].toString());
                ++n;
            }
            stringBuffer.append("]; minBufferSize: ");
            stringBuffer.append(this.minBufferSize);
            stringBuffer.append("; maxBufferSize: ");
            stringBuffer.append(this.maxBufferSize);
            return stringBuffer.toString();
        }

        public Info(Class clazz, AudioFormat audioFormat) {
            super(clazz);
            this.minBufferSize = -1;
            this.maxBufferSize = -1;
            this.formats = new AudioFormat[]{audioFormat};
        }

        public Info(Class clazz, AudioFormat[] audioFormatArray, int n, int n2) {
            super(clazz);
            this.minBufferSize = n;
            this.maxBufferSize = n2;
            this.formats = audioFormatArray;
        }

        public Info(Class clazz, AudioFormat audioFormat, int n) {
            super(clazz);
            this.minBufferSize = n;
            this.maxBufferSize = n;
            this.formats = new AudioFormat[]{audioFormat};
        }
    }
}

