/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import javax.swing.Action;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.DefaultCaret;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainDocument;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.TextAction;
import javax.swing.text.Utilities;
import javax.swing.text.ViewFactory;

public class DefaultEditorKit
extends EditorKit {
    private static final long serialVersionUID = 9017245433028523428L;
    public static final String backwardAction = "caret-backward";
    public static final String beepAction = "beep";
    public static final String beginAction = "caret-begin";
    public static final String beginLineAction = "caret-begin-line";
    public static final String beginParagraphAction = "caret-begin-paragraph";
    public static final String beginWordAction = "caret-begin-word";
    public static final String copyAction = "copy-to-clipboard";
    public static final String cutAction = "cut-to-clipboard";
    public static final String defaultKeyTypedAction = "default-typed";
    public static final String deleteNextCharAction = "delete-next";
    public static final String deletePrevCharAction = "delete-previous";
    public static final String downAction = "caret-down";
    public static final String endAction = "caret-end";
    public static final String endLineAction = "caret-end-line";
    public static final String EndOfLineStringProperty = "__EndOfLine__";
    public static final String endParagraphAction = "caret-end-paragraph";
    public static final String endWordAction = "caret-end-word";
    public static final String forwardAction = "caret-forward";
    public static final String insertBreakAction = "insert-break";
    public static final String insertContentAction = "insert-content";
    public static final String insertTabAction = "insert-tab";
    public static final String nextWordAction = "caret-next-word";
    public static final String pageDownAction = "page-down";
    public static final String pageUpAction = "page-up";
    public static final String pasteAction = "paste-from-clipboard";
    public static final String previousWordAction = "caret-previous-word";
    public static final String readOnlyAction = "set-read-only";
    public static final String selectAllAction = "select-all";
    public static final String selectionBackwardAction = "selection-backward";
    public static final String selectionBeginAction = "selection-begin";
    public static final String selectionBeginLineAction = "selection-begin-line";
    public static final String selectionBeginParagraphAction = "selection-begin-paragraph";
    public static final String selectionBeginWordAction = "selection-begin-word";
    public static final String selectionDownAction = "selection-down";
    public static final String selectionEndAction = "selection-end";
    public static final String selectionEndLineAction = "selection-end-line";
    public static final String selectionEndParagraphAction = "selection-end-paragraph";
    public static final String selectionEndWordAction = "selection-end-word";
    public static final String selectionForwardAction = "selection-forward";
    public static final String selectionNextWordAction = "selection-next-word";
    public static final String selectionPreviousWordAction = "selection-previous-word";
    public static final String selectionUpAction = "selection-up";
    public static final String selectLineAction = "select-line";
    public static final String selectParagraphAction = "select-paragraph";
    public static final String selectWordAction = "select-word";
    public static final String upAction = "caret-up";
    public static final String writableAction = "set-writable";
    private static Action[] defaultActions = new Action[]{new BeepAction(), new CopyAction(), new CutAction(), new DefaultKeyTypedAction(), new InsertBreakAction(), new InsertContentAction(), new InsertTabAction(), new PasteAction(), new DeleteNextCharAction(), new DeletePrevCharAction(), new BeginLineAction(), new SelectionBeginLineAction(), new EndLineAction(), new SelectionEndLineAction(), new BackwardAction(), new SelectionBackwardAction(), new ForwardAction(), new SelectionForwardAction(), new UpAction(), new SelectionUpAction(), new DownAction(), new SelectionDownAction(), new NextWordAction(), new SelectionNextWordAction(), new PreviousWordAction(), new SelectionPreviousWordAction(), new SelectionBeginAction(), new SelectionEndAction(), new SelectAllAction()};

    public Caret createCaret() {
        return new DefaultCaret();
    }

    public Document createDefaultDocument() {
        return new PlainDocument();
    }

    public Action[] getActions() {
        return defaultActions;
    }

    public String getContentType() {
        return "text/plain";
    }

    public ViewFactory getViewFactory() {
        return null;
    }

    public void read(InputStream inputStream, Document document, int n) throws BadLocationException, IOException {
        this.read(new InputStreamReader(inputStream), document, n);
    }

    public void read(Reader reader, Document document, int n) throws BadLocationException, IOException {
        String string;
        BufferedReader bufferedReader = new BufferedReader(reader);
        StringBuffer stringBuffer = new StringBuffer();
        while ((string = bufferedReader.readLine()) != null) {
            stringBuffer.append(string);
            stringBuffer.append("\n");
        }
        document.insertString(n, stringBuffer.substring(0, stringBuffer.length() - 1), SimpleAttributeSet.EMPTY);
    }

    public void write(OutputStream outputStream, Document document, int n, int n2) throws BadLocationException, IOException {
        this.write(new OutputStreamWriter(outputStream), document, n, n2);
    }

    public void write(Writer writer, Document document, int n, int n2) throws BadLocationException, IOException {
        if (n < 0 || n > document.getLength()) {
            throw new BadLocationException("Tried to write to invalid location", n);
        }
        if (n + n2 > document.getLength()) {
            n2 = document.getLength() - n;
        }
        writer.write(document.getText(n, n2));
    }

    public static class BeepAction
    extends TextAction {
        public void actionPerformed(ActionEvent actionEvent) {
            Toolkit.getDefaultToolkit().beep();
        }

        public BeepAction() {
            super(DefaultEditorKit.beepAction);
        }
    }

    public static class CopyAction
    extends TextAction {
        public void actionPerformed(ActionEvent actionEvent) {
            this.getTextComponent(actionEvent).copy();
        }

        public CopyAction() {
            super(DefaultEditorKit.copyAction);
        }
    }

    public static class CutAction
    extends TextAction {
        public void actionPerformed(ActionEvent actionEvent) {
            this.getTextComponent(actionEvent).cut();
        }

        public CutAction() {
            super(DefaultEditorKit.cutAction);
        }
    }

    public static class DefaultKeyTypedAction
    extends TextAction {
        public void actionPerformed(ActionEvent actionEvent) {
            char c = actionEvent.getActionCommand().charAt(0);
            if (Character.isISOControl(c)) {
                return;
            }
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (jTextComponent != null && jTextComponent.isEnabled() && jTextComponent.isEditable()) {
                jTextComponent.replaceSelection(actionEvent.getActionCommand());
            }
        }

        public DefaultKeyTypedAction() {
            super(DefaultEditorKit.defaultKeyTypedAction);
        }
    }

    public static class InsertBreakAction
    extends TextAction {
        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            jTextComponent.replaceSelection("\n");
        }

        public InsertBreakAction() {
            super(DefaultEditorKit.insertBreakAction);
        }
    }

    public static class InsertContentAction
    extends TextAction {
        public void actionPerformed(ActionEvent actionEvent) {
        }

        public InsertContentAction() {
            super(DefaultEditorKit.insertContentAction);
        }
    }

    public static class InsertTabAction
    extends TextAction {
        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            jTextComponent.replaceSelection("\t");
        }

        public InsertTabAction() {
            super(DefaultEditorKit.insertTabAction);
        }
    }

    public static class PasteAction
    extends TextAction {
        public void actionPerformed(ActionEvent actionEvent) {
            this.getTextComponent(actionEvent).paste();
        }

        public PasteAction() {
            super(DefaultEditorKit.pasteAction);
        }
    }

    static class DeleteNextCharAction
    extends TextAction {
        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (jTextComponent != null) {
                try {
                    int n = jTextComponent.getSelectionStart();
                    int n2 = jTextComponent.getSelectionEnd() - n;
                    if (n2 > 0) {
                        jTextComponent.getDocument().remove(n, n2);
                    } else if (n < jTextComponent.getDocument().getLength()) {
                        jTextComponent.getDocument().remove(n, 1);
                    }
                    Caret caret = jTextComponent.getCaret();
                    caret.setDot(n);
                    caret.setMagicCaretPosition(jTextComponent.modelToView(n).getLocation());
                }
                catch (BadLocationException badLocationException) {}
            }
        }

        DeleteNextCharAction() {
            super(DefaultEditorKit.deleteNextCharAction);
        }
    }

    static class DeletePrevCharAction
    extends TextAction {
        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (jTextComponent != null) {
                try {
                    int n = jTextComponent.getSelectionStart();
                    int n2 = jTextComponent.getSelectionEnd() - n;
                    if (n2 > 0) {
                        jTextComponent.getDocument().remove(n, n2);
                    } else if (n > 0) {
                        jTextComponent.getDocument().remove(--n, 1);
                        Caret caret = jTextComponent.getCaret();
                        caret.setDot(n);
                        caret.setMagicCaretPosition(jTextComponent.modelToView(n).getLocation());
                    }
                }
                catch (BadLocationException badLocationException) {}
            }
        }

        DeletePrevCharAction() {
            super(DefaultEditorKit.deletePrevCharAction);
        }
    }

    static class BeginLineAction
    extends TextAction {
        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            try {
                int n = Utilities.getRowStart(jTextComponent, jTextComponent.getCaretPosition());
                if (n > -1) {
                    Caret caret = jTextComponent.getCaret();
                    caret.setDot(n);
                    caret.setMagicCaretPosition(jTextComponent.modelToView(n).getLocation());
                }
            }
            catch (BadLocationException badLocationException) {}
        }

        BeginLineAction() {
            super(DefaultEditorKit.beginLineAction);
        }
    }

    static class SelectionBeginLineAction
    extends TextAction {
        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            try {
                Point point = jTextComponent.modelToView(jTextComponent.getCaret().getDot()).getLocation();
                int n = jTextComponent.getCaretPosition();
                int n2 = point.y;
                while (n2 == point.y && n > 0) {
                    n2 = jTextComponent.modelToView((int)(--n)).getLocation().y;
                }
                if (n != 0) {
                    ++n;
                }
                Caret caret = jTextComponent.getCaret();
                caret.moveDot(n);
                caret.setMagicCaretPosition(jTextComponent.modelToView(n).getLocation());
            }
            catch (BadLocationException badLocationException) {}
        }

        SelectionBeginLineAction() {
            super(DefaultEditorKit.selectionBeginLineAction);
        }
    }

    static class EndLineAction
    extends TextAction {
        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            try {
                int n = Utilities.getRowEnd(jTextComponent, jTextComponent.getCaretPosition());
                if (n > -1) {
                    Caret caret = jTextComponent.getCaret();
                    caret.setDot(n);
                    caret.setMagicCaretPosition(jTextComponent.modelToView(n).getLocation());
                }
            }
            catch (BadLocationException badLocationException) {}
        }

        EndLineAction() {
            super(DefaultEditorKit.endLineAction);
        }
    }

    static class SelectionEndLineAction
    extends TextAction {
        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            try {
                Point point = jTextComponent.modelToView(jTextComponent.getCaret().getDot()).getLocation();
                int n = jTextComponent.getCaretPosition();
                int n2 = point.y;
                int n3 = jTextComponent.getDocument().getLength();
                while (n2 == point.y && n < n3) {
                    n2 = jTextComponent.modelToView((int)(++n)).getLocation().y;
                }
                if (n != n3) {
                    --n;
                }
                Caret caret = jTextComponent.getCaret();
                caret.moveDot(n);
                caret.setMagicCaretPosition(jTextComponent.modelToView(n).getLocation());
            }
            catch (BadLocationException badLocationException) {}
        }

        SelectionEndLineAction() {
            super(DefaultEditorKit.selectionEndLineAction);
        }
    }

    static class BackwardAction
    extends TextAction {
        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (jTextComponent != null && (n = jTextComponent.getCaretPosition() - 1) >= 0) {
                Caret caret = jTextComponent.getCaret();
                caret.setDot(n);
                try {
                    caret.setMagicCaretPosition(jTextComponent.modelToView(n).getLocation());
                }
                catch (BadLocationException badLocationException) {}
            }
        }

        BackwardAction() {
            super(DefaultEditorKit.backwardAction);
        }
    }

    static class SelectionBackwardAction
    extends TextAction {
        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (jTextComponent != null && (n = jTextComponent.getCaretPosition() - 1) >= 0) {
                Caret caret = jTextComponent.getCaret();
                caret.moveDot(n);
                try {
                    caret.setMagicCaretPosition(jTextComponent.modelToView(n).getLocation());
                }
                catch (BadLocationException badLocationException) {}
            }
        }

        SelectionBackwardAction() {
            super(DefaultEditorKit.selectionBackwardAction);
        }
    }

    static class ForwardAction
    extends TextAction {
        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (jTextComponent != null && (n = jTextComponent.getCaretPosition() + 1) <= jTextComponent.getDocument().getLength()) {
                Caret caret = jTextComponent.getCaret();
                caret.setDot(n);
                try {
                    caret.setMagicCaretPosition(jTextComponent.modelToView(n).getLocation());
                }
                catch (BadLocationException badLocationException) {}
            }
        }

        ForwardAction() {
            super(DefaultEditorKit.forwardAction);
        }
    }

    static class SelectionForwardAction
    extends TextAction {
        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (jTextComponent != null && (n = jTextComponent.getCaretPosition() + 1) <= jTextComponent.getDocument().getLength()) {
                Caret caret = jTextComponent.getCaret();
                caret.moveDot(n);
                try {
                    caret.setMagicCaretPosition(jTextComponent.modelToView(n).getLocation());
                }
                catch (BadLocationException badLocationException) {}
            }
        }

        SelectionForwardAction() {
            super(DefaultEditorKit.selectionForwardAction);
        }
    }

    static class UpAction
    extends TextAction {
        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            try {
                if (jTextComponent != null) {
                    int n;
                    int n2;
                    Caret caret = jTextComponent.getCaret();
                    Point point = caret.getMagicCaretPosition();
                    int n3 = 0;
                    if (point != null) {
                        n3 = n2 = point.x;
                    }
                    if ((n = Utilities.getPositionAbove(jTextComponent, jTextComponent.getCaretPosition(), n2)) > -1) {
                        jTextComponent.setCaretPosition(n);
                    }
                }
            }
            catch (BadLocationException badLocationException) {}
        }

        UpAction() {
            super(DefaultEditorKit.upAction);
        }
    }

    static class SelectionUpAction
    extends TextAction {
        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            try {
                if (jTextComponent != null) {
                    int n;
                    int n2;
                    Caret caret = jTextComponent.getCaret();
                    Point point = caret.getMagicCaretPosition();
                    int n3 = 0;
                    if (point != null) {
                        n3 = n2 = point.x;
                    }
                    if ((n = Utilities.getPositionAbove(jTextComponent, jTextComponent.getCaretPosition(), n2)) > -1) {
                        jTextComponent.moveCaretPosition(n);
                    }
                }
            }
            catch (BadLocationException badLocationException) {}
        }

        SelectionUpAction() {
            super(DefaultEditorKit.selectionUpAction);
        }
    }

    static class DownAction
    extends TextAction {
        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            try {
                if (jTextComponent != null) {
                    int n;
                    int n2;
                    Caret caret = jTextComponent.getCaret();
                    Point point = caret.getMagicCaretPosition();
                    int n3 = 0;
                    if (point != null) {
                        n3 = n2 = point.x;
                    }
                    if ((n = Utilities.getPositionBelow(jTextComponent, jTextComponent.getCaretPosition(), n2)) > -1) {
                        jTextComponent.setCaretPosition(n);
                    }
                }
            }
            catch (BadLocationException badLocationException) {}
        }

        DownAction() {
            super(DefaultEditorKit.downAction);
        }
    }

    static class SelectionDownAction
    extends TextAction {
        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            try {
                if (jTextComponent != null) {
                    int n;
                    int n2;
                    Caret caret = jTextComponent.getCaret();
                    Point point = caret.getMagicCaretPosition();
                    int n3 = 0;
                    if (point != null) {
                        n3 = n2 = point.x;
                    }
                    if ((n = Utilities.getPositionBelow(jTextComponent, jTextComponent.getCaretPosition(), n2)) > -1) {
                        jTextComponent.moveCaretPosition(n);
                    }
                }
            }
            catch (BadLocationException badLocationException) {}
        }

        SelectionDownAction() {
            super(DefaultEditorKit.selectionDownAction);
        }
    }

    static class NextWordAction
    extends TextAction {
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                JTextComponent jTextComponent = this.getTextComponent(actionEvent);
                if (jTextComponent != null) {
                    int n = Utilities.getNextWord(jTextComponent, jTextComponent.getCaretPosition());
                    Caret caret = jTextComponent.getCaret();
                    caret.setDot(n);
                    caret.setMagicCaretPosition(jTextComponent.modelToView(n).getLocation());
                }
            }
            catch (BadLocationException badLocationException) {}
        }

        NextWordAction() {
            super(DefaultEditorKit.nextWordAction);
        }
    }

    static class SelectionNextWordAction
    extends TextAction {
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                JTextComponent jTextComponent = this.getTextComponent(actionEvent);
                if (jTextComponent != null) {
                    int n = Utilities.getNextWord(jTextComponent, jTextComponent.getCaretPosition());
                    Caret caret = jTextComponent.getCaret();
                    caret.moveDot(n);
                    caret.setMagicCaretPosition(jTextComponent.modelToView(n).getLocation());
                }
            }
            catch (BadLocationException badLocationException) {}
        }

        SelectionNextWordAction() {
            super(DefaultEditorKit.selectionNextWordAction);
        }
    }

    static class PreviousWordAction
    extends TextAction {
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                JTextComponent jTextComponent = this.getTextComponent(actionEvent);
                if (jTextComponent != null) {
                    int n = Utilities.getPreviousWord(jTextComponent, jTextComponent.getCaretPosition());
                    Caret caret = jTextComponent.getCaret();
                    caret.setDot(n);
                    caret.setMagicCaretPosition(jTextComponent.modelToView(n).getLocation());
                }
            }
            catch (BadLocationException badLocationException) {}
        }

        PreviousWordAction() {
            super(DefaultEditorKit.previousWordAction);
        }
    }

    static class SelectionPreviousWordAction
    extends TextAction {
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                JTextComponent jTextComponent = this.getTextComponent(actionEvent);
                if (jTextComponent != null) {
                    int n = Utilities.getPreviousWord(jTextComponent, jTextComponent.getCaretPosition());
                    Caret caret = jTextComponent.getCaret();
                    caret.moveDot(n);
                    caret.setMagicCaretPosition(jTextComponent.modelToView(n).getLocation());
                }
            }
            catch (BadLocationException badLocationException) {}
        }

        SelectionPreviousWordAction() {
            super(DefaultEditorKit.selectionPreviousWordAction);
        }
    }

    static class SelectionBeginAction
    extends TextAction {
        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            Caret caret = jTextComponent.getCaret();
            caret.moveDot(0);
            try {
                caret.setMagicCaretPosition(jTextComponent.modelToView(0).getLocation());
            }
            catch (BadLocationException badLocationException) {}
        }

        SelectionBeginAction() {
            super(DefaultEditorKit.selectionBeginAction);
        }
    }

    static class SelectionEndAction
    extends TextAction {
        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            int n = jTextComponent.getDocument().getLength();
            Caret caret = jTextComponent.getCaret();
            caret.moveDot(n);
            try {
                caret.setMagicCaretPosition(jTextComponent.modelToView(n).getLocation());
            }
            catch (BadLocationException badLocationException) {}
        }

        SelectionEndAction() {
            super(DefaultEditorKit.selectionEndAction);
        }
    }

    static class SelectAllAction
    extends TextAction {
        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            int n = jTextComponent.getDocument().getLength();
            Caret caret = jTextComponent.getCaret();
            caret.setDot(0);
            caret.moveDot(n);
            try {
                caret.setMagicCaretPosition(jTextComponent.modelToView(n).getLocation());
            }
            catch (BadLocationException badLocationException) {}
        }

        SelectAllAction() {
            super(DefaultEditorKit.selectAllAction);
        }
    }
}

