/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.Iterator;
import java.util.List;
import org.xbill.DNS.Message;
import org.xbill.DNS.Name;
import org.xbill.DNS.OPTRecord;
import org.xbill.DNS.Options;
import org.xbill.DNS.Rcode;
import org.xbill.DNS.Record;
import org.xbill.DNS.ResolveThread;
import org.xbill.DNS.Resolver;
import org.xbill.DNS.ResolverConfig;
import org.xbill.DNS.ResolverListener;
import org.xbill.DNS.TCPClient;
import org.xbill.DNS.TSIG;
import org.xbill.DNS.UDPClient;
import org.xbill.DNS.WireParseException;
import org.xbill.DNS.ZoneTransferException;
import org.xbill.DNS.ZoneTransferIn;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class SimpleResolver
implements Resolver {
    public static final int DEFAULT_PORT = 53;
    private static final short DEFAULT_UDPSIZE = 512;
    private static final short EDNS_UDPSIZE = 1280;
    private static String defaultResolver = "localhost";
    private static int uniqueID = 0;
    private InetAddress addr;
    private int port;
    private boolean useTCP;
    private boolean ignoreTruncation;
    private byte EDNSlevel;
    private TSIG tsig;
    private int timeoutValue;

    InetSocketAddress getAddress() {
        return new InetSocketAddress(this.addr, this.port);
    }

    public static void setDefaultResolver(String string) {
        defaultResolver = string;
    }

    public void setPort(int n) {
        this.port = n;
    }

    public void setTCP(boolean bl) {
        this.useTCP = bl;
    }

    public void setIgnoreTruncation(boolean bl) {
        this.ignoreTruncation = bl;
    }

    public void setEDNS(int n) {
        if (n != 0 && n != -1) {
            throw new UnsupportedOperationException("invalid EDNS level - must be 0 or -1");
        }
        this.EDNSlevel = (byte)n;
    }

    public void setTSIGKey(TSIG tSIG) {
        this.tsig = tSIG;
    }

    public void setTSIGKey(Name name, byte[] byArray) {
        this.tsig = new TSIG(name, byArray);
    }

    public void setTSIGKey(String string, String string2) {
        this.tsig = new TSIG(string, string2);
    }

    TSIG getTSIGKey() {
        return this.tsig;
    }

    public void setTimeout(int n) {
        this.timeoutValue = n * 1000;
    }

    int getTimeout() {
        return this.timeoutValue / 1000;
    }

    private final Message parseMessage(byte[] byArray) throws WireParseException {
        try {
            return new Message(byArray);
        }
        catch (IOException iOException) {
            WireParseException wireParseException;
            if (Options.check("verbose")) {
                iOException.printStackTrace();
            }
            if (!(iOException instanceof WireParseException)) {
                wireParseException = new WireParseException("Error parsing message");
            }
            throw (WireParseException)wireParseException;
        }
    }

    private final void verifyTSIG(Message message, Message message2, byte[] byArray, TSIG tSIG) {
        if (tSIG == null) {
            return;
        }
        int n = tSIG.verify(message2, byArray, message.getTSIG());
        message2.tsigState = n == 0 ? 1 : 4;
        if (Options.check("verbose")) {
            System.err.println("TSIG verify: " + Rcode.string(n));
        }
    }

    private final void applyEDNS(Message message) {
        if (this.EDNSlevel < 0 || message.getOPT() != null) {
            return;
        }
        OPTRecord oPTRecord = new OPTRecord(1280, 0, 0);
        message.addRecord(oPTRecord, 3);
    }

    private final int maxUDPSize(Message message) {
        OPTRecord oPTRecord = message.getOPT();
        if (oPTRecord == null) {
            return 512;
        }
        return oPTRecord.getPayloadSize();
    }

    public Message send(Message message) throws IOException {
        Object object;
        Object object2;
        if (Options.check("verbose")) {
            System.err.println("Sending to " + this.addr.getHostAddress() + ':' + this.port);
        }
        if (message.getHeader().getOpcode() == 0 && (object2 = message.getQuestion()) != null && ((Record)object2).getType() == 252) {
            return this.sendAXFR(message);
        }
        message = (Message)message.clone();
        this.applyEDNS(message);
        if (this.tsig != null) {
            this.tsig.apply(message, null);
        }
        object2 = message.toWire((char)-1);
        int n = this.maxUDPSize(message);
        boolean bl = false;
        InetSocketAddress inetSocketAddress = new InetSocketAddress(this.addr, this.port);
        long l = System.currentTimeMillis() + (long)this.timeoutValue;
        while (true) {
            byte[] byArray;
            if (this.useTCP || ((Object)object2).length > n) {
                bl = true;
            }
            if ((byArray = bl ? TCPClient.sendrecv(inetSocketAddress, (byte[])object2, l) : UDPClient.sendrecv(inetSocketAddress, (byte[])object2, n, l)).length < 12) {
                throw new WireParseException("invalid DNS header - too short");
            }
            int n2 = ((byArray[0] & 0xFF) << 8) + (byArray[1] & 0xFF);
            int n3 = message.getHeader().getID();
            if (n2 != n3) {
                object = "invalid message id: expected " + n3 + "; got id " + n2;
                if (bl) {
                    throw new WireParseException((String)object);
                }
                if (!Options.check("verbose")) continue;
                System.err.println((String)object);
                continue;
            }
            object = this.parseMessage(byArray);
            this.verifyTSIG(message, (Message)object, byArray, this.tsig);
            if (bl || this.ignoreTruncation || !((Message)object).getHeader().getFlag(6)) break;
            bl = true;
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object sendAsync(Message message, ResolverListener resolverListener) {
        String string;
        Integer n;
        SimpleResolver simpleResolver = this;
        synchronized (simpleResolver) {
            n = new Integer(uniqueID++);
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl5 : MonitorExitStatement: MONITOREXIT : var4_3
            Record record = message.getQuestion();
            string = record != null ? record.getName().toString() : "(none)";
        }
        String string2 = this.getClass() + ": " + string;
        ResolveThread resolveThread = new ResolveThread(this, message, n, resolverListener);
        resolveThread.setName(string2);
        resolveThread.setDaemon(true);
        resolveThread.start();
        return n;
    }

    private final Message sendAXFR(Message message) throws IOException {
        Name name = message.getQuestion().getName();
        InetSocketAddress inetSocketAddress = new InetSocketAddress(this.addr, this.port);
        ZoneTransferIn zoneTransferIn = ZoneTransferIn.newAXFR(name, inetSocketAddress, this.tsig);
        try {
            zoneTransferIn.run();
        }
        catch (ZoneTransferException zoneTransferException) {
            throw new WireParseException(zoneTransferException.getMessage());
        }
        List list2 = zoneTransferIn.getAXFR();
        Message message2 = new Message(message.getHeader().getID());
        message2.getHeader().setFlag(5);
        message2.getHeader().setFlag(0);
        message2.addRecord(message.getQuestion(), 0);
        Iterator iterator = list2.iterator();
        while (iterator.hasNext()) {
            message2.addRecord((Record)iterator.next(), 1);
        }
        return message2;
    }

    private final /* synthetic */ void this() {
        this.port = 53;
        this.EDNSlevel = (byte)-1;
        this.timeoutValue = 10000;
    }

    public SimpleResolver(String string) throws UnknownHostException {
        this.this();
        if (string == null && (string = ResolverConfig.getCurrentConfig().server()) == null) {
            string = defaultResolver;
        }
        this.addr = string.equals("0") ? InetAddress.getLocalHost() : InetAddress.getByName(string);
    }

    public SimpleResolver() throws UnknownHostException {
        this(null);
    }
}

