/*
 * This file is part of the TYPO3 CMS project.
 *
 * It is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License, either version 2
 * of the License, or any later version.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 *
 * The TYPO3 project - inspiring people to share!
 */
import"bootstrap";import{AbstractInteractableModule}from"@typo3/install/module/abstract-interactable-module.js";import Notification from"@typo3/backend/notification.js";import AjaxRequest from"@typo3/core/ajax/ajax-request.js";import SecurityUtility from"@typo3/core/security-utility.js";import{FlashMessage}from"@typo3/install/renderable/flash-message.js";import{InfoBox}from"@typo3/install/renderable/info-box.js";import Severity from"@typo3/install/renderable/severity.js";import Router from"@typo3/install/router.js";import RegularEvent from"@typo3/core/event/regular-event.js";var Identifiers;!function(e){e.outputWizardsContainer=".t3js-upgradeWizards-wizards-output",e.outputMessagesContainer=".t3js-upgradeWizards-wizards-messages-output",e.outputDoneContainer=".t3js-upgradeWizards-done-output",e.wizardsBlockingAddsTemplate="#t3js-upgradeWizards-blocking-adds-template",e.wizardsBlockingAddsRows=".t3js-upgradeWizards-blocking-adds-rows",e.wizardsBlockingAddsExecute=".t3js-upgradeWizards-blocking-adds-execute",e.wizardsBlockingCharsetTemplate="#t3js-upgradeWizards-blocking-charset-template",e.wizardsBlockingCharsetFix=".t3js-upgradeWizards-blocking-charset-fix",e.wizardsDoneBodyTemplate="#t3js-upgradeWizards-done-body-template",e.wizardsDoneRows=".t3js-upgradeWizards-done-rows",e.wizardsDoneRowTemplate="#t3js-upgradeWizards-done-row-template",e.wizardsDoneRowMarkUndone=".t3js-upgradeWizards-done-markUndone",e.wizardsDoneRowTitle=".t3js-upgradeWizards-done-title",e.wizardsListTemplate="#t3js-upgradeWizards-list-template",e.wizardsListRows=".t3js-upgradeWizards-list-rows",e.wizardsListRowTemplate="#t3js-upgradeWizards-list-row-template",e.wizardsListRowTitle=".t3js-upgradeWizards-list-row-title",e.wizardsListRowExplanation=".t3js-upgradeWizards-list-row-explanation",e.wizardsListRowExecute=".t3js-upgradeWizards-list-row-execute",e.wizardsInputTemplate="#t3js-upgradeWizards-input",e.wizardsInputTitle=".t3js-upgradeWizards-input-title",e.wizardsInputDescription=".t3js-upgradeWizards-input-description",e.wizardsInputHtml=".t3js-upgradeWizards-input-html",e.wizardsInputPerform=".t3js-upgradeWizards-input-perform",e.wizardsInputAbort=".t3js-upgradeWizards-input-abort"}(Identifiers||(Identifiers={}));class UpgradeWizards extends AbstractInteractableModule{constructor(){super(),this.securityUtility=new SecurityUtility}static removeLoadingMessage(e){e.querySelectorAll("typo3-backend-progress-bar").forEach((e=>e.remove()))}initialize(e){super.initialize(e),Promise.all([this.loadModuleFrameAgnostic("@typo3/install/renderable/info-box.js"),this.loadModuleFrameAgnostic("@typo3/install/renderable/flash-message.js")]).then((async()=>{await this.getData(),this.doneUpgrades()})),new RegularEvent("click",((e,t)=>{t.disabled=!0,this.markUndone(t.dataset.identifier)})).delegateTo(e,Identifiers.wizardsDoneRowMarkUndone),new RegularEvent("click",(()=>{this.blockingUpgradesDatabaseCharsetFix()})).delegateTo(e,Identifiers.wizardsBlockingCharsetFix),new RegularEvent("click",(()=>{this.blockingUpgradesDatabaseAddsExecute()})).delegateTo(e,Identifiers.wizardsBlockingAddsExecute),new RegularEvent("click",((e,t)=>{this.wizardInput(t.dataset.identifier,t.dataset.title)})).delegateTo(e,Identifiers.wizardsListRowExecute),new RegularEvent("click",((e,t)=>{this.wizardExecute(t.dataset.identifier,t.dataset.title)})).delegateTo(e,Identifiers.wizardsInputPerform),new RegularEvent("click",(()=>{this.findInModal(Identifiers.outputWizardsContainer).innerHTML="",this.wizardsList()})).delegateTo(e,Identifiers.wizardsInputAbort)}getData(){const e=this.getModalBody(),t=this.findInModal(Identifiers.outputWizardsContainer);return new AjaxRequest(Router.getUrl("upgradeWizardsGetData")).get({cache:"no-cache"}).then((async t=>{const r=await t.resolve();!0===r.success?(e.innerHTML=r.html,this.blockingUpgradesDatabaseCharsetTest()):Notification.error("Something went wrong","The request was not processed successfully. Please check the browser's console and TYPO3's log.")}),(e=>{Router.handleAjaxError(e,t)}))}blockingUpgradesDatabaseCharsetTest(){const e=this.getModalBody(),t=this.findInModal(Identifiers.outputWizardsContainer);this.renderProgressBar(t,{label:"Checking database charset..."}),new AjaxRequest(Router.getUrl("upgradeWizardsBlockingDatabaseCharsetTest")).get({cache:"no-cache"}).then((async r=>{const s=await r.resolve();!0===s.success&&(!0===s.needsUpdate?(UpgradeWizards.removeLoadingMessage(t),e.querySelector(Identifiers.outputWizardsContainer).appendChild(e.querySelector(Identifiers.wizardsBlockingCharsetTemplate).content.cloneNode(!0))):this.blockingUpgradesDatabaseAdds())}),(e=>{Router.handleAjaxError(e,t)}))}blockingUpgradesDatabaseCharsetFix(){const e=this.findInModal(Identifiers.outputWizardsContainer);this.renderProgressBar(e,{label:"Setting database charset to UTF-8..."}),new AjaxRequest(Router.getUrl("upgradeWizardsBlockingDatabaseCharsetFix")).get({cache:"no-cache"}).then((async t=>{const r=await t.resolve();!0===r.success?Array.isArray(r.status)&&r.status.length>0&&r.status.forEach((t=>{e.append(InfoBox.create(t.severity,t.title,t.message))})):(UpgradeWizards.removeLoadingMessage(e),e.append(FlashMessage.create(Severity.error,"Something went wrong")))}),(t=>{Router.handleAjaxError(t,e)}))}blockingUpgradesDatabaseAdds(){const e=this.getModalBody(),t=this.findInModal(Identifiers.outputWizardsContainer);this.renderProgressBar(t,{label:"Check for missing mandatory database tables and fields..."}),new AjaxRequest(Router.getUrl("upgradeWizardsBlockingDatabaseAdds")).get({cache:"no-cache"}).then((async r=>{const s=await r.resolve();if(!0===s.success)if(!0===s.needsUpdate){const t=e.querySelector(Identifiers.wizardsBlockingAddsTemplate).content.cloneNode(!0);"object"==typeof s.adds.tables&&s.adds.tables.forEach((e=>{const r="Table: "+this.securityUtility.encodeHtml(e.table);t.querySelector(Identifiers.wizardsBlockingAddsRows).append(r,document.createElement("br"))})),"object"==typeof s.adds.columns&&s.adds.columns.forEach((e=>{const r="Table: "+this.securityUtility.encodeHtml(e.table)+", Field: "+this.securityUtility.encodeHtml(e.field);t.querySelector(Identifiers.wizardsBlockingAddsRows).append(r,document.createElement("br"))})),"object"==typeof s.adds.indexes&&s.adds.indexes.forEach((e=>{const r="Table: "+this.securityUtility.encodeHtml(e.table)+", Index: "+this.securityUtility.encodeHtml(e.index);t.querySelector(Identifiers.wizardsBlockingAddsRows).append(r,document.createElement("br"))})),e.querySelector(Identifiers.outputWizardsContainer).appendChild(t)}else this.wizardsList();else UpgradeWizards.removeLoadingMessage(t),Notification.error("Something went wrong","The request was not processed successfully. Please check the browser's console and TYPO3's log.")}),(e=>{Router.handleAjaxError(e,t)}))}blockingUpgradesDatabaseAddsExecute(){const e=this.findInModal(Identifiers.outputWizardsContainer);this.renderProgressBar(e,{label:"Adding database tables and fields..."}),new AjaxRequest(Router.getUrl("upgradeWizardsBlockingDatabaseExecute")).get({cache:"no-cache"}).then((async t=>{const r=await t.resolve();if(Array.isArray(r.status)&&r.status.length>0&&r.status.forEach((t=>{e.append(InfoBox.create(t.severity,t.title,t.message))})),!0===r.success)this.wizardsList();else if(Array.isArray(r.status)&&0!==r.status.length){const t=document.createElement("div");t.classList.add("btn-toolbar","mt-3","mb-4");const r=document.createElement("button");r.classList.add("btn","btn-default"),r.innerText="Retry database migration";const s=document.createElement("button");s.classList.add("btn","btn-danger"),s.innerText="Proceed despite of errors",new RegularEvent("click",(()=>{this.blockingUpgradesDatabaseAddsExecute()})).bindTo(r),new RegularEvent("click",(()=>{t.remove(),this.wizardsList()})).bindTo(s),t.appendChild(r),t.appendChild(s),e.appendChild(t)}else e.append(FlashMessage.create(Severity.error,"Something went wrong"))}),(t=>{Router.handleAjaxError(t,e)}))}wizardsList(){const e=this.getModalBody(),t=this.findInModal(Identifiers.outputWizardsContainer);this.renderProgressBar(t,{label:"Loading upgrade wizards..."}),new AjaxRequest(Router.getUrl("upgradeWizardsList")).get({cache:"no-cache"}).then((async r=>{const s=await r.resolve();UpgradeWizards.removeLoadingMessage(t);const a=e.querySelector(Identifiers.wizardsListTemplate).content.cloneNode(!0);if(!0===s.success){let t=0,r=0;Array.isArray(s.wizards)&&s.wizards.length>0&&(r=s.wizards.length,s.wizards.forEach((r=>{if(!0===r.shouldRenderWizard){const s=e.querySelector(Identifiers.wizardsListRowTemplate).content.cloneNode(!0);t+=1,s.querySelector(Identifiers.wizardsListRowTitle).innerText=r.title,s.querySelector(Identifiers.wizardsListRowExplanation).innerText=r.explanation,s.querySelector(Identifiers.wizardsListRowExecute).setAttribute("data-identifier",r.identifier),s.querySelector(Identifiers.wizardsListRowExecute).setAttribute("data-title",r.title),a.querySelector(Identifiers.wizardsListRows).append(s)}})));let i=100;const n=a.querySelector("typo3-backend-progress-bar");t>0?i=Math.round((r-t)/s.wizards.length*100):n.severity=Severity.ok,n.value=i,n.label=`${r-t} of ${r} upgrade wizards executed`,e.querySelector(Identifiers.outputWizardsContainer).appendChild(a)}else Notification.error("Something went wrong","The request was not processed successfully. Please check the browser's console and TYPO3's log.")}),(e=>{Router.handleAjaxError(e,t)}))}wizardInput(e,t){const r=this.getModuleContent().dataset.upgradeWizardsInputToken,s=this.getModalBody(),a=this.findInModal(Identifiers.outputWizardsContainer);this.renderProgressBar(a,{label:'Loading "'+t+'"...'}),s.animate({scrollTop:s.scrollTop-Math.abs(s.querySelector(".t3js-upgrade-status-section").getBoundingClientRect().top)},250),new AjaxRequest(Router.getUrl("upgradeWizardsInput")).post({install:{action:"upgradeWizardsInput",token:r,identifier:e}}).then((async e=>{const t=await e.resolve();a.innerHTML="";const r=s.querySelector(Identifiers.wizardsInputTemplate).content.cloneNode(!0);if(!0===t.success){Array.isArray(t.status)&&t.status.forEach((e=>{a.append(FlashMessage.create(e.severity,e.title,e.message))})),t.userInput.wizardHtml.length>0&&(r.querySelector(Identifiers.wizardsInputHtml).innerHTML=t.userInput.wizardHtml),r.querySelector(Identifiers.wizardsInputTitle).innerText=t.userInput.title,r.querySelector(Identifiers.wizardsInputDescription).innerHTML=this.securityUtility.stripHtml(t.userInput.description).replace(/\n/g,"<br>");const e=r.querySelector(Identifiers.wizardsInputPerform);e.setAttribute("data-identifier",t.userInput.identifier),e.setAttribute("data-title",t.userInput.title)}s.querySelector(Identifiers.outputWizardsContainer).appendChild(r)}),(e=>{Router.handleAjaxError(e,a)}))}wizardExecute(e,t){const r=this.getModuleContent().dataset.upgradeWizardsExecuteToken,s=this.getModalBody(),a={"install[action]":"upgradeWizardsExecute","install[token]":r,"install[identifier]":e},i=new FormData(this.findInModal(Identifiers.outputWizardsContainer+" form"));for(const[e,t]of i)a[e]=t.toString();const n=this.findInModal(Identifiers.outputWizardsContainer),o=this.findInModal(Identifiers.outputMessagesContainer);this.renderProgressBar(n,{label:'Executing "'+t+'"...'}),new AjaxRequest(Router.getUrl()).post(a).then((async e=>{const t=await e.resolve();if(o.replaceChildren(),!0===t.success){if(Array.isArray(t.status)){const e=[];t.status.forEach((t=>{e.push(InfoBox.create(t.severity,t.title,t.message))})),o.append(...e)}this.wizardsList(),s.querySelector(Identifiers.outputDoneContainer).innerHTML="",this.doneUpgrades()}else Notification.error("Something went wrong","The request was not processed successfully. Please check the browser's console and TYPO3's log.")}),(e=>{Router.handleAjaxError(e,n)}))}doneUpgrades(){const e=this.getModalBody(),t=e.querySelector(Identifiers.outputDoneContainer);this.renderProgressBar(t,{label:"Loading executed upgrade wizards..."}),new AjaxRequest(Router.getUrl("upgradeWizardsDoneUpgrades")).get({cache:"no-cache"}).then((async r=>{const s=await r.resolve();if(UpgradeWizards.removeLoadingMessage(t),!0===s.success){Array.isArray(s.status)&&s.status.length>0&&s.status.forEach((e=>{t.append(InfoBox.create(e.severity,e.title,e.message))}));const r=e.querySelector(Identifiers.wizardsDoneBodyTemplate).content.cloneNode(!0),a=r.querySelector(Identifiers.wizardsDoneRows);let i=!1;Array.isArray(s.wizardsDone)&&s.wizardsDone.length>0&&s.wizardsDone.forEach((t=>{i=!0;const r=e.querySelector(Identifiers.wizardsDoneRowTemplate).content.cloneNode(!0);r.querySelector(Identifiers.wizardsDoneRowMarkUndone).setAttribute("data-identifier",t.identifier),r.querySelector(Identifiers.wizardsDoneRowTitle).innerText=t.title,a.appendChild(r)})),Array.isArray(s.rowUpdatersDone)&&s.rowUpdatersDone.length>0&&s.rowUpdatersDone.forEach((t=>{i=!0;const r=e.querySelector(Identifiers.wizardsDoneRowTemplate).content.cloneNode(!0);r.querySelector(Identifiers.wizardsDoneRowMarkUndone).setAttribute("data-identifier",t.identifier),r.querySelector(Identifiers.wizardsDoneRowTitle).innerText=t.title,a.appendChild(r)})),i&&e.querySelector(Identifiers.outputDoneContainer).appendChild(r)}else Notification.error("Something went wrong","The request was not processed successfully. Please check the browser's console and TYPO3's log.")}),(e=>{Router.handleAjaxError(e,t)}))}markUndone(e){const t=this.getModuleContent().dataset.upgradeWizardsMarkUndoneToken,r=this.getModalBody(),s=this.findInModal(Identifiers.outputMessagesContainer),a=this.findInModal(Identifiers.outputDoneContainer);this.renderProgressBar(a,{label:"Marking upgrade wizard as undone..."}),new AjaxRequest(Router.getUrl()).post({install:{action:"upgradeWizardsMarkUndone",token:t,identifier:e}}).then((async e=>{const t=await e.resolve();s.replaceChildren(),a.replaceChildren(),r.querySelector(Identifiers.outputDoneContainer).replaceChildren(),!0===t.success&&Array.isArray(t.status)?t.status.forEach((e=>{Notification.success(e.title,e.message),this.doneUpgrades(),this.blockingUpgradesDatabaseCharsetTest()})):Notification.error("Something went wrong","The request was not processed successfully. Please check the browser's console and TYPO3's log.")}),(e=>{Router.handleAjaxError(e,a)}))}}export default new UpgradeWizards;