<?php

class RecentListAction extends SOY2Action{

	var $limit = 3;
	
	function setLimit($limit){
		$this->limit = $limit;
	}

    function execute() {
    	
    	//最新エントリーを3件取得
    	$logic = SOY2Logic::createInstance("logic.site.Entry.EntryLogic");
    	$logic->setLimit(3);
    	$array = $logic->getRecentEntries();
    	
    	$entries = array();
    	foreach($array as $entry){
    		$labeledEntry = SOY2::cast("LabeledEntry",$entry);
    		$labeledEntry->setLabels($logic->getLabelIdsByEntryId($entry->getId()));
    		$entries[] = $labeledEntry;
    	}    	
    	
    	$this->setAttribute("list",$entries);
    	
    	//ラベルを取得
    	$dao = SOY2DAOFactory::create("cms.LabelDAO");
    	$labels = $dao->get();
    	
    	$this->setAttribute("labels",$labels);    	
    	
    	return SOY2Action::SUCCESS;
    }
    
}
?>