/*
 * This file contains D-Bus client proxy classes generated by qt-client-gen.py.
 *
 * This file can be distributed under the same terms as the specification from
 * which it was generated.
 */

#ifndef IN_TP_QT_HEADER
#error IN_TP_QT_HEADER
#endif

#include <TelepathyQt/Types>

#include <QtGlobal>

#include <QString>
#include <QObject>
#include <QVariant>

#include <QDBusPendingReply>

#include <TelepathyQt/AbstractInterface>
#include <TelepathyQt/DBusProxy>
#include <TelepathyQt/Global>

namespace Tp
{
class PendingVariant;
class PendingOperation;
}

namespace Tp
{
namespace Client
{

/**
 * \class AccountManagerInterface
 * \headerfile TelepathyQt/account-manager.h <TelepathyQt/AccountManager>
 * \ingroup clientam
 *
 * Proxy class providing a 1:1 mapping of the D-Bus interface "org.freedesktop.Telepathy.AccountManager".
 */
class TP_QT_EXPORT AccountManagerInterface : public Tp::AbstractInterface
{
    Q_OBJECT

public:
    /**
     * Returns the name of the interface "org.freedesktop.Telepathy.AccountManager", which this class
     * represents.
     *
     * \return The D-Bus interface name.
     */
    static inline QLatin1String staticInterfaceName()
    {
        return QLatin1String("org.freedesktop.Telepathy.AccountManager");
    }

    /**
     * Creates a AccountManagerInterface associated with the given object on the session bus.
     *
     * \param busName Name of the service the object is on.
     * \param objectPath Path to the object on the service.
     * \param parent Passed to the parent class constructor.
     */
    AccountManagerInterface(
        const QString& busName,
        const QString& objectPath,
        QObject* parent = 0
    );

    /**
     * Creates a AccountManagerInterface associated with the given object on the given bus.
     *
     * \param connection The bus via which the object can be reached.
     * \param busName Name of the service the object is on.
     * \param objectPath Path to the object on the service.
     * \param parent Passed to the parent class constructor.
     */
    AccountManagerInterface(
        const QDBusConnection& connection,
        const QString& busName,
        const QString& objectPath,
        QObject* parent = 0
    );

    /**
     * Creates a AccountManagerInterface associated with the same object as the given proxy.
     *
     * \param proxy The proxy to use. It will also be the QObject::parent()
     *               for this object.
     */
    AccountManagerInterface(Tp::DBusProxy *proxy);

    /**
     * Asynchronous getter for the remote object property \c Interfaces of type \c QStringList.
     *
     * 
     * A list of the interfaces provided by the account manager object.
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyInterfaces() const
    {
        return internalRequestProperty(QLatin1String("Interfaces"));
    }

    /**
     * Asynchronous getter for the remote object property \c ValidAccounts of type \c Tp::ObjectPathList.
     *
     * 
     * A list of the valid (complete, usable) Accounts. Change notification is 
     * via AccountValidityChanged. This split between valid and invalid 
     * accounts makes it easy to ignore the invalid ones. The only things that 
     * should be manipulating invalid accounts are account-editing UIs, which 
     * might be able to rescue them.
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyValidAccounts() const
    {
        return internalRequestProperty(QLatin1String("ValidAccounts"));
    }

    /**
     * Asynchronous getter for the remote object property \c InvalidAccounts of type \c Tp::ObjectPathList.
     *
     * 
     * A list of incomplete or otherwise unusable Accounts. Change 
     * notification is via AccountValidityChanged.
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyInvalidAccounts() const
    {
        return internalRequestProperty(QLatin1String("InvalidAccounts"));
    }

    /**
     * Asynchronous getter for the remote object property \c SupportedAccountProperties of type \c QStringList.
     *
     * 
     * \htmlonly
     * <p>A list of the fully qualified names of properties that can be set
     *   via the Properties argument to
     *    \endhtmlonly CreateAccount() \htmlonly  when an account is
     *   created.</p>
     * 
     * <div class="rationale">
     *   <p>Examples of good properties to support here include
     *      \endhtmlonly \link AccountInterface::requestPropertyIcon() AccountInterface::Icon \endlink \htmlonly ,
     *      \endhtmlonly \link AccountInterface::requestPropertyEnabled() AccountInterface::Enabled \endlink \htmlonly ,
     *      \endhtmlonly \link AccountInterface::requestPropertyNickname() AccountInterface::Nickname \endlink \htmlonly ,
     *      \endhtmlonly \link AccountInterface::requestPropertyAutomaticPresence() AccountInterface::AutomaticPresence \endlink \htmlonly ,
     *      \endhtmlonly \link AccountInterface::requestPropertyConnectAutomatically() AccountInterface::ConnectAutomatically \endlink \htmlonly ,
     *      \endhtmlonly \link AccountInterface::requestPropertySupersedes() AccountInterface::Supersedes \endlink \htmlonly ,
     *      \endhtmlonly \link AccountInterface::requestPropertyRequestedPresence() AccountInterface::RequestedPresence \endlink \htmlonly 
     *     and
     *      \endhtmlonly \link AccountInterfaceAvatarInterface::requestPropertyAvatar() AccountInterfaceAvatarInterface::Avatar \endlink \htmlonly .
     *     </p>
     * 
     *   <p>Examples of properties that would make no sense here include
     *      \endhtmlonly \link AccountInterface::requestPropertyValid() AccountInterface::Valid \endlink \htmlonly ,
     *      \endhtmlonly \link AccountInterface::requestPropertyConnection() AccountInterface::Connection \endlink \htmlonly ,
     *      \endhtmlonly \link AccountInterface::requestPropertyConnectionStatus() AccountInterface::ConnectionStatus \endlink \htmlonly ,
     *      \endhtmlonly \link AccountInterface::requestPropertyConnectionStatusReason() AccountInterface::ConnectionStatusReason \endlink \htmlonly ,
     *      \endhtmlonly \link AccountInterface::requestPropertyCurrentPresence() AccountInterface::CurrentPresence \endlink \htmlonly 
     *     and
     *      \endhtmlonly \link AccountInterface::requestPropertyNormalizedName() AccountInterface::NormalizedName \endlink \htmlonly .
     *   </p>
     * </div>
     * 
     * <p>This property MUST NOT include include the  \endhtmlonly \link AccountInterface::requestPropertyDisplayName() AccountInterface::DisplayName \endlink \htmlonly 
     *   and  \endhtmlonly \link AccountInterface::requestPropertyParameters() AccountInterface::Parameters \endlink \htmlonly 
     *   properties, which are set using separate arguments.</p>
     * 
     * <p>This property MAY include the names of properties that, after
     *   account creation, will be read-only: this indicates that the property
     *   can be set at account creation but not changed later.</p>
     * 
     * <div class="rationale">
     *   <p>For example, an account manager might support migration tools that
     *     use this to preserve the  \endhtmlonly \link AccountInterface::requestPropertyHasBeenOnline() AccountInterface::HasBeenOnline \endlink \htmlonly 
     *     property, even though that property is usually read-only.</p>
     * </div>
     * \endhtmlonly
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertySupportedAccountProperties() const
    {
        return internalRequestProperty(QLatin1String("SupportedAccountProperties"));
    }

    /**
     * Request all of the DBus properties on the interface.
     *
     * \return A pending variant map which will emit finished when the properties have
     *          been retrieved.
     */
    Tp::PendingVariantMap *requestAllProperties() const
    {
        return internalRequestAllProperties();
    }

public Q_SLOTS:
    /**
     * Begins a call to the D-Bus method \c CreateAccount on the remote object.
     * 
     * Request the creation of a new Account. The account manager SHOULD NOT 
     * allow invalid accounts to be created.
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     *
     * \param connectionManager
     *     
     *     The name of the connection manager, e.g. &quot;salut&quot;.
     *
     * \param protocol
     *     
     *     The protocol, e.g. &quot;local-xmpp&quot;.
     *
     * \param displayName
     *     
     *     The initial value of the new account&apos;s DisplayName property. 
     *     The account manager SHOULD modify this to make it unique if an 
     *     Account already exists with the same display name, for instance by 
     *     appending a number or the &apos;account&apos; parameter. Account 
     *     manager implementations SHOULD accept an empty string, but account 
     *     editing user interfaces should avoid passing an empty string for 
     *     this parameter. The account creation UI may ask the user for a name 
     *     for the new account. If the author of the UI chooses not to do 
     *     this, the account creation UI is better able to suggest a default 
     *     display name because it has protocol-specific knowledge which the 
     *     account manager does not. The account manager always knows the 
     *     complete list of accounts so it can easily tell whether it should 
     *     append something to the display name to avoid presenting two 
     *     identically-named accounts to the user.
     *
     * \param parameters
     *     
     *     Initial parameter values, as would be passed to RequestConnection.
     *
     * \param properties
     *     
     *     \htmlonly
     *     <p>The values of any other properties to be set immediately on the
     *       new Account.</p>
     *     
     *     <p>Only the properties mentioned in
     *        \endhtmlonly \link requestPropertySupportedAccountProperties() SupportedAccountProperties \endlink \htmlonly  are
     *       acceptable here. In particular, the  \endhtmlonly \link AccountInterface::requestPropertyDisplayName() AccountInterface::DisplayName \endlink \htmlonly 
     *       and  \endhtmlonly \link AccountInterface::requestPropertyParameters() AccountInterface::Parameters \endlink \htmlonly 
     *       properties are never allowed here, since they are set using the other
     *       arguments to this method.</p>
     *     
     *     <p>Account manager implementations SHOULD support creating accounts
     *       with an empty value for this argument.</p>
     *     \endhtmlonly
     * \param timeout The timeout in milliseconds.
     *
     * \return
     *     
     *     The new Account.
     */
    inline QDBusPendingReply<QDBusObjectPath> CreateAccount(const QString& connectionManager, const QString& protocol, const QString& displayName, const QVariantMap& parameters, const QVariantMap& properties, int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<QDBusObjectPath>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("CreateAccount"));
        callMessage << QVariant::fromValue(connectionManager) << QVariant::fromValue(protocol) << QVariant::fromValue(displayName) << QVariant::fromValue(parameters) << QVariant::fromValue(properties);
        return this->connection().asyncCall(callMessage, timeout);
    }

Q_SIGNALS:
    /**
     * Represents the signal \c AccountRemoved on the remote object.
     * 
     * The given account has been removed. This is effectively change 
     * notification for the valid and invalid accounts lists. On emission of 
     * this signal, the Account indicated will no longer be present in either 
     * of the lists.
     *
     * \param account
     *     
     *     An Account, which must not be used any more.
     */
    void AccountRemoved(const QDBusObjectPath& account);

    /**
     * Represents the signal \c AccountValidityChanged on the remote object.
     * 
     * The validity of the given account has changed. New accounts are also 
     * indicated by this signal, as an account validity change (usually to 
     * True) on an account that did not previously exist. This is effectively 
     * change notification for the valid and invalid accounts lists.
     *
     * \param account
     *     
     *     An Account.
     *
     * \param valid
     *     
     *     True if the account is now valid.
     */
    void AccountValidityChanged(const QDBusObjectPath& account, bool valid);

protected:
    virtual void invalidate(Tp::DBusProxy *, const QString &, const QString &);
};
}
}
Q_DECLARE_METATYPE(Tp::Client::AccountManagerInterface*)
