/*
* MyGoGrinder - a program to practice Go problems
* Copyright (c) 2004-2006 Tim Kington
*   timkington@users.sourceforge.net
* Portions Copyright (C) Ruediger Klehn (2014)
*   RuediRf@users.sourceforge.net
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA
*
*/

package GoGrinder;
import java.io.File;
import java.io.BufferedReader;
// import java.io.FileReader;
import java.io.IOException;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.*;
import java.awt.*;
/**
 * @author tkington
 */
public class Messages { // ? throws MissingResourceException ? - yes, when the whole block of locales is missing
// interestingly, the captions and buttons (load/save file) are in the system's language 
// despite the language been switched correctly
// seemingly a problem also in CGoban, but jEdit switches these
// see  in java.util.Locale: public static void setDefault(Locale newLocale)
// and try java -XshowSettings:locale

// Java has a problem with a trailing "!" in a folder in the program's path
// (also, another one with a "!" anywhere in the path);
// this problem shows up, when internal resources are called (language, graphics, ...)
  
  private static final String BUNDLE_NAME = "GoGrinder.messages";//$NON-NLS-1$
  private static ResourceBundle myResourceBundle;
  private static boolean setByUser = false;
  private static String language = "";
  private static boolean tempSetLang = false;
  private static boolean resetLang = false;
  
  // without file grind.locale : system's language - when GG has a language file for it
  // empty grind.locale : program's default ( = Englisch)
  public static void Messages() { /* NOTHING */ }
  
  public static void initMessages(){
  try{
      Locale tempLocale = new Locale(Locale.getDefault().toString().substring(0, 2));
      myResourceBundle = ResourceBundle.getBundle(BUNDLE_NAME, tempLocale);
    }
    catch(Exception e3){
      JOptionPane.showMessageDialog(null, "Possibly a problem with a character in the path: \n"
                                        + Main.thisProgsFolder + "\n"
                                        + e3.getMessage() + "\n"
                                        + "see " + Main.commonLogFilePath);
      Main.logSilent(e3);
    }
  }
  
  public static void switchLocale(String newLocale){
    if (newLocale == null) newLocale = Locale.getDefault().toString().substring(0, 2);
    if (newLocale.equals("df")) newLocale = "en"; // scary logic - need to write new? the "df" is for the SystemInfo window
    Locale newLocaleL = new Locale(newLocale);
    myResourceBundle = ResourceBundle.getBundle(BUNDLE_NAME, newLocaleL);
  }
  
  // read the locale from the grind.locale
  private static Locale getLocale() {
        String locale = FileWReadWrite.readFileLineDefaultCharsetDontMoan(Main.localeOldFilePath);
        if (locale == null){ // file error (IOExc.): not found, not allowed to read etc.
          return new Locale(Locale.getDefault().toString().substring(0, 2)); // system's default, based on the JVM
        } // we need to check, if this meets the old handling!! we collide with the old handling!
        return new Locale(locale);
    
  }

  public static String getString(String key) {
    try {
      return myResourceBundle.getString(key);
    } 
    catch (MissingResourceException e) {
      return '!' + key + '!';
    }
  }

// ############################  PARSE  #######################################################################################
  public static boolean parseLanguage(String parseThis){ // or setLanguage 
     // Feb.'15: we switch to -l/-language, 
     // -l=temp:en or -l=prg or -l=reset (... to default) can be possible
     // here we could differenciate between tempLang, setLang + defaultLang
     // we would set -tempLanguage= (just this run), 
     //              -defaultLanguage (is system's lang. / JVM's lang.) 
     //           or -resetLang
     //          and -setLanguage=xy (which can also be set by the user from the settings or help menu)
     //          AND -prgLang (use the programs language - engl.)
    parseThis = parseThis.toLowerCase();
    String LANGUAGES = Main.LANGUAGE_TOKENS; // for the parser
    // to create a list of available languages for selecting the desired language, 
    // this list could be read (but how to make a word out of a token? de - Deutsch, fr - Francais, and - in Chinese?...)
    // Locale and ResourceBundle have posssibly something more nice

    boolean parseSuccess = false;
    int index = parseThis.indexOf("=");
    String language = Main.language;

    // wrong language switch?
    if(index == -1) {   // "=" not in the parameter string, e.g. 
      if (parseThis.equals("defaultlanguage") || parseThis.equals("-defaultlanguage")
        || parseThis.equals("-l") || parseThis.equals("-language") ){
        language = "";
        Main.language = language;
        switchLocale(language);
        tempSetLang = true;
        return true;
      } 
             // #### No need to translate this message / caption ####
      String question = "Start parameters: correct format is \"-language=en\" \n"
                     + "We accept also \"-l=en\" and for some time \"-defaultlanguage=en\" (the latter will change) \n"
                     + "Possible tokens are " + Main.LANGUAGE_TOKENS + ". Omitting the token \n"
                     + "lets the program start with the program's default (which is english). \n"
                     + "Continue with the default?";   // (else we abort the program)
      String caption = "Invalid language switch";
             // #### No need to translate this message / caption ####

      Object[] options = {"OK", "Cancel"};
      Component parent = null;
      boolean answer = false;
      int btnClicked = JOptionPane.showOptionDialog(parent, question, 
                                                   caption, JOptionPane.OK_CANCEL_OPTION, 
                                                   0, null, 
                                                   options, options[1]);
      if (btnClicked != 0) {
        System.exit(0);
      }
      else { // OK - should allow to load the standard ressource (which is also English)
        language = "en";
        Main.language = language;
        switchLocale(language);
        tempSetLang = true;
        return true;
      }
    } // end "=" not in the parameter string
    language = parseThis.substring(index + 1); // takes the rest, behind "=" up to next space (but without the space)

    // invalid language token in the language switch?
    if(language != null) { // lang got a value
      if (language.length() == 0) {
        language = Locale.getDefault().toString().substring(0, 2);
        resetLang = true;
        tempSetLang = false;
        parseSuccess = true;
      } // switch was "defaultLanguage="
      if (language.length() != 2 || LANGUAGES.indexOf(language) == -1){
        //         invalid token || used token is not in the valid-token-list
        JOptionPane.showMessageDialog(null, "Invalid language token: \"" + language + "\" \n"
                                           + "Continuing with the default language (which is English).");
        language = "df"; // ~default, try to load the "GoGrinder.messages" instead of "GoGrinder_en.messages"
        // "df" - scary logic, risk of bug, need rewrite
        tempSetLang = true;
        Main.language = language;
        switchLocale(language);
        return true;
      }                  // like above ("=" not in the parameter string)
      setByUser = true;
    }//lang got a value
    switchLocale(language);
    Main.language = language;
    return true;
  }

  // write the language token to the grind.locale file 
  public static void setDefaultLanguage(String lang) {
    // Set language from the preferences window?  call this directly or from switchLang? (we could make this private) 
    // should then read in the list: "CHIN.CHARS (chinese)", "RUSS.CHARS (russian)" "Deutsch", 
    if (!setByUser){ // setByUser: z.B. =de,  
      if (!tempSetLang || lang == null){
        String gotLocale = getLocale().toString();
        switchLocale(gotLocale);
        Main.language = gotLocale;
      }
      return;
    }
    if (resetLang) {
      boolean dummy = new File(Main.localeOldFilePath).delete(); // dummy: we don't care about errors here
      return;
    }
    boolean success = FileWReadWrite.writeFileLine(Main.localeOldFilePath, lang);
    String msg = "Error saving default locale to \"" + Main.localeOldFilePath + "\"";
    if (!success) {
      JOptionPane.showMessageDialog(null, msg);
      Main.logSilent(msg);
    }
  }
}