/*
 * Decompiled with CFR 0.152.
 */
package org.xerial.snappy;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Properties;
import org.xerial.snappy.OSInfo;
import org.xerial.snappy.SnappyError;
import org.xerial.snappy.SnappyErrorCode;
import org.xerial.snappy.SnappyNativeAPI;

public class SnappyLoader {
    private static boolean isInitialized = false;
    private static boolean isLoaded = false;
    private static SnappyNativeAPI api = null;
    public static final String KEY_SNAPPY_LIB_PATH = "org.xerial.snappy.lib.path";
    public static final String KEY_SNAPPY_LIB_NAME = "org.xerial.snappy.lib.name";
    public static final String KEY_SNAPPY_TEMPDIR = "org.xerial.snappy.tempdir";
    public static final String KEY_SNAPPY_DISABLE_BUNDLED_LIBS = "org.xerial.snappy.disable.bundled.libs";

    private static ClassLoader getRootClassLoader() {
        ClassLoader cl = SnappyLoader.class.getClassLoader();
        while (cl.getParent() != null) {
            cl = cl.getParent();
        }
        return cl;
    }

    private static byte[] getByteCode(String resourcePath) throws IOException {
        int readLength;
        InputStream in = SnappyLoader.class.getResourceAsStream(resourcePath);
        if (in == null) {
            throw new IOException(resourcePath + " is not found");
        }
        byte[] buf = new byte[1024];
        ByteArrayOutputStream byteCodeBuf = new ByteArrayOutputStream();
        while ((readLength = in.read(buf)) != -1) {
            byteCodeBuf.write(buf, 0, readLength);
        }
        in.close();
        return byteCodeBuf.toByteArray();
    }

    public static boolean isNativeLibraryLoaded() {
        return isLoaded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static SnappyNativeAPI load() {
        if (isInitialized) {
            return api;
        }
        isInitialized = true;
        String nativeLoaderClassName = "org.xerial.snappy.SnappyNativeLoader";
        String[] classesToPreload = new String[]{"org.xerial.snappy.SnappyNativeAPI", "org.xerial.snappy.SnappyNative", "org.xerial.snappy.SnappyErrorCode"};
        try {
            Class<?> c = Class.forName("org.xerial.snappy.SnappyNativeLoader");
            api = (SnappyNativeAPI)Class.forName("org.xerial.snappy.SnappyNative").newInstance();
            isLoaded = true;
            return api;
        }
        catch (ClassNotFoundException e) {
            try {
                byte[] byteCode = SnappyLoader.getByteCode("/org/xerial/snappy/SnappyNativeLoader.bytecode");
                ArrayList<byte[]> preloadClassByteCode = new ArrayList<byte[]>(classesToPreload.length);
                for (String each : classesToPreload) {
                    preloadClassByteCode.add(SnappyLoader.getByteCode(String.format("/%s.class", each.replaceAll("\\.", "/"))));
                }
                Class<?> classLoader = Class.forName("java.lang.ClassLoader");
                Method defineClass = classLoader.getDeclaredMethod("defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE, ProtectionDomain.class);
                ClassLoader systemClassLoader = SnappyLoader.getRootClassLoader();
                ProtectionDomain pd = System.class.getProtectionDomain();
                defineClass.setAccessible(true);
                try {
                    defineClass.invoke((Object)systemClassLoader, "org.xerial.snappy.SnappyNativeLoader", byteCode, 0, byteCode.length, pd);
                    for (int i = 0; i < classesToPreload.length; ++i) {
                        byte[] b = (byte[])preloadClassByteCode.get(i);
                        defineClass.invoke((Object)systemClassLoader, classesToPreload[i], b, 0, b.length, pd);
                    }
                }
                finally {
                    defineClass.setAccessible(false);
                }
                Class<?> loaderClass = systemClassLoader.loadClass("org.xerial.snappy.SnappyNativeLoader");
                if (loaderClass != null) {
                    Method loadMethod;
                    File nativeLib = SnappyLoader.findNativeLibrary();
                    if (nativeLib != null) {
                        loadMethod = loaderClass.getDeclaredMethod("load", String.class);
                        loadMethod.invoke(null, nativeLib.getAbsolutePath());
                    } else {
                        loadMethod = loaderClass.getDeclaredMethod("loadLibrary", String.class);
                        loadMethod.invoke(null, "snappyjava");
                    }
                    for (String each : classesToPreload) {
                        systemClassLoader.loadClass(each);
                    }
                    isLoaded = true;
                    api = (SnappyNativeAPI)Class.forName("org.xerial.snappy.SnappyNative").newInstance();
                    return api;
                }
            }
            catch (ClassNotFoundException ee) {
                throw new SnappyError(SnappyErrorCode.FAILED_TO_LOAD_NATIVE_LIBRARY, ee.getMessage());
            }
            catch (Exception e2) {
                throw new SnappyError(SnappyErrorCode.FAILED_TO_LOAD_NATIVE_LIBRARY, e.getMessage());
            }
        }
        catch (Exception e) {
            throw new SnappyError(SnappyErrorCode.FAILED_TO_LOAD_NATIVE_LIBRARY, e.getMessage());
        }
        throw new SnappyError(SnappyErrorCode.FAILED_TO_LOAD_NATIVE_LIBRARY);
    }

    static String md5sum(InputStream input) throws IOException {
        BufferedInputStream in = new BufferedInputStream(input);
        try {
            MessageDigest digest = MessageDigest.getInstance("MD5");
            DigestInputStream digestInputStream = new DigestInputStream(in, digest);
            while (digestInputStream.read() >= 0) {
            }
            ByteArrayOutputStream md5out = new ByteArrayOutputStream();
            md5out.write(digest.digest());
            String string = md5out.toString();
            return string;
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("MD5 algorithm is not available: " + e);
        }
        finally {
            in.close();
        }
    }

    private static File extractLibraryFile(String libFolderForCurrentOS, String libraryFileName, String targetFolder) {
        String nativeLibraryFilePath = libFolderForCurrentOS + "/" + libraryFileName;
        String prefix = "snappy-" + SnappyLoader.getVersion() + "-";
        String extractedLibFileName = prefix + libraryFileName;
        File extractedLibFile = new File(targetFolder, extractedLibFileName);
        try {
            if (extractedLibFile.exists()) {
                String md5sum2;
                String md5sum1 = SnappyLoader.md5sum(SnappyLoader.class.getResourceAsStream(nativeLibraryFilePath));
                if (md5sum1.equals(md5sum2 = SnappyLoader.md5sum(new FileInputStream(extractedLibFile)))) {
                    return new File(targetFolder, extractedLibFileName);
                }
                boolean deletionSucceeded = extractedLibFile.delete();
                if (!deletionSucceeded) {
                    throw new IOException("failed to remove existing native library file: " + extractedLibFile.getAbsolutePath());
                }
            }
            InputStream reader = SnappyLoader.class.getResourceAsStream(nativeLibraryFilePath);
            FileOutputStream writer = new FileOutputStream(extractedLibFile);
            byte[] buffer = new byte[8192];
            int bytesRead = 0;
            while ((bytesRead = reader.read(buffer)) != -1) {
                writer.write(buffer, 0, bytesRead);
            }
            writer.close();
            reader.close();
            if (!System.getProperty("os.name").contains("Windows")) {
                try {
                    Runtime.getRuntime().exec(new String[]{"chmod", "755", extractedLibFile.getAbsolutePath()}).waitFor();
                }
                catch (Throwable e) {
                    // empty catch block
                }
            }
            return new File(targetFolder, extractedLibFileName);
        }
        catch (IOException e) {
            e.printStackTrace(System.err);
            return null;
        }
    }

    static File findNativeLibrary() {
        String snappyNativeLibraryPath = System.getProperty(KEY_SNAPPY_LIB_PATH);
        String snappyNativeLibraryName = System.getProperty(KEY_SNAPPY_LIB_NAME);
        if (System.getProperty(KEY_SNAPPY_DISABLE_BUNDLED_LIBS, "false").equals("false")) {
            File nativeLib;
            if (snappyNativeLibraryName == null) {
                snappyNativeLibraryName = System.mapLibraryName("snappyjava");
            }
            if (snappyNativeLibraryPath != null && (nativeLib = new File(snappyNativeLibraryPath, snappyNativeLibraryName)).exists()) {
                return nativeLib;
            }
        }
        if (SnappyLoader.class.getResource((snappyNativeLibraryPath = "/org/xerial/snappy/native/" + OSInfo.getNativeLibFolderPathForCurrentOS()) + "/" + snappyNativeLibraryName) != null) {
            String tempFolder = new File(System.getProperty(KEY_SNAPPY_TEMPDIR, System.getProperty("java.io.tmpdir"))).getAbsolutePath();
            return SnappyLoader.extractLibraryFile(snappyNativeLibraryPath, snappyNativeLibraryName, tempFolder);
        }
        return null;
    }

    private static void getNativeLibraryFolderForTheCurrentOS() {
        String osName = OSInfo.getOSName();
        String archName = OSInfo.getArchName();
    }

    public static int getMajorVersion() {
        String[] c = SnappyLoader.getVersion().split("\\.");
        return c.length > 0 ? Integer.parseInt(c[0]) : 1;
    }

    public static int getMinorVersion() {
        String[] c = SnappyLoader.getVersion().split("\\.");
        return c.length > 1 ? Integer.parseInt(c[1]) : 0;
    }

    public static String getVersion() {
        URL versionFile = SnappyLoader.class.getResource("/META-INF/maven/org.xerial.snappy/snappy-java/pom.properties");
        if (versionFile == null) {
            versionFile = SnappyLoader.class.getResource("/org/xerial/snappy/VERSION");
        }
        String version = "unknown";
        try {
            if (versionFile != null) {
                Properties versionData = new Properties();
                versionData.load(versionFile.openStream());
                version = versionData.getProperty("version", version);
                if (version.equals("unknown")) {
                    version = versionData.getProperty("VERSION", version);
                }
                version = version.trim().replaceAll("[^0-9\\.]", "");
            }
        }
        catch (IOException e) {
            System.err.println(e);
        }
        return version;
    }
}

