/*
 * Decompiled with CFR 0.152.
 */
package org.igoweb.igoweb.client.swing;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.StringTokenizer;
import java.util.TimeZone;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.UIManager;
import javax.swing.text.JTextComponent;
import org.igoweb.igoweb.Config;
import org.igoweb.igoweb.client.CArchive;
import org.igoweb.igoweb.client.CDetailsChannel;
import org.igoweb.igoweb.client.CRoom;
import org.igoweb.igoweb.client.Client;
import org.igoweb.igoweb.client.swing.EditTagDialog;
import org.igoweb.igoweb.client.swing.GameSummaryRenderer;
import org.igoweb.igoweb.client.swing.GuiClientUtil;
import org.igoweb.igoweb.client.swing.RoomSubmenu;
import org.igoweb.igoweb.shared.GameSummary;
import org.igoweb.igoweb.shared.IBundle;
import org.igoweb.igoweb.shared.User;
import org.igoweb.igoweb.shared.swing.RankGraph;
import org.igoweb.util.Event;
import org.igoweb.util.EventListener;
import org.igoweb.util.swing.AFrame;
import org.igoweb.util.swing.AList;
import org.igoweb.util.swing.APopupMenu;
import org.igoweb.util.swing.ATextField;
import org.igoweb.util.swing.AutolinkTextPane;
import org.igoweb.util.swing.DFrame;
import org.igoweb.util.swing.Defs;
import org.igoweb.util.swing.Errout;
import org.igoweb.util.swing.GCLayout;
import org.igoweb.util.swing.HorizBar;
import org.igoweb.util.swing.ImageViewer;
import org.igoweb.util.swing.MsgOut;
import org.igoweb.util.swing.Prefs;
import org.igoweb.util.swing.SingletonWindow;
import org.igoweb.util.swing.SortedListModel;

public abstract class ViewUserWindow
extends DFrame
implements Runnable,
ActionListener,
ItemListener,
EventListener {
    private boolean editing;
    private boolean canEdit = false;
    private final CDetailsChannel details;
    public static final String RATED_ONLY_PREF = "^sX>,]Rd";
    private boolean ratedGamesOnly = Prefs.getBoolean("^sX>,]Rd", false);
    private final JPasswordField passwordIn;
    private final JPasswordField password2In;
    private final ATextField realNameIn;
    private final ATextField emailIn;
    private final ATextField rankOut;
    private final ATextField regDateOut;
    private final ATextField loginDateOut;
    private final ATextField subscribeDateOut;
    private final RankGraph rankGraph;
    private final Client client;
    private final AutolinkTextPane infoIn;
    private final CardLayout userAuthLayout = new CardLayout();
    private final JComboBox<String> userAuthCombo = new JComboBox();
    private final JLabel userAuthLabel = new JLabel("", 0);
    private final JCheckBox rankWanted;
    private final JCheckBox rankForcedOff;
    private JCheckBox[] friendsGroupIn;
    private final JCheckBox emailPrivateIn;
    private String origRankString;
    private final APopupMenu archiveMenu = new ArchivePop();
    private boolean menuOnTagList;
    private final JRadioButtonMenuItem sortByDateMI;
    private final JRadioButtonMenuItem sortByOppMI;
    private final JMenuItem joinGameMI;
    private final JComboBox<String> wantsEmail;
    private final JMenuItem visitPageMI;
    private final JMenuItem editTagMI;
    private final JMenuItem adminClearTagMI;
    private final RoomSubmenu loadMI;
    private final RoomSubmenu loadPrivateMI;
    private final SortedListModel<GameSummary<?>> archiveList;
    private final SortedListModel<GameSummary<?>> tagArchiveList;
    private final GameSummaryRenderer tagRenderer;
    private final GameSummary.Comparator archiveComparator;
    private final GameSummary.Comparator tagArchiveComparator;
    private final ImageViewer userPic;
    private CArchive archive;
    private CArchive tagArchive;
    private AList tagListWidget;
    private boolean disposed;
    private JButton closeBut;
    private JButton forceCloseBut;
    private JButton editBut;
    private JButton applyBut;
    private JButton applyBut2;
    private SingletonWindow confirmCloseWindow = new SingletonWindow();
    final MouseAdapter mouseListener = new MouseAdapter(){

        @Override
        public void mouseClicked(MouseEvent event) {
            ViewUserWindow.this.emailIn.setText(ViewUserWindow.this.details.getPersonalEmail());
            if (ViewUserWindow.this.editing) {
                ViewUserWindow.this.emailIn.setEnabled(true);
            }
        }
    };

    public ViewUserWindow(CDetailsChannel newDetails, AFrame parent, Client newClient) {
        super(Defs.getString(newDetails.isMe() && !newDetails.owner.isGuest() ? -903340749 : (newClient.getMe().getAuthLevel() >= 4 ? -903340556 : -903340553), newDetails.owner.name), parent);
        int i;
        this.details = newDetails;
        this.client = newClient;
        ButtonGroup sorts = new ButtonGroup();
        this.sortByOppMI = new JRadioButtonMenuItem(Defs.getString(-903340595));
        sorts.add(this.sortByOppMI);
        this.sortByDateMI = new JRadioButtonMenuItem(Defs.getString(-903340596));
        sorts.add(this.sortByDateMI);
        newDetails.addListener(this);
        User owner = newDetails.owner;
        owner.addListener(this);
        this.archiveComparator = new GameSummary.Comparator(owner);
        this.tagArchiveComparator = new GameSummary.Comparator();
        this.sortByOppMI.addActionListener(this);
        this.sortByDateMI.addActionListener(this);
        this.archiveList = new SortedListModel(this.archiveComparator);
        this.tagArchiveList = new SortedListModel(this.tagArchiveComparator);
        User me = newClient.getMe();
        boolean bl = this.editing = newDetails.isMe() && !me.isGuest();
        this.canEdit = this.editing ? false : me.getAuthLevel() >= 4;
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                ViewUserWindow.this.closePressed();
            }
        });
        GuiClientUtil.addToWindowList(newClient, this);
        JTabbedPane tabPane = new JTabbedPane();
        this.setMainPanel(tabPane);
        tabPane.addChangeListener(event -> this.handleTabPaneChange(tabPane.getSelectedIndex()));
        JPanel outerPanel = new JPanel(new GCLayout());
        tabPane.add(Defs.getString(-903340679), outerPanel);
        JPanel p1 = new JPanel(new GCLayout());
        outerPanel.add("x=0,xSpan=1,xGrow=t,yGrow=f", p1);
        p1.add("fill=h,yGrow=t", new JLabel(Defs.getString(-903340680)));
        p1.add("xGrow=t", new ATextField(owner.name, 10, false));
        p1.add("x=0,xGrow=f", new JLabel(Defs.getString(-903340634)));
        this.realNameIn = new ATextField("", 15, this.editing);
        p1.add(this.realNameIn);
        if (this.editing || this.canEdit) {
            this.rankForcedOff = new JCheckBox(Defs.getString(-903340462), false);
            if (me.getAuthLevel() >= 4) {
                p1.add("x=0,xSpan=2", this.rankForcedOff);
            }
            this.rankWanted = new JCheckBox(Defs.getString(-903340641), false);
            p1.add("x=0,xSpan=1", this.rankWanted);
            this.rankWanted.setSelected(owner.isRankWanted());
            this.rankWanted.setEnabled(this.editing);
            this.rankWanted.addItemListener(this);
            this.rankWanted.setToolTipText(Defs.getString(-903340780));
        } else {
            p1.add("x=0", new JLabel(Defs.getString(-903340641)));
            this.rankWanted = null;
            this.rankForcedOff = null;
        }
        this.origRankString = IBundle.get().formatRank(owner.getRank(), owner.isRankWanted(), owner.isRankConfident());
        this.rankOut = new ATextField(this.origRankString, 5, false);
        p1.add(this.rankOut);
        JPanel subPanel = new JPanel(this.userAuthLayout);
        subPanel.add((Component)this.userAuthLabel, "");
        subPanel.add(this.userAuthCombo, "x=0");
        for (int i2 = 0; i2 < (me.getAuthLevel() == 5 ? 6 : 4); ++i2) {
            this.userAuthCombo.addItem(Defs.getString(862961687 + i2));
        }
        p1.add("x=0,xSpan=2", subPanel);
        if ((me.getAuthLevel() == 5 || me.getAuthLevel() == 4 && owner.getAuthLevel() == 3) && !owner.isGuest()) {
            this.userAuthLayout.last(subPanel);
            this.userAuthCombo.setSelectedIndex(owner.getAuthLevel());
            this.userAuthCombo.setEditable(false);
            this.userAuthCombo.setEnabled(newDetails.isMe());
        } else {
            this.userAuthLabel.setText(Defs.getString(owner.isGuest() ? -903340715 : 862961687 + owner.getAuthLevel()));
            this.userAuthLayout.first(subPanel);
            this.userAuthCombo.setEnabled(false);
        }
        p1.add("x=0,xSpan=1", new JLabel(Defs.getString(-903340629)));
        this.regDateOut = new ATextField("", 20, false);
        p1.add(this.regDateOut);
        JPanel p2 = new JPanel(new GCLayout());
        outerPanel.add(p2);
        if (this.editing || this.canEdit) {
            p2.add("xGrow=f,yGrow=t,fill=h", new JLabel(Defs.getString(-903340650)));
            this.passwordIn = new JPasswordField(10);
            p2.add("xGrow=t", this.passwordIn);
            p2.add("x=0,xGrow=f", new JLabel(Defs.getString(-903340649)));
            this.password2In = new JPasswordField(10);
            p2.add(this.password2In);
            if (!this.editing) {
                this.passwordIn.setEditable(false);
                this.passwordIn.setBackground(UIManager.getColor("org.igoweb.outputBg"));
                this.password2In.setEditable(false);
                this.password2In.setBackground(UIManager.getColor("org.igoweb.outputBg"));
            }
            p2.add("x=0,xSpan=2,yGrow=f", new HorizBar());
            p2.add("x=0,xGrow=f,xSpan=1,yGrow=t,fill=h", new JLabel(Defs.getString(-903340747)));
        } else {
            this.passwordIn = null;
            this.password2In = null;
            p2.add("x=0,xGrow=f,xSpan=1,yGrow=t,fill=h", new JLabel(Defs.getString(-903340747)));
        }
        this.emailIn = new ATextField("", 15, this.editing);
        p2.add("xGrow=t", this.emailIn);
        if (this.editing || this.canEdit) {
            p2.add("x=0,xGrow=f", new JLabel(Defs.getString(-903340607)));
            this.wantsEmail = new JComboBox<String>(new String[]{Defs.getString(-903340675), Defs.getString(-903340711)});
            p2.add(this.wantsEmail);
            this.wantsEmail.setEditable(false);
            this.wantsEmail.setOpaque(false);
            this.emailPrivateIn = new JCheckBox(Defs.getString(-903340714));
            p2.add("x=0,xSpan=2", this.emailPrivateIn);
            if (!this.editing) {
                this.wantsEmail.setEnabled(false);
                this.emailPrivateIn.setEnabled(false);
            }
        } else {
            this.wantsEmail = null;
            this.emailPrivateIn = null;
        }
        p2.add("x=0,xGrow=f,xSpan=1", new JLabel(Defs.getString(-903340638)));
        p2.add(new JLabel(newDetails.getLocale().getDisplayName()));
        if (newDetails.getSubscriptions() != null) {
            p2.add("x=0,xGrow=f,xSpan=1", new JLabel(Defs.getString(-903340699)));
            this.subscribeDateOut = new ATextField("", 20, false);
            p2.add(this.subscribeDateOut);
        } else if (owner.isSubscribed()) {
            this.subscribeDateOut = null;
            p2.add("x=0,xGrow=f,xSpan=2", new JLabel(Defs.getString(-903340472), 0));
        } else {
            this.subscribeDateOut = null;
        }
        JPanel p = newDetails.isMe() ? p1 : p2;
        p.add("x=0,yGrow=f,xSpan=1", new JLabel(Defs.getString(-903340705)));
        this.loginDateOut = new ATextField("", 15, false);
        p.add(this.loginDateOut);
        if (!newDetails.isMe()) {
            JPanel subP = new JPanel(new GridLayout(1, 3));
            p.add("x=0,xSpan=2", subP);
            this.friendsGroupIn = new JCheckBox[3];
            i = 0;
            while (i < 3) {
                JCheckBox cbox;
                this.friendsGroupIn[i] = cbox = new JCheckBox(Defs.getString(-1219405872 + i));
                subP.add(cbox);
                int type = i++;
                cbox.addActionListener(event -> {
                    if (cbox.isSelected()) {
                        newClient.addFriend(type, owner.name, "");
                    } else {
                        newClient.removeFriend(type, owner.name);
                    }
                });
            }
        }
        p = new JPanel(new GCLayout());
        p.add("xGrow=t,yGrow=f", new JLabel(Defs.getString(-903340672)));
        if (newDetails.owner.isAvatar()) {
            this.userPic = new ImageViewer(141, 200);
            p.add("xGrow=f,ySpan=2", this.userPic);
            GuiClientUtil.get(newClient).getUserPic(owner, this.getToolkit(), this.userPic);
        } else {
            this.userPic = null;
        }
        this.infoIn = new AutolinkTextPane();
        JScrollPane infoScroller = new JScrollPane(this.infoIn, 20, 31);
        infoScroller.setName("infoScroller");
        p.add("yGrow=t,x=0,ySpan=1,sz=0", infoScroller);
        this.infoIn.setBackground(UIManager.getColor(this.editing ? "org.igoweb.inputBg" : "org.igoweb.outputBg"));
        this.infoIn.setEditable(this.editing);
        if (this.editing) {
            this.infoIn.setText(newDetails.getPersonalInfo());
        }
        outerPanel.add("x=0,xSpan=2,xGrow=t,yGrow=t", p);
        this.tagRenderer = this.buildGameSummaryRenderer();
        for (i = 0; i < 2; ++i) {
            p = new JPanel(i == 0 ? new GCLayout() : new BorderLayout());
            tabPane.add(Defs.getString(i == 0 ? -903340723 : -903340727), p);
            p.setBorder(BorderFactory.createEmptyBorder(2, 0, 0, 0));
            JLabel label = new JLabel(Defs.getString(i == 0 ? -903340722 : -903340806));
            label.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 0));
            p.add(i == 0 ? "xGrow=t" : "North", label);
            if (i == 0) {
                JComboBox<String> showGameTypes = new JComboBox<String>();
                showGameTypes.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, 0, 0, 2), showGameTypes.getBorder()));
                p.add("xGrow=f", showGameTypes);
                StringTokenizer combos = new StringTokenizer(Defs.getString(-903340600), "|");
                while (combos.hasMoreElements()) {
                    showGameTypes.addItem(combos.nextToken());
                }
                showGameTypes.addActionListener(event -> this.updateArchiveListFilter(((JComboBox)event.getSource()).getSelectedIndex() == 1));
                showGameTypes.setSelectedIndex(this.ratedGamesOnly ? 1 : 0);
            }
            AList list = new AList(i == 0 ? this.buildGameSummaryRenderer() : this.tagRenderer, 3, event -> this.joinGame((GameSummary)event.arg), i == 0 ? this.archiveList : this.tagArchiveList, false);
            if (i == 1) {
                this.tagListWidget = list;
            }
            p.add(i == 0 ? "x=0,yGrow=t,xSpan=2" : "Center", list);
            if (i != 0) {
                list.setHorizontalScrollBarPolicy(30);
            }
            list.addPopup(this.archiveMenu);
        }
        this.rankGraph = new RankGraph(owner.name, this, IBundle.get());
        tabPane.add(Defs.getString(-903340642), this.rankGraph);
        if (this.editing) {
            this.applyBut = this.addButton(Defs.getString(1436228518), this);
            this.closeBut = this.addButton(Defs.getString(1436228510), this);
        } else {
            if (this.canEdit) {
                this.editBut = this.addButton(Defs.getString(-903340751), this);
            }
            this.closeBut = this.addButton(Defs.getString(1436228518), this);
        }
        this.joinGameMI = new JMenuItem(Defs.getString(-903340708));
        this.joinGameMI.addActionListener(this);
        this.visitPageMI = Defs.isApp() ? new JMenuItem(Defs.getString(-903340771)) : new JMenuItem(Defs.getString(-903340552));
        this.visitPageMI.addActionListener(this);
        EventListener loadListener = event -> this.loadArchive((CRoom)event.source, (GameSummary)event.arg, event.type == 1);
        this.loadMI = new RoomSubmenu(Defs.getString(-903340703), newClient, 10, loadListener, 0, null);
        this.loadPrivateMI = new RoomSubmenu(Defs.getString(-903340702), newClient, -5, loadListener, 1, null);
        this.archiveMenu.add(this.joinGameMI);
        this.archiveMenu.add(this.visitPageMI);
        this.archiveMenu.add(this.loadMI);
        this.archiveMenu.add(this.loadPrivateMI);
        this.archiveMenu.addSeparator();
        if (!newClient.getMe().isGuest()) {
            this.editTagMI = new JMenuItem(Defs.getString(-903340611));
            this.editTagMI.addActionListener(this);
            this.archiveMenu.add(this.editTagMI);
            if (newClient.getMe().getAuthLevel() >= 4 && !owner.equals(newClient.getMe())) {
                this.adminClearTagMI = new JMenuItem(Defs.getString(-903340610, owner.name));
                this.adminClearTagMI.addActionListener(this);
                this.archiveMenu.add(this.adminClearTagMI);
            } else {
                this.adminClearTagMI = null;
            }
            this.archiveMenu.addSeparator();
        } else {
            this.editTagMI = null;
            this.adminClearTagMI = null;
        }
        this.archiveMenu.add(this.sortByDateMI);
        this.archiveMenu.add(this.sortByOppMI);
        this.updateDetails();
        this.updateOwner();
        this.pack(parent);
        this.setVisible(true);
    }

    @Override
    public void handleEvent(Event event) {
        switch (event.type) {
            case 33: {
                this.toFront();
                break;
            }
            case 32: {
                this.updateDetails();
                break;
            }
            case 35: {
                CArchive arch = (CArchive)event.source;
                if (this.disposed) {
                    arch.removeListener(this);
                    break;
                }
                if (arch.isTagArchive()) {
                    this.tagArchive = arch;
                    this.tagRenderer.setTags(arch.getTags());
                    this.tagArchiveList.setAndSort(arch.getGames());
                    break;
                }
                this.archive = arch;
                this.updateArchiveListFilter(this.ratedGamesOnly);
                break;
            }
            case 36: {
                this.newGame(event.source == this.tagArchive, (GameSummary)event.arg);
                break;
            }
            case 37: {
                SortedListModel<GameSummary<?>> listModel = event.source == this.archive ? this.archiveList : this.tagArchiveList;
                listModel.remove(event.arg);
                break;
            }
            case 0: {
                if (this.editing) break;
                this.updateOwner();
                break;
            }
            case 6: 
            case 7: {
                for (int i = 0; i < 3; ++i) {
                    this.friendsGroupIn[i].setSelected(this.client.getFriendsGroup(i).contains(this.details.owner));
                }
                break;
            }
            case 34: {
                this.rankGraph.setData((short[])event.arg);
            }
        }
    }

    @Override
    public Dimension getDefaultPreferredSize() {
        Dimension size = super.getDefaultPreferredSize();
        Insets insets = this.getInsets();
        int adjWidth = (size.width - (insets.left + insets.right)) * 3 / 4 + (insets.top + insets.bottom);
        if (size.height < adjWidth) {
            size.height = adjWidth;
        }
        return size;
    }

    private void newGame(boolean taggedList, GameSummary<?> game) {
        if (taggedList) {
            this.tagArchiveList.add(game);
        } else if (!this.ratedGamesOnly || game.getGameType().isRanked()) {
            this.archiveList.add(game);
        }
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source == this.joinGameMI) {
            this.joinGame((GameSummary)this.archiveMenu.getTarget());
        } else if (source == this.visitPageMI) {
            this.loadArchivePage((GameSummary)this.archiveMenu.getTarget());
        } else if (source == this.sortByDateMI) {
            if (this.menuOnTagList) {
                this.tagArchiveComparator.setSortType(0);
                this.tagArchiveList.sortNow();
            } else {
                this.archiveComparator.setSortType(0);
                this.archiveList.sortNow();
            }
        } else if (source == this.sortByOppMI) {
            if (this.menuOnTagList) {
                this.tagArchiveComparator.setSortType(1);
                this.tagArchiveList.sortNow();
            } else {
                this.archiveComparator.setSortType(1);
                this.archiveList.sortNow();
            }
        } else if (source == this.editBut) {
            this.canEdit = false;
            this.editing = true;
            JTextComponent[] tComps = this.passwordIn == null ? new JTextComponent[]{this.realNameIn, this.emailIn, this.infoIn} : new JTextComponent[]{this.passwordIn, this.password2In, this.realNameIn, this.emailIn, this.infoIn};
            for (JTextComponent tComp : tComps) {
                tComp.setEditable(true);
                tComp.setBackground(UIManager.getColor("org.igoweb.inputBg"));
            }
            this.infoIn.setText(this.details.getPersonalInfo());
            if (this.emailIn.getText().equals(Defs.getString(-903340644))) {
                this.emailIn.setEnabled(false);
            }
            this.rankWanted.setEnabled(true);
            this.wantsEmail.setEnabled(true);
            this.emailPrivateIn.setEnabled(true);
            this.userAuthCombo.setEnabled(true);
            this.rankForcedOff.setEnabled(true);
            this.applyBut = this.editBut;
            this.editBut = null;
            this.applyBut.setText(Defs.getString(1436228518));
            this.closeBut.setText(Defs.getString(1436228510));
        } else if (source == this.applyBut || source == this.applyBut2) {
            if (this.isDataValid()) {
                this.sendChanges();
                this.dispose();
            }
        } else if (source == this.closeBut) {
            this.closePressed();
        } else if (source == this.forceCloseBut) {
            this.dispose();
        } else if (source == this.editTagMI) {
            new EditTagDialog(this, (GameSummary)this.archiveMenu.getTarget(), this.client);
        } else if (source == this.adminClearTagMI && this.tagArchive != null) {
            this.tagArchive.adminClearTag((GameSummary)this.archiveMenu.getTarget());
        }
    }

    @Override
    public void itemStateChanged(ItemEvent event) {
        if (this.rankWanted.isSelected()) {
            this.rankOut.setText(this.origRankString);
        } else {
            this.rankOut.setText("-");
        }
    }

    private void updateOwner() {
        User owner = this.details.owner;
        if (this.rankWanted != null) {
            this.rankWanted.setSelected(owner.isRankWanted());
            this.rankForcedOff.setSelected(this.details.isForcedNoRank());
        }
        this.rankOut.setText(IBundle.get().formatRank(owner.getRank(), owner.isRankWanted(), owner.isRankConfident()));
        if (owner.getAuthLevel() < this.userAuthCombo.getItemCount()) {
            this.userAuthCombo.setSelectedIndex(owner.getAuthLevel());
        }
        int newText = owner.isDeleted() ? -903340661 : (owner.isGuest() ? -903340715 : 862961687 + owner.getAuthLevel());
        this.userAuthLabel.setText(Defs.getString(newText));
        Container parent = this.userAuthLabel.getParent();
        User me = this.client.getMe();
        if ((me.getAuthLevel() == 5 || me.getAuthLevel() == 4 && owner.getAuthLevel() == 3) && !owner.isGuest()) {
            this.userAuthLayout.last(parent);
            this.userAuthCombo.setEnabled(this.editing);
        } else {
            this.userAuthLayout.first(parent);
            this.userAuthCombo.setEnabled(false);
        }
        this.updateLastOn();
    }

    private void updateDetails() {
        this.realNameIn.setText(this.details.getPersonalName());
        if (this.details.isEmailPrivate() && !this.details.isMe()) {
            this.emailIn.setText(Defs.getString(-903340644));
            if (this.client.getMe().getAuthLevel() >= 4) {
                this.emailIn.setToolTipText(this.details.getPersonalEmail());
                this.emailIn.addMouseListener(this.mouseListener);
            }
        } else {
            this.emailIn.setText(this.details.getPersonalEmail());
        }
        this.infoIn.setText(this.details.getPersonalInfo());
        this.infoIn.setCaretPosition(0);
        if (this.regDateOut != null) {
            this.regDateOut.setText(this.details.owner.isGuest() ? "-" : DateFormat.getDateInstance(2).format(this.details.getRegistrationStart()));
        }
        if (this.subscribeDateOut != null) {
            long end = this.details.getSubscriptions() == null ? 0L : this.details.getSubscriptions()[this.details.getSubscriptions().length - 1].end;
            this.subscribeDateOut.setText(end < System.currentTimeMillis() ? "-" : DateFormat.getDateInstance(2).format(new Date(this.details.getSubscriptions()[this.details.getSubscriptions().length - 1].end)));
        }
        if (this.wantsEmail != null) {
            this.wantsEmail.setSelectedIndex(this.details.isEmailWanted() ? 1 : 0);
            this.emailPrivateIn.setSelected(this.details.isEmailPrivate());
        }
        this.updateLastOn();
    }

    private void updateLastOn() {
        if (this.loginDateOut != null) {
            if (this.details.owner.isConnected()) {
                if (this.details.owner.isSleeping()) {
                    this.loginDateOut.setText(Defs.getString(-903340668));
                } else {
                    this.loginDateOut.setText(Defs.getString(-903340669));
                }
            } else {
                this.loginDateOut.setText(DateFormat.getDateTimeInstance(2, 3).format(this.details.getLastOn()));
            }
        }
    }

    public void joinGame(GameSummary<?> game) {
        if (game.isInPlay()) {
            this.client.sendJoinRequest(game.id);
        } else {
            Defs.ringBell();
        }
    }

    private static boolean emailOk(String email) {
        if (email.indexOf(32) != -1) {
            return false;
        }
        int atPos = email.indexOf(64);
        return atPos != -1 && email.indexOf(46, atPos) >= atPos + 2;
    }

    protected abstract GameSummaryRenderer buildGameSummaryRenderer();

    private void loadArchive(CRoom room, GameSummary<?> gsum, boolean isPrivate) {
        if (gsum.isPrivate() && !isPrivate) {
            new MsgOut(Defs.getString(-903340547), Defs.getString(-903340804), 2, (Component)this, new String[]{Defs.getString(1436228510), Defs.getString(1436228518)}, event -> {
                if (Defs.getString(1436228518).equals(event.getActionCommand())) {
                    room.requestLoadGame(gsum.id, false);
                }
            });
        } else {
            room.requestLoadGame(gsum.id, isPrivate);
        }
    }

    private void updateArchiveListFilter(boolean ratedOnly) {
        this.ratedGamesOnly = ratedOnly;
        Prefs.putBoolean(RATED_ONLY_PREF, ratedOnly);
        if (this.archive == null) {
            this.archiveList.clear();
            return;
        }
        if (ratedOnly) {
            ArrayList tmpList = new ArrayList();
            for (GameSummary<?> game : this.archive.getGames()) {
                if (!game.getGameType().isRanked()) continue;
                tmpList.add(game);
            }
            this.archiveList.setAndSort(tmpList);
        } else {
            this.archiveList.setAndSort(this.archive.getGames());
        }
    }

    public static boolean isDataValid(String realName, String email, String info, boolean isAdmin) {
        if (realName != null && realName.length() > 50) {
            new Errout(Defs.getString(-903340710, new Object[]{0, 50}));
            return false;
        }
        if (email != null && email.length() > 70) {
            new Errout(Defs.getString(-903340710, new Object[]{1, 70}));
            return false;
        }
        if (info != null && info.length() > 1500) {
            new Errout(Defs.getString(-903340710, new Object[]{2, 1500}));
            return false;
        }
        if (email != null && !isAdmin && !ViewUserWindow.emailOk(email.trim())) {
            new Errout(Defs.getString(-903340800));
            return false;
        }
        return true;
    }

    private void handleTabPaneChange(int selectedTab) {
        if (selectedTab == 1) {
            if (this.archive == null) {
                this.client.requestArchive(this.details.owner.name, this);
            }
        } else if (selectedTab == 2 && this.tagArchive == null) {
            this.client.requestTagArchive(this.details.owner.name, this);
        }
    }

    private void loadArchivePage(GameSummary<?> game) {
        if (Defs.isApp()) {
            GuiClientUtil.get(this.client).download(this, "games/", game.getFileName());
        } else {
            GregorianCalendar cal = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
            cal.setTime(new Date(game.id));
            Defs.loadWebPage("http://" + Config.get("webHost") + "/gameArchives.jsp?user=" + this.details.owner.name + "&y=" + cal.get(1) + "&m=" + (cal.get(2) + 1 - cal.getMinimum(2)), false);
        }
    }

    @Override
    protected String getSavePositionPref() {
        return "E\\iDYA'E";
    }

    @Override
    public void dispose() {
        this.disposed = true;
        this.details.sendUnjoinRequest();
        this.details.removeListener(this);
        this.details.owner.removeListener(this);
        if (this.archive != null) {
            this.archive.removeListener(this);
        }
        if (this.tagArchive != null) {
            this.tagArchive.removeListener(this);
        }
        super.dispose();
    }

    @Override
    public void addNotify() {
        if (this.friendsGroupIn != null) {
            for (int i = 0; i < 3; ++i) {
                this.client.getFriendsGroup(i).addListener(this);
            }
            this.handleEvent(new Event(null, 6, null));
        }
        super.addNotify();
    }

    @Override
    public void removeNotify() {
        for (int i = 0; i < 3; ++i) {
            this.client.getFriendsGroup(i).removeListener(this);
        }
        super.removeNotify();
    }

    private boolean isDataChanged() {
        return this.passwordIn.getPassword().length > 0 || this.password2In.getPassword().length > 0 || this.details.isDataChanged(this.realNameIn.getText(), this.rankWanted.isSelected(), this.emailIn.isEnabled() ? this.emailIn.getText() : this.details.getPersonalEmail(), this.emailPrivateIn.isSelected(), this.wantsEmail.getSelectedIndex() == 1, this.infoIn.getText(), this.rankForcedOff.isSelected(), this.userAuthCombo.isEnabled() ? this.userAuthCombo.getSelectedIndex() : this.details.owner.getAuthLevel());
    }

    private boolean isDataValid() {
        if (this.passwordIn != null) {
            String p1 = new String(this.passwordIn.getPassword());
            String p2 = new String(this.password2In.getPassword());
            if (!(p1.isEmpty() && p2.isEmpty() || p1.equals(p2))) {
                new Errout(Defs.getString(-903340648), this);
                return false;
            }
        }
        return ViewUserWindow.isDataValid(this.realNameIn.getText(), this.emailIn.isEnabled() ? this.emailIn.getText() : null, this.infoIn.getText(), this.client.getMe().getAuthLevel() >= 4);
    }

    private void sendChanges() {
        if (this.passwordIn.getPassword().length > 0) {
            this.client.sendSetPassword(this.details.owner.name, new String(this.passwordIn.getPassword()));
        }
        this.details.sendChanges(this.realNameIn.getText(), this.rankWanted.isSelected(), this.emailIn.isEnabled() ? this.emailIn.getText() : this.details.getPersonalEmail(), this.emailPrivateIn.isSelected(), this.wantsEmail.getSelectedIndex() == 1, this.infoIn.getText(), this.rankForcedOff.isSelected(), this.userAuthCombo.isEnabled() ? this.userAuthCombo.getSelectedIndex() : this.details.owner.getAuthLevel());
    }

    private void closePressed() {
        if (!this.infoIn.isEditable()) {
            this.dispose();
            return;
        }
        if (this.isDataChanged()) {
            MsgOut confirm = new MsgOut(Defs.getString(-903340547), Defs.getString(-903340784), 2, (Component)this, new String[]{Defs.getString(-903340614), Defs.getString(-903340613)}, null);
            this.confirmCloseWindow.setWindow(confirm);
            this.applyBut2 = confirm.getButton(0);
            this.applyBut2.addActionListener(this);
            this.forceCloseBut = confirm.getButton(1);
            this.forceCloseBut.addActionListener(this);
        } else {
            this.dispose();
        }
    }

    @Override
    public void run() {
        short[] data = this.details.requestRankGraphData();
        if (data != null) {
            this.rankGraph.setData(data);
        }
    }

    private class ArchivePop
    extends APopupMenu {
        @Override
        public void show(Component comp, int x, int y, Object popupSource) {
            GameSummary game = (GameSummary)popupSource;
            ViewUserWindow.this.menuOnTagList = comp == ViewUserWindow.this.tagListWidget.getInnerList();
            int label = game == null ? -903340728 : (game.isInPlay() ? -903340730 : (game.isPrivate() ? -903340729 : (game.isFinished() ? -903340728 : -903340731)));
            ViewUserWindow.this.visitPageMI.setEnabled(game != null && !game.isPrivate());
            if (ViewUserWindow.this.editTagMI != null) {
                ViewUserWindow.this.editTagMI.setEnabled(game != null);
            }
            if (ViewUserWindow.this.adminClearTagMI != null) {
                ViewUserWindow.this.adminClearTagMI.setEnabled(game != null && ViewUserWindow.this.menuOnTagList);
            }
            this.setLabel(Defs.getString(label));
            GameSummary.Comparator comparator = ViewUserWindow.this.menuOnTagList ? ViewUserWindow.this.tagArchiveComparator : ViewUserWindow.this.archiveComparator;
            (comparator.getSortType() == 0 ? ViewUserWindow.this.sortByDateMI : ViewUserWindow.this.sortByOppMI).setSelected(true);
            User me = ViewUserWindow.this.client.getMe();
            boolean hiddenFromMe = game == null || game.isPrivate() && !game.getGameType().isMainRole(game.getRole(me.name));
            ViewUserWindow.this.joinGameMI.setEnabled(!hiddenFromMe && game.isInPlay());
            ViewUserWindow.this.visitPageMI.setEnabled(game != null && !game.isPrivate());
            boolean canLoad = !hiddenFromMe && !game.isInPlay() && (!game.getGameType().isTournament() || game.isFinished());
            ViewUserWindow.this.loadMI.setEnabled(canLoad);
            if (game != null) {
                ViewUserWindow.this.loadMI.setEventArg(game);
            }
            ViewUserWindow.this.loadPrivateMI.setEnabled(canLoad && (!game.getGameType().isRanked() || game.isFinished()));
            if (game != null) {
                ViewUserWindow.this.loadPrivateMI.setEventArg(game);
            }
            super.show(comp, x, y, popupSource);
        }
    }
}

