/*
 * Decompiled with CFR 0.152.
 */
package org.igoweb.util.swing;

import java.awt.Desktop;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JTextPane;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;

public class AutolinkTextPane
extends JTextPane {
    private static final Substitution LINK_SUB = new Substitution("https?://[^\\s\u00a0]+"){

        @Override
        public String getText(Matcher m) {
            return m.group(0);
        }

        @Override
        public AttributeSet getStyle(AttributeSet attrs) {
            SimpleAttributeSet unders = new SimpleAttributeSet(attrs);
            StyleConstants.setUnderline(unders, true);
            return unders;
        }
    };
    private static final GregorianCalendar DEFAULT_CAL = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
    public static final Substitution GMT_SUB = new Substitution("<gmt>(\\d{4})-(\\d?\\d)-(\\d?\\d) (\\d?\\d):(\\d\\d)</gmt>"){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String getText(Matcher m) {
            GregorianCalendar gregorianCalendar = DEFAULT_CAL;
            synchronized (gregorianCalendar) {
                DEFAULT_CAL.set(Integer.parseInt(m.group(1)), Integer.parseInt(m.group(2)) - 1 + 0, Integer.parseInt(m.group(3)), Integer.parseInt(m.group(4)), Integer.parseInt(m.group(5)), 0);
                return DateFormat.getDateTimeInstance(3, 3).format(DEFAULT_CAL.getTime());
            }
        }

        @Override
        public AttributeSet getStyle(AttributeSet attrs) {
            SimpleAttributeSet itals = new SimpleAttributeSet(attrs);
            StyleConstants.setItalic(itals, true);
            return itals;
        }
    };
    private ArrayList<Substitution> subs = new ArrayList();

    public AutolinkTextPane() {
        this.setDocument(new UnderlinerDoc());
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                if (event.getButton() == 1) {
                    AutolinkTextPane.this.handleTextPaneClick(event);
                }
            }
        });
        this.addSubstitution(GMT_SUB);
        this.addSubstitution(LINK_SUB);
    }

    public void addSubstitution(Substitution sub) {
        this.subs.add(sub);
    }

    protected boolean handleTextPaneClick(MouseEvent event) {
        if (this.isEditable()) {
            return false;
        }
        if (event.getClickCount() == 1) {
            String paragraphText;
            Element paragraph;
            DefaultStyledDocument doc = (DefaultStyledDocument)this.getDocument();
            int offset = this.viewToModel(event.getPoint());
            if (offset <= (paragraph = doc.getParagraphElement(offset)).getStartOffset() || offset >= paragraph.getEndOffset()) {
                return false;
            }
            try {
                paragraphText = doc.getText(paragraph.getStartOffset(), paragraph.getEndOffset() - paragraph.getStartOffset());
            }
            catch (BadLocationException excep) {
                throw new RuntimeException(excep.toString());
            }
            offset -= paragraph.getStartOffset();
            Matcher m = LINK_SUB.pat.matcher(paragraphText);
            while (m.find()) {
                if (offset < m.start() || offset >= m.end()) continue;
                try {
                    Desktop.getDesktop().browse(new URL(m.group(0)).toURI());
                    return true;
                }
                catch (MalformedURLException excep) {
                    return false;
                }
                catch (URISyntaxException excep) {
                    return false;
                }
                catch (IOException excep) {
                    return false;
                }
            }
        }
        return false;
    }

    @Override
    public void setEditable(boolean isEditable) {
        if (isEditable && this.getDocument() != null && this.getDocument() instanceof UnderlinerDoc) {
            SimpleAttributeSet clear = new SimpleAttributeSet();
            StyleConstants.setUnderline(clear, false);
            ((UnderlinerDoc)this.getDocument()).setCharacterAttributes(0, this.getDocument().getLength(), clear, false);
        }
        super.setEditable(isEditable);
    }

    @Override
    public void setText(String text) {
        try {
            Document doc = this.getDocument();
            doc.remove(0, doc.getLength());
            if (!text.equals("")) {
                doc.insertString(0, text, new SimpleAttributeSet());
            }
        }
        catch (BadLocationException excep) {
            throw new RuntimeException();
        }
    }

    @Override
    public String getText() {
        String base = super.getText();
        int len = base.length();
        for (int i = 0; i < len; ++i) {
            if (base.charAt(i) != '\r') continue;
            StringBuilder sb = new StringBuilder(base);
            sb.deleteCharAt(i);
            while (i < sb.length()) {
                if (sb.charAt(i) == '\r') {
                    sb.deleteCharAt(i);
                    continue;
                }
                ++i;
            }
            return sb.toString();
        }
        return base;
    }

    public static abstract class Substitution {
        private final Pattern pat;

        public Substitution(String pattern) {
            this.pat = Pattern.compile(pattern);
        }

        public abstract String getText(Matcher var1);

        public AttributeSet getStyle(AttributeSet attrs) {
            return attrs;
        }
    }

    private class UnderlinerDoc
    extends DefaultStyledDocument {
        @Override
        public void insertString(int offset, String str, AttributeSet rawInitAttr) throws BadLocationException {
            if (AutolinkTextPane.this.isEditable()) {
                super.insertString(offset, str, rawInitAttr);
                return;
            }
            SimpleAttributeSet initAttr = new SimpleAttributeSet(rawInitAttr);
            StyleConstants.setItalic(initAttr, false);
            StyleConstants.setUnderline(initAttr, false);
            Matcher[] matches = new Matcher[AutolinkTextPane.this.subs.size()];
            for (int i = 0; i < matches.length; ++i) {
                matches[i] = ((Substitution)AutolinkTextPane.this.subs.get(i)).pat.matcher(str);
                if (matches[i].find()) continue;
                matches[i] = null;
            }
            int prevEnd = 0;
            while (true) {
                int bestIndex = -1;
                int bestStart = Integer.MAX_VALUE;
                for (int i = 0; i < matches.length; ++i) {
                    while (matches[i] != null && matches[i].start() < prevEnd) {
                        if (matches[i].find()) continue;
                        matches[i] = null;
                    }
                    if (matches[i] == null || matches[i].start() >= bestStart) continue;
                    bestIndex = i;
                    bestStart = matches[i].start();
                }
                if (bestIndex == -1) break;
                if (bestStart > prevEnd) {
                    String newText = str.substring(prevEnd, bestStart);
                    super.insertString(offset, newText, initAttr);
                    offset += newText.length();
                }
                String newText = ((Substitution)AutolinkTextPane.this.subs.get(bestIndex)).getText(matches[bestIndex]);
                super.insertString(offset, newText, ((Substitution)AutolinkTextPane.this.subs.get(bestIndex)).getStyle(initAttr));
                offset += newText.length();
                prevEnd = matches[bestIndex].end();
            }
            if (prevEnd < str.length()) {
                super.insertString(offset, str.substring(prevEnd), initAttr);
            }
        }
    }
}

