/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.jline.terminal.impl.jansi.freebsd;

import java.io.FileDescriptor;
import java.io.IOException;
import java.util.EnumMap;
import java.util.EnumSet;
import org.jetbrains.kotlin.org.fusesource.jansi.internal.CLibrary;
import org.jetbrains.kotlin.org.jline.terminal.Attributes;
import org.jetbrains.kotlin.org.jline.terminal.Size;
import org.jetbrains.kotlin.org.jline.terminal.impl.jansi.JansiNativePty;

public class FreeBsdNativePty
extends JansiNativePty {
    public static FreeBsdNativePty current() throws IOException {
        try {
            String name2 = FreeBsdNativePty.ttyname();
            return new FreeBsdNativePty(-1, null, 0, FileDescriptor.in, name2);
        }
        catch (IOException e) {
            throw new IOException("Not a tty", e);
        }
    }

    public static FreeBsdNativePty open(Attributes attr, Size size) throws IOException {
        int[] master = new int[1];
        int[] slave = new int[1];
        byte[] buf = new byte[64];
        CLibrary.openpty(master, slave, buf, attr != null ? FreeBsdNativePty.termios(attr) : null, size != null ? new CLibrary.WinSize((short)size.getRows(), (short)size.getColumns()) : null);
        int len = 0;
        while (buf[len] != 0) {
            ++len;
        }
        String name2 = new String(buf, 0, len);
        return new FreeBsdNativePty(master[0], FreeBsdNativePty.newDescriptor(master[0]), slave[0], FreeBsdNativePty.newDescriptor(slave[0]), name2);
    }

    public FreeBsdNativePty(int master, FileDescriptor masterFD, int slave, FileDescriptor slaveFD, String name2) {
        super(master, masterFD, slave, slaveFD, name2);
    }

    @Override
    protected CLibrary.Termios toTermios(Attributes t) {
        return FreeBsdNativePty.termios(t);
    }

    static CLibrary.Termios termios(Attributes t) {
        CLibrary.Termios tio = new CLibrary.Termios();
        tio.c_iflag = FreeBsdNativePty.setFlag(t.getInputFlag(Attributes.InputFlag.IGNBRK), 1L, tio.c_iflag);
        tio.c_iflag = FreeBsdNativePty.setFlag(t.getInputFlag(Attributes.InputFlag.BRKINT), 2L, tio.c_iflag);
        tio.c_iflag = FreeBsdNativePty.setFlag(t.getInputFlag(Attributes.InputFlag.IGNPAR), 4L, tio.c_iflag);
        tio.c_iflag = FreeBsdNativePty.setFlag(t.getInputFlag(Attributes.InputFlag.PARMRK), 8L, tio.c_iflag);
        tio.c_iflag = FreeBsdNativePty.setFlag(t.getInputFlag(Attributes.InputFlag.INPCK), 16L, tio.c_iflag);
        tio.c_iflag = FreeBsdNativePty.setFlag(t.getInputFlag(Attributes.InputFlag.ISTRIP), 32L, tio.c_iflag);
        tio.c_iflag = FreeBsdNativePty.setFlag(t.getInputFlag(Attributes.InputFlag.INLCR), 64L, tio.c_iflag);
        tio.c_iflag = FreeBsdNativePty.setFlag(t.getInputFlag(Attributes.InputFlag.IGNCR), 128L, tio.c_iflag);
        tio.c_iflag = FreeBsdNativePty.setFlag(t.getInputFlag(Attributes.InputFlag.ICRNL), 256L, tio.c_iflag);
        tio.c_iflag = FreeBsdNativePty.setFlag(t.getInputFlag(Attributes.InputFlag.IXON), 512L, tio.c_iflag);
        tio.c_iflag = FreeBsdNativePty.setFlag(t.getInputFlag(Attributes.InputFlag.IXOFF), 1024L, tio.c_iflag);
        tio.c_iflag = FreeBsdNativePty.setFlag(t.getInputFlag(Attributes.InputFlag.IXANY), 2048L, tio.c_iflag);
        tio.c_iflag = FreeBsdNativePty.setFlag(t.getInputFlag(Attributes.InputFlag.IMAXBEL), 8192L, tio.c_iflag);
        tio.c_oflag = FreeBsdNativePty.setFlag(t.getOutputFlag(Attributes.OutputFlag.OPOST), 1L, tio.c_oflag);
        tio.c_oflag = FreeBsdNativePty.setFlag(t.getOutputFlag(Attributes.OutputFlag.ONLCR), 2L, tio.c_oflag);
        tio.c_oflag = FreeBsdNativePty.setFlag(t.getOutputFlag(Attributes.OutputFlag.ONOEOT), 8L, tio.c_oflag);
        tio.c_oflag = FreeBsdNativePty.setFlag(t.getOutputFlag(Attributes.OutputFlag.OCRNL), 16L, tio.c_oflag);
        tio.c_oflag = FreeBsdNativePty.setFlag(t.getOutputFlag(Attributes.OutputFlag.ONLRET), 64L, tio.c_oflag);
        tio.c_oflag = FreeBsdNativePty.setFlag(t.getOutputFlag(Attributes.OutputFlag.TABDLY), 4L, tio.c_oflag);
        tio.c_cflag = FreeBsdNativePty.setFlag(t.getControlFlag(Attributes.ControlFlag.CIGNORE), 1L, tio.c_cflag);
        tio.c_cflag = FreeBsdNativePty.setFlag(t.getControlFlag(Attributes.ControlFlag.CS5), 0L, tio.c_cflag);
        tio.c_cflag = FreeBsdNativePty.setFlag(t.getControlFlag(Attributes.ControlFlag.CS6), 256L, tio.c_cflag);
        tio.c_cflag = FreeBsdNativePty.setFlag(t.getControlFlag(Attributes.ControlFlag.CS7), 512L, tio.c_cflag);
        tio.c_cflag = FreeBsdNativePty.setFlag(t.getControlFlag(Attributes.ControlFlag.CS8), 768L, tio.c_cflag);
        tio.c_cflag = FreeBsdNativePty.setFlag(t.getControlFlag(Attributes.ControlFlag.CSTOPB), 1024L, tio.c_cflag);
        tio.c_cflag = FreeBsdNativePty.setFlag(t.getControlFlag(Attributes.ControlFlag.CREAD), 2048L, tio.c_cflag);
        tio.c_cflag = FreeBsdNativePty.setFlag(t.getControlFlag(Attributes.ControlFlag.PARENB), 4096L, tio.c_cflag);
        tio.c_cflag = FreeBsdNativePty.setFlag(t.getControlFlag(Attributes.ControlFlag.PARODD), 8192L, tio.c_cflag);
        tio.c_cflag = FreeBsdNativePty.setFlag(t.getControlFlag(Attributes.ControlFlag.HUPCL), 16384L, tio.c_cflag);
        tio.c_cflag = FreeBsdNativePty.setFlag(t.getControlFlag(Attributes.ControlFlag.CLOCAL), 32768L, tio.c_cflag);
        tio.c_lflag = FreeBsdNativePty.setFlag(t.getLocalFlag(Attributes.LocalFlag.ECHOKE), 1L, tio.c_lflag);
        tio.c_lflag = FreeBsdNativePty.setFlag(t.getLocalFlag(Attributes.LocalFlag.ECHOE), 2L, tio.c_lflag);
        tio.c_lflag = FreeBsdNativePty.setFlag(t.getLocalFlag(Attributes.LocalFlag.ECHOK), 4L, tio.c_lflag);
        tio.c_lflag = FreeBsdNativePty.setFlag(t.getLocalFlag(Attributes.LocalFlag.ECHO), 8L, tio.c_lflag);
        tio.c_lflag = FreeBsdNativePty.setFlag(t.getLocalFlag(Attributes.LocalFlag.ECHONL), 16L, tio.c_lflag);
        tio.c_lflag = FreeBsdNativePty.setFlag(t.getLocalFlag(Attributes.LocalFlag.ECHOPRT), 32L, tio.c_lflag);
        tio.c_lflag = FreeBsdNativePty.setFlag(t.getLocalFlag(Attributes.LocalFlag.ECHOCTL), 64L, tio.c_lflag);
        tio.c_lflag = FreeBsdNativePty.setFlag(t.getLocalFlag(Attributes.LocalFlag.ISIG), 128L, tio.c_lflag);
        tio.c_lflag = FreeBsdNativePty.setFlag(t.getLocalFlag(Attributes.LocalFlag.ICANON), 256L, tio.c_lflag);
        tio.c_lflag = FreeBsdNativePty.setFlag(t.getLocalFlag(Attributes.LocalFlag.ALTWERASE), 512L, tio.c_lflag);
        tio.c_lflag = FreeBsdNativePty.setFlag(t.getLocalFlag(Attributes.LocalFlag.IEXTEN), 1024L, tio.c_lflag);
        tio.c_lflag = FreeBsdNativePty.setFlag(t.getLocalFlag(Attributes.LocalFlag.EXTPROC), 2048L, tio.c_lflag);
        tio.c_lflag = FreeBsdNativePty.setFlag(t.getLocalFlag(Attributes.LocalFlag.TOSTOP), 0x400000L, tio.c_lflag);
        tio.c_lflag = FreeBsdNativePty.setFlag(t.getLocalFlag(Attributes.LocalFlag.FLUSHO), 0x800000L, tio.c_lflag);
        tio.c_lflag = FreeBsdNativePty.setFlag(t.getLocalFlag(Attributes.LocalFlag.PENDIN), 0x2000000L, tio.c_lflag);
        tio.c_lflag = FreeBsdNativePty.setFlag(t.getLocalFlag(Attributes.LocalFlag.NOFLSH), 0x8000000L, tio.c_lflag);
        tio.c_cc[0] = (byte)t.getControlChar(Attributes.ControlChar.VEOF);
        tio.c_cc[1] = (byte)t.getControlChar(Attributes.ControlChar.VEOL);
        tio.c_cc[2] = (byte)t.getControlChar(Attributes.ControlChar.VEOL2);
        tio.c_cc[3] = (byte)t.getControlChar(Attributes.ControlChar.VERASE);
        tio.c_cc[4] = (byte)t.getControlChar(Attributes.ControlChar.VWERASE);
        tio.c_cc[5] = (byte)t.getControlChar(Attributes.ControlChar.VKILL);
        tio.c_cc[6] = (byte)t.getControlChar(Attributes.ControlChar.VREPRINT);
        tio.c_cc[8] = (byte)t.getControlChar(Attributes.ControlChar.VINTR);
        tio.c_cc[9] = (byte)t.getControlChar(Attributes.ControlChar.VQUIT);
        tio.c_cc[10] = (byte)t.getControlChar(Attributes.ControlChar.VSUSP);
        tio.c_cc[12] = (byte)t.getControlChar(Attributes.ControlChar.VSTART);
        tio.c_cc[13] = (byte)t.getControlChar(Attributes.ControlChar.VSTOP);
        tio.c_cc[14] = (byte)t.getControlChar(Attributes.ControlChar.VLNEXT);
        tio.c_cc[15] = (byte)t.getControlChar(Attributes.ControlChar.VDISCARD);
        tio.c_cc[16] = (byte)t.getControlChar(Attributes.ControlChar.VMIN);
        tio.c_cc[17] = (byte)t.getControlChar(Attributes.ControlChar.VTIME);
        return tio;
    }

    @Override
    protected Attributes toAttributes(CLibrary.Termios tio) {
        Attributes attr = new Attributes();
        EnumSet<Attributes.InputFlag> iflag = attr.getInputFlags();
        FreeBsdNativePty.addFlag(tio.c_iflag, iflag, Attributes.InputFlag.IGNBRK, 1);
        FreeBsdNativePty.addFlag(tio.c_iflag, iflag, Attributes.InputFlag.IGNBRK, 1);
        FreeBsdNativePty.addFlag(tio.c_iflag, iflag, Attributes.InputFlag.BRKINT, 2);
        FreeBsdNativePty.addFlag(tio.c_iflag, iflag, Attributes.InputFlag.IGNPAR, 4);
        FreeBsdNativePty.addFlag(tio.c_iflag, iflag, Attributes.InputFlag.PARMRK, 8);
        FreeBsdNativePty.addFlag(tio.c_iflag, iflag, Attributes.InputFlag.INPCK, 16);
        FreeBsdNativePty.addFlag(tio.c_iflag, iflag, Attributes.InputFlag.ISTRIP, 32);
        FreeBsdNativePty.addFlag(tio.c_iflag, iflag, Attributes.InputFlag.INLCR, 64);
        FreeBsdNativePty.addFlag(tio.c_iflag, iflag, Attributes.InputFlag.IGNCR, 128);
        FreeBsdNativePty.addFlag(tio.c_iflag, iflag, Attributes.InputFlag.ICRNL, 256);
        FreeBsdNativePty.addFlag(tio.c_iflag, iflag, Attributes.InputFlag.IXON, 512);
        FreeBsdNativePty.addFlag(tio.c_iflag, iflag, Attributes.InputFlag.IXOFF, 1024);
        FreeBsdNativePty.addFlag(tio.c_iflag, iflag, Attributes.InputFlag.IXANY, 2048);
        FreeBsdNativePty.addFlag(tio.c_iflag, iflag, Attributes.InputFlag.IMAXBEL, 8192);
        EnumSet<Attributes.OutputFlag> oflag = attr.getOutputFlags();
        FreeBsdNativePty.addFlag(tio.c_oflag, oflag, Attributes.OutputFlag.OPOST, 1);
        FreeBsdNativePty.addFlag(tio.c_oflag, oflag, Attributes.OutputFlag.ONLCR, 2);
        FreeBsdNativePty.addFlag(tio.c_oflag, oflag, Attributes.OutputFlag.ONOEOT, 8);
        FreeBsdNativePty.addFlag(tio.c_oflag, oflag, Attributes.OutputFlag.OCRNL, 16);
        FreeBsdNativePty.addFlag(tio.c_oflag, oflag, Attributes.OutputFlag.ONLRET, 64);
        FreeBsdNativePty.addFlag(tio.c_oflag, oflag, Attributes.OutputFlag.TABDLY, 4);
        EnumSet<Attributes.ControlFlag> cflag = attr.getControlFlags();
        FreeBsdNativePty.addFlag(tio.c_cflag, cflag, Attributes.ControlFlag.CIGNORE, 1);
        FreeBsdNativePty.addFlag(tio.c_cflag, cflag, Attributes.ControlFlag.CS5, 0);
        FreeBsdNativePty.addFlag(tio.c_cflag, cflag, Attributes.ControlFlag.CS6, 256);
        FreeBsdNativePty.addFlag(tio.c_cflag, cflag, Attributes.ControlFlag.CS7, 512);
        FreeBsdNativePty.addFlag(tio.c_cflag, cflag, Attributes.ControlFlag.CS8, 768);
        FreeBsdNativePty.addFlag(tio.c_cflag, cflag, Attributes.ControlFlag.CSTOPB, 1024);
        FreeBsdNativePty.addFlag(tio.c_cflag, cflag, Attributes.ControlFlag.CREAD, 2048);
        FreeBsdNativePty.addFlag(tio.c_cflag, cflag, Attributes.ControlFlag.PARENB, 4096);
        FreeBsdNativePty.addFlag(tio.c_cflag, cflag, Attributes.ControlFlag.PARODD, 8192);
        FreeBsdNativePty.addFlag(tio.c_cflag, cflag, Attributes.ControlFlag.HUPCL, 16384);
        FreeBsdNativePty.addFlag(tio.c_cflag, cflag, Attributes.ControlFlag.CLOCAL, 32768);
        EnumSet<Attributes.LocalFlag> lflag = attr.getLocalFlags();
        FreeBsdNativePty.addFlag(tio.c_lflag, lflag, Attributes.LocalFlag.ECHOKE, 1);
        FreeBsdNativePty.addFlag(tio.c_lflag, lflag, Attributes.LocalFlag.ECHOE, 2);
        FreeBsdNativePty.addFlag(tio.c_lflag, lflag, Attributes.LocalFlag.ECHOK, 4);
        FreeBsdNativePty.addFlag(tio.c_lflag, lflag, Attributes.LocalFlag.ECHO, 8);
        FreeBsdNativePty.addFlag(tio.c_lflag, lflag, Attributes.LocalFlag.ECHONL, 16);
        FreeBsdNativePty.addFlag(tio.c_lflag, lflag, Attributes.LocalFlag.ECHOPRT, 32);
        FreeBsdNativePty.addFlag(tio.c_lflag, lflag, Attributes.LocalFlag.ECHOCTL, 64);
        FreeBsdNativePty.addFlag(tio.c_lflag, lflag, Attributes.LocalFlag.ISIG, 128);
        FreeBsdNativePty.addFlag(tio.c_lflag, lflag, Attributes.LocalFlag.ICANON, 256);
        FreeBsdNativePty.addFlag(tio.c_lflag, lflag, Attributes.LocalFlag.ALTWERASE, 512);
        FreeBsdNativePty.addFlag(tio.c_lflag, lflag, Attributes.LocalFlag.IEXTEN, 1024);
        FreeBsdNativePty.addFlag(tio.c_lflag, lflag, Attributes.LocalFlag.EXTPROC, 2048);
        FreeBsdNativePty.addFlag(tio.c_lflag, lflag, Attributes.LocalFlag.TOSTOP, 0x400000);
        FreeBsdNativePty.addFlag(tio.c_lflag, lflag, Attributes.LocalFlag.FLUSHO, 0x800000);
        FreeBsdNativePty.addFlag(tio.c_lflag, lflag, Attributes.LocalFlag.PENDIN, 0x2000000);
        FreeBsdNativePty.addFlag(tio.c_lflag, lflag, Attributes.LocalFlag.NOFLSH, 0x8000000);
        EnumMap<Attributes.ControlChar, Integer> cc = attr.getControlChars();
        cc.put(Attributes.ControlChar.VEOF, Integer.valueOf(tio.c_cc[0]));
        cc.put(Attributes.ControlChar.VEOL, Integer.valueOf(tio.c_cc[1]));
        cc.put(Attributes.ControlChar.VEOL2, Integer.valueOf(tio.c_cc[2]));
        cc.put(Attributes.ControlChar.VERASE, Integer.valueOf(tio.c_cc[3]));
        cc.put(Attributes.ControlChar.VWERASE, Integer.valueOf(tio.c_cc[4]));
        cc.put(Attributes.ControlChar.VKILL, Integer.valueOf(tio.c_cc[5]));
        cc.put(Attributes.ControlChar.VREPRINT, Integer.valueOf(tio.c_cc[6]));
        cc.put(Attributes.ControlChar.VINTR, Integer.valueOf(tio.c_cc[8]));
        cc.put(Attributes.ControlChar.VQUIT, Integer.valueOf(tio.c_cc[9]));
        cc.put(Attributes.ControlChar.VSUSP, Integer.valueOf(tio.c_cc[10]));
        cc.put(Attributes.ControlChar.VSTART, Integer.valueOf(tio.c_cc[12]));
        cc.put(Attributes.ControlChar.VSTOP, Integer.valueOf(tio.c_cc[13]));
        cc.put(Attributes.ControlChar.VLNEXT, Integer.valueOf(tio.c_cc[14]));
        cc.put(Attributes.ControlChar.VDISCARD, Integer.valueOf(tio.c_cc[15]));
        cc.put(Attributes.ControlChar.VMIN, Integer.valueOf(tio.c_cc[16]));
        cc.put(Attributes.ControlChar.VTIME, Integer.valueOf(tio.c_cc[17]));
        return attr;
    }

    private static long setFlag(boolean flag, long value2, long org) {
        return flag ? org | value2 : org;
    }

    private static <T extends Enum<T>> void addFlag(long value2, EnumSet<T> flags, T flag, int v) {
        if ((value2 & (long)v) != 0L) {
            flags.add(flag);
        }
    }
}

