/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.publish.internal.component;

import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.apache.commons.lang.StringUtils;
import org.gradle.api.Action;
import org.gradle.api.InvalidUserCodeException;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.artifacts.ConfigurablePublishArtifact;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationVariant;
import org.gradle.api.artifacts.PublishArtifactSet;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.component.ConfigurationVariantDetails;
import org.gradle.api.internal.artifacts.configurations.ConfigurationInternal;
import org.gradle.api.internal.component.UsageContext;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.publish.internal.component.ConfigurationVariantDetailsInternal;
import org.gradle.api.publish.internal.component.FeatureConfigurationVariant;
import org.gradle.internal.Actions;
import org.gradle.internal.deprecation.DeprecationLogger;
import org.gradle.internal.deprecation.DeprecationMessageBuilder;

public class ConfigurationVariantMapping {
    private final ConfigurationInternal outgoingConfiguration;
    private Action<? super ConfigurationVariantDetails> action;
    private final ObjectFactory objectFactory;

    public ConfigurationVariantMapping(ConfigurationInternal outgoingConfiguration, Action<? super ConfigurationVariantDetails> action, ObjectFactory objectFactory) {
        this.outgoingConfiguration = outgoingConfiguration;
        this.action = action;
        this.objectFactory = objectFactory;
    }

    public void addAction(Action<? super ConfigurationVariantDetails> action) {
        this.action = Actions.composite((Action[])new Action[]{this.action, action});
    }

    public void collectVariants(Consumer<UsageContext> collector) {
        this.outgoingConfiguration.runDependencyActions();
        this.outgoingConfiguration.markAsObserved();
        String outgoingConfigurationName = this.outgoingConfiguration.getName();
        if (!this.outgoingConfiguration.isTransitive()) {
            ((DeprecationMessageBuilder.WithDocumentation)DeprecationLogger.warnOfChangedBehaviour((String)"Publication ignores 'transitive = false' at configuration level", (String)"Consider using 'transitive = false' at the dependency level if you need this to be published.").withUserManual("publishing_ivy", "configurations_marked_as_non_transitive")).nagUser();
        }
        HashSet<String> seen = new HashSet<String>();
        ConfigurationVariant defaultConfigurationVariant = (ConfigurationVariant)this.objectFactory.newInstance(DefaultConfigurationVariant.class, new Object[]{this.outgoingConfiguration});
        this.visitVariant(collector, seen, defaultConfigurationVariant, outgoingConfigurationName);
        NamedDomainObjectContainer subvariants = this.outgoingConfiguration.getOutgoing().getVariants();
        for (ConfigurationVariant subvariant : subvariants) {
            String publishedVariantName = outgoingConfigurationName + StringUtils.capitalize((String)subvariant.getName());
            this.visitVariant(collector, seen, subvariant, publishedVariantName);
        }
    }

    private void visitVariant(Consumer<UsageContext> collector, Set<String> seen, ConfigurationVariant subvariant, String name) {
        DefaultConfigurationVariantDetails details = (DefaultConfigurationVariantDetails)this.objectFactory.newInstance(DefaultConfigurationVariantDetails.class, new Object[]{subvariant});
        this.action.execute((Object)details);
        if (!details.shouldPublish()) {
            return;
        }
        if (!seen.add(name)) {
            throw new InvalidUserDataException("Cannot add feature variant '" + name + "' as a variant with the same name is already registered");
        }
        collector.accept((UsageContext)new FeatureConfigurationVariant(name, (Configuration)this.outgoingConfiguration, subvariant, details.getMavenScope(), details.isOptional(), details.dependencyMappingDetails));
    }

    public static abstract class DefaultDependencyMappingDetails
    implements ConfigurationVariantDetailsInternal.DependencyMappingDetails {
        private Configuration resolutionConfiguration;

        @Override
        public void fromResolutionOf(Configuration configuration) {
            this.resolutionConfiguration = configuration;
        }

        @Nullable
        public Configuration getResolutionConfiguration() {
            return this.resolutionConfiguration;
        }
    }

    static class DefaultConfigurationVariantDetails
    implements ConfigurationVariantDetailsInternal {
        private final ConfigurationVariant variant;
        private final ObjectFactory objectFactory;
        private boolean skip = false;
        private String mavenScope = "compile";
        private boolean optional = false;
        private DefaultDependencyMappingDetails dependencyMappingDetails;

        @Inject
        public DefaultConfigurationVariantDetails(ConfigurationVariant variant, ObjectFactory objectFactory) {
            this.variant = variant;
            this.objectFactory = objectFactory;
        }

        public ConfigurationVariant getConfigurationVariant() {
            return this.variant;
        }

        public void skip() {
            this.skip = true;
        }

        public void mapToOptional() {
            this.optional = true;
        }

        public void mapToMavenScope(String scope) {
            this.mavenScope = DefaultConfigurationVariantDetails.assertValidScope(scope);
        }

        @Override
        public void dependencyMapping(Action<? super ConfigurationVariantDetailsInternal.DependencyMappingDetails> action) {
            if (this.dependencyMappingDetails == null) {
                this.dependencyMappingDetails = (DefaultDependencyMappingDetails)this.objectFactory.newInstance(DefaultDependencyMappingDetails.class, new Object[0]);
            }
            action.execute((Object)this.dependencyMappingDetails);
        }

        private static String assertValidScope(String scope) {
            if ("compile".equals(scope = scope.toLowerCase()) || "runtime".equals(scope)) {
                return scope;
            }
            throw new InvalidUserCodeException("Invalid Maven scope '" + scope + "'. You must choose between 'compile' and 'runtime'");
        }

        public boolean shouldPublish() {
            return !this.skip;
        }

        public String getMavenScope() {
            return this.mavenScope;
        }

        public boolean isOptional() {
            return this.optional;
        }
    }

    static class DefaultConfigurationVariant
    implements ConfigurationVariant {
        private final ConfigurationInternal outgoingConfiguration;

        @Inject
        public DefaultConfigurationVariant(ConfigurationInternal outgoingConfiguration) {
            this.outgoingConfiguration = outgoingConfiguration;
        }

        public PublishArtifactSet getArtifacts() {
            return this.outgoingConfiguration.getArtifacts();
        }

        public void artifact(Object notation) {
            throw new InvalidUserCodeException("Cannot add artifacts during filtering");
        }

        public void artifact(Object notation, Action<? super ConfigurablePublishArtifact> configureAction) {
            throw new InvalidUserCodeException("Cannot add artifacts during filtering");
        }

        public String getName() {
            return this.outgoingConfiguration.getName();
        }

        public Optional<String> getDescription() {
            return Optional.ofNullable(this.outgoingConfiguration.getDescription());
        }

        public ConfigurationVariant attributes(Action<? super AttributeContainer> action) {
            throw new InvalidUserCodeException("Cannot mutate outgoing configuration during filtering");
        }

        public AttributeContainer getAttributes() {
            return this.outgoingConfiguration.getAttributes();
        }
    }
}

