/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.io;

import java.util.StringTokenizer;

public class PlatformHelper {
    public static final boolean isWindows;
    public static final String separator;
    public static final char separatorChar;
    public static final String pathSeparator;
    public static final char pathSeparatorChar;
    public static final int INITIAL_MAX_PATH = 130;

    public static final int beginWithRootPathPrefix(String string) {
        if (string.startsWith("/") || string.startsWith("\\")) {
            return 1;
        }
        if (!isWindows) {
            return 0;
        }
        if (string.length() > 2 && Character.isLetter(string.charAt(0)) && string.charAt(1) == ':' && (string.charAt(2) == '/' || string.charAt(2) == '\\')) {
            return 3;
        }
        return 0;
    }

    public static final boolean isRootDirectory(String string) {
        int n = string.length();
        boolean bl = false;
        if (n > 0 && PlatformHelper.beginWithRootPathPrefix(string) == n) {
            bl = true;
        }
        return bl;
    }

    public static final String toCanonicalForm(String string) {
        String string2;
        String string3 = string.replace('/', separatorChar);
        int n = PlatformHelper.beginWithRootPathPrefix(string3);
        if (n == 0) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(130);
        stringBuffer.append(string3.substring(0, n));
        string3 = string3.substring(n);
        int n2 = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string3, separator);
        if (stringTokenizer.hasMoreTokens()) {
            do {
                if ((string2 = stringTokenizer.nextToken()).equals(".") || string2.equals("")) continue;
                if (string2.equals("..")) {
                    if (n2 == 0) continue;
                    stringBuffer.setLength(stringBuffer.length() - 1);
                    String string4 = stringBuffer.toString();
                    int n3 = string4.lastIndexOf(separator);
                    if (n3 == -1 || n3 + 1 > string4.length()) {
                        return string;
                    }
                    stringBuffer.setLength(n3 + 1);
                    --n2;
                    continue;
                }
                stringBuffer.append(string2);
                ++n2;
                if (!stringTokenizer.hasMoreTokens()) continue;
                stringBuffer.append(separator);
            } while (stringTokenizer.hasMoreTokens());
        }
        if (PlatformHelper.endWithSeparator(string)) {
            stringBuffer.append(separator);
        }
        string2 = stringBuffer.toString();
        return string2;
    }

    public static final String toCanonicalForm(String string, char c) {
        String string2 = PlatformHelper.toCanonicalForm(string);
        string2 = string2.replace(separatorChar, c);
        return string2;
    }

    public static final boolean endWithSeparator(String string) {
        return string.endsWith("\\") || string.endsWith("/");
    }

    public static final String removeTailSeparator(String string) {
        if (PlatformHelper.endWithSeparator(string) && !PlatformHelper.isRootDirectory(string)) {
            return string.substring(0, string.length() - 1);
        }
        return string;
    }

    public static final int lastIndexOfSeparator(String string) {
        return Math.max(string.lastIndexOf("/"), string.lastIndexOf("\\"));
    }

    static {
        boolean bl = false;
        if (System.getProperty("os.name").indexOf("Windows") >= 0) {
            bl = true;
        }
        isWindows = bl;
        separator = System.getProperty("file.separator");
        separatorChar = separator.charAt(0);
        pathSeparator = System.getProperty("path.separator");
        pathSeparatorChar = pathSeparator.charAt(0);
    }
}

